package org.openapitools.client.model;

import java.util.Objects;
import java.util.Arrays;
    import com.fasterxml.jackson.annotation.JsonPropertyOrder;
    import com.fasterxml.jackson.annotation.JsonTypeName;

        import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * Gets or Sets DevicePolicyPlatformType
 */
public enum DevicePolicyPlatformType {
  
  ANDROID("ANDROID"),
  
  IOS("IOS"),
  
  OSX("OSX"),
  
  WINDOWS("WINDOWS");

  private String value;

  DevicePolicyPlatformType(String value) {
    this.value = value;
  }

  @JsonValue
  public String getValue() {
    return value;
  }

  @Override
  public String toString() {
    return String.valueOf(value);
  }

  @JsonCreator
  public static DevicePolicyPlatformType fromValue(String value) {
    for (DevicePolicyPlatformType b : DevicePolicyPlatformType.values()) {
      if (b.value.equals(value)) {
        return b;
      }
    }
    throw new IllegalArgumentException("Unexpected value '" + value + "'");
  }
}

