package org.openapitools.client.model;

import java.util.Objects;
import java.util.Arrays;
    import com.fasterxml.jackson.annotation.JsonInclude;
    import com.fasterxml.jackson.annotation.JsonProperty;
    import com.fasterxml.jackson.annotation.JsonCreator;
    import com.fasterxml.jackson.annotation.JsonTypeName;
    import com.fasterxml.jackson.annotation.JsonValue;
    import io.swagger.annotations.ApiModel;
    import io.swagger.annotations.ApiModelProperty;
    import org.openapitools.client.model.ApiTokenLink;
    import org.openapitools.client.model.DeviceAssuranceDiskEncryptionType;
    import org.openapitools.client.model.DeviceAssuranceScreenLockType;
    import org.openapitools.client.model.Platform;
    import org.openapitools.client.model.VersionObject;
    import com.fasterxml.jackson.annotation.JsonPropertyOrder;
    import com.fasterxml.jackson.annotation.JsonTypeName;

        /**
* DeviceAssurance
*/
    @JsonPropertyOrder({
        DeviceAssurance.JSON_PROPERTY_CREATED_BY,
        DeviceAssurance.JSON_PROPERTY_CREATED_DATE,
        DeviceAssurance.JSON_PROPERTY_DISK_ENCRYPTION_TYPE,
        DeviceAssurance.JSON_PROPERTY_ID,
        DeviceAssurance.JSON_PROPERTY_JAILBREAK,
        DeviceAssurance.JSON_PROPERTY_LAST_UPDATED_BY,
        DeviceAssurance.JSON_PROPERTY_LAST_UPDATED_DATE,
        DeviceAssurance.JSON_PROPERTY_NAME,
        DeviceAssurance.JSON_PROPERTY_OS_VERSION,
        DeviceAssurance.JSON_PROPERTY_PLATFORM,
        DeviceAssurance.JSON_PROPERTY_SCREEN_LOCK_TYPE,
        DeviceAssurance.JSON_PROPERTY_SECURE_HARDWARE_PRESENT,
        DeviceAssurance.JSON_PROPERTY_LINKS
    })
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-10-28T09:44:59.080-05:00[America/Chicago]")
public class DeviceAssurance {


        public static final String JSON_PROPERTY_CREATED_BY = "createdBy";
            private String createdBy;

        public static final String JSON_PROPERTY_CREATED_DATE = "createdDate";
            private String createdDate;

        public static final String JSON_PROPERTY_DISK_ENCRYPTION_TYPE = "diskEncryptionType";
            private DeviceAssuranceDiskEncryptionType diskEncryptionType;

        public static final String JSON_PROPERTY_ID = "id";
            private String id;

        public static final String JSON_PROPERTY_JAILBREAK = "jailbreak";
            private Boolean jailbreak;

        public static final String JSON_PROPERTY_LAST_UPDATED_BY = "lastUpdatedBy";
            private String lastUpdatedBy;

        public static final String JSON_PROPERTY_LAST_UPDATED_DATE = "lastUpdatedDate";
            private String lastUpdatedDate;

        public static final String JSON_PROPERTY_NAME = "name";
            private String name;

        public static final String JSON_PROPERTY_OS_VERSION = "osVersion";
            private VersionObject osVersion;

        public static final String JSON_PROPERTY_PLATFORM = "platform";
            private Platform platform;

        public static final String JSON_PROPERTY_SCREEN_LOCK_TYPE = "screenLockType";
            private DeviceAssuranceScreenLockType screenLockType;

        public static final String JSON_PROPERTY_SECURE_HARDWARE_PRESENT = "secureHardwarePresent";
            private Boolean secureHardwarePresent;

        public static final String JSON_PROPERTY_LINKS = "_links";
            private ApiTokenLink links;

public DeviceAssurance() { 
}

    /*
    @JsonCreator
    public DeviceAssurance(
        @JsonProperty(JSON_PROPERTY_CREATED_BY) String createdBy, 
        @JsonProperty(JSON_PROPERTY_CREATED_DATE) String createdDate, 
        @JsonProperty(JSON_PROPERTY_ID) String id, 
        @JsonProperty(JSON_PROPERTY_LAST_UPDATED_BY) String lastUpdatedBy, 
        @JsonProperty(JSON_PROPERTY_LAST_UPDATED_DATE) String lastUpdatedDate
    ) {
    this();
        this.createdBy = createdBy;
        this.createdDate = createdDate;
        this.id = id;
        this.lastUpdatedBy = lastUpdatedBy;
        this.lastUpdatedDate = lastUpdatedDate;
    }*/


    /**
        * Get createdBy
    * @return createdBy
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(value = "")
      @JsonProperty(JSON_PROPERTY_CREATED_BY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getCreatedBy() {
        return createdBy;
    }




    /**
        * Get createdDate
    * @return createdDate
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(value = "")
      @JsonProperty(JSON_PROPERTY_CREATED_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getCreatedDate() {
        return createdDate;
    }




        public DeviceAssurance diskEncryptionType(DeviceAssuranceDiskEncryptionType diskEncryptionType) {
        
        this.diskEncryptionType = diskEncryptionType;
        return this;
        }

    /**
        * Get diskEncryptionType
    * @return diskEncryptionType
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(value = "")
      @JsonProperty(JSON_PROPERTY_DISK_ENCRYPTION_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public DeviceAssuranceDiskEncryptionType getDiskEncryptionType() {
        return diskEncryptionType;
    }


          @JsonProperty(JSON_PROPERTY_DISK_ENCRYPTION_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDiskEncryptionType(DeviceAssuranceDiskEncryptionType diskEncryptionType) {
            this.diskEncryptionType = diskEncryptionType;
        }


    /**
        * Get id
    * @return id
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(value = "")
      @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getId() {
        return id;
    }




        public DeviceAssurance jailbreak(Boolean jailbreak) {
        
        this.jailbreak = jailbreak;
        return this;
        }

    /**
        * Get jailbreak
    * @return jailbreak
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(value = "")
      @JsonProperty(JSON_PROPERTY_JAILBREAK)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public Boolean getJailbreak() {
        return jailbreak;
    }


          @JsonProperty(JSON_PROPERTY_JAILBREAK)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setJailbreak(Boolean jailbreak) {
            this.jailbreak = jailbreak;
        }


    /**
        * Get lastUpdatedBy
    * @return lastUpdatedBy
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(value = "")
      @JsonProperty(JSON_PROPERTY_LAST_UPDATED_BY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getLastUpdatedBy() {
        return lastUpdatedBy;
    }




    /**
        * Get lastUpdatedDate
    * @return lastUpdatedDate
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(value = "")
      @JsonProperty(JSON_PROPERTY_LAST_UPDATED_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getLastUpdatedDate() {
        return lastUpdatedDate;
    }




        public DeviceAssurance name(String name) {
        
        this.name = name;
        return this;
        }

    /**
        * Display name of the Device Assurance Policy
    * @return name
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(value = "Display name of the Device Assurance Policy")
      @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getName() {
        return name;
    }


          @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setName(String name) {
            this.name = name;
        }


        public DeviceAssurance osVersion(VersionObject osVersion) {
        
        this.osVersion = osVersion;
        return this;
        }

    /**
        * Get osVersion
    * @return osVersion
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(value = "")
      @JsonProperty(JSON_PROPERTY_OS_VERSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public VersionObject getOsVersion() {
        return osVersion;
    }


          @JsonProperty(JSON_PROPERTY_OS_VERSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setOsVersion(VersionObject osVersion) {
            this.osVersion = osVersion;
        }


        public DeviceAssurance platform(Platform platform) {
        
        this.platform = platform;
        return this;
        }

    /**
        * Get platform
    * @return platform
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(value = "")
      @JsonProperty(JSON_PROPERTY_PLATFORM)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public Platform getPlatform() {
        return platform;
    }


          @JsonProperty(JSON_PROPERTY_PLATFORM)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPlatform(Platform platform) {
            this.platform = platform;
        }


        public DeviceAssurance screenLockType(DeviceAssuranceScreenLockType screenLockType) {
        
        this.screenLockType = screenLockType;
        return this;
        }

    /**
        * Get screenLockType
    * @return screenLockType
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(value = "")
      @JsonProperty(JSON_PROPERTY_SCREEN_LOCK_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public DeviceAssuranceScreenLockType getScreenLockType() {
        return screenLockType;
    }


          @JsonProperty(JSON_PROPERTY_SCREEN_LOCK_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setScreenLockType(DeviceAssuranceScreenLockType screenLockType) {
            this.screenLockType = screenLockType;
        }


        public DeviceAssurance secureHardwarePresent(Boolean secureHardwarePresent) {
        
        this.secureHardwarePresent = secureHardwarePresent;
        return this;
        }

    /**
        * Get secureHardwarePresent
    * @return secureHardwarePresent
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(value = "")
      @JsonProperty(JSON_PROPERTY_SECURE_HARDWARE_PRESENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public Boolean getSecureHardwarePresent() {
        return secureHardwarePresent;
    }


          @JsonProperty(JSON_PROPERTY_SECURE_HARDWARE_PRESENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSecureHardwarePresent(Boolean secureHardwarePresent) {
            this.secureHardwarePresent = secureHardwarePresent;
        }


        public DeviceAssurance links(ApiTokenLink links) {
        
        this.links = links;
        return this;
        }

    /**
        * Get links
    * @return links
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(value = "")
      @JsonProperty(JSON_PROPERTY_LINKS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public ApiTokenLink getLinks() {
        return links;
    }


          @JsonProperty(JSON_PROPERTY_LINKS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLinks(ApiTokenLink links) {
            this.links = links;
        }


@Override
public boolean equals(Object o) {
    if (this == o) {
    return true;
    }
    if (o == null || getClass() != o.getClass()) {
    return false;
    }
        DeviceAssurance deviceAssurance = (DeviceAssurance) o;
        return Objects.equals(this.createdBy, deviceAssurance.createdBy) &&
        Objects.equals(this.createdDate, deviceAssurance.createdDate) &&
        Objects.equals(this.diskEncryptionType, deviceAssurance.diskEncryptionType) &&
        Objects.equals(this.id, deviceAssurance.id) &&
        Objects.equals(this.jailbreak, deviceAssurance.jailbreak) &&
        Objects.equals(this.lastUpdatedBy, deviceAssurance.lastUpdatedBy) &&
        Objects.equals(this.lastUpdatedDate, deviceAssurance.lastUpdatedDate) &&
        Objects.equals(this.name, deviceAssurance.name) &&
        Objects.equals(this.osVersion, deviceAssurance.osVersion) &&
        Objects.equals(this.platform, deviceAssurance.platform) &&
        Objects.equals(this.screenLockType, deviceAssurance.screenLockType) &&
        Objects.equals(this.secureHardwarePresent, deviceAssurance.secureHardwarePresent) &&
        Objects.equals(this.links, deviceAssurance.links);
}

    @Override
    public int hashCode() {
        return Objects.hash(createdBy, createdDate, diskEncryptionType, id, jailbreak, lastUpdatedBy, lastUpdatedDate, name, osVersion, platform, screenLockType, secureHardwarePresent, links);
    }

    @Override
    public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class DeviceAssurance {\n");
        sb.append("    createdBy: ").append(toIndentedString(createdBy)).append("\n");
        sb.append("    createdDate: ").append(toIndentedString(createdDate)).append("\n");
        sb.append("    diskEncryptionType: ").append(toIndentedString(diskEncryptionType)).append("\n");
        sb.append("    id: ").append(toIndentedString(id)).append("\n");
        sb.append("    jailbreak: ").append(toIndentedString(jailbreak)).append("\n");
        sb.append("    lastUpdatedBy: ").append(toIndentedString(lastUpdatedBy)).append("\n");
        sb.append("    lastUpdatedDate: ").append(toIndentedString(lastUpdatedDate)).append("\n");
        sb.append("    name: ").append(toIndentedString(name)).append("\n");
        sb.append("    osVersion: ").append(toIndentedString(osVersion)).append("\n");
        sb.append("    platform: ").append(toIndentedString(platform)).append("\n");
        sb.append("    screenLockType: ").append(toIndentedString(screenLockType)).append("\n");
        sb.append("    secureHardwarePresent: ").append(toIndentedString(secureHardwarePresent)).append("\n");
        sb.append("    links: ").append(toIndentedString(links)).append("\n");
    sb.append("}");
    return sb.toString();
    }

    /**
    * Convert the given object to string with each line indented by 4 spaces
    * (except the first line).
    */
    private String toIndentedString(Object o) {
    if (o == null) {
    return "null";
    }
    return o.toString().replace("\n", "\n    ");
    }


    }
