package org.openapitools.client.model;

import java.util.Objects;
import java.util.Arrays;
    import com.fasterxml.jackson.annotation.JsonInclude;
    import com.fasterxml.jackson.annotation.JsonProperty;
    import com.fasterxml.jackson.annotation.JsonCreator;
    import com.fasterxml.jackson.annotation.JsonTypeName;
    import com.fasterxml.jackson.annotation.JsonValue;
    import io.swagger.annotations.ApiModel;
    import io.swagger.annotations.ApiModelProperty;
    import java.util.ArrayList;
    import java.util.List;
    import org.openapitools.client.model.UserCredentials;
    import org.openapitools.client.model.UserProfile;
    import org.openapitools.client.model.UserType;
    import com.fasterxml.jackson.annotation.JsonPropertyOrder;
    import com.fasterxml.jackson.annotation.JsonTypeName;

        /**
* CreateUserRequest
*/
    @JsonPropertyOrder({
        CreateUserRequest.JSON_PROPERTY_CREDENTIALS,
        CreateUserRequest.JSON_PROPERTY_GROUP_IDS,
        CreateUserRequest.JSON_PROPERTY_PROFILE,
        CreateUserRequest.JSON_PROPERTY_TYPE
    })
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-10-28T09:44:59.080-05:00[America/Chicago]")
public class CreateUserRequest {


        public static final String JSON_PROPERTY_CREDENTIALS = "credentials";
            private UserCredentials credentials;

        public static final String JSON_PROPERTY_GROUP_IDS = "groupIds";
            private List<String> groupIds = null;

        public static final String JSON_PROPERTY_PROFILE = "profile";
            private UserProfile profile;

        public static final String JSON_PROPERTY_TYPE = "type";
            private UserType type;

public CreateUserRequest() { 
}

        public CreateUserRequest credentials(UserCredentials credentials) {
        
        this.credentials = credentials;
        return this;
        }

    /**
        * Get credentials
    * @return credentials
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(value = "")
      @JsonProperty(JSON_PROPERTY_CREDENTIALS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public UserCredentials getCredentials() {
        return credentials;
    }


          @JsonProperty(JSON_PROPERTY_CREDENTIALS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCredentials(UserCredentials credentials) {
            this.credentials = credentials;
        }


        public CreateUserRequest groupIds(List<String> groupIds) {
        
        this.groupIds = groupIds;
        return this;
        }

            public CreateUserRequest addGroupIdsItem(String groupIdsItem) {
                    if (this.groupIds == null) {
                    this.groupIds = new ArrayList<>();
                    }
                this.groupIds.add(groupIdsItem);
                return this;
            }

    /**
        * Get groupIds
    * @return groupIds
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(value = "")
      @JsonProperty(JSON_PROPERTY_GROUP_IDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public List<String> getGroupIds() {
        return groupIds;
    }


          @JsonProperty(JSON_PROPERTY_GROUP_IDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setGroupIds(List<String> groupIds) {
            this.groupIds = groupIds;
        }


        public CreateUserRequest profile(UserProfile profile) {
        
        this.profile = profile;
        return this;
        }

    /**
        * Get profile
    * @return profile
    **/
            @javax.annotation.Nonnull
      @ApiModelProperty(required = true, value = "")
      @JsonProperty(JSON_PROPERTY_PROFILE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

    public UserProfile getProfile() {
        return profile;
    }


          @JsonProperty(JSON_PROPERTY_PROFILE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setProfile(UserProfile profile) {
            this.profile = profile;
        }


        public CreateUserRequest type(UserType type) {
        
        this.type = type;
        return this;
        }

    /**
        * Get type
    * @return type
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(value = "")
      @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public UserType getType() {
        return type;
    }


          @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setType(UserType type) {
            this.type = type;
        }


@Override
public boolean equals(Object o) {
    if (this == o) {
    return true;
    }
    if (o == null || getClass() != o.getClass()) {
    return false;
    }
        CreateUserRequest createUserRequest = (CreateUserRequest) o;
        return Objects.equals(this.credentials, createUserRequest.credentials) &&
        Objects.equals(this.groupIds, createUserRequest.groupIds) &&
        Objects.equals(this.profile, createUserRequest.profile) &&
        Objects.equals(this.type, createUserRequest.type);
}

    @Override
    public int hashCode() {
        return Objects.hash(credentials, groupIds, profile, type);
    }

    @Override
    public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CreateUserRequest {\n");
        sb.append("    credentials: ").append(toIndentedString(credentials)).append("\n");
        sb.append("    groupIds: ").append(toIndentedString(groupIds)).append("\n");
        sb.append("    profile: ").append(toIndentedString(profile)).append("\n");
        sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("}");
    return sb.toString();
    }

    /**
    * Convert the given object to string with each line indented by 4 spaces
    * (except the first line).
    */
    private String toIndentedString(Object o) {
    if (o == null) {
    return "null";
    }
    return o.toString().replace("\n", "\n    ");
    }


    }
