package org.openapitools.client.model;

import java.util.Objects;
import java.util.Arrays;
    import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
    import com.fasterxml.jackson.annotation.JsonInclude;
    import com.fasterxml.jackson.annotation.JsonProperty;
    import com.fasterxml.jackson.annotation.JsonCreator;
    import com.fasterxml.jackson.annotation.JsonSubTypes;
    import com.fasterxml.jackson.annotation.JsonTypeInfo;
    import com.fasterxml.jackson.annotation.JsonTypeName;
    import com.fasterxml.jackson.annotation.JsonValue;
    import io.swagger.annotations.ApiModel;
    import io.swagger.annotations.ApiModelProperty;
    import java.time.OffsetDateTime;
    import java.util.ArrayList;
    import java.util.HashMap;
    import java.util.List;
    import java.util.Map;
    import org.openapitools.client.model.Application;
    import org.openapitools.client.model.ApplicationAccessibility;
    import org.openapitools.client.model.ApplicationCredentials;
    import org.openapitools.client.model.ApplicationLicensing;
    import org.openapitools.client.model.ApplicationLifecycleStatus;
    import org.openapitools.client.model.ApplicationLinks;
    import org.openapitools.client.model.ApplicationSignOnMode;
    import org.openapitools.client.model.ApplicationVisibility;
    import org.openapitools.client.model.AutoLoginApplication;
    import org.openapitools.client.model.BasicAuthApplication;
    import org.openapitools.client.model.BookmarkApplication;
    import org.openapitools.client.model.BookmarkApplicationSettings;
    import org.openapitools.client.model.BrowserPluginApplication;
    import org.openapitools.client.model.OpenIdConnectApplication;
    import org.openapitools.client.model.SamlApplication;
    import org.openapitools.client.model.SecurePasswordStoreApplication;
    import org.openapitools.client.model.WsFederationApplication;
    import com.fasterxml.jackson.annotation.JsonPropertyOrder;
    import com.fasterxml.jackson.annotation.JsonTypeName;

        /**
* BookmarkApplication
*/
    @JsonPropertyOrder({
        BookmarkApplication.JSON_PROPERTY_CREDENTIALS,
        BookmarkApplication.JSON_PROPERTY_NAME,
        BookmarkApplication.JSON_PROPERTY_SETTINGS
    })
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-10-28T09:44:59.080-05:00[America/Chicago]")
public class BookmarkApplication extends Application {


        public static final String JSON_PROPERTY_CREDENTIALS = "credentials";
            private ApplicationCredentials credentials;

        public static final String JSON_PROPERTY_NAME = "name";
            private String name = "bookmark";

        public static final String JSON_PROPERTY_SETTINGS = "settings";
            private BookmarkApplicationSettings settings;

public BookmarkApplication() { 
}

    /*
    @JsonCreator
    public BookmarkApplication(
        @JsonProperty(JSON_PROPERTY_CREATED) OffsetDateTime created, 
        @JsonProperty(JSON_PROPERTY_ID) String id, 
        @JsonProperty(JSON_PROPERTY_LAST_UPDATED) OffsetDateTime lastUpdated, 
        @JsonProperty(JSON_PROPERTY_EMBEDDED) Map<String, Object> embedded
    ) {
    this();
        this.created = created;
        this.id = id;
        this.lastUpdated = lastUpdated;
        this.embedded = embedded;
    }*/


        public BookmarkApplication credentials(ApplicationCredentials credentials) {
        
        this.credentials = credentials;
        return this;
        }

    /**
        * Get credentials
    * @return credentials
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(value = "")
      @JsonProperty(JSON_PROPERTY_CREDENTIALS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public ApplicationCredentials getCredentials() {
        return credentials;
    }


          @JsonProperty(JSON_PROPERTY_CREDENTIALS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCredentials(ApplicationCredentials credentials) {
            this.credentials = credentials;
        }


        public BookmarkApplication name(String name) {
        
        this.name = name;
        return this;
        }

    /**
        * Get name
    * @return name
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(value = "")
      @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getName() {
        return name;
    }


          @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setName(String name) {
            this.name = name;
        }


        public BookmarkApplication settings(BookmarkApplicationSettings settings) {
        
        this.settings = settings;
        return this;
        }

    /**
        * Get settings
    * @return settings
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(value = "")
      @JsonProperty(JSON_PROPERTY_SETTINGS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public BookmarkApplicationSettings getSettings() {
        return settings;
    }


          @JsonProperty(JSON_PROPERTY_SETTINGS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSettings(BookmarkApplicationSettings settings) {
            this.settings = settings;
        }


@Override
public boolean equals(Object o) {
    if (this == o) {
    return true;
    }
    if (o == null || getClass() != o.getClass()) {
    return false;
    }
        BookmarkApplication bookmarkApplication = (BookmarkApplication) o;
        return Objects.equals(this.credentials, bookmarkApplication.credentials) &&
        Objects.equals(this.name, bookmarkApplication.name) &&
        Objects.equals(this.settings, bookmarkApplication.settings) &&
        super.equals(o);
}

    @Override
    public int hashCode() {
        return Objects.hash(credentials, name, settings, super.hashCode());
    }

    @Override
    public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class BookmarkApplication {\n");
        sb.append("    ").append(toIndentedString(super.toString())).append("\n");
        sb.append("    credentials: ").append(toIndentedString(credentials)).append("\n");
        sb.append("    name: ").append(toIndentedString(name)).append("\n");
        sb.append("    settings: ").append(toIndentedString(settings)).append("\n");
    sb.append("}");
    return sb.toString();
    }

    /**
    * Convert the given object to string with each line indented by 4 spaces
    * (except the first line).
    */
    private String toIndentedString(Object o) {
    if (o == null) {
    return "null";
    }
    return o.toString().replace("\n", "\n    ");
    }


    }
