package org.openapitools.client.model;

import java.util.Objects;
import java.util.Arrays;
    import com.fasterxml.jackson.annotation.JsonPropertyOrder;
    import com.fasterxml.jackson.annotation.JsonTypeName;

        import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * Gets or Sets BehaviorRuleType
 */
public enum BehaviorRuleType {
  
  ANOMALOUS_DEVICE("ANOMALOUS_DEVICE"),
  
  ANOMALOUS_IP("ANOMALOUS_IP"),
  
  ANOMALOUS_LOCATION("ANOMALOUS_LOCATION"),
  
  VELOCITY("VELOCITY");

  private String value;

  BehaviorRuleType(String value) {
    this.value = value;
  }

  @JsonValue
  public String getValue() {
    return value;
  }

  @Override
  public String toString() {
    return String.valueOf(value);
  }

  @JsonCreator
  public static BehaviorRuleType fromValue(String value) {
    for (BehaviorRuleType b : BehaviorRuleType.values()) {
      if (b.value.equals(value)) {
        return b;
      }
    }
    throw new IllegalArgumentException("Unexpected value '" + value + "'");
  }
}

