package org.openapitools.client.model;

import java.util.Objects;
import java.util.Arrays;
    import com.fasterxml.jackson.annotation.JsonInclude;
    import com.fasterxml.jackson.annotation.JsonProperty;
    import com.fasterxml.jackson.annotation.JsonCreator;
    import com.fasterxml.jackson.annotation.JsonTypeName;
    import com.fasterxml.jackson.annotation.JsonValue;
    import io.swagger.annotations.ApiModel;
    import io.swagger.annotations.ApiModelProperty;
    import java.time.OffsetDateTime;
    import java.util.ArrayList;
    import java.util.HashMap;
    import java.util.List;
    import java.util.Map;
    import org.openapitools.client.model.AuthorizationServerCredentials;
    import org.openapitools.client.model.IssuerMode;
    import org.openapitools.client.model.LifecycleStatus;
    import com.fasterxml.jackson.annotation.JsonPropertyOrder;
    import com.fasterxml.jackson.annotation.JsonTypeName;

        /**
* AuthorizationServer
*/
    @JsonPropertyOrder({
        AuthorizationServer.JSON_PROPERTY_AUDIENCES,
        AuthorizationServer.JSON_PROPERTY_CREATED,
        AuthorizationServer.JSON_PROPERTY_CREDENTIALS,
        AuthorizationServer.JSON_PROPERTY_DESCRIPTION,
        AuthorizationServer.JSON_PROPERTY_ID,
        AuthorizationServer.JSON_PROPERTY_ISSUER,
        AuthorizationServer.JSON_PROPERTY_ISSUER_MODE,
        AuthorizationServer.JSON_PROPERTY_LAST_UPDATED,
        AuthorizationServer.JSON_PROPERTY_NAME,
        AuthorizationServer.JSON_PROPERTY_STATUS,
        AuthorizationServer.JSON_PROPERTY_LINKS
    })
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-10-28T09:44:59.080-05:00[America/Chicago]")
public class AuthorizationServer {


        public static final String JSON_PROPERTY_AUDIENCES = "audiences";
            private List<String> audiences = null;

        public static final String JSON_PROPERTY_CREATED = "created";
            private OffsetDateTime created;

        public static final String JSON_PROPERTY_CREDENTIALS = "credentials";
            private AuthorizationServerCredentials credentials;

        public static final String JSON_PROPERTY_DESCRIPTION = "description";
            private String description;

        public static final String JSON_PROPERTY_ID = "id";
            private String id;

        public static final String JSON_PROPERTY_ISSUER = "issuer";
            private String issuer;

        public static final String JSON_PROPERTY_ISSUER_MODE = "issuerMode";
            private IssuerMode issuerMode;

        public static final String JSON_PROPERTY_LAST_UPDATED = "lastUpdated";
            private OffsetDateTime lastUpdated;

        public static final String JSON_PROPERTY_NAME = "name";
            private String name;

        public static final String JSON_PROPERTY_STATUS = "status";
            private LifecycleStatus status;

        public static final String JSON_PROPERTY_LINKS = "_links";
            private Map<String, Object> links = null;

public AuthorizationServer() { 
}

    /*
    @JsonCreator
    public AuthorizationServer(
        @JsonProperty(JSON_PROPERTY_CREATED) OffsetDateTime created, 
        @JsonProperty(JSON_PROPERTY_ID) String id, 
        @JsonProperty(JSON_PROPERTY_LAST_UPDATED) OffsetDateTime lastUpdated, 
        @JsonProperty(JSON_PROPERTY_LINKS) Map<String, Object> links
    ) {
    this();
        this.created = created;
        this.id = id;
        this.lastUpdated = lastUpdated;
        this.links = links;
    }*/


        public AuthorizationServer audiences(List<String> audiences) {
        
        this.audiences = audiences;
        return this;
        }

            public AuthorizationServer addAudiencesItem(String audiencesItem) {
                    if (this.audiences == null) {
                    this.audiences = new ArrayList<>();
                    }
                this.audiences.add(audiencesItem);
                return this;
            }

    /**
        * Get audiences
    * @return audiences
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(value = "")
      @JsonProperty(JSON_PROPERTY_AUDIENCES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public List<String> getAudiences() {
        return audiences;
    }


          @JsonProperty(JSON_PROPERTY_AUDIENCES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAudiences(List<String> audiences) {
            this.audiences = audiences;
        }


    /**
        * Get created
    * @return created
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(value = "")
      @JsonProperty(JSON_PROPERTY_CREATED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public OffsetDateTime getCreated() {
        return created;
    }




        public AuthorizationServer credentials(AuthorizationServerCredentials credentials) {
        
        this.credentials = credentials;
        return this;
        }

    /**
        * Get credentials
    * @return credentials
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(value = "")
      @JsonProperty(JSON_PROPERTY_CREDENTIALS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public AuthorizationServerCredentials getCredentials() {
        return credentials;
    }


          @JsonProperty(JSON_PROPERTY_CREDENTIALS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCredentials(AuthorizationServerCredentials credentials) {
            this.credentials = credentials;
        }


        public AuthorizationServer description(String description) {
        
        this.description = description;
        return this;
        }

    /**
        * Get description
    * @return description
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(value = "")
      @JsonProperty(JSON_PROPERTY_DESCRIPTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getDescription() {
        return description;
    }


          @JsonProperty(JSON_PROPERTY_DESCRIPTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDescription(String description) {
            this.description = description;
        }


    /**
        * Get id
    * @return id
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(value = "")
      @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getId() {
        return id;
    }




        public AuthorizationServer issuer(String issuer) {
        
        this.issuer = issuer;
        return this;
        }

    /**
        * Get issuer
    * @return issuer
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(value = "")
      @JsonProperty(JSON_PROPERTY_ISSUER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getIssuer() {
        return issuer;
    }


          @JsonProperty(JSON_PROPERTY_ISSUER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIssuer(String issuer) {
            this.issuer = issuer;
        }


        public AuthorizationServer issuerMode(IssuerMode issuerMode) {
        
        this.issuerMode = issuerMode;
        return this;
        }

    /**
        * Get issuerMode
    * @return issuerMode
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(value = "")
      @JsonProperty(JSON_PROPERTY_ISSUER_MODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public IssuerMode getIssuerMode() {
        return issuerMode;
    }


          @JsonProperty(JSON_PROPERTY_ISSUER_MODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIssuerMode(IssuerMode issuerMode) {
            this.issuerMode = issuerMode;
        }


    /**
        * Get lastUpdated
    * @return lastUpdated
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(value = "")
      @JsonProperty(JSON_PROPERTY_LAST_UPDATED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public OffsetDateTime getLastUpdated() {
        return lastUpdated;
    }




        public AuthorizationServer name(String name) {
        
        this.name = name;
        return this;
        }

    /**
        * Get name
    * @return name
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(value = "")
      @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getName() {
        return name;
    }


          @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setName(String name) {
            this.name = name;
        }


        public AuthorizationServer status(LifecycleStatus status) {
        
        this.status = status;
        return this;
        }

    /**
        * Get status
    * @return status
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(value = "")
      @JsonProperty(JSON_PROPERTY_STATUS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public LifecycleStatus getStatus() {
        return status;
    }


          @JsonProperty(JSON_PROPERTY_STATUS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setStatus(LifecycleStatus status) {
            this.status = status;
        }


    /**
        * Get links
    * @return links
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(value = "")
      @JsonProperty(JSON_PROPERTY_LINKS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public Map<String, Object> getLinks() {
        return links;
    }




@Override
public boolean equals(Object o) {
    if (this == o) {
    return true;
    }
    if (o == null || getClass() != o.getClass()) {
    return false;
    }
        AuthorizationServer authorizationServer = (AuthorizationServer) o;
        return Objects.equals(this.audiences, authorizationServer.audiences) &&
        Objects.equals(this.created, authorizationServer.created) &&
        Objects.equals(this.credentials, authorizationServer.credentials) &&
        Objects.equals(this.description, authorizationServer.description) &&
        Objects.equals(this.id, authorizationServer.id) &&
        Objects.equals(this.issuer, authorizationServer.issuer) &&
        Objects.equals(this.issuerMode, authorizationServer.issuerMode) &&
        Objects.equals(this.lastUpdated, authorizationServer.lastUpdated) &&
        Objects.equals(this.name, authorizationServer.name) &&
        Objects.equals(this.status, authorizationServer.status) &&
        Objects.equals(this.links, authorizationServer.links);
}

    @Override
    public int hashCode() {
        return Objects.hash(audiences, created, credentials, description, id, issuer, issuerMode, lastUpdated, name, status, links);
    }

    @Override
    public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class AuthorizationServer {\n");
        sb.append("    audiences: ").append(toIndentedString(audiences)).append("\n");
        sb.append("    created: ").append(toIndentedString(created)).append("\n");
        sb.append("    credentials: ").append(toIndentedString(credentials)).append("\n");
        sb.append("    description: ").append(toIndentedString(description)).append("\n");
        sb.append("    id: ").append(toIndentedString(id)).append("\n");
        sb.append("    issuer: ").append(toIndentedString(issuer)).append("\n");
        sb.append("    issuerMode: ").append(toIndentedString(issuerMode)).append("\n");
        sb.append("    lastUpdated: ").append(toIndentedString(lastUpdated)).append("\n");
        sb.append("    name: ").append(toIndentedString(name)).append("\n");
        sb.append("    status: ").append(toIndentedString(status)).append("\n");
        sb.append("    links: ").append(toIndentedString(links)).append("\n");
    sb.append("}");
    return sb.toString();
    }

    /**
    * Convert the given object to string with each line indented by 4 spaces
    * (except the first line).
    */
    private String toIndentedString(Object o) {
    if (o == null) {
    return "null";
    }
    return o.toString().replace("\n", "\n    ");
    }


    }
