package org.openapitools.client.model;

import java.util.Objects;
import java.util.Arrays;
    import com.fasterxml.jackson.annotation.JsonInclude;
    import com.fasterxml.jackson.annotation.JsonProperty;
    import com.fasterxml.jackson.annotation.JsonCreator;
    import com.fasterxml.jackson.annotation.JsonTypeName;
    import com.fasterxml.jackson.annotation.JsonValue;
    import io.swagger.annotations.ApiModel;
    import io.swagger.annotations.ApiModelProperty;
    import org.openapitools.client.model.AllowedForEnum;
    import org.openapitools.client.model.ChannelBinding;
    import org.openapitools.client.model.Compliance;
    import org.openapitools.client.model.UserVerificationEnum;
    import com.fasterxml.jackson.annotation.JsonPropertyOrder;
    import com.fasterxml.jackson.annotation.JsonTypeName;

        /**
* AuthenticatorSettings
*/
    @JsonPropertyOrder({
        AuthenticatorSettings.JSON_PROPERTY_ALLOWED_FOR,
        AuthenticatorSettings.JSON_PROPERTY_APP_INSTANCE_ID,
        AuthenticatorSettings.JSON_PROPERTY_CHANNEL_BINDING,
        AuthenticatorSettings.JSON_PROPERTY_COMPLIANCE,
        AuthenticatorSettings.JSON_PROPERTY_TOKEN_LIFETIME_IN_MINUTES,
        AuthenticatorSettings.JSON_PROPERTY_USER_VERIFICATION
    })
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-10-28T09:44:59.080-05:00[America/Chicago]")
public class AuthenticatorSettings {


        public static final String JSON_PROPERTY_ALLOWED_FOR = "allowedFor";
            private AllowedForEnum allowedFor;

        public static final String JSON_PROPERTY_APP_INSTANCE_ID = "appInstanceId";
            private String appInstanceId;

        public static final String JSON_PROPERTY_CHANNEL_BINDING = "channelBinding";
            private ChannelBinding channelBinding;

        public static final String JSON_PROPERTY_COMPLIANCE = "compliance";
            private Compliance compliance;

        public static final String JSON_PROPERTY_TOKEN_LIFETIME_IN_MINUTES = "tokenLifetimeInMinutes";
            private Integer tokenLifetimeInMinutes;

        public static final String JSON_PROPERTY_USER_VERIFICATION = "userVerification";
            private UserVerificationEnum userVerification;

public AuthenticatorSettings() { 
}

        public AuthenticatorSettings allowedFor(AllowedForEnum allowedFor) {
        
        this.allowedFor = allowedFor;
        return this;
        }

    /**
        * Get allowedFor
    * @return allowedFor
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(value = "")
      @JsonProperty(JSON_PROPERTY_ALLOWED_FOR)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public AllowedForEnum getAllowedFor() {
        return allowedFor;
    }


          @JsonProperty(JSON_PROPERTY_ALLOWED_FOR)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAllowedFor(AllowedForEnum allowedFor) {
            this.allowedFor = allowedFor;
        }


        public AuthenticatorSettings appInstanceId(String appInstanceId) {
        
        this.appInstanceId = appInstanceId;
        return this;
        }

    /**
        * Get appInstanceId
    * @return appInstanceId
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(value = "")
      @JsonProperty(JSON_PROPERTY_APP_INSTANCE_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getAppInstanceId() {
        return appInstanceId;
    }


          @JsonProperty(JSON_PROPERTY_APP_INSTANCE_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAppInstanceId(String appInstanceId) {
            this.appInstanceId = appInstanceId;
        }


        public AuthenticatorSettings channelBinding(ChannelBinding channelBinding) {
        
        this.channelBinding = channelBinding;
        return this;
        }

    /**
        * Get channelBinding
    * @return channelBinding
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(value = "")
      @JsonProperty(JSON_PROPERTY_CHANNEL_BINDING)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public ChannelBinding getChannelBinding() {
        return channelBinding;
    }


          @JsonProperty(JSON_PROPERTY_CHANNEL_BINDING)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setChannelBinding(ChannelBinding channelBinding) {
            this.channelBinding = channelBinding;
        }


        public AuthenticatorSettings compliance(Compliance compliance) {
        
        this.compliance = compliance;
        return this;
        }

    /**
        * Get compliance
    * @return compliance
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(value = "")
      @JsonProperty(JSON_PROPERTY_COMPLIANCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public Compliance getCompliance() {
        return compliance;
    }


          @JsonProperty(JSON_PROPERTY_COMPLIANCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCompliance(Compliance compliance) {
            this.compliance = compliance;
        }


        public AuthenticatorSettings tokenLifetimeInMinutes(Integer tokenLifetimeInMinutes) {
        
        this.tokenLifetimeInMinutes = tokenLifetimeInMinutes;
        return this;
        }

    /**
        * Get tokenLifetimeInMinutes
    * @return tokenLifetimeInMinutes
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(value = "")
      @JsonProperty(JSON_PROPERTY_TOKEN_LIFETIME_IN_MINUTES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public Integer getTokenLifetimeInMinutes() {
        return tokenLifetimeInMinutes;
    }


          @JsonProperty(JSON_PROPERTY_TOKEN_LIFETIME_IN_MINUTES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTokenLifetimeInMinutes(Integer tokenLifetimeInMinutes) {
            this.tokenLifetimeInMinutes = tokenLifetimeInMinutes;
        }


        public AuthenticatorSettings userVerification(UserVerificationEnum userVerification) {
        
        this.userVerification = userVerification;
        return this;
        }

    /**
        * Get userVerification
    * @return userVerification
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(value = "")
      @JsonProperty(JSON_PROPERTY_USER_VERIFICATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public UserVerificationEnum getUserVerification() {
        return userVerification;
    }


          @JsonProperty(JSON_PROPERTY_USER_VERIFICATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUserVerification(UserVerificationEnum userVerification) {
            this.userVerification = userVerification;
        }


@Override
public boolean equals(Object o) {
    if (this == o) {
    return true;
    }
    if (o == null || getClass() != o.getClass()) {
    return false;
    }
        AuthenticatorSettings authenticatorSettings = (AuthenticatorSettings) o;
        return Objects.equals(this.allowedFor, authenticatorSettings.allowedFor) &&
        Objects.equals(this.appInstanceId, authenticatorSettings.appInstanceId) &&
        Objects.equals(this.channelBinding, authenticatorSettings.channelBinding) &&
        Objects.equals(this.compliance, authenticatorSettings.compliance) &&
        Objects.equals(this.tokenLifetimeInMinutes, authenticatorSettings.tokenLifetimeInMinutes) &&
        Objects.equals(this.userVerification, authenticatorSettings.userVerification);
}

    @Override
    public int hashCode() {
        return Objects.hash(allowedFor, appInstanceId, channelBinding, compliance, tokenLifetimeInMinutes, userVerification);
    }

    @Override
    public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class AuthenticatorSettings {\n");
        sb.append("    allowedFor: ").append(toIndentedString(allowedFor)).append("\n");
        sb.append("    appInstanceId: ").append(toIndentedString(appInstanceId)).append("\n");
        sb.append("    channelBinding: ").append(toIndentedString(channelBinding)).append("\n");
        sb.append("    compliance: ").append(toIndentedString(compliance)).append("\n");
        sb.append("    tokenLifetimeInMinutes: ").append(toIndentedString(tokenLifetimeInMinutes)).append("\n");
        sb.append("    userVerification: ").append(toIndentedString(userVerification)).append("\n");
    sb.append("}");
    return sb.toString();
    }

    /**
    * Convert the given object to string with each line indented by 4 spaces
    * (except the first line).
    */
    private String toIndentedString(Object o) {
    if (o == null) {
    return "null";
    }
    return o.toString().replace("\n", "\n    ");
    }


    }
