package org.openapitools.client.model;

import java.util.Objects;
import java.util.Arrays;
    import com.fasterxml.jackson.annotation.JsonPropertyOrder;
    import com.fasterxml.jackson.annotation.JsonTypeName;

        import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * Gets or Sets ApplicationSignOnMode
 */
public enum ApplicationSignOnMode {
  
  AUTO_LOGIN("AUTO_LOGIN"),
  
  BASIC_AUTH("BASIC_AUTH"),
  
  BOOKMARK("BOOKMARK"),
  
  BROWSER_PLUGIN("BROWSER_PLUGIN"),
  
  OPENID_CONNECT("OPENID_CONNECT"),
  
  SAML_1_1("SAML_1_1"),
  
  SAML_2_0("SAML_2_0"),
  
  SECURE_PASSWORD_STORE("SECURE_PASSWORD_STORE"),
  
  WS_FEDERATION("WS_FEDERATION");

  private String value;

  ApplicationSignOnMode(String value) {
    this.value = value;
  }

  @JsonValue
  public String getValue() {
    return value;
  }

  @Override
  public String toString() {
    return String.valueOf(value);
  }

  @JsonCreator
  public static ApplicationSignOnMode fromValue(String value) {
    for (ApplicationSignOnMode b : ApplicationSignOnMode.values()) {
      if (b.value.equals(value)) {
        return b;
      }
    }
    throw new IllegalArgumentException("Unexpected value '" + value + "'");
  }
}

