package org.openapitools.client.model;

import java.util.Objects;
import java.util.Arrays;
    import io.swagger.annotations.ApiModel;
    import com.fasterxml.jackson.annotation.JsonPropertyOrder;
    import com.fasterxml.jackson.annotation.JsonTypeName;

        import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * Overall state for the auto-update job from admin perspective
 */
public enum AgentUpdateJobStatus {
  
  CANCELLED("Cancelled"),
  
  FAILED("Failed"),
  
  INPROGRESS("InProgress"),
  
  PAUSED("Paused"),
  
  SCHEDULED("Scheduled"),
  
  SUCCESS("Success");

  private String value;

  AgentUpdateJobStatus(String value) {
    this.value = value;
  }

  @JsonValue
  public String getValue() {
    return value;
  }

  @Override
  public String toString() {
    return String.valueOf(value);
  }

  @JsonCreator
  public static AgentUpdateJobStatus fromValue(String value) {
    for (AgentUpdateJobStatus b : AgentUpdateJobStatus.values()) {
      if (b.value.equals(value)) {
        return b;
      }
    }
    throw new IllegalArgumentException("Unexpected value '" + value + "'");
  }
}

