package org.openapitools.client.model;

import java.util.Objects;
import java.util.Arrays;
    import io.swagger.annotations.ApiModel;
    import com.fasterxml.jackson.annotation.JsonPropertyOrder;
    import com.fasterxml.jackson.annotation.JsonTypeName;

        import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * Status for one agent regarding the status to auto-update that agent
 */
public enum AgentUpdateInstanceStatus {
  
  CANCELLED("Cancelled"),
  
  FAILED("Failed"),
  
  INPROGRESS("InProgress"),
  
  PENDINGCOMPLETION("PendingCompletion"),
  
  SCHEDULED("Scheduled"),
  
  SUCCESS("Success");

  private String value;

  AgentUpdateInstanceStatus(String value) {
    this.value = value;
  }

  @JsonValue
  public String getValue() {
    return value;
  }

  @Override
  public String toString() {
    return String.valueOf(value);
  }

  @JsonCreator
  public static AgentUpdateInstanceStatus fromValue(String value) {
    for (AgentUpdateInstanceStatus b : AgentUpdateInstanceStatus.values()) {
      if (b.value.equals(value)) {
        return b;
      }
    }
    throw new IllegalArgumentException("Unexpected value '" + value + "'");
  }
}

