package org.openapitools.client.model;

import java.util.Objects;
import java.util.Arrays;
    import io.swagger.annotations.ApiModel;
    import com.fasterxml.jackson.annotation.JsonPropertyOrder;
    import com.fasterxml.jackson.annotation.JsonTypeName;

        import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * Agent types that are being monitored
 */
public enum AgentType {
  
  AD("AD"),
  
  IWA("IWA"),
  
  LDAP("LDAP"),
  
  MFA("MFA"),
  
  OPP("OPP"),
  
  RUM("RUM"),
  
  RADIUS("Radius");

  private String value;

  AgentType(String value) {
    this.value = value;
  }

  @JsonValue
  public String getValue() {
    return value;
  }

  @Override
  public String toString() {
    return String.valueOf(value);
  }

  @JsonCreator
  public static AgentType fromValue(String value) {
    for (AgentType b : AgentType.values()) {
      if (b.value.equals(value)) {
        return b;
      }
    }
    throw new IllegalArgumentException("Unexpected value '" + value + "'");
  }
}

