package org.openapitools.client.api;

import org.openapitools.client.ApiClient;

import org.openapitools.client.model.ActivateFactorRequest;
import org.openapitools.client.model.Error;
import org.openapitools.client.model.SecurityQuestion;
import org.openapitools.client.model.UserFactor;
import org.openapitools.client.model.VerifyFactorRequest;
import org.openapitools.client.model.VerifyUserFactorResponse;

import java.util.Collections;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.LinkedHashMap;
import java.util.stream.Collectors;

import com.okta.sdk.resource.common.PagedList;

import com.okta.commons.lang.Assert;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;

import org.openapitools.jackson.nullable.JsonNullableModule;

@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-10-28T09:44:59.080-05:00[America/Chicago]")
@Component("org.openapitools.client.api.UserFactorApi")
    public class UserFactorApi {
    private ApiClient apiClient;

    public UserFactorApi() {
    this(new ApiClient());
    }

    @Autowired
    public UserFactorApi(ApiClient apiClient) {
    this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
    return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
    this.apiClient = apiClient;
    }

        /**
        * Activate a Factor
        * The &#x60;sms&#x60; and &#x60;token:software:totp&#x60; factor types require activation to complete the enrollment process
            * <p><b>200</b> - Success
            * <p><b>400</b> - Bad Request
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>429</b> - Too Many Requests
                * @param userId  (required)
                * @param factorId  (required)
                * @param body  (optional)
                * @return UserFactor
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public UserFactor activateFactor(String userId, String factorId, ActivateFactorRequest body) throws RestClientException {
                return activateFactorWithHttpInfo(userId, factorId, body).getBody();
            }




            /**
            * Activate a Factor
            * The &#x60;sms&#x60; and &#x60;token:software:totp&#x60; factor types require activation to complete the enrollment process
                * <p><b>200</b> - Success
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param T (required) - the assignable return type
                * @param userId  (required)
                * @param factorId  (required)
                * @param body  (optional)
                * @return T instance
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public <T> T activateFactor(Class<?> T, String userId, String factorId, ActivateFactorRequest body) throws RestClientException {
                return (T) getObjectMapper().convertValue(activateFactorWithReturnType(T, userId, factorId, body).getBody(), T);
            }




            /**
            * Activate a Factor
            * The &#x60;sms&#x60; and &#x60;token:software:totp&#x60; factor types require activation to complete the enrollment process
                * <p><b>200</b> - Success
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param userId  (required)
                * @param factorId  (required)
                * @param body  (optional)
            * @return ResponseEntity&lt;UserFactor&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<UserFactor> activateFactorWithHttpInfo(String userId, String factorId, ActivateFactorRequest body) throws RestClientException {
            Object localVarPostBody = body;
        
                // verify the required parameter 'userId' is set ''
                if (userId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'userId' when calling activateFactor");
                }
        
                // verify the required parameter 'factorId' is set ''
                if (factorId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'factorId' when calling activateFactor");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("userId", userId);
                    uriVariables.put("factorId", factorId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = { 
            "application/json"
         };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<UserFactor> localReturnType = new ParameterizedTypeReference<UserFactor>() {};
            return apiClient.invokeAPI("/api/v1/users/{userId}/factors/{factorId}/lifecycle/activate", HttpMethod.POST, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }




            /**
            * Activate a Factor
            * The &#x60;sms&#x60; and &#x60;token:software:totp&#x60; factor types require activation to complete the enrollment process
                * <p><b>200</b> - Success
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param userId  (required)
                * @param factorId  (required)
                * @param body  (optional)
            * @return ResponseEntity&lt;UserFactor&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private <T> ResponseEntity<T> activateFactorWithReturnType(Class<?> T, String userId,String factorId,ActivateFactorRequest body) throws RestClientException {
            Object localVarPostBody = body;
        
                // verify the required parameter 'userId' is set
                if (userId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'userId' when calling activateFactor");
                }
        
                // verify the required parameter 'factorId' is set
                if (factorId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'factorId' when calling activateFactor");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("userId", userId);
                    uriVariables.put("factorId", factorId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = { 
            "application/json"
         };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<T> localReturnType = new ParameterizedTypeReference<T>() {};
            return apiClient.invokeAPI("/api/v1/users/{userId}/factors/{factorId}/lifecycle/activate", HttpMethod.POST, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }




            /**
            * Activate a Factor
            * The &#x60;sms&#x60; and &#x60;token:software:totp&#x60; factor types require activation to complete the enrollment process
                * <p><b>200</b> - Success
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param userId  (required)
                * @param factorId  (required)
                * @param body  (optional)
            * @return ResponseEntity&lt;UserFactor&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public PagedList activateFactorWithPaginationInfo(String userId, String factorId, ActivateFactorRequest body) throws RestClientException {
            Object localVarPostBody = body;
        
                // verify the required parameter 'userId' is set
                if (userId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'userId' when calling activateFactor");
                }
        
                // verify the required parameter 'factorId' is set
                if (factorId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'factorId' when calling activateFactor");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("userId", userId);
                    uriVariables.put("factorId", factorId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = { 
            "application/json"
         };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<UserFactor> localReturnType = new ParameterizedTypeReference<UserFactor>() {};
            ResponseEntity<UserFactor> responseEntity = apiClient.invokeAPI("/api/v1/users/{userId}/factors/{factorId}/lifecycle/activate", HttpMethod.POST, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                    HttpHeaders headers = responseEntity.getHeaders();
                    PagedList pagedList = new PagedList();
                    List<String> linkHeaders = headers.get("link");
                    String self = null, nextPage = null;
                    for (String link : linkHeaders) {
                    if (link.contains("next")) {
                    nextPage = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    if (link.contains("self")) {
                    self = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    }
                    pagedList.addItems(Arrays.asList(responseEntity.getBody()));
                    if (Objects.nonNull(nextPage)) {
                    pagedList.setNextPage(nextPage);
                    }
                    if (Objects.nonNull(self)) {
                    pagedList.setSelf(self);
                    }
                    return pagedList;
        }

        /**
        * Delete a Factor
        * Unenrolls an existing factor for the specified user, allowing the user to enroll a new factor
            * <p><b>204</b> - No Content
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>429</b> - Too Many Requests
                * @param userId  (required)
                * @param factorId  (required)
                * @param removeEnrollmentRecovery  (optional, default to false)
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public void deleteFactor(String userId, String factorId, Boolean removeEnrollmentRecovery) throws RestClientException {
            deleteFactorWithHttpInfo(userId, factorId, removeEnrollmentRecovery);
            }






            /**
            * Delete a Factor
            * Unenrolls an existing factor for the specified user, allowing the user to enroll a new factor
                * <p><b>204</b> - No Content
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param userId  (required)
                * @param factorId  (required)
                * @param removeEnrollmentRecovery  (optional, default to false)
            * @return ResponseEntity&lt;Void&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<Void> deleteFactorWithHttpInfo(String userId, String factorId, Boolean removeEnrollmentRecovery) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'userId' is set ''
                if (userId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'userId' when calling deleteFactor");
                }
        
                // verify the required parameter 'factorId' is set ''
                if (factorId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'factorId' when calling deleteFactor");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("userId", userId);
                    uriVariables.put("factorId", factorId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "removeEnrollmentRecovery", removeEnrollmentRecovery));

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<Void> localReturnType = new ParameterizedTypeReference<Void>() {};
            return apiClient.invokeAPI("/api/v1/users/{userId}/factors/{factorId}", HttpMethod.DELETE, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }







        /**
        * Enroll a Factor
        * Enrolls a user with a supported factor
            * <p><b>200</b> - Success
            * <p><b>400</b> - Bad Request
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>429</b> - Too Many Requests
                * @param userId  (required)
                * @param body Factor (required)
                * @param updatePhone  (optional, default to false)
                * @param templateId id of SMS template (only for SMS factor) (optional)
                * @param tokenLifetimeSeconds  (optional, default to 300)
                * @param activate  (optional, default to false)
                * @return UserFactor
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public UserFactor enrollFactor(String userId, UserFactor body, Boolean updatePhone, String templateId, Integer tokenLifetimeSeconds, Boolean activate) throws RestClientException {
                return enrollFactorWithHttpInfo(userId, body, updatePhone, templateId, tokenLifetimeSeconds, activate).getBody();
            }




            /**
            * Enroll a Factor
            * Enrolls a user with a supported factor
                * <p><b>200</b> - Success
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param T (required) - the assignable return type
                * @param userId  (required)
                * @param body Factor (required)
                * @param updatePhone  (optional, default to false)
                * @param templateId id of SMS template (only for SMS factor) (optional)
                * @param tokenLifetimeSeconds  (optional, default to 300)
                * @param activate  (optional, default to false)
                * @return T instance
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public <T> T enrollFactor(Class<?> T, String userId, UserFactor body, Boolean updatePhone, String templateId, Integer tokenLifetimeSeconds, Boolean activate) throws RestClientException {
                return (T) getObjectMapper().convertValue(enrollFactorWithReturnType(T, userId, body, updatePhone, templateId, tokenLifetimeSeconds, activate).getBody(), T);
            }




            /**
            * Enroll a Factor
            * Enrolls a user with a supported factor
                * <p><b>200</b> - Success
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param userId  (required)
                * @param body Factor (required)
                * @param updatePhone  (optional, default to false)
                * @param templateId id of SMS template (only for SMS factor) (optional)
                * @param tokenLifetimeSeconds  (optional, default to 300)
                * @param activate  (optional, default to false)
            * @return ResponseEntity&lt;UserFactor&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<UserFactor> enrollFactorWithHttpInfo(String userId, UserFactor body, Boolean updatePhone, String templateId, Integer tokenLifetimeSeconds, Boolean activate) throws RestClientException {
            Object localVarPostBody = body;
        
                // verify the required parameter 'userId' is set ''
                if (userId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'userId' when calling enrollFactor");
                }
        
                // verify the required parameter 'body' is set ''
                if (body == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'body' when calling enrollFactor");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("userId", userId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "updatePhone", updatePhone));
            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "templateId", templateId));
            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "tokenLifetimeSeconds", tokenLifetimeSeconds));
            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "activate", activate));

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = { 
            "application/json"
         };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<UserFactor> localReturnType = new ParameterizedTypeReference<UserFactor>() {};
            return apiClient.invokeAPI("/api/v1/users/{userId}/factors", HttpMethod.POST, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }




            /**
            * Enroll a Factor
            * Enrolls a user with a supported factor
                * <p><b>200</b> - Success
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param userId  (required)
                * @param body Factor (required)
                * @param updatePhone  (optional, default to false)
                * @param templateId id of SMS template (only for SMS factor) (optional)
                * @param tokenLifetimeSeconds  (optional, default to 300)
                * @param activate  (optional, default to false)
            * @return ResponseEntity&lt;UserFactor&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private <T> ResponseEntity<T> enrollFactorWithReturnType(Class<?> T, String userId,UserFactor body,Boolean updatePhone,String templateId,Integer tokenLifetimeSeconds,Boolean activate) throws RestClientException {
            Object localVarPostBody = body;
        
                // verify the required parameter 'userId' is set
                if (userId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'userId' when calling enrollFactor");
                }
        
                // verify the required parameter 'body' is set
                if (body == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'body' when calling enrollFactor");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("userId", userId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "updatePhone", updatePhone));
            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "templateId", templateId));
            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "tokenLifetimeSeconds", tokenLifetimeSeconds));
            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "activate", activate));

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = { 
            "application/json"
         };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<T> localReturnType = new ParameterizedTypeReference<T>() {};
            return apiClient.invokeAPI("/api/v1/users/{userId}/factors", HttpMethod.POST, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }




            /**
            * Enroll a Factor
            * Enrolls a user with a supported factor
                * <p><b>200</b> - Success
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param userId  (required)
                * @param body Factor (required)
                * @param updatePhone  (optional, default to false)
                * @param templateId id of SMS template (only for SMS factor) (optional)
                * @param tokenLifetimeSeconds  (optional, default to 300)
                * @param activate  (optional, default to false)
            * @return ResponseEntity&lt;UserFactor&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public PagedList enrollFactorWithPaginationInfo(String userId, UserFactor body, Boolean updatePhone, String templateId, Integer tokenLifetimeSeconds, Boolean activate) throws RestClientException {
            Object localVarPostBody = body;
        
                // verify the required parameter 'userId' is set
                if (userId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'userId' when calling enrollFactor");
                }
        
                // verify the required parameter 'body' is set
                if (body == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'body' when calling enrollFactor");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("userId", userId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "updatePhone", updatePhone));
            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "templateId", templateId));
            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "tokenLifetimeSeconds", tokenLifetimeSeconds));
            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "activate", activate));

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = { 
            "application/json"
         };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<UserFactor> localReturnType = new ParameterizedTypeReference<UserFactor>() {};
            ResponseEntity<UserFactor> responseEntity = apiClient.invokeAPI("/api/v1/users/{userId}/factors", HttpMethod.POST, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                    HttpHeaders headers = responseEntity.getHeaders();
                    PagedList pagedList = new PagedList();
                    List<String> linkHeaders = headers.get("link");
                    String self = null, nextPage = null;
                    for (String link : linkHeaders) {
                    if (link.contains("next")) {
                    nextPage = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    if (link.contains("self")) {
                    self = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    }
                    pagedList.addItems(Arrays.asList(responseEntity.getBody()));
                    if (Objects.nonNull(nextPage)) {
                    pagedList.setNextPage(nextPage);
                    }
                    if (Objects.nonNull(self)) {
                    pagedList.setSelf(self);
                    }
                    return pagedList;
        }

        /**
        * Retrieve a Factor
        * Retrieves a factor for the specified user
            * <p><b>200</b> - Success
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>429</b> - Too Many Requests
                * @param userId  (required)
                * @param factorId  (required)
                * @return UserFactor
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public UserFactor getFactor(String userId, String factorId) throws RestClientException {
                return getFactorWithHttpInfo(userId, factorId).getBody();
            }






            /**
            * Retrieve a Factor
            * Retrieves a factor for the specified user
                * <p><b>200</b> - Success
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param userId  (required)
                * @param factorId  (required)
            * @return ResponseEntity&lt;UserFactor&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<UserFactor> getFactorWithHttpInfo(String userId, String factorId) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'userId' is set ''
                if (userId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'userId' when calling getFactor");
                }
        
                // verify the required parameter 'factorId' is set ''
                if (factorId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'factorId' when calling getFactor");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("userId", userId);
                    uriVariables.put("factorId", factorId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<UserFactor> localReturnType = new ParameterizedTypeReference<UserFactor>() {};
            return apiClient.invokeAPI("/api/v1/users/{userId}/factors/{factorId}", HttpMethod.GET, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }







            /**
            * Retrieve a Factor
            * Retrieves a factor for the specified user
                * <p><b>200</b> - Success
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param userId  (required)
                * @param factorId  (required)
            * @return ResponseEntity&lt;UserFactor&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public PagedList getFactorWithPaginationInfo(String userId, String factorId) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'userId' is set
                if (userId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'userId' when calling getFactor");
                }
        
                // verify the required parameter 'factorId' is set
                if (factorId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'factorId' when calling getFactor");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("userId", userId);
                    uriVariables.put("factorId", factorId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<UserFactor> localReturnType = new ParameterizedTypeReference<UserFactor>() {};
            ResponseEntity<UserFactor> responseEntity = apiClient.invokeAPI("/api/v1/users/{userId}/factors/{factorId}", HttpMethod.GET, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                    HttpHeaders headers = responseEntity.getHeaders();
                    PagedList pagedList = new PagedList();
                    List<String> linkHeaders = headers.get("link");
                    String self = null, nextPage = null;
                    for (String link : linkHeaders) {
                    if (link.contains("next")) {
                    nextPage = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    if (link.contains("self")) {
                    self = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    }
                    pagedList.addItems(Arrays.asList(responseEntity.getBody()));
                    if (Objects.nonNull(nextPage)) {
                    pagedList.setNextPage(nextPage);
                    }
                    if (Objects.nonNull(self)) {
                    pagedList.setSelf(self);
                    }
                    return pagedList;
        }

        /**
        * Retrieve a Factor Transaction Status
        * Polls factors verification transaction for status
            * <p><b>200</b> - Success
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>429</b> - Too Many Requests
                * @param userId  (required)
                * @param factorId  (required)
                * @param transactionId  (required)
                * @return VerifyUserFactorResponse
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public VerifyUserFactorResponse getFactorTransactionStatus(String userId, String factorId, String transactionId) throws RestClientException {
                return getFactorTransactionStatusWithHttpInfo(userId, factorId, transactionId).getBody();
            }






            /**
            * Retrieve a Factor Transaction Status
            * Polls factors verification transaction for status
                * <p><b>200</b> - Success
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param userId  (required)
                * @param factorId  (required)
                * @param transactionId  (required)
            * @return ResponseEntity&lt;VerifyUserFactorResponse&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<VerifyUserFactorResponse> getFactorTransactionStatusWithHttpInfo(String userId, String factorId, String transactionId) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'userId' is set ''
                if (userId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'userId' when calling getFactorTransactionStatus");
                }
        
                // verify the required parameter 'factorId' is set ''
                if (factorId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'factorId' when calling getFactorTransactionStatus");
                }
        
                // verify the required parameter 'transactionId' is set ''
                if (transactionId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'transactionId' when calling getFactorTransactionStatus");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("userId", userId);
                    uriVariables.put("factorId", factorId);
                    uriVariables.put("transactionId", transactionId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<VerifyUserFactorResponse> localReturnType = new ParameterizedTypeReference<VerifyUserFactorResponse>() {};
            return apiClient.invokeAPI("/api/v1/users/{userId}/factors/{factorId}/transactions/{transactionId}", HttpMethod.GET, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }







            /**
            * Retrieve a Factor Transaction Status
            * Polls factors verification transaction for status
                * <p><b>200</b> - Success
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param userId  (required)
                * @param factorId  (required)
                * @param transactionId  (required)
            * @return ResponseEntity&lt;VerifyUserFactorResponse&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public PagedList getFactorTransactionStatusWithPaginationInfo(String userId, String factorId, String transactionId) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'userId' is set
                if (userId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'userId' when calling getFactorTransactionStatus");
                }
        
                // verify the required parameter 'factorId' is set
                if (factorId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'factorId' when calling getFactorTransactionStatus");
                }
        
                // verify the required parameter 'transactionId' is set
                if (transactionId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'transactionId' when calling getFactorTransactionStatus");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("userId", userId);
                    uriVariables.put("factorId", factorId);
                    uriVariables.put("transactionId", transactionId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<VerifyUserFactorResponse> localReturnType = new ParameterizedTypeReference<VerifyUserFactorResponse>() {};
            ResponseEntity<VerifyUserFactorResponse> responseEntity = apiClient.invokeAPI("/api/v1/users/{userId}/factors/{factorId}/transactions/{transactionId}", HttpMethod.GET, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                    HttpHeaders headers = responseEntity.getHeaders();
                    PagedList pagedList = new PagedList();
                    List<String> linkHeaders = headers.get("link");
                    String self = null, nextPage = null;
                    for (String link : linkHeaders) {
                    if (link.contains("next")) {
                    nextPage = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    if (link.contains("self")) {
                    self = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    }
                    pagedList.addItems(Arrays.asList(responseEntity.getBody()));
                    if (Objects.nonNull(nextPage)) {
                    pagedList.setNextPage(nextPage);
                    }
                    if (Objects.nonNull(self)) {
                    pagedList.setSelf(self);
                    }
                    return pagedList;
        }

        /**
        * List all Factors
        * Lists all the enrolled factors for the specified user
            * <p><b>200</b> - Success
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>429</b> - Too Many Requests
                * @param userId  (required)
                * @return List&lt;UserFactor&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public List<UserFactor> listFactors(String userId) throws RestClientException {
                return listFactorsWithHttpInfo(userId).getBody();
            }






            /**
            * List all Factors
            * Lists all the enrolled factors for the specified user
                * <p><b>200</b> - Success
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param userId  (required)
            * @return ResponseEntity&lt;List&lt;UserFactor&gt;&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<List<UserFactor>> listFactorsWithHttpInfo(String userId) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'userId' is set ''
                if (userId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'userId' when calling listFactors");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("userId", userId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<List<UserFactor>> localReturnType = new ParameterizedTypeReference<List<UserFactor>>() {};
            return apiClient.invokeAPI("/api/v1/users/{userId}/factors", HttpMethod.GET, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }







            /**
            * List all Factors
            * Lists all the enrolled factors for the specified user
                * <p><b>200</b> - Success
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param userId  (required)
            * @return ResponseEntity&lt;List&lt;UserFactor&gt;&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public PagedList listFactorsWithPaginationInfo(String userId) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'userId' is set
                if (userId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'userId' when calling listFactors");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("userId", userId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<List<UserFactor>> localReturnType = new ParameterizedTypeReference<List<UserFactor>>() {};
            ResponseEntity<List<UserFactor>> responseEntity = apiClient.invokeAPI("/api/v1/users/{userId}/factors", HttpMethod.GET, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                    HttpHeaders headers = responseEntity.getHeaders();
                    PagedList pagedList = new PagedList();
                    List<String> linkHeaders = headers.get("link");
                    String self = null, nextPage = null;
                    for (String link : linkHeaders) {
                    if (link.contains("next")) {
                    nextPage = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    if (link.contains("self")) {
                    self = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    }
                    pagedList.addItems(Arrays.asList(responseEntity.getBody()));
                    if (Objects.nonNull(nextPage)) {
                    pagedList.setNextPage(nextPage);
                    }
                    if (Objects.nonNull(self)) {
                    pagedList.setSelf(self);
                    }
                    return pagedList;
        }

        /**
        * List all Supported Factors
        * Lists all the supported factors that can be enrolled for the specified user
            * <p><b>200</b> - Success
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>429</b> - Too Many Requests
                * @param userId  (required)
                * @return List&lt;UserFactor&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public List<UserFactor> listSupportedFactors(String userId) throws RestClientException {
                return listSupportedFactorsWithHttpInfo(userId).getBody();
            }






            /**
            * List all Supported Factors
            * Lists all the supported factors that can be enrolled for the specified user
                * <p><b>200</b> - Success
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param userId  (required)
            * @return ResponseEntity&lt;List&lt;UserFactor&gt;&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<List<UserFactor>> listSupportedFactorsWithHttpInfo(String userId) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'userId' is set ''
                if (userId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'userId' when calling listSupportedFactors");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("userId", userId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<List<UserFactor>> localReturnType = new ParameterizedTypeReference<List<UserFactor>>() {};
            return apiClient.invokeAPI("/api/v1/users/{userId}/factors/catalog", HttpMethod.GET, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }







            /**
            * List all Supported Factors
            * Lists all the supported factors that can be enrolled for the specified user
                * <p><b>200</b> - Success
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param userId  (required)
            * @return ResponseEntity&lt;List&lt;UserFactor&gt;&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public PagedList listSupportedFactorsWithPaginationInfo(String userId) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'userId' is set
                if (userId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'userId' when calling listSupportedFactors");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("userId", userId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<List<UserFactor>> localReturnType = new ParameterizedTypeReference<List<UserFactor>>() {};
            ResponseEntity<List<UserFactor>> responseEntity = apiClient.invokeAPI("/api/v1/users/{userId}/factors/catalog", HttpMethod.GET, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                    HttpHeaders headers = responseEntity.getHeaders();
                    PagedList pagedList = new PagedList();
                    List<String> linkHeaders = headers.get("link");
                    String self = null, nextPage = null;
                    for (String link : linkHeaders) {
                    if (link.contains("next")) {
                    nextPage = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    if (link.contains("self")) {
                    self = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    }
                    pagedList.addItems(Arrays.asList(responseEntity.getBody()));
                    if (Objects.nonNull(nextPage)) {
                    pagedList.setNextPage(nextPage);
                    }
                    if (Objects.nonNull(self)) {
                    pagedList.setSelf(self);
                    }
                    return pagedList;
        }

        /**
        * List all Supported Security Questions
        * Lists all available security questions for a user&#39;s &#x60;question&#x60; factor
            * <p><b>200</b> - Success
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>429</b> - Too Many Requests
                * @param userId  (required)
                * @return List&lt;SecurityQuestion&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public List<SecurityQuestion> listSupportedSecurityQuestions(String userId) throws RestClientException {
                return listSupportedSecurityQuestionsWithHttpInfo(userId).getBody();
            }






            /**
            * List all Supported Security Questions
            * Lists all available security questions for a user&#39;s &#x60;question&#x60; factor
                * <p><b>200</b> - Success
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param userId  (required)
            * @return ResponseEntity&lt;List&lt;SecurityQuestion&gt;&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<List<SecurityQuestion>> listSupportedSecurityQuestionsWithHttpInfo(String userId) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'userId' is set ''
                if (userId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'userId' when calling listSupportedSecurityQuestions");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("userId", userId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken" };

        ParameterizedTypeReference<List<SecurityQuestion>> localReturnType = new ParameterizedTypeReference<List<SecurityQuestion>>() {};
            return apiClient.invokeAPI("/api/v1/users/{userId}/factors/questions", HttpMethod.GET, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }







            /**
            * List all Supported Security Questions
            * Lists all available security questions for a user&#39;s &#x60;question&#x60; factor
                * <p><b>200</b> - Success
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param userId  (required)
            * @return ResponseEntity&lt;List&lt;SecurityQuestion&gt;&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public PagedList listSupportedSecurityQuestionsWithPaginationInfo(String userId) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'userId' is set
                if (userId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'userId' when calling listSupportedSecurityQuestions");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("userId", userId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken" };

        ParameterizedTypeReference<List<SecurityQuestion>> localReturnType = new ParameterizedTypeReference<List<SecurityQuestion>>() {};
            ResponseEntity<List<SecurityQuestion>> responseEntity = apiClient.invokeAPI("/api/v1/users/{userId}/factors/questions", HttpMethod.GET, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                    HttpHeaders headers = responseEntity.getHeaders();
                    PagedList pagedList = new PagedList();
                    List<String> linkHeaders = headers.get("link");
                    String self = null, nextPage = null;
                    for (String link : linkHeaders) {
                    if (link.contains("next")) {
                    nextPage = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    if (link.contains("self")) {
                    self = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    }
                    pagedList.addItems(Arrays.asList(responseEntity.getBody()));
                    if (Objects.nonNull(nextPage)) {
                    pagedList.setNextPage(nextPage);
                    }
                    if (Objects.nonNull(self)) {
                    pagedList.setSelf(self);
                    }
                    return pagedList;
        }

        /**
        * Verify an MFA Factor
        * Verifies an OTP for a &#x60;token&#x60; or &#x60;token:hardware&#x60; factor
            * <p><b>200</b> - Success
            * <p><b>400</b> - Bad Request
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>429</b> - Too Many Requests
                * @param userId  (required)
                * @param factorId  (required)
                * @param templateId  (optional)
                * @param tokenLifetimeSeconds  (optional, default to 300)
                * @param xForwardedFor  (optional)
                * @param userAgent  (optional)
                * @param acceptLanguage  (optional)
                * @param body  (optional)
                * @return VerifyUserFactorResponse
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public VerifyUserFactorResponse verifyFactor(String userId, String factorId, String templateId, Integer tokenLifetimeSeconds, String xForwardedFor, String userAgent, String acceptLanguage, VerifyFactorRequest body) throws RestClientException {
                return verifyFactorWithHttpInfo(userId, factorId, templateId, tokenLifetimeSeconds, xForwardedFor, userAgent, acceptLanguage, body).getBody();
            }




            /**
            * Verify an MFA Factor
            * Verifies an OTP for a &#x60;token&#x60; or &#x60;token:hardware&#x60; factor
                * <p><b>200</b> - Success
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param T (required) - the assignable return type
                * @param userId  (required)
                * @param factorId  (required)
                * @param templateId  (optional)
                * @param tokenLifetimeSeconds  (optional, default to 300)
                * @param xForwardedFor  (optional)
                * @param userAgent  (optional)
                * @param acceptLanguage  (optional)
                * @param body  (optional)
                * @return T instance
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public <T> T verifyFactor(Class<?> T, String userId, String factorId, String templateId, Integer tokenLifetimeSeconds, String xForwardedFor, String userAgent, String acceptLanguage, VerifyFactorRequest body) throws RestClientException {
                return (T) getObjectMapper().convertValue(verifyFactorWithReturnType(T, userId, factorId, templateId, tokenLifetimeSeconds, xForwardedFor, userAgent, acceptLanguage, body).getBody(), T);
            }




            /**
            * Verify an MFA Factor
            * Verifies an OTP for a &#x60;token&#x60; or &#x60;token:hardware&#x60; factor
                * <p><b>200</b> - Success
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param userId  (required)
                * @param factorId  (required)
                * @param templateId  (optional)
                * @param tokenLifetimeSeconds  (optional, default to 300)
                * @param xForwardedFor  (optional)
                * @param userAgent  (optional)
                * @param acceptLanguage  (optional)
                * @param body  (optional)
            * @return ResponseEntity&lt;VerifyUserFactorResponse&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<VerifyUserFactorResponse> verifyFactorWithHttpInfo(String userId, String factorId, String templateId, Integer tokenLifetimeSeconds, String xForwardedFor, String userAgent, String acceptLanguage, VerifyFactorRequest body) throws RestClientException {
            Object localVarPostBody = body;
        
                // verify the required parameter 'userId' is set ''
                if (userId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'userId' when calling verifyFactor");
                }
        
                // verify the required parameter 'factorId' is set ''
                if (factorId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'factorId' when calling verifyFactor");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("userId", userId);
                    uriVariables.put("factorId", factorId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "templateId", templateId));
            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "tokenLifetimeSeconds", tokenLifetimeSeconds));

            if (xForwardedFor != null)
                localVarHeaderParams.add("X-Forwarded-For", apiClient.parameterToString(xForwardedFor));
            if (userAgent != null)
                localVarHeaderParams.add("User-Agent", apiClient.parameterToString(userAgent));
            if (acceptLanguage != null)
                localVarHeaderParams.add("Accept-Language", apiClient.parameterToString(acceptLanguage));

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = { 
            "application/json"
         };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<VerifyUserFactorResponse> localReturnType = new ParameterizedTypeReference<VerifyUserFactorResponse>() {};
            return apiClient.invokeAPI("/api/v1/users/{userId}/factors/{factorId}/verify", HttpMethod.POST, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }




            /**
            * Verify an MFA Factor
            * Verifies an OTP for a &#x60;token&#x60; or &#x60;token:hardware&#x60; factor
                * <p><b>200</b> - Success
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param userId  (required)
                * @param factorId  (required)
                * @param templateId  (optional)
                * @param tokenLifetimeSeconds  (optional, default to 300)
                * @param xForwardedFor  (optional)
                * @param userAgent  (optional)
                * @param acceptLanguage  (optional)
                * @param body  (optional)
            * @return ResponseEntity&lt;VerifyUserFactorResponse&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private <T> ResponseEntity<T> verifyFactorWithReturnType(Class<?> T, String userId,String factorId,String templateId,Integer tokenLifetimeSeconds,String xForwardedFor,String userAgent,String acceptLanguage,VerifyFactorRequest body) throws RestClientException {
            Object localVarPostBody = body;
        
                // verify the required parameter 'userId' is set
                if (userId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'userId' when calling verifyFactor");
                }
        
                // verify the required parameter 'factorId' is set
                if (factorId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'factorId' when calling verifyFactor");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("userId", userId);
                    uriVariables.put("factorId", factorId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "templateId", templateId));
            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "tokenLifetimeSeconds", tokenLifetimeSeconds));

            if (xForwardedFor != null)
                localVarHeaderParams.add("X-Forwarded-For", apiClient.parameterToString(xForwardedFor));
            if (userAgent != null)
                localVarHeaderParams.add("User-Agent", apiClient.parameterToString(userAgent));
            if (acceptLanguage != null)
                localVarHeaderParams.add("Accept-Language", apiClient.parameterToString(acceptLanguage));

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = { 
            "application/json"
         };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<T> localReturnType = new ParameterizedTypeReference<T>() {};
            return apiClient.invokeAPI("/api/v1/users/{userId}/factors/{factorId}/verify", HttpMethod.POST, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }




            /**
            * Verify an MFA Factor
            * Verifies an OTP for a &#x60;token&#x60; or &#x60;token:hardware&#x60; factor
                * <p><b>200</b> - Success
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param userId  (required)
                * @param factorId  (required)
                * @param templateId  (optional)
                * @param tokenLifetimeSeconds  (optional, default to 300)
                * @param xForwardedFor  (optional)
                * @param userAgent  (optional)
                * @param acceptLanguage  (optional)
                * @param body  (optional)
            * @return ResponseEntity&lt;VerifyUserFactorResponse&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public PagedList verifyFactorWithPaginationInfo(String userId, String factorId, String templateId, Integer tokenLifetimeSeconds, String xForwardedFor, String userAgent, String acceptLanguage, VerifyFactorRequest body) throws RestClientException {
            Object localVarPostBody = body;
        
                // verify the required parameter 'userId' is set
                if (userId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'userId' when calling verifyFactor");
                }
        
                // verify the required parameter 'factorId' is set
                if (factorId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'factorId' when calling verifyFactor");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("userId", userId);
                    uriVariables.put("factorId", factorId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "templateId", templateId));
            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "tokenLifetimeSeconds", tokenLifetimeSeconds));

            if (xForwardedFor != null)
                localVarHeaderParams.add("X-Forwarded-For", apiClient.parameterToString(xForwardedFor));
            if (userAgent != null)
                localVarHeaderParams.add("User-Agent", apiClient.parameterToString(userAgent));
            if (acceptLanguage != null)
                localVarHeaderParams.add("Accept-Language", apiClient.parameterToString(acceptLanguage));

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = { 
            "application/json"
         };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<VerifyUserFactorResponse> localReturnType = new ParameterizedTypeReference<VerifyUserFactorResponse>() {};
            ResponseEntity<VerifyUserFactorResponse> responseEntity = apiClient.invokeAPI("/api/v1/users/{userId}/factors/{factorId}/verify", HttpMethod.POST, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                    HttpHeaders headers = responseEntity.getHeaders();
                    PagedList pagedList = new PagedList();
                    List<String> linkHeaders = headers.get("link");
                    String self = null, nextPage = null;
                    for (String link : linkHeaders) {
                    if (link.contains("next")) {
                    nextPage = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    if (link.contains("self")) {
                    self = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    }
                    pagedList.addItems(Arrays.asList(responseEntity.getBody()));
                    if (Objects.nonNull(nextPage)) {
                    pagedList.setNextPage(nextPage);
                    }
                    if (Objects.nonNull(self)) {
                    pagedList.setSelf(self);
                    }
                    return pagedList;
        }


    private ObjectMapper getObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule(new JavaTimeModule());
        objectMapper.registerModule(new JsonNullableModule());
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        return objectMapper;
    }
        }
