package org.openapitools.client.api;

import org.openapitools.client.ApiClient;

import org.openapitools.client.model.AssignRoleRequest;
import org.openapitools.client.model.Error;
import org.openapitools.client.model.Role;

import java.util.Collections;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.LinkedHashMap;
import java.util.stream.Collectors;

import com.okta.sdk.resource.common.PagedList;

import com.okta.commons.lang.Assert;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;

import org.openapitools.jackson.nullable.JsonNullableModule;

@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-10-28T09:44:59.080-05:00[America/Chicago]")
@Component("org.openapitools.client.api.RoleAssignmentApi")
    public class RoleAssignmentApi {
    private ApiClient apiClient;

    public RoleAssignmentApi() {
    this(new ApiClient());
    }

    @Autowired
    public RoleAssignmentApi(ApiClient apiClient) {
    this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
    return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
    this.apiClient = apiClient;
    }

        /**
        * Assign a Role to a Group
        * Assigns a role to a group
            * <p><b>200</b> - Success
            * <p><b>201</b> - Success
            * <p><b>400</b> - Bad Request
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>429</b> - Too Many Requests
                * @param groupId  (required)
                * @param assignRoleRequest  (required)
                * @param disableNotifications Setting this to &#x60;true&#x60; grants the group third-party admin status (optional)
                * @return Role
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public Role assignRoleToGroup(String groupId, AssignRoleRequest assignRoleRequest, Boolean disableNotifications) throws RestClientException {
                return assignRoleToGroupWithHttpInfo(groupId, assignRoleRequest, disableNotifications).getBody();
            }




            /**
            * Assign a Role to a Group
            * Assigns a role to a group
                * <p><b>200</b> - Success
                * <p><b>201</b> - Success
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param T (required) - the assignable return type
                * @param groupId  (required)
                * @param assignRoleRequest  (required)
                * @param disableNotifications Setting this to &#x60;true&#x60; grants the group third-party admin status (optional)
                * @return T instance
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public <T> T assignRoleToGroup(Class<?> T, String groupId, AssignRoleRequest assignRoleRequest, Boolean disableNotifications) throws RestClientException {
                return (T) getObjectMapper().convertValue(assignRoleToGroupWithReturnType(T, groupId, assignRoleRequest, disableNotifications).getBody(), T);
            }




            /**
            * Assign a Role to a Group
            * Assigns a role to a group
                * <p><b>200</b> - Success
                * <p><b>201</b> - Success
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param groupId  (required)
                * @param assignRoleRequest  (required)
                * @param disableNotifications Setting this to &#x60;true&#x60; grants the group third-party admin status (optional)
            * @return ResponseEntity&lt;Role&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<Role> assignRoleToGroupWithHttpInfo(String groupId, AssignRoleRequest assignRoleRequest, Boolean disableNotifications) throws RestClientException {
            Object localVarPostBody = assignRoleRequest;
        
                // verify the required parameter 'groupId' is set ''
                if (groupId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'groupId' when calling assignRoleToGroup");
                }
        
                // verify the required parameter 'assignRoleRequest' is set ''
                if (assignRoleRequest == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'assignRoleRequest' when calling assignRoleToGroup");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("groupId", groupId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "disableNotifications", disableNotifications));

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = { 
            "application/json"
         };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<Role> localReturnType = new ParameterizedTypeReference<Role>() {};
            return apiClient.invokeAPI("/api/v1/groups/{groupId}/roles", HttpMethod.POST, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }




            /**
            * Assign a Role to a Group
            * Assigns a role to a group
                * <p><b>200</b> - Success
                * <p><b>201</b> - Success
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param groupId  (required)
                * @param assignRoleRequest  (required)
                * @param disableNotifications Setting this to &#x60;true&#x60; grants the group third-party admin status (optional)
            * @return ResponseEntity&lt;Role&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private <T> ResponseEntity<T> assignRoleToGroupWithReturnType(Class<?> T, String groupId,AssignRoleRequest assignRoleRequest,Boolean disableNotifications) throws RestClientException {
            Object localVarPostBody = assignRoleRequest;
        
                // verify the required parameter 'groupId' is set
                if (groupId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'groupId' when calling assignRoleToGroup");
                }
        
                // verify the required parameter 'assignRoleRequest' is set
                if (assignRoleRequest == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'assignRoleRequest' when calling assignRoleToGroup");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("groupId", groupId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "disableNotifications", disableNotifications));

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = { 
            "application/json"
         };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<T> localReturnType = new ParameterizedTypeReference<T>() {};
            return apiClient.invokeAPI("/api/v1/groups/{groupId}/roles", HttpMethod.POST, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }




            /**
            * Assign a Role to a Group
            * Assigns a role to a group
                * <p><b>200</b> - Success
                * <p><b>201</b> - Success
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param groupId  (required)
                * @param assignRoleRequest  (required)
                * @param disableNotifications Setting this to &#x60;true&#x60; grants the group third-party admin status (optional)
            * @return ResponseEntity&lt;Role&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public PagedList assignRoleToGroupWithPaginationInfo(String groupId, AssignRoleRequest assignRoleRequest, Boolean disableNotifications) throws RestClientException {
            Object localVarPostBody = assignRoleRequest;
        
                // verify the required parameter 'groupId' is set
                if (groupId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'groupId' when calling assignRoleToGroup");
                }
        
                // verify the required parameter 'assignRoleRequest' is set
                if (assignRoleRequest == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'assignRoleRequest' when calling assignRoleToGroup");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("groupId", groupId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "disableNotifications", disableNotifications));

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = { 
            "application/json"
         };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<Role> localReturnType = new ParameterizedTypeReference<Role>() {};
            ResponseEntity<Role> responseEntity = apiClient.invokeAPI("/api/v1/groups/{groupId}/roles", HttpMethod.POST, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                    HttpHeaders headers = responseEntity.getHeaders();
                    PagedList pagedList = new PagedList();
                    List<String> linkHeaders = headers.get("link");
                    String self = null, nextPage = null;
                    for (String link : linkHeaders) {
                    if (link.contains("next")) {
                    nextPage = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    if (link.contains("self")) {
                    self = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    }
                    pagedList.addItems(Arrays.asList(responseEntity.getBody()));
                    if (Objects.nonNull(nextPage)) {
                    pagedList.setNextPage(nextPage);
                    }
                    if (Objects.nonNull(self)) {
                    pagedList.setSelf(self);
                    }
                    return pagedList;
        }

        /**
        * Assign a Role to a User
        * Assigns a role to a user identified by &#x60;userId&#x60;
            * <p><b>201</b> - Created
            * <p><b>400</b> - Bad Request
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>429</b> - Too Many Requests
                * @param userId  (required)
                * @param assignRoleRequest  (required)
                * @param disableNotifications Setting this to &#x60;true&#x60; grants the user third-party admin status (optional)
                * @return Role
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public Role assignRoleToUser(String userId, AssignRoleRequest assignRoleRequest, Boolean disableNotifications) throws RestClientException {
                return assignRoleToUserWithHttpInfo(userId, assignRoleRequest, disableNotifications).getBody();
            }




            /**
            * Assign a Role to a User
            * Assigns a role to a user identified by &#x60;userId&#x60;
                * <p><b>201</b> - Created
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param T (required) - the assignable return type
                * @param userId  (required)
                * @param assignRoleRequest  (required)
                * @param disableNotifications Setting this to &#x60;true&#x60; grants the user third-party admin status (optional)
                * @return T instance
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public <T> T assignRoleToUser(Class<?> T, String userId, AssignRoleRequest assignRoleRequest, Boolean disableNotifications) throws RestClientException {
                return (T) getObjectMapper().convertValue(assignRoleToUserWithReturnType(T, userId, assignRoleRequest, disableNotifications).getBody(), T);
            }




            /**
            * Assign a Role to a User
            * Assigns a role to a user identified by &#x60;userId&#x60;
                * <p><b>201</b> - Created
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param userId  (required)
                * @param assignRoleRequest  (required)
                * @param disableNotifications Setting this to &#x60;true&#x60; grants the user third-party admin status (optional)
            * @return ResponseEntity&lt;Role&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<Role> assignRoleToUserWithHttpInfo(String userId, AssignRoleRequest assignRoleRequest, Boolean disableNotifications) throws RestClientException {
            Object localVarPostBody = assignRoleRequest;
        
                // verify the required parameter 'userId' is set ''
                if (userId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'userId' when calling assignRoleToUser");
                }
        
                // verify the required parameter 'assignRoleRequest' is set ''
                if (assignRoleRequest == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'assignRoleRequest' when calling assignRoleToUser");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("userId", userId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "disableNotifications", disableNotifications));

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = { 
            "application/json"
         };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<Role> localReturnType = new ParameterizedTypeReference<Role>() {};
            return apiClient.invokeAPI("/api/v1/users/{userId}/roles", HttpMethod.POST, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }




            /**
            * Assign a Role to a User
            * Assigns a role to a user identified by &#x60;userId&#x60;
                * <p><b>201</b> - Created
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param userId  (required)
                * @param assignRoleRequest  (required)
                * @param disableNotifications Setting this to &#x60;true&#x60; grants the user third-party admin status (optional)
            * @return ResponseEntity&lt;Role&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private <T> ResponseEntity<T> assignRoleToUserWithReturnType(Class<?> T, String userId,AssignRoleRequest assignRoleRequest,Boolean disableNotifications) throws RestClientException {
            Object localVarPostBody = assignRoleRequest;
        
                // verify the required parameter 'userId' is set
                if (userId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'userId' when calling assignRoleToUser");
                }
        
                // verify the required parameter 'assignRoleRequest' is set
                if (assignRoleRequest == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'assignRoleRequest' when calling assignRoleToUser");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("userId", userId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "disableNotifications", disableNotifications));

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = { 
            "application/json"
         };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<T> localReturnType = new ParameterizedTypeReference<T>() {};
            return apiClient.invokeAPI("/api/v1/users/{userId}/roles", HttpMethod.POST, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }




            /**
            * Assign a Role to a User
            * Assigns a role to a user identified by &#x60;userId&#x60;
                * <p><b>201</b> - Created
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param userId  (required)
                * @param assignRoleRequest  (required)
                * @param disableNotifications Setting this to &#x60;true&#x60; grants the user third-party admin status (optional)
            * @return ResponseEntity&lt;Role&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public PagedList assignRoleToUserWithPaginationInfo(String userId, AssignRoleRequest assignRoleRequest, Boolean disableNotifications) throws RestClientException {
            Object localVarPostBody = assignRoleRequest;
        
                // verify the required parameter 'userId' is set
                if (userId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'userId' when calling assignRoleToUser");
                }
        
                // verify the required parameter 'assignRoleRequest' is set
                if (assignRoleRequest == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'assignRoleRequest' when calling assignRoleToUser");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("userId", userId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "disableNotifications", disableNotifications));

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = { 
            "application/json"
         };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<Role> localReturnType = new ParameterizedTypeReference<Role>() {};
            ResponseEntity<Role> responseEntity = apiClient.invokeAPI("/api/v1/users/{userId}/roles", HttpMethod.POST, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                    HttpHeaders headers = responseEntity.getHeaders();
                    PagedList pagedList = new PagedList();
                    List<String> linkHeaders = headers.get("link");
                    String self = null, nextPage = null;
                    for (String link : linkHeaders) {
                    if (link.contains("next")) {
                    nextPage = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    if (link.contains("self")) {
                    self = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    }
                    pagedList.addItems(Arrays.asList(responseEntity.getBody()));
                    if (Objects.nonNull(nextPage)) {
                    pagedList.setNextPage(nextPage);
                    }
                    if (Objects.nonNull(self)) {
                    pagedList.setSelf(self);
                    }
                    return pagedList;
        }

        /**
        * Retrieve a Role assigned to Group
        * Retrieves a role identified by &#x60;roleId&#x60; assigned to group identified by &#x60;groupId&#x60;
            * <p><b>200</b> - Success
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>429</b> - Too Many Requests
                * @param groupId  (required)
                * @param roleId  (required)
                * @return Role
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public Role getGroupAssignedRole(String groupId, String roleId) throws RestClientException {
                return getGroupAssignedRoleWithHttpInfo(groupId, roleId).getBody();
            }






            /**
            * Retrieve a Role assigned to Group
            * Retrieves a role identified by &#x60;roleId&#x60; assigned to group identified by &#x60;groupId&#x60;
                * <p><b>200</b> - Success
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param groupId  (required)
                * @param roleId  (required)
            * @return ResponseEntity&lt;Role&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<Role> getGroupAssignedRoleWithHttpInfo(String groupId, String roleId) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'groupId' is set ''
                if (groupId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'groupId' when calling getGroupAssignedRole");
                }
        
                // verify the required parameter 'roleId' is set ''
                if (roleId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'roleId' when calling getGroupAssignedRole");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("groupId", groupId);
                    uriVariables.put("roleId", roleId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<Role> localReturnType = new ParameterizedTypeReference<Role>() {};
            return apiClient.invokeAPI("/api/v1/groups/{groupId}/roles/{roleId}", HttpMethod.GET, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }







            /**
            * Retrieve a Role assigned to Group
            * Retrieves a role identified by &#x60;roleId&#x60; assigned to group identified by &#x60;groupId&#x60;
                * <p><b>200</b> - Success
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param groupId  (required)
                * @param roleId  (required)
            * @return ResponseEntity&lt;Role&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public PagedList getGroupAssignedRoleWithPaginationInfo(String groupId, String roleId) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'groupId' is set
                if (groupId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'groupId' when calling getGroupAssignedRole");
                }
        
                // verify the required parameter 'roleId' is set
                if (roleId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'roleId' when calling getGroupAssignedRole");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("groupId", groupId);
                    uriVariables.put("roleId", roleId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<Role> localReturnType = new ParameterizedTypeReference<Role>() {};
            ResponseEntity<Role> responseEntity = apiClient.invokeAPI("/api/v1/groups/{groupId}/roles/{roleId}", HttpMethod.GET, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                    HttpHeaders headers = responseEntity.getHeaders();
                    PagedList pagedList = new PagedList();
                    List<String> linkHeaders = headers.get("link");
                    String self = null, nextPage = null;
                    for (String link : linkHeaders) {
                    if (link.contains("next")) {
                    nextPage = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    if (link.contains("self")) {
                    self = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    }
                    pagedList.addItems(Arrays.asList(responseEntity.getBody()));
                    if (Objects.nonNull(nextPage)) {
                    pagedList.setNextPage(nextPage);
                    }
                    if (Objects.nonNull(self)) {
                    pagedList.setSelf(self);
                    }
                    return pagedList;
        }

        /**
        * Retrieve a Role assigned to a User
        * Retrieves a role identified by &#x60;roleId&#x60; assigned to a user identified by &#x60;userId&#x60;
            * <p><b>200</b> - Success
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>429</b> - Too Many Requests
                * @param userId  (required)
                * @param roleId  (required)
                * @return Role
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public Role getUserAssignedRole(String userId, String roleId) throws RestClientException {
                return getUserAssignedRoleWithHttpInfo(userId, roleId).getBody();
            }






            /**
            * Retrieve a Role assigned to a User
            * Retrieves a role identified by &#x60;roleId&#x60; assigned to a user identified by &#x60;userId&#x60;
                * <p><b>200</b> - Success
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param userId  (required)
                * @param roleId  (required)
            * @return ResponseEntity&lt;Role&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<Role> getUserAssignedRoleWithHttpInfo(String userId, String roleId) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'userId' is set ''
                if (userId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'userId' when calling getUserAssignedRole");
                }
        
                // verify the required parameter 'roleId' is set ''
                if (roleId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'roleId' when calling getUserAssignedRole");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("userId", userId);
                    uriVariables.put("roleId", roleId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<Role> localReturnType = new ParameterizedTypeReference<Role>() {};
            return apiClient.invokeAPI("/api/v1/users/{userId}/roles/{roleId}", HttpMethod.GET, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }







            /**
            * Retrieve a Role assigned to a User
            * Retrieves a role identified by &#x60;roleId&#x60; assigned to a user identified by &#x60;userId&#x60;
                * <p><b>200</b> - Success
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param userId  (required)
                * @param roleId  (required)
            * @return ResponseEntity&lt;Role&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public PagedList getUserAssignedRoleWithPaginationInfo(String userId, String roleId) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'userId' is set
                if (userId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'userId' when calling getUserAssignedRole");
                }
        
                // verify the required parameter 'roleId' is set
                if (roleId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'roleId' when calling getUserAssignedRole");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("userId", userId);
                    uriVariables.put("roleId", roleId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<Role> localReturnType = new ParameterizedTypeReference<Role>() {};
            ResponseEntity<Role> responseEntity = apiClient.invokeAPI("/api/v1/users/{userId}/roles/{roleId}", HttpMethod.GET, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                    HttpHeaders headers = responseEntity.getHeaders();
                    PagedList pagedList = new PagedList();
                    List<String> linkHeaders = headers.get("link");
                    String self = null, nextPage = null;
                    for (String link : linkHeaders) {
                    if (link.contains("next")) {
                    nextPage = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    if (link.contains("self")) {
                    self = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    }
                    pagedList.addItems(Arrays.asList(responseEntity.getBody()));
                    if (Objects.nonNull(nextPage)) {
                    pagedList.setNextPage(nextPage);
                    }
                    if (Objects.nonNull(self)) {
                    pagedList.setSelf(self);
                    }
                    return pagedList;
        }

        /**
        * List all Roles assigned to a User
        * Lists all roles assigned to a user identified by &#x60;userId&#x60;
            * <p><b>200</b> - Success
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>429</b> - Too Many Requests
                * @param userId  (required)
                * @param expand  (optional)
                * @return List&lt;Role&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public List<Role> listAssignedRolesForUser(String userId, String expand) throws RestClientException {
                return listAssignedRolesForUserWithHttpInfo(userId, expand).getBody();
            }






            /**
            * List all Roles assigned to a User
            * Lists all roles assigned to a user identified by &#x60;userId&#x60;
                * <p><b>200</b> - Success
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param userId  (required)
                * @param expand  (optional)
            * @return ResponseEntity&lt;List&lt;Role&gt;&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<List<Role>> listAssignedRolesForUserWithHttpInfo(String userId, String expand) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'userId' is set ''
                if (userId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'userId' when calling listAssignedRolesForUser");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("userId", userId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "expand", expand));

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<List<Role>> localReturnType = new ParameterizedTypeReference<List<Role>>() {};
            return apiClient.invokeAPI("/api/v1/users/{userId}/roles", HttpMethod.GET, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }







            /**
            * List all Roles assigned to a User
            * Lists all roles assigned to a user identified by &#x60;userId&#x60;
                * <p><b>200</b> - Success
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param userId  (required)
                * @param expand  (optional)
            * @return ResponseEntity&lt;List&lt;Role&gt;&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public PagedList listAssignedRolesForUserWithPaginationInfo(String userId, String expand) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'userId' is set
                if (userId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'userId' when calling listAssignedRolesForUser");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("userId", userId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "expand", expand));

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<List<Role>> localReturnType = new ParameterizedTypeReference<List<Role>>() {};
            ResponseEntity<List<Role>> responseEntity = apiClient.invokeAPI("/api/v1/users/{userId}/roles", HttpMethod.GET, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                    HttpHeaders headers = responseEntity.getHeaders();
                    PagedList pagedList = new PagedList();
                    List<String> linkHeaders = headers.get("link");
                    String self = null, nextPage = null;
                    for (String link : linkHeaders) {
                    if (link.contains("next")) {
                    nextPage = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    if (link.contains("self")) {
                    self = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    }
                    pagedList.addItems(Arrays.asList(responseEntity.getBody()));
                    if (Objects.nonNull(nextPage)) {
                    pagedList.setNextPage(nextPage);
                    }
                    if (Objects.nonNull(self)) {
                    pagedList.setSelf(self);
                    }
                    return pagedList;
        }

        /**
        * List all Assigned Roles of Group
        * Lists all assigned roles of group identified by &#x60;groupId&#x60;
            * <p><b>200</b> - Success
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>429</b> - Too Many Requests
                * @param groupId  (required)
                * @param expand  (optional)
                * @return List&lt;Role&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public List<Role> listGroupAssignedRoles(String groupId, String expand) throws RestClientException {
                return listGroupAssignedRolesWithHttpInfo(groupId, expand).getBody();
            }






            /**
            * List all Assigned Roles of Group
            * Lists all assigned roles of group identified by &#x60;groupId&#x60;
                * <p><b>200</b> - Success
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param groupId  (required)
                * @param expand  (optional)
            * @return ResponseEntity&lt;List&lt;Role&gt;&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<List<Role>> listGroupAssignedRolesWithHttpInfo(String groupId, String expand) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'groupId' is set ''
                if (groupId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'groupId' when calling listGroupAssignedRoles");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("groupId", groupId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "expand", expand));

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<List<Role>> localReturnType = new ParameterizedTypeReference<List<Role>>() {};
            return apiClient.invokeAPI("/api/v1/groups/{groupId}/roles", HttpMethod.GET, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }







            /**
            * List all Assigned Roles of Group
            * Lists all assigned roles of group identified by &#x60;groupId&#x60;
                * <p><b>200</b> - Success
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param groupId  (required)
                * @param expand  (optional)
            * @return ResponseEntity&lt;List&lt;Role&gt;&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public PagedList listGroupAssignedRolesWithPaginationInfo(String groupId, String expand) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'groupId' is set
                if (groupId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'groupId' when calling listGroupAssignedRoles");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("groupId", groupId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "expand", expand));

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<List<Role>> localReturnType = new ParameterizedTypeReference<List<Role>>() {};
            ResponseEntity<List<Role>> responseEntity = apiClient.invokeAPI("/api/v1/groups/{groupId}/roles", HttpMethod.GET, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                    HttpHeaders headers = responseEntity.getHeaders();
                    PagedList pagedList = new PagedList();
                    List<String> linkHeaders = headers.get("link");
                    String self = null, nextPage = null;
                    for (String link : linkHeaders) {
                    if (link.contains("next")) {
                    nextPage = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    if (link.contains("self")) {
                    self = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    }
                    pagedList.addItems(Arrays.asList(responseEntity.getBody()));
                    if (Objects.nonNull(nextPage)) {
                    pagedList.setNextPage(nextPage);
                    }
                    if (Objects.nonNull(self)) {
                    pagedList.setSelf(self);
                    }
                    return pagedList;
        }

        /**
        * Unassign a Role from a Group
        * Unassigns a role identified by &#x60;roleId&#x60; assigned to group identified by &#x60;groupId&#x60;
            * <p><b>204</b> - No Content
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>429</b> - Too Many Requests
                * @param groupId  (required)
                * @param roleId  (required)
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public void unassignRoleFromGroup(String groupId, String roleId) throws RestClientException {
            unassignRoleFromGroupWithHttpInfo(groupId, roleId);
            }






            /**
            * Unassign a Role from a Group
            * Unassigns a role identified by &#x60;roleId&#x60; assigned to group identified by &#x60;groupId&#x60;
                * <p><b>204</b> - No Content
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param groupId  (required)
                * @param roleId  (required)
            * @return ResponseEntity&lt;Void&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<Void> unassignRoleFromGroupWithHttpInfo(String groupId, String roleId) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'groupId' is set ''
                if (groupId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'groupId' when calling unassignRoleFromGroup");
                }
        
                // verify the required parameter 'roleId' is set ''
                if (roleId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'roleId' when calling unassignRoleFromGroup");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("groupId", groupId);
                    uriVariables.put("roleId", roleId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<Void> localReturnType = new ParameterizedTypeReference<Void>() {};
            return apiClient.invokeAPI("/api/v1/groups/{groupId}/roles/{roleId}", HttpMethod.DELETE, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }







        /**
        * Unassign a Role from a User
        * Unassigns a role identified by &#x60;roleId&#x60; from a user identified by &#x60;userId&#x60;
            * <p><b>204</b> - No Content
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>429</b> - Too Many Requests
                * @param userId  (required)
                * @param roleId  (required)
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public void unassignRoleFromUser(String userId, String roleId) throws RestClientException {
            unassignRoleFromUserWithHttpInfo(userId, roleId);
            }






            /**
            * Unassign a Role from a User
            * Unassigns a role identified by &#x60;roleId&#x60; from a user identified by &#x60;userId&#x60;
                * <p><b>204</b> - No Content
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param userId  (required)
                * @param roleId  (required)
            * @return ResponseEntity&lt;Void&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<Void> unassignRoleFromUserWithHttpInfo(String userId, String roleId) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'userId' is set ''
                if (userId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'userId' when calling unassignRoleFromUser");
                }
        
                // verify the required parameter 'roleId' is set ''
                if (roleId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'roleId' when calling unassignRoleFromUser");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("userId", userId);
                    uriVariables.put("roleId", roleId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<Void> localReturnType = new ParameterizedTypeReference<Void>() {};
            return apiClient.invokeAPI("/api/v1/users/{userId}/roles/{roleId}", HttpMethod.DELETE, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }








    private ObjectMapper getObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule(new JavaTimeModule());
        objectMapper.registerModule(new JsonNullableModule());
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        return objectMapper;
    }
        }
