package org.openapitools.client.api;

import org.openapitools.client.ApiClient;

import org.openapitools.client.model.Error;
import org.openapitools.client.model.ResourceSet;
import org.openapitools.client.model.ResourceSetBindingAddMembersRequest;
import org.openapitools.client.model.ResourceSetBindingCreateRequest;
import org.openapitools.client.model.ResourceSetBindingMember;
import org.openapitools.client.model.ResourceSetBindingMembers;
import org.openapitools.client.model.ResourceSetBindingResponse;
import org.openapitools.client.model.ResourceSetBindings;
import org.openapitools.client.model.ResourceSetResourcePatchRequest;
import org.openapitools.client.model.ResourceSetResources;
import org.openapitools.client.model.ResourceSets;

import java.util.Collections;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.LinkedHashMap;
import java.util.stream.Collectors;

import com.okta.sdk.resource.common.PagedList;

import com.okta.commons.lang.Assert;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;

import org.openapitools.jackson.nullable.JsonNullableModule;

@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-10-28T09:44:59.080-05:00[America/Chicago]")
@Component("org.openapitools.client.api.ResourceSetApi")
    public class ResourceSetApi {
    private ApiClient apiClient;

    public ResourceSetApi() {
    this(new ApiClient());
    }

    @Autowired
    public ResourceSetApi(ApiClient apiClient) {
    this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
    return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
    this.apiClient = apiClient;
    }

        /**
        * Add more Members to a binding
        * Creates more members to a resource set binding
            * <p><b>200</b> - Success
            * <p><b>400</b> - Bad Request
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>429</b> - Too Many Requests
                * @param resourceSetId &#x60;id&#x60; of a resource set (required)
                * @param roleIdOrLabel &#x60;id&#x60; or &#x60;label&#x60; of the role (required)
                * @param instance  (required)
                * @return ResourceSetBindingResponse
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public ResourceSetBindingResponse addMembersToBinding(String resourceSetId, String roleIdOrLabel, ResourceSetBindingAddMembersRequest instance) throws RestClientException {
                return addMembersToBindingWithHttpInfo(resourceSetId, roleIdOrLabel, instance).getBody();
            }




            /**
            * Add more Members to a binding
            * Creates more members to a resource set binding
                * <p><b>200</b> - Success
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param T (required) - the assignable return type
                * @param resourceSetId &#x60;id&#x60; of a resource set (required)
                * @param roleIdOrLabel &#x60;id&#x60; or &#x60;label&#x60; of the role (required)
                * @param instance  (required)
                * @return T instance
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public <T> T addMembersToBinding(Class<?> T, String resourceSetId, String roleIdOrLabel, ResourceSetBindingAddMembersRequest instance) throws RestClientException {
                return (T) getObjectMapper().convertValue(addMembersToBindingWithReturnType(T, resourceSetId, roleIdOrLabel, instance).getBody(), T);
            }




            /**
            * Add more Members to a binding
            * Creates more members to a resource set binding
                * <p><b>200</b> - Success
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param resourceSetId &#x60;id&#x60; of a resource set (required)
                * @param roleIdOrLabel &#x60;id&#x60; or &#x60;label&#x60; of the role (required)
                * @param instance  (required)
            * @return ResponseEntity&lt;ResourceSetBindingResponse&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<ResourceSetBindingResponse> addMembersToBindingWithHttpInfo(String resourceSetId, String roleIdOrLabel, ResourceSetBindingAddMembersRequest instance) throws RestClientException {
            Object localVarPostBody = instance;
        
                // verify the required parameter 'resourceSetId' is set ''
                if (resourceSetId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'resourceSetId' when calling addMembersToBinding");
                }
        
                // verify the required parameter 'roleIdOrLabel' is set ''
                if (roleIdOrLabel == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'roleIdOrLabel' when calling addMembersToBinding");
                }
        
                // verify the required parameter 'instance' is set ''
                if (instance == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'instance' when calling addMembersToBinding");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("resourceSetId", resourceSetId);
                    uriVariables.put("roleIdOrLabel", roleIdOrLabel);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = { 
            "application/json"
         };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<ResourceSetBindingResponse> localReturnType = new ParameterizedTypeReference<ResourceSetBindingResponse>() {};
            return apiClient.invokeAPI("/api/v1/iam/resource-sets/{resourceSetId}/bindings/{roleIdOrLabel}/members", HttpMethod.PATCH, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }




            /**
            * Add more Members to a binding
            * Creates more members to a resource set binding
                * <p><b>200</b> - Success
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param resourceSetId &#x60;id&#x60; of a resource set (required)
                * @param roleIdOrLabel &#x60;id&#x60; or &#x60;label&#x60; of the role (required)
                * @param instance  (required)
            * @return ResponseEntity&lt;ResourceSetBindingResponse&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private <T> ResponseEntity<T> addMembersToBindingWithReturnType(Class<?> T, String resourceSetId,String roleIdOrLabel,ResourceSetBindingAddMembersRequest instance) throws RestClientException {
            Object localVarPostBody = instance;
        
                // verify the required parameter 'resourceSetId' is set
                if (resourceSetId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'resourceSetId' when calling addMembersToBinding");
                }
        
                // verify the required parameter 'roleIdOrLabel' is set
                if (roleIdOrLabel == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'roleIdOrLabel' when calling addMembersToBinding");
                }
        
                // verify the required parameter 'instance' is set
                if (instance == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'instance' when calling addMembersToBinding");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("resourceSetId", resourceSetId);
                    uriVariables.put("roleIdOrLabel", roleIdOrLabel);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = { 
            "application/json"
         };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<T> localReturnType = new ParameterizedTypeReference<T>() {};
            return apiClient.invokeAPI("/api/v1/iam/resource-sets/{resourceSetId}/bindings/{roleIdOrLabel}/members", HttpMethod.PATCH, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }




            /**
            * Add more Members to a binding
            * Creates more members to a resource set binding
                * <p><b>200</b> - Success
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param resourceSetId &#x60;id&#x60; of a resource set (required)
                * @param roleIdOrLabel &#x60;id&#x60; or &#x60;label&#x60; of the role (required)
                * @param instance  (required)
            * @return ResponseEntity&lt;ResourceSetBindingResponse&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public PagedList addMembersToBindingWithPaginationInfo(String resourceSetId, String roleIdOrLabel, ResourceSetBindingAddMembersRequest instance) throws RestClientException {
            Object localVarPostBody = instance;
        
                // verify the required parameter 'resourceSetId' is set
                if (resourceSetId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'resourceSetId' when calling addMembersToBinding");
                }
        
                // verify the required parameter 'roleIdOrLabel' is set
                if (roleIdOrLabel == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'roleIdOrLabel' when calling addMembersToBinding");
                }
        
                // verify the required parameter 'instance' is set
                if (instance == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'instance' when calling addMembersToBinding");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("resourceSetId", resourceSetId);
                    uriVariables.put("roleIdOrLabel", roleIdOrLabel);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = { 
            "application/json"
         };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<ResourceSetBindingResponse> localReturnType = new ParameterizedTypeReference<ResourceSetBindingResponse>() {};
            ResponseEntity<ResourceSetBindingResponse> responseEntity = apiClient.invokeAPI("/api/v1/iam/resource-sets/{resourceSetId}/bindings/{roleIdOrLabel}/members", HttpMethod.PATCH, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                    HttpHeaders headers = responseEntity.getHeaders();
                    PagedList pagedList = new PagedList();
                    List<String> linkHeaders = headers.get("link");
                    String self = null, nextPage = null;
                    for (String link : linkHeaders) {
                    if (link.contains("next")) {
                    nextPage = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    if (link.contains("self")) {
                    self = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    }
                    pagedList.addItems(Arrays.asList(responseEntity.getBody()));
                    if (Objects.nonNull(nextPage)) {
                    pagedList.setNextPage(nextPage);
                    }
                    if (Objects.nonNull(self)) {
                    pagedList.setSelf(self);
                    }
                    return pagedList;
        }

        /**
        * Add a Resource to a resource set
        * Creates more resources to a resource set
            * <p><b>200</b> - Success
            * <p><b>400</b> - Bad Request
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>429</b> - Too Many Requests
                * @param resourceSetId &#x60;id&#x60; of a resource set (required)
                * @param instance  (required)
                * @return ResourceSet
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public ResourceSet addResourceSetResource(String resourceSetId, ResourceSetResourcePatchRequest instance) throws RestClientException {
                return addResourceSetResourceWithHttpInfo(resourceSetId, instance).getBody();
            }




            /**
            * Add a Resource to a resource set
            * Creates more resources to a resource set
                * <p><b>200</b> - Success
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param T (required) - the assignable return type
                * @param resourceSetId &#x60;id&#x60; of a resource set (required)
                * @param instance  (required)
                * @return T instance
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public <T> T addResourceSetResource(Class<?> T, String resourceSetId, ResourceSetResourcePatchRequest instance) throws RestClientException {
                return (T) getObjectMapper().convertValue(addResourceSetResourceWithReturnType(T, resourceSetId, instance).getBody(), T);
            }




            /**
            * Add a Resource to a resource set
            * Creates more resources to a resource set
                * <p><b>200</b> - Success
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param resourceSetId &#x60;id&#x60; of a resource set (required)
                * @param instance  (required)
            * @return ResponseEntity&lt;ResourceSet&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<ResourceSet> addResourceSetResourceWithHttpInfo(String resourceSetId, ResourceSetResourcePatchRequest instance) throws RestClientException {
            Object localVarPostBody = instance;
        
                // verify the required parameter 'resourceSetId' is set ''
                if (resourceSetId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'resourceSetId' when calling addResourceSetResource");
                }
        
                // verify the required parameter 'instance' is set ''
                if (instance == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'instance' when calling addResourceSetResource");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("resourceSetId", resourceSetId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = { 
            "application/json"
         };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<ResourceSet> localReturnType = new ParameterizedTypeReference<ResourceSet>() {};
            return apiClient.invokeAPI("/api/v1/iam/resource-sets/{resourceSetId}/resources", HttpMethod.PATCH, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }




            /**
            * Add a Resource to a resource set
            * Creates more resources to a resource set
                * <p><b>200</b> - Success
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param resourceSetId &#x60;id&#x60; of a resource set (required)
                * @param instance  (required)
            * @return ResponseEntity&lt;ResourceSet&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private <T> ResponseEntity<T> addResourceSetResourceWithReturnType(Class<?> T, String resourceSetId,ResourceSetResourcePatchRequest instance) throws RestClientException {
            Object localVarPostBody = instance;
        
                // verify the required parameter 'resourceSetId' is set
                if (resourceSetId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'resourceSetId' when calling addResourceSetResource");
                }
        
                // verify the required parameter 'instance' is set
                if (instance == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'instance' when calling addResourceSetResource");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("resourceSetId", resourceSetId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = { 
            "application/json"
         };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<T> localReturnType = new ParameterizedTypeReference<T>() {};
            return apiClient.invokeAPI("/api/v1/iam/resource-sets/{resourceSetId}/resources", HttpMethod.PATCH, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }




            /**
            * Add a Resource to a resource set
            * Creates more resources to a resource set
                * <p><b>200</b> - Success
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param resourceSetId &#x60;id&#x60; of a resource set (required)
                * @param instance  (required)
            * @return ResponseEntity&lt;ResourceSet&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public PagedList addResourceSetResourceWithPaginationInfo(String resourceSetId, ResourceSetResourcePatchRequest instance) throws RestClientException {
            Object localVarPostBody = instance;
        
                // verify the required parameter 'resourceSetId' is set
                if (resourceSetId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'resourceSetId' when calling addResourceSetResource");
                }
        
                // verify the required parameter 'instance' is set
                if (instance == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'instance' when calling addResourceSetResource");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("resourceSetId", resourceSetId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = { 
            "application/json"
         };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<ResourceSet> localReturnType = new ParameterizedTypeReference<ResourceSet>() {};
            ResponseEntity<ResourceSet> responseEntity = apiClient.invokeAPI("/api/v1/iam/resource-sets/{resourceSetId}/resources", HttpMethod.PATCH, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                    HttpHeaders headers = responseEntity.getHeaders();
                    PagedList pagedList = new PagedList();
                    List<String> linkHeaders = headers.get("link");
                    String self = null, nextPage = null;
                    for (String link : linkHeaders) {
                    if (link.contains("next")) {
                    nextPage = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    if (link.contains("self")) {
                    self = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    }
                    pagedList.addItems(Arrays.asList(responseEntity.getBody()));
                    if (Objects.nonNull(nextPage)) {
                    pagedList.setNextPage(nextPage);
                    }
                    if (Objects.nonNull(self)) {
                    pagedList.setSelf(self);
                    }
                    return pagedList;
        }

        /**
        * Create a Resource Set
        * Creates a new resource set
            * <p><b>200</b> - Success
            * <p><b>400</b> - Bad Request
            * <p><b>403</b> - Forbidden
            * <p><b>429</b> - Too Many Requests
                * @param instance  (required)
                * @return ResourceSet
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public ResourceSet createResourceSet(ResourceSet instance) throws RestClientException {
                return createResourceSetWithHttpInfo(instance).getBody();
            }




            /**
            * Create a Resource Set
            * Creates a new resource set
                * <p><b>200</b> - Success
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>429</b> - Too Many Requests
                * @param T (required) - the assignable return type
                * @param instance  (required)
                * @return T instance
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public <T> T createResourceSet(Class<?> T, ResourceSet instance) throws RestClientException {
                return (T) getObjectMapper().convertValue(createResourceSetWithReturnType(T, instance).getBody(), T);
            }




            /**
            * Create a Resource Set
            * Creates a new resource set
                * <p><b>200</b> - Success
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>429</b> - Too Many Requests
                * @param instance  (required)
            * @return ResponseEntity&lt;ResourceSet&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<ResourceSet> createResourceSetWithHttpInfo(ResourceSet instance) throws RestClientException {
            Object localVarPostBody = instance;
        
                // verify the required parameter 'instance' is set ''
                if (instance == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'instance' when calling createResourceSet");
                }
        

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = { 
            "application/json"
         };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<ResourceSet> localReturnType = new ParameterizedTypeReference<ResourceSet>() {};
            return apiClient.invokeAPI("/api/v1/iam/resource-sets", HttpMethod.POST, Collections.<String, Object>emptyMap(), localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }




            /**
            * Create a Resource Set
            * Creates a new resource set
                * <p><b>200</b> - Success
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>429</b> - Too Many Requests
                * @param instance  (required)
            * @return ResponseEntity&lt;ResourceSet&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private <T> ResponseEntity<T> createResourceSetWithReturnType(Class<?> T, ResourceSet instance) throws RestClientException {
            Object localVarPostBody = instance;
        
                // verify the required parameter 'instance' is set
                if (instance == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'instance' when calling createResourceSet");
                }
        

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = { 
            "application/json"
         };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<T> localReturnType = new ParameterizedTypeReference<T>() {};
            return apiClient.invokeAPI("/api/v1/iam/resource-sets", HttpMethod.POST, Collections.<String, Object>emptyMap(), localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }




            /**
            * Create a Resource Set
            * Creates a new resource set
                * <p><b>200</b> - Success
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>429</b> - Too Many Requests
                * @param instance  (required)
            * @return ResponseEntity&lt;ResourceSet&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public PagedList createResourceSetWithPaginationInfo(ResourceSet instance) throws RestClientException {
            Object localVarPostBody = instance;
        
                // verify the required parameter 'instance' is set
                if (instance == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'instance' when calling createResourceSet");
                }
        

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = { 
            "application/json"
         };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<ResourceSet> localReturnType = new ParameterizedTypeReference<ResourceSet>() {};
            ResponseEntity<ResourceSet> responseEntity = apiClient.invokeAPI("/api/v1/iam/resource-sets", HttpMethod.POST, Collections.<String, Object>emptyMap(), localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                    HttpHeaders headers = responseEntity.getHeaders();
                    PagedList pagedList = new PagedList();
                    List<String> linkHeaders = headers.get("link");
                    String self = null, nextPage = null;
                    for (String link : linkHeaders) {
                    if (link.contains("next")) {
                    nextPage = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    if (link.contains("self")) {
                    self = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    }
                    pagedList.addItems(Arrays.asList(responseEntity.getBody()));
                    if (Objects.nonNull(nextPage)) {
                    pagedList.setNextPage(nextPage);
                    }
                    if (Objects.nonNull(self)) {
                    pagedList.setSelf(self);
                    }
                    return pagedList;
        }

        /**
        * Create a Resource Set Binding
        * Creates a new resource set binding
            * <p><b>200</b> - Success
            * <p><b>400</b> - Bad Request
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>429</b> - Too Many Requests
                * @param resourceSetId &#x60;id&#x60; of a resource set (required)
                * @param instance  (required)
                * @return ResourceSetBindingResponse
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public ResourceSetBindingResponse createResourceSetBinding(String resourceSetId, ResourceSetBindingCreateRequest instance) throws RestClientException {
                return createResourceSetBindingWithHttpInfo(resourceSetId, instance).getBody();
            }




            /**
            * Create a Resource Set Binding
            * Creates a new resource set binding
                * <p><b>200</b> - Success
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param T (required) - the assignable return type
                * @param resourceSetId &#x60;id&#x60; of a resource set (required)
                * @param instance  (required)
                * @return T instance
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public <T> T createResourceSetBinding(Class<?> T, String resourceSetId, ResourceSetBindingCreateRequest instance) throws RestClientException {
                return (T) getObjectMapper().convertValue(createResourceSetBindingWithReturnType(T, resourceSetId, instance).getBody(), T);
            }




            /**
            * Create a Resource Set Binding
            * Creates a new resource set binding
                * <p><b>200</b> - Success
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param resourceSetId &#x60;id&#x60; of a resource set (required)
                * @param instance  (required)
            * @return ResponseEntity&lt;ResourceSetBindingResponse&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<ResourceSetBindingResponse> createResourceSetBindingWithHttpInfo(String resourceSetId, ResourceSetBindingCreateRequest instance) throws RestClientException {
            Object localVarPostBody = instance;
        
                // verify the required parameter 'resourceSetId' is set ''
                if (resourceSetId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'resourceSetId' when calling createResourceSetBinding");
                }
        
                // verify the required parameter 'instance' is set ''
                if (instance == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'instance' when calling createResourceSetBinding");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("resourceSetId", resourceSetId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = { 
            "application/json"
         };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<ResourceSetBindingResponse> localReturnType = new ParameterizedTypeReference<ResourceSetBindingResponse>() {};
            return apiClient.invokeAPI("/api/v1/iam/resource-sets/{resourceSetId}/bindings", HttpMethod.POST, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }




            /**
            * Create a Resource Set Binding
            * Creates a new resource set binding
                * <p><b>200</b> - Success
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param resourceSetId &#x60;id&#x60; of a resource set (required)
                * @param instance  (required)
            * @return ResponseEntity&lt;ResourceSetBindingResponse&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private <T> ResponseEntity<T> createResourceSetBindingWithReturnType(Class<?> T, String resourceSetId,ResourceSetBindingCreateRequest instance) throws RestClientException {
            Object localVarPostBody = instance;
        
                // verify the required parameter 'resourceSetId' is set
                if (resourceSetId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'resourceSetId' when calling createResourceSetBinding");
                }
        
                // verify the required parameter 'instance' is set
                if (instance == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'instance' when calling createResourceSetBinding");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("resourceSetId", resourceSetId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = { 
            "application/json"
         };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<T> localReturnType = new ParameterizedTypeReference<T>() {};
            return apiClient.invokeAPI("/api/v1/iam/resource-sets/{resourceSetId}/bindings", HttpMethod.POST, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }




            /**
            * Create a Resource Set Binding
            * Creates a new resource set binding
                * <p><b>200</b> - Success
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param resourceSetId &#x60;id&#x60; of a resource set (required)
                * @param instance  (required)
            * @return ResponseEntity&lt;ResourceSetBindingResponse&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public PagedList createResourceSetBindingWithPaginationInfo(String resourceSetId, ResourceSetBindingCreateRequest instance) throws RestClientException {
            Object localVarPostBody = instance;
        
                // verify the required parameter 'resourceSetId' is set
                if (resourceSetId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'resourceSetId' when calling createResourceSetBinding");
                }
        
                // verify the required parameter 'instance' is set
                if (instance == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'instance' when calling createResourceSetBinding");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("resourceSetId", resourceSetId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = { 
            "application/json"
         };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<ResourceSetBindingResponse> localReturnType = new ParameterizedTypeReference<ResourceSetBindingResponse>() {};
            ResponseEntity<ResourceSetBindingResponse> responseEntity = apiClient.invokeAPI("/api/v1/iam/resource-sets/{resourceSetId}/bindings", HttpMethod.POST, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                    HttpHeaders headers = responseEntity.getHeaders();
                    PagedList pagedList = new PagedList();
                    List<String> linkHeaders = headers.get("link");
                    String self = null, nextPage = null;
                    for (String link : linkHeaders) {
                    if (link.contains("next")) {
                    nextPage = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    if (link.contains("self")) {
                    self = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    }
                    pagedList.addItems(Arrays.asList(responseEntity.getBody()));
                    if (Objects.nonNull(nextPage)) {
                    pagedList.setNextPage(nextPage);
                    }
                    if (Objects.nonNull(self)) {
                    pagedList.setSelf(self);
                    }
                    return pagedList;
        }

        /**
        * Delete a Binding
        * Deletes a resource set binding by &#x60;resourceSetId&#x60; and &#x60;roleIdOrLabel&#x60;
            * <p><b>204</b> - No Content
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>429</b> - Too Many Requests
                * @param resourceSetId &#x60;id&#x60; of a resource set (required)
                * @param roleIdOrLabel &#x60;id&#x60; or &#x60;label&#x60; of the role (required)
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public void deleteBinding(String resourceSetId, String roleIdOrLabel) throws RestClientException {
            deleteBindingWithHttpInfo(resourceSetId, roleIdOrLabel);
            }






            /**
            * Delete a Binding
            * Deletes a resource set binding by &#x60;resourceSetId&#x60; and &#x60;roleIdOrLabel&#x60;
                * <p><b>204</b> - No Content
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param resourceSetId &#x60;id&#x60; of a resource set (required)
                * @param roleIdOrLabel &#x60;id&#x60; or &#x60;label&#x60; of the role (required)
            * @return ResponseEntity&lt;Void&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<Void> deleteBindingWithHttpInfo(String resourceSetId, String roleIdOrLabel) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'resourceSetId' is set ''
                if (resourceSetId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'resourceSetId' when calling deleteBinding");
                }
        
                // verify the required parameter 'roleIdOrLabel' is set ''
                if (roleIdOrLabel == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'roleIdOrLabel' when calling deleteBinding");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("resourceSetId", resourceSetId);
                    uriVariables.put("roleIdOrLabel", roleIdOrLabel);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<Void> localReturnType = new ParameterizedTypeReference<Void>() {};
            return apiClient.invokeAPI("/api/v1/iam/resource-sets/{resourceSetId}/bindings/{roleIdOrLabel}", HttpMethod.DELETE, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }







        /**
        * Delete a Resource Set
        * Deletes a role by &#x60;resourceSetId&#x60;
            * <p><b>204</b> - No Content
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>429</b> - Too Many Requests
                * @param resourceSetId &#x60;id&#x60; of a resource set (required)
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public void deleteResourceSet(String resourceSetId) throws RestClientException {
            deleteResourceSetWithHttpInfo(resourceSetId);
            }






            /**
            * Delete a Resource Set
            * Deletes a role by &#x60;resourceSetId&#x60;
                * <p><b>204</b> - No Content
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param resourceSetId &#x60;id&#x60; of a resource set (required)
            * @return ResponseEntity&lt;Void&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<Void> deleteResourceSetWithHttpInfo(String resourceSetId) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'resourceSetId' is set ''
                if (resourceSetId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'resourceSetId' when calling deleteResourceSet");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("resourceSetId", resourceSetId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<Void> localReturnType = new ParameterizedTypeReference<Void>() {};
            return apiClient.invokeAPI("/api/v1/iam/resource-sets/{resourceSetId}", HttpMethod.DELETE, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }







        /**
        * Delete a Resource from a resource set
        * Deletes a resource identified by &#x60;resourceId&#x60; from a resource set
            * <p><b>204</b> - No Content
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>429</b> - Too Many Requests
                * @param resourceSetId &#x60;id&#x60; of a resource set (required)
                * @param resourceId &#x60;id&#x60; of a resource (required)
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public void deleteResourceSetResource(String resourceSetId, String resourceId) throws RestClientException {
            deleteResourceSetResourceWithHttpInfo(resourceSetId, resourceId);
            }






            /**
            * Delete a Resource from a resource set
            * Deletes a resource identified by &#x60;resourceId&#x60; from a resource set
                * <p><b>204</b> - No Content
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param resourceSetId &#x60;id&#x60; of a resource set (required)
                * @param resourceId &#x60;id&#x60; of a resource (required)
            * @return ResponseEntity&lt;Void&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<Void> deleteResourceSetResourceWithHttpInfo(String resourceSetId, String resourceId) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'resourceSetId' is set ''
                if (resourceSetId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'resourceSetId' when calling deleteResourceSetResource");
                }
        
                // verify the required parameter 'resourceId' is set ''
                if (resourceId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'resourceId' when calling deleteResourceSetResource");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("resourceSetId", resourceSetId);
                    uriVariables.put("resourceId", resourceId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<Void> localReturnType = new ParameterizedTypeReference<Void>() {};
            return apiClient.invokeAPI("/api/v1/iam/resource-sets/{resourceSetId}/resources/{resourceId}", HttpMethod.DELETE, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }







        /**
        * Retrieve a Binding
        * Retrieves a resource set binding by &#x60;resourceSetId&#x60; and &#x60;roleIdOrLabel&#x60;
            * <p><b>200</b> - OK
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>429</b> - Too Many Requests
                * @param resourceSetId &#x60;id&#x60; of a resource set (required)
                * @param roleIdOrLabel &#x60;id&#x60; or &#x60;label&#x60; of the role (required)
                * @return ResourceSetBindingResponse
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public ResourceSetBindingResponse getBinding(String resourceSetId, String roleIdOrLabel) throws RestClientException {
                return getBindingWithHttpInfo(resourceSetId, roleIdOrLabel).getBody();
            }






            /**
            * Retrieve a Binding
            * Retrieves a resource set binding by &#x60;resourceSetId&#x60; and &#x60;roleIdOrLabel&#x60;
                * <p><b>200</b> - OK
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param resourceSetId &#x60;id&#x60; of a resource set (required)
                * @param roleIdOrLabel &#x60;id&#x60; or &#x60;label&#x60; of the role (required)
            * @return ResponseEntity&lt;ResourceSetBindingResponse&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<ResourceSetBindingResponse> getBindingWithHttpInfo(String resourceSetId, String roleIdOrLabel) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'resourceSetId' is set ''
                if (resourceSetId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'resourceSetId' when calling getBinding");
                }
        
                // verify the required parameter 'roleIdOrLabel' is set ''
                if (roleIdOrLabel == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'roleIdOrLabel' when calling getBinding");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("resourceSetId", resourceSetId);
                    uriVariables.put("roleIdOrLabel", roleIdOrLabel);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<ResourceSetBindingResponse> localReturnType = new ParameterizedTypeReference<ResourceSetBindingResponse>() {};
            return apiClient.invokeAPI("/api/v1/iam/resource-sets/{resourceSetId}/bindings/{roleIdOrLabel}", HttpMethod.GET, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }







            /**
            * Retrieve a Binding
            * Retrieves a resource set binding by &#x60;resourceSetId&#x60; and &#x60;roleIdOrLabel&#x60;
                * <p><b>200</b> - OK
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param resourceSetId &#x60;id&#x60; of a resource set (required)
                * @param roleIdOrLabel &#x60;id&#x60; or &#x60;label&#x60; of the role (required)
            * @return ResponseEntity&lt;ResourceSetBindingResponse&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public PagedList getBindingWithPaginationInfo(String resourceSetId, String roleIdOrLabel) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'resourceSetId' is set
                if (resourceSetId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'resourceSetId' when calling getBinding");
                }
        
                // verify the required parameter 'roleIdOrLabel' is set
                if (roleIdOrLabel == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'roleIdOrLabel' when calling getBinding");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("resourceSetId", resourceSetId);
                    uriVariables.put("roleIdOrLabel", roleIdOrLabel);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<ResourceSetBindingResponse> localReturnType = new ParameterizedTypeReference<ResourceSetBindingResponse>() {};
            ResponseEntity<ResourceSetBindingResponse> responseEntity = apiClient.invokeAPI("/api/v1/iam/resource-sets/{resourceSetId}/bindings/{roleIdOrLabel}", HttpMethod.GET, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                    HttpHeaders headers = responseEntity.getHeaders();
                    PagedList pagedList = new PagedList();
                    List<String> linkHeaders = headers.get("link");
                    String self = null, nextPage = null;
                    for (String link : linkHeaders) {
                    if (link.contains("next")) {
                    nextPage = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    if (link.contains("self")) {
                    self = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    }
                    pagedList.addItems(Arrays.asList(responseEntity.getBody()));
                    if (Objects.nonNull(nextPage)) {
                    pagedList.setNextPage(nextPage);
                    }
                    if (Objects.nonNull(self)) {
                    pagedList.setSelf(self);
                    }
                    return pagedList;
        }

        /**
        * Retrieve a Member of a binding
        * Retreieves a member identified by &#x60;memberId&#x60; for a binding
            * <p><b>200</b> - OK
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>429</b> - Too Many Requests
                * @param resourceSetId &#x60;id&#x60; of a resource set (required)
                * @param roleIdOrLabel &#x60;id&#x60; or &#x60;label&#x60; of the role (required)
                * @param memberId &#x60;id&#x60; of a member (required)
                * @return ResourceSetBindingMember
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public ResourceSetBindingMember getMemberOfBinding(String resourceSetId, String roleIdOrLabel, String memberId) throws RestClientException {
                return getMemberOfBindingWithHttpInfo(resourceSetId, roleIdOrLabel, memberId).getBody();
            }






            /**
            * Retrieve a Member of a binding
            * Retreieves a member identified by &#x60;memberId&#x60; for a binding
                * <p><b>200</b> - OK
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param resourceSetId &#x60;id&#x60; of a resource set (required)
                * @param roleIdOrLabel &#x60;id&#x60; or &#x60;label&#x60; of the role (required)
                * @param memberId &#x60;id&#x60; of a member (required)
            * @return ResponseEntity&lt;ResourceSetBindingMember&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<ResourceSetBindingMember> getMemberOfBindingWithHttpInfo(String resourceSetId, String roleIdOrLabel, String memberId) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'resourceSetId' is set ''
                if (resourceSetId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'resourceSetId' when calling getMemberOfBinding");
                }
        
                // verify the required parameter 'roleIdOrLabel' is set ''
                if (roleIdOrLabel == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'roleIdOrLabel' when calling getMemberOfBinding");
                }
        
                // verify the required parameter 'memberId' is set ''
                if (memberId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'memberId' when calling getMemberOfBinding");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("resourceSetId", resourceSetId);
                    uriVariables.put("roleIdOrLabel", roleIdOrLabel);
                    uriVariables.put("memberId", memberId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<ResourceSetBindingMember> localReturnType = new ParameterizedTypeReference<ResourceSetBindingMember>() {};
            return apiClient.invokeAPI("/api/v1/iam/resource-sets/{resourceSetId}/bindings/{roleIdOrLabel}/members/{memberId}", HttpMethod.GET, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }







            /**
            * Retrieve a Member of a binding
            * Retreieves a member identified by &#x60;memberId&#x60; for a binding
                * <p><b>200</b> - OK
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param resourceSetId &#x60;id&#x60; of a resource set (required)
                * @param roleIdOrLabel &#x60;id&#x60; or &#x60;label&#x60; of the role (required)
                * @param memberId &#x60;id&#x60; of a member (required)
            * @return ResponseEntity&lt;ResourceSetBindingMember&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public PagedList getMemberOfBindingWithPaginationInfo(String resourceSetId, String roleIdOrLabel, String memberId) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'resourceSetId' is set
                if (resourceSetId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'resourceSetId' when calling getMemberOfBinding");
                }
        
                // verify the required parameter 'roleIdOrLabel' is set
                if (roleIdOrLabel == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'roleIdOrLabel' when calling getMemberOfBinding");
                }
        
                // verify the required parameter 'memberId' is set
                if (memberId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'memberId' when calling getMemberOfBinding");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("resourceSetId", resourceSetId);
                    uriVariables.put("roleIdOrLabel", roleIdOrLabel);
                    uriVariables.put("memberId", memberId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<ResourceSetBindingMember> localReturnType = new ParameterizedTypeReference<ResourceSetBindingMember>() {};
            ResponseEntity<ResourceSetBindingMember> responseEntity = apiClient.invokeAPI("/api/v1/iam/resource-sets/{resourceSetId}/bindings/{roleIdOrLabel}/members/{memberId}", HttpMethod.GET, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                    HttpHeaders headers = responseEntity.getHeaders();
                    PagedList pagedList = new PagedList();
                    List<String> linkHeaders = headers.get("link");
                    String self = null, nextPage = null;
                    for (String link : linkHeaders) {
                    if (link.contains("next")) {
                    nextPage = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    if (link.contains("self")) {
                    self = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    }
                    pagedList.addItems(Arrays.asList(responseEntity.getBody()));
                    if (Objects.nonNull(nextPage)) {
                    pagedList.setNextPage(nextPage);
                    }
                    if (Objects.nonNull(self)) {
                    pagedList.setSelf(self);
                    }
                    return pagedList;
        }

        /**
        * Retrieve a Resource Set
        * Retrieves a resource set by &#x60;resourceSetId&#x60;
            * <p><b>200</b> - OK
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>429</b> - Too Many Requests
                * @param resourceSetId &#x60;id&#x60; of a resource set (required)
                * @return ResourceSet
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public ResourceSet getResourceSet(String resourceSetId) throws RestClientException {
                return getResourceSetWithHttpInfo(resourceSetId).getBody();
            }






            /**
            * Retrieve a Resource Set
            * Retrieves a resource set by &#x60;resourceSetId&#x60;
                * <p><b>200</b> - OK
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param resourceSetId &#x60;id&#x60; of a resource set (required)
            * @return ResponseEntity&lt;ResourceSet&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<ResourceSet> getResourceSetWithHttpInfo(String resourceSetId) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'resourceSetId' is set ''
                if (resourceSetId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'resourceSetId' when calling getResourceSet");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("resourceSetId", resourceSetId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<ResourceSet> localReturnType = new ParameterizedTypeReference<ResourceSet>() {};
            return apiClient.invokeAPI("/api/v1/iam/resource-sets/{resourceSetId}", HttpMethod.GET, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }







            /**
            * Retrieve a Resource Set
            * Retrieves a resource set by &#x60;resourceSetId&#x60;
                * <p><b>200</b> - OK
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param resourceSetId &#x60;id&#x60; of a resource set (required)
            * @return ResponseEntity&lt;ResourceSet&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public PagedList getResourceSetWithPaginationInfo(String resourceSetId) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'resourceSetId' is set
                if (resourceSetId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'resourceSetId' when calling getResourceSet");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("resourceSetId", resourceSetId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<ResourceSet> localReturnType = new ParameterizedTypeReference<ResourceSet>() {};
            ResponseEntity<ResourceSet> responseEntity = apiClient.invokeAPI("/api/v1/iam/resource-sets/{resourceSetId}", HttpMethod.GET, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                    HttpHeaders headers = responseEntity.getHeaders();
                    PagedList pagedList = new PagedList();
                    List<String> linkHeaders = headers.get("link");
                    String self = null, nextPage = null;
                    for (String link : linkHeaders) {
                    if (link.contains("next")) {
                    nextPage = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    if (link.contains("self")) {
                    self = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    }
                    pagedList.addItems(Arrays.asList(responseEntity.getBody()));
                    if (Objects.nonNull(nextPage)) {
                    pagedList.setNextPage(nextPage);
                    }
                    if (Objects.nonNull(self)) {
                    pagedList.setSelf(self);
                    }
                    return pagedList;
        }

        /**
        * List all Bindings
        * Lists all resource set bindings with pagination support
            * <p><b>200</b> - OK
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>429</b> - Too Many Requests
                * @param resourceSetId &#x60;id&#x60; of a resource set (required)
                * @param after The cursor to use for pagination. It is an opaque string that specifies your current location in the list and is obtained from the &#x60;Link&#x60; response header. See [Pagination](/#pagination) for more information. (optional)
                * @return ResourceSetBindings
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public ResourceSetBindings listBindings(String resourceSetId, String after) throws RestClientException {
                return listBindingsWithHttpInfo(resourceSetId, after).getBody();
            }






            /**
            * List all Bindings
            * Lists all resource set bindings with pagination support
                * <p><b>200</b> - OK
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param resourceSetId &#x60;id&#x60; of a resource set (required)
                * @param after The cursor to use for pagination. It is an opaque string that specifies your current location in the list and is obtained from the &#x60;Link&#x60; response header. See [Pagination](/#pagination) for more information. (optional)
            * @return ResponseEntity&lt;ResourceSetBindings&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<ResourceSetBindings> listBindingsWithHttpInfo(String resourceSetId, String after) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'resourceSetId' is set ''
                if (resourceSetId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'resourceSetId' when calling listBindings");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("resourceSetId", resourceSetId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "after", after));

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<ResourceSetBindings> localReturnType = new ParameterizedTypeReference<ResourceSetBindings>() {};
            return apiClient.invokeAPI("/api/v1/iam/resource-sets/{resourceSetId}/bindings", HttpMethod.GET, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }







            /**
            * List all Bindings
            * Lists all resource set bindings with pagination support
                * <p><b>200</b> - OK
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param resourceSetId &#x60;id&#x60; of a resource set (required)
                * @param after The cursor to use for pagination. It is an opaque string that specifies your current location in the list and is obtained from the &#x60;Link&#x60; response header. See [Pagination](/#pagination) for more information. (optional)
            * @return ResponseEntity&lt;ResourceSetBindings&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public PagedList listBindingsWithPaginationInfo(String resourceSetId, String after) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'resourceSetId' is set
                if (resourceSetId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'resourceSetId' when calling listBindings");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("resourceSetId", resourceSetId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "after", after));

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<ResourceSetBindings> localReturnType = new ParameterizedTypeReference<ResourceSetBindings>() {};
            ResponseEntity<ResourceSetBindings> responseEntity = apiClient.invokeAPI("/api/v1/iam/resource-sets/{resourceSetId}/bindings", HttpMethod.GET, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                    HttpHeaders headers = responseEntity.getHeaders();
                    PagedList pagedList = new PagedList();
                    List<String> linkHeaders = headers.get("link");
                    String self = null, nextPage = null;
                    for (String link : linkHeaders) {
                    if (link.contains("next")) {
                    nextPage = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    if (link.contains("self")) {
                    self = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    }
                    pagedList.addItems(Arrays.asList(responseEntity.getBody()));
                    if (Objects.nonNull(nextPage)) {
                    pagedList.setNextPage(nextPage);
                    }
                    if (Objects.nonNull(self)) {
                    pagedList.setSelf(self);
                    }
                    return pagedList;
        }

        /**
        * List all Members of a binding
        * Lists all members of a resource set binding with pagination support
            * <p><b>200</b> - OK
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>429</b> - Too Many Requests
                * @param resourceSetId &#x60;id&#x60; of a resource set (required)
                * @param roleIdOrLabel &#x60;id&#x60; or &#x60;label&#x60; of the role (required)
                * @param after The cursor to use for pagination. It is an opaque string that specifies your current location in the list and is obtained from the &#x60;Link&#x60; response header. See [Pagination](/#pagination) for more information. (optional)
                * @return ResourceSetBindingMembers
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public ResourceSetBindingMembers listMembersOfBinding(String resourceSetId, String roleIdOrLabel, String after) throws RestClientException {
                return listMembersOfBindingWithHttpInfo(resourceSetId, roleIdOrLabel, after).getBody();
            }






            /**
            * List all Members of a binding
            * Lists all members of a resource set binding with pagination support
                * <p><b>200</b> - OK
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param resourceSetId &#x60;id&#x60; of a resource set (required)
                * @param roleIdOrLabel &#x60;id&#x60; or &#x60;label&#x60; of the role (required)
                * @param after The cursor to use for pagination. It is an opaque string that specifies your current location in the list and is obtained from the &#x60;Link&#x60; response header. See [Pagination](/#pagination) for more information. (optional)
            * @return ResponseEntity&lt;ResourceSetBindingMembers&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<ResourceSetBindingMembers> listMembersOfBindingWithHttpInfo(String resourceSetId, String roleIdOrLabel, String after) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'resourceSetId' is set ''
                if (resourceSetId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'resourceSetId' when calling listMembersOfBinding");
                }
        
                // verify the required parameter 'roleIdOrLabel' is set ''
                if (roleIdOrLabel == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'roleIdOrLabel' when calling listMembersOfBinding");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("resourceSetId", resourceSetId);
                    uriVariables.put("roleIdOrLabel", roleIdOrLabel);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "after", after));

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<ResourceSetBindingMembers> localReturnType = new ParameterizedTypeReference<ResourceSetBindingMembers>() {};
            return apiClient.invokeAPI("/api/v1/iam/resource-sets/{resourceSetId}/bindings/{roleIdOrLabel}/members", HttpMethod.GET, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }







            /**
            * List all Members of a binding
            * Lists all members of a resource set binding with pagination support
                * <p><b>200</b> - OK
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param resourceSetId &#x60;id&#x60; of a resource set (required)
                * @param roleIdOrLabel &#x60;id&#x60; or &#x60;label&#x60; of the role (required)
                * @param after The cursor to use for pagination. It is an opaque string that specifies your current location in the list and is obtained from the &#x60;Link&#x60; response header. See [Pagination](/#pagination) for more information. (optional)
            * @return ResponseEntity&lt;ResourceSetBindingMembers&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public PagedList listMembersOfBindingWithPaginationInfo(String resourceSetId, String roleIdOrLabel, String after) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'resourceSetId' is set
                if (resourceSetId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'resourceSetId' when calling listMembersOfBinding");
                }
        
                // verify the required parameter 'roleIdOrLabel' is set
                if (roleIdOrLabel == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'roleIdOrLabel' when calling listMembersOfBinding");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("resourceSetId", resourceSetId);
                    uriVariables.put("roleIdOrLabel", roleIdOrLabel);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "after", after));

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<ResourceSetBindingMembers> localReturnType = new ParameterizedTypeReference<ResourceSetBindingMembers>() {};
            ResponseEntity<ResourceSetBindingMembers> responseEntity = apiClient.invokeAPI("/api/v1/iam/resource-sets/{resourceSetId}/bindings/{roleIdOrLabel}/members", HttpMethod.GET, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                    HttpHeaders headers = responseEntity.getHeaders();
                    PagedList pagedList = new PagedList();
                    List<String> linkHeaders = headers.get("link");
                    String self = null, nextPage = null;
                    for (String link : linkHeaders) {
                    if (link.contains("next")) {
                    nextPage = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    if (link.contains("self")) {
                    self = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    }
                    pagedList.addItems(Arrays.asList(responseEntity.getBody()));
                    if (Objects.nonNull(nextPage)) {
                    pagedList.setNextPage(nextPage);
                    }
                    if (Objects.nonNull(self)) {
                    pagedList.setSelf(self);
                    }
                    return pagedList;
        }

        /**
        * List all Resources of a resource set
        * Lists all resources that make up the resource set
            * <p><b>200</b> - OK
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>429</b> - Too Many Requests
                * @param resourceSetId &#x60;id&#x60; of a resource set (required)
                * @return ResourceSetResources
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public ResourceSetResources listResourceSetResources(String resourceSetId) throws RestClientException {
                return listResourceSetResourcesWithHttpInfo(resourceSetId).getBody();
            }






            /**
            * List all Resources of a resource set
            * Lists all resources that make up the resource set
                * <p><b>200</b> - OK
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param resourceSetId &#x60;id&#x60; of a resource set (required)
            * @return ResponseEntity&lt;ResourceSetResources&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<ResourceSetResources> listResourceSetResourcesWithHttpInfo(String resourceSetId) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'resourceSetId' is set ''
                if (resourceSetId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'resourceSetId' when calling listResourceSetResources");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("resourceSetId", resourceSetId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<ResourceSetResources> localReturnType = new ParameterizedTypeReference<ResourceSetResources>() {};
            return apiClient.invokeAPI("/api/v1/iam/resource-sets/{resourceSetId}/resources", HttpMethod.GET, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }







            /**
            * List all Resources of a resource set
            * Lists all resources that make up the resource set
                * <p><b>200</b> - OK
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param resourceSetId &#x60;id&#x60; of a resource set (required)
            * @return ResponseEntity&lt;ResourceSetResources&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public PagedList listResourceSetResourcesWithPaginationInfo(String resourceSetId) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'resourceSetId' is set
                if (resourceSetId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'resourceSetId' when calling listResourceSetResources");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("resourceSetId", resourceSetId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<ResourceSetResources> localReturnType = new ParameterizedTypeReference<ResourceSetResources>() {};
            ResponseEntity<ResourceSetResources> responseEntity = apiClient.invokeAPI("/api/v1/iam/resource-sets/{resourceSetId}/resources", HttpMethod.GET, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                    HttpHeaders headers = responseEntity.getHeaders();
                    PagedList pagedList = new PagedList();
                    List<String> linkHeaders = headers.get("link");
                    String self = null, nextPage = null;
                    for (String link : linkHeaders) {
                    if (link.contains("next")) {
                    nextPage = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    if (link.contains("self")) {
                    self = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    }
                    pagedList.addItems(Arrays.asList(responseEntity.getBody()));
                    if (Objects.nonNull(nextPage)) {
                    pagedList.setNextPage(nextPage);
                    }
                    if (Objects.nonNull(self)) {
                    pagedList.setSelf(self);
                    }
                    return pagedList;
        }

        /**
        * List all Resource Sets
        * Lists all resource sets with pagination support
            * <p><b>200</b> - OK
            * <p><b>403</b> - Forbidden
            * <p><b>429</b> - Too Many Requests
                * @param after The cursor to use for pagination. It is an opaque string that specifies your current location in the list and is obtained from the &#x60;Link&#x60; response header. See [Pagination](/#pagination) for more information. (optional)
                * @return ResourceSets
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public ResourceSets listResourceSets(String after) throws RestClientException {
                return listResourceSetsWithHttpInfo(after).getBody();
            }






            /**
            * List all Resource Sets
            * Lists all resource sets with pagination support
                * <p><b>200</b> - OK
                * <p><b>403</b> - Forbidden
                * <p><b>429</b> - Too Many Requests
                * @param after The cursor to use for pagination. It is an opaque string that specifies your current location in the list and is obtained from the &#x60;Link&#x60; response header. See [Pagination](/#pagination) for more information. (optional)
            * @return ResponseEntity&lt;ResourceSets&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<ResourceSets> listResourceSetsWithHttpInfo(String after) throws RestClientException {
            Object localVarPostBody = null;
        

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "after", after));

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<ResourceSets> localReturnType = new ParameterizedTypeReference<ResourceSets>() {};
            return apiClient.invokeAPI("/api/v1/iam/resource-sets", HttpMethod.GET, Collections.<String, Object>emptyMap(), localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }







            /**
            * List all Resource Sets
            * Lists all resource sets with pagination support
                * <p><b>200</b> - OK
                * <p><b>403</b> - Forbidden
                * <p><b>429</b> - Too Many Requests
                * @param after The cursor to use for pagination. It is an opaque string that specifies your current location in the list and is obtained from the &#x60;Link&#x60; response header. See [Pagination](/#pagination) for more information. (optional)
            * @return ResponseEntity&lt;ResourceSets&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public PagedList listResourceSetsWithPaginationInfo(String after) throws RestClientException {
            Object localVarPostBody = null;
        

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "after", after));

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<ResourceSets> localReturnType = new ParameterizedTypeReference<ResourceSets>() {};
            ResponseEntity<ResourceSets> responseEntity = apiClient.invokeAPI("/api/v1/iam/resource-sets", HttpMethod.GET, Collections.<String, Object>emptyMap(), localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                    HttpHeaders headers = responseEntity.getHeaders();
                    PagedList pagedList = new PagedList();
                    List<String> linkHeaders = headers.get("link");
                    String self = null, nextPage = null;
                    for (String link : linkHeaders) {
                    if (link.contains("next")) {
                    nextPage = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    if (link.contains("self")) {
                    self = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    }
                    pagedList.addItems(Arrays.asList(responseEntity.getBody()));
                    if (Objects.nonNull(nextPage)) {
                    pagedList.setNextPage(nextPage);
                    }
                    if (Objects.nonNull(self)) {
                    pagedList.setSelf(self);
                    }
                    return pagedList;
        }

        /**
        * Replace a Resource Set
        * Replaces a resource set by &#x60;resourceSetId&#x60;
            * <p><b>200</b> - OK
            * <p><b>400</b> - Bad Request
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>429</b> - Too Many Requests
                * @param resourceSetId &#x60;id&#x60; of a resource set (required)
                * @param instance  (required)
                * @return ResourceSet
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public ResourceSet replaceResourceSet(String resourceSetId, ResourceSet instance) throws RestClientException {
                return replaceResourceSetWithHttpInfo(resourceSetId, instance).getBody();
            }




            /**
            * Replace a Resource Set
            * Replaces a resource set by &#x60;resourceSetId&#x60;
                * <p><b>200</b> - OK
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param T (required) - the assignable return type
                * @param resourceSetId &#x60;id&#x60; of a resource set (required)
                * @param instance  (required)
                * @return T instance
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public <T> T replaceResourceSet(Class<?> T, String resourceSetId, ResourceSet instance) throws RestClientException {
                return (T) getObjectMapper().convertValue(replaceResourceSetWithReturnType(T, resourceSetId, instance).getBody(), T);
            }




            /**
            * Replace a Resource Set
            * Replaces a resource set by &#x60;resourceSetId&#x60;
                * <p><b>200</b> - OK
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param resourceSetId &#x60;id&#x60; of a resource set (required)
                * @param instance  (required)
            * @return ResponseEntity&lt;ResourceSet&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<ResourceSet> replaceResourceSetWithHttpInfo(String resourceSetId, ResourceSet instance) throws RestClientException {
            Object localVarPostBody = instance;
        
                // verify the required parameter 'resourceSetId' is set ''
                if (resourceSetId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'resourceSetId' when calling replaceResourceSet");
                }
        
                // verify the required parameter 'instance' is set ''
                if (instance == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'instance' when calling replaceResourceSet");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("resourceSetId", resourceSetId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = { 
            "application/json"
         };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<ResourceSet> localReturnType = new ParameterizedTypeReference<ResourceSet>() {};
            return apiClient.invokeAPI("/api/v1/iam/resource-sets/{resourceSetId}", HttpMethod.PUT, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }




            /**
            * Replace a Resource Set
            * Replaces a resource set by &#x60;resourceSetId&#x60;
                * <p><b>200</b> - OK
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param resourceSetId &#x60;id&#x60; of a resource set (required)
                * @param instance  (required)
            * @return ResponseEntity&lt;ResourceSet&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private <T> ResponseEntity<T> replaceResourceSetWithReturnType(Class<?> T, String resourceSetId,ResourceSet instance) throws RestClientException {
            Object localVarPostBody = instance;
        
                // verify the required parameter 'resourceSetId' is set
                if (resourceSetId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'resourceSetId' when calling replaceResourceSet");
                }
        
                // verify the required parameter 'instance' is set
                if (instance == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'instance' when calling replaceResourceSet");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("resourceSetId", resourceSetId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = { 
            "application/json"
         };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<T> localReturnType = new ParameterizedTypeReference<T>() {};
            return apiClient.invokeAPI("/api/v1/iam/resource-sets/{resourceSetId}", HttpMethod.PUT, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }




            /**
            * Replace a Resource Set
            * Replaces a resource set by &#x60;resourceSetId&#x60;
                * <p><b>200</b> - OK
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param resourceSetId &#x60;id&#x60; of a resource set (required)
                * @param instance  (required)
            * @return ResponseEntity&lt;ResourceSet&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public PagedList replaceResourceSetWithPaginationInfo(String resourceSetId, ResourceSet instance) throws RestClientException {
            Object localVarPostBody = instance;
        
                // verify the required parameter 'resourceSetId' is set
                if (resourceSetId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'resourceSetId' when calling replaceResourceSet");
                }
        
                // verify the required parameter 'instance' is set
                if (instance == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'instance' when calling replaceResourceSet");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("resourceSetId", resourceSetId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = { 
            "application/json"
         };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<ResourceSet> localReturnType = new ParameterizedTypeReference<ResourceSet>() {};
            ResponseEntity<ResourceSet> responseEntity = apiClient.invokeAPI("/api/v1/iam/resource-sets/{resourceSetId}", HttpMethod.PUT, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                    HttpHeaders headers = responseEntity.getHeaders();
                    PagedList pagedList = new PagedList();
                    List<String> linkHeaders = headers.get("link");
                    String self = null, nextPage = null;
                    for (String link : linkHeaders) {
                    if (link.contains("next")) {
                    nextPage = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    if (link.contains("self")) {
                    self = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    }
                    pagedList.addItems(Arrays.asList(responseEntity.getBody()));
                    if (Objects.nonNull(nextPage)) {
                    pagedList.setNextPage(nextPage);
                    }
                    if (Objects.nonNull(self)) {
                    pagedList.setSelf(self);
                    }
                    return pagedList;
        }

        /**
        * Unassign a Member from a binding
        * Unassigns a member identified by &#x60;memberId&#x60; from a binding
            * <p><b>204</b> - No Content
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>429</b> - Too Many Requests
                * @param resourceSetId &#x60;id&#x60; of a resource set (required)
                * @param roleIdOrLabel &#x60;id&#x60; or &#x60;label&#x60; of the role (required)
                * @param memberId &#x60;id&#x60; of a member (required)
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public void unassignMemberFromBinding(String resourceSetId, String roleIdOrLabel, String memberId) throws RestClientException {
            unassignMemberFromBindingWithHttpInfo(resourceSetId, roleIdOrLabel, memberId);
            }






            /**
            * Unassign a Member from a binding
            * Unassigns a member identified by &#x60;memberId&#x60; from a binding
                * <p><b>204</b> - No Content
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param resourceSetId &#x60;id&#x60; of a resource set (required)
                * @param roleIdOrLabel &#x60;id&#x60; or &#x60;label&#x60; of the role (required)
                * @param memberId &#x60;id&#x60; of a member (required)
            * @return ResponseEntity&lt;Void&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<Void> unassignMemberFromBindingWithHttpInfo(String resourceSetId, String roleIdOrLabel, String memberId) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'resourceSetId' is set ''
                if (resourceSetId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'resourceSetId' when calling unassignMemberFromBinding");
                }
        
                // verify the required parameter 'roleIdOrLabel' is set ''
                if (roleIdOrLabel == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'roleIdOrLabel' when calling unassignMemberFromBinding");
                }
        
                // verify the required parameter 'memberId' is set ''
                if (memberId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'memberId' when calling unassignMemberFromBinding");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("resourceSetId", resourceSetId);
                    uriVariables.put("roleIdOrLabel", roleIdOrLabel);
                    uriVariables.put("memberId", memberId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<Void> localReturnType = new ParameterizedTypeReference<Void>() {};
            return apiClient.invokeAPI("/api/v1/iam/resource-sets/{resourceSetId}/bindings/{roleIdOrLabel}/members/{memberId}", HttpMethod.DELETE, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }








    private ObjectMapper getObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule(new JavaTimeModule());
        objectMapper.registerModule(new JsonNullableModule());
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        return objectMapper;
    }
        }
