package org.openapitools.client.api;

import org.openapitools.client.ApiClient;

import org.openapitools.client.model.Error;
import org.openapitools.client.model.PerClientRateLimitSettings;
import org.openapitools.client.model.RateLimitAdminNotifications;

import java.util.Collections;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.LinkedHashMap;
import java.util.stream.Collectors;

import com.okta.sdk.resource.common.PagedList;

import com.okta.commons.lang.Assert;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;

import org.openapitools.jackson.nullable.JsonNullableModule;

@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-10-28T09:44:59.080-05:00[America/Chicago]")
@Component("org.openapitools.client.api.RateLimitSettingsApi")
    public class RateLimitSettingsApi {
    private ApiClient apiClient;

    public RateLimitSettingsApi() {
    this(new ApiClient());
    }

    @Autowired
    public RateLimitSettingsApi(ApiClient apiClient) {
    this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
    return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
    this.apiClient = apiClient;
    }

        /**
        * Retrieve the Rate Limit Admin Notification Settings
        * Retrieves the currently configured Rate Limit Admin Notification Settings
            * <p><b>200</b> - OK
            * <p><b>403</b> - Forbidden
            * <p><b>429</b> - Too Many Requests
                * @return RateLimitAdminNotifications
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public RateLimitAdminNotifications getRateLimitSettingsAdminNotifications() throws RestClientException {
                return getRateLimitSettingsAdminNotificationsWithHttpInfo().getBody();
            }






            /**
            * Retrieve the Rate Limit Admin Notification Settings
            * Retrieves the currently configured Rate Limit Admin Notification Settings
                * <p><b>200</b> - OK
                * <p><b>403</b> - Forbidden
                * <p><b>429</b> - Too Many Requests
            * @return ResponseEntity&lt;RateLimitAdminNotifications&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<RateLimitAdminNotifications> getRateLimitSettingsAdminNotificationsWithHttpInfo() throws RestClientException {
            Object localVarPostBody = null;
        

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<RateLimitAdminNotifications> localReturnType = new ParameterizedTypeReference<RateLimitAdminNotifications>() {};
            return apiClient.invokeAPI("/api/v1/rate-limit-settings/admin-notifications", HttpMethod.GET, Collections.<String, Object>emptyMap(), localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }







            /**
            * Retrieve the Rate Limit Admin Notification Settings
            * Retrieves the currently configured Rate Limit Admin Notification Settings
                * <p><b>200</b> - OK
                * <p><b>403</b> - Forbidden
                * <p><b>429</b> - Too Many Requests
            * @return ResponseEntity&lt;RateLimitAdminNotifications&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public PagedList getRateLimitSettingsAdminNotificationsWithPaginationInfo() throws RestClientException {
            Object localVarPostBody = null;
        

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<RateLimitAdminNotifications> localReturnType = new ParameterizedTypeReference<RateLimitAdminNotifications>() {};
            ResponseEntity<RateLimitAdminNotifications> responseEntity = apiClient.invokeAPI("/api/v1/rate-limit-settings/admin-notifications", HttpMethod.GET, Collections.<String, Object>emptyMap(), localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                    HttpHeaders headers = responseEntity.getHeaders();
                    PagedList pagedList = new PagedList();
                    List<String> linkHeaders = headers.get("link");
                    String self = null, nextPage = null;
                    for (String link : linkHeaders) {
                    if (link.contains("next")) {
                    nextPage = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    if (link.contains("self")) {
                    self = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    }
                    pagedList.addItems(Arrays.asList(responseEntity.getBody()));
                    if (Objects.nonNull(nextPage)) {
                    pagedList.setNextPage(nextPage);
                    }
                    if (Objects.nonNull(self)) {
                    pagedList.setSelf(self);
                    }
                    return pagedList;
        }

        /**
        * Retrieve the Per-Client Rate Limit Settings
        * Retrieves the currently configured Per-Client Rate Limit Settings
            * <p><b>200</b> - OK
            * <p><b>403</b> - Forbidden
            * <p><b>429</b> - Too Many Requests
                * @return PerClientRateLimitSettings
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public PerClientRateLimitSettings getRateLimitSettingsPerClient() throws RestClientException {
                return getRateLimitSettingsPerClientWithHttpInfo().getBody();
            }






            /**
            * Retrieve the Per-Client Rate Limit Settings
            * Retrieves the currently configured Per-Client Rate Limit Settings
                * <p><b>200</b> - OK
                * <p><b>403</b> - Forbidden
                * <p><b>429</b> - Too Many Requests
            * @return ResponseEntity&lt;PerClientRateLimitSettings&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<PerClientRateLimitSettings> getRateLimitSettingsPerClientWithHttpInfo() throws RestClientException {
            Object localVarPostBody = null;
        

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<PerClientRateLimitSettings> localReturnType = new ParameterizedTypeReference<PerClientRateLimitSettings>() {};
            return apiClient.invokeAPI("/api/v1/rate-limit-settings/per-client", HttpMethod.GET, Collections.<String, Object>emptyMap(), localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }







            /**
            * Retrieve the Per-Client Rate Limit Settings
            * Retrieves the currently configured Per-Client Rate Limit Settings
                * <p><b>200</b> - OK
                * <p><b>403</b> - Forbidden
                * <p><b>429</b> - Too Many Requests
            * @return ResponseEntity&lt;PerClientRateLimitSettings&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public PagedList getRateLimitSettingsPerClientWithPaginationInfo() throws RestClientException {
            Object localVarPostBody = null;
        

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<PerClientRateLimitSettings> localReturnType = new ParameterizedTypeReference<PerClientRateLimitSettings>() {};
            ResponseEntity<PerClientRateLimitSettings> responseEntity = apiClient.invokeAPI("/api/v1/rate-limit-settings/per-client", HttpMethod.GET, Collections.<String, Object>emptyMap(), localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                    HttpHeaders headers = responseEntity.getHeaders();
                    PagedList pagedList = new PagedList();
                    List<String> linkHeaders = headers.get("link");
                    String self = null, nextPage = null;
                    for (String link : linkHeaders) {
                    if (link.contains("next")) {
                    nextPage = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    if (link.contains("self")) {
                    self = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    }
                    pagedList.addItems(Arrays.asList(responseEntity.getBody()));
                    if (Objects.nonNull(nextPage)) {
                    pagedList.setNextPage(nextPage);
                    }
                    if (Objects.nonNull(self)) {
                    pagedList.setSelf(self);
                    }
                    return pagedList;
        }

        /**
        * Replace the Rate Limit Admin Notification Settings
        * Replaces the Rate Limit Admin Notification Settings and returns the configured properties
            * <p><b>200</b> - Success
            * <p><b>400</b> - Bad Request
            * <p><b>403</b> - Forbidden
            * <p><b>429</b> - Too Many Requests
                * @param rateLimitAdminNotifications  (required)
                * @return RateLimitAdminNotifications
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public RateLimitAdminNotifications replaceRateLimitSettingsAdminNotifications(RateLimitAdminNotifications rateLimitAdminNotifications) throws RestClientException {
                return replaceRateLimitSettingsAdminNotificationsWithHttpInfo(rateLimitAdminNotifications).getBody();
            }




            /**
            * Replace the Rate Limit Admin Notification Settings
            * Replaces the Rate Limit Admin Notification Settings and returns the configured properties
                * <p><b>200</b> - Success
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>429</b> - Too Many Requests
                * @param T (required) - the assignable return type
                * @param rateLimitAdminNotifications  (required)
                * @return T instance
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public <T> T replaceRateLimitSettingsAdminNotifications(Class<?> T, RateLimitAdminNotifications rateLimitAdminNotifications) throws RestClientException {
                return (T) getObjectMapper().convertValue(replaceRateLimitSettingsAdminNotificationsWithReturnType(T, rateLimitAdminNotifications).getBody(), T);
            }




            /**
            * Replace the Rate Limit Admin Notification Settings
            * Replaces the Rate Limit Admin Notification Settings and returns the configured properties
                * <p><b>200</b> - Success
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>429</b> - Too Many Requests
                * @param rateLimitAdminNotifications  (required)
            * @return ResponseEntity&lt;RateLimitAdminNotifications&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<RateLimitAdminNotifications> replaceRateLimitSettingsAdminNotificationsWithHttpInfo(RateLimitAdminNotifications rateLimitAdminNotifications) throws RestClientException {
            Object localVarPostBody = rateLimitAdminNotifications;
        
                // verify the required parameter 'rateLimitAdminNotifications' is set ''
                if (rateLimitAdminNotifications == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'rateLimitAdminNotifications' when calling replaceRateLimitSettingsAdminNotifications");
                }
        

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = { 
            "application/json"
         };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<RateLimitAdminNotifications> localReturnType = new ParameterizedTypeReference<RateLimitAdminNotifications>() {};
            return apiClient.invokeAPI("/api/v1/rate-limit-settings/admin-notifications", HttpMethod.PUT, Collections.<String, Object>emptyMap(), localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }




            /**
            * Replace the Rate Limit Admin Notification Settings
            * Replaces the Rate Limit Admin Notification Settings and returns the configured properties
                * <p><b>200</b> - Success
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>429</b> - Too Many Requests
                * @param rateLimitAdminNotifications  (required)
            * @return ResponseEntity&lt;RateLimitAdminNotifications&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private <T> ResponseEntity<T> replaceRateLimitSettingsAdminNotificationsWithReturnType(Class<?> T, RateLimitAdminNotifications rateLimitAdminNotifications) throws RestClientException {
            Object localVarPostBody = rateLimitAdminNotifications;
        
                // verify the required parameter 'rateLimitAdminNotifications' is set
                if (rateLimitAdminNotifications == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'rateLimitAdminNotifications' when calling replaceRateLimitSettingsAdminNotifications");
                }
        

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = { 
            "application/json"
         };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<T> localReturnType = new ParameterizedTypeReference<T>() {};
            return apiClient.invokeAPI("/api/v1/rate-limit-settings/admin-notifications", HttpMethod.PUT, Collections.<String, Object>emptyMap(), localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }




            /**
            * Replace the Rate Limit Admin Notification Settings
            * Replaces the Rate Limit Admin Notification Settings and returns the configured properties
                * <p><b>200</b> - Success
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>429</b> - Too Many Requests
                * @param rateLimitAdminNotifications  (required)
            * @return ResponseEntity&lt;RateLimitAdminNotifications&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public PagedList replaceRateLimitSettingsAdminNotificationsWithPaginationInfo(RateLimitAdminNotifications rateLimitAdminNotifications) throws RestClientException {
            Object localVarPostBody = rateLimitAdminNotifications;
        
                // verify the required parameter 'rateLimitAdminNotifications' is set
                if (rateLimitAdminNotifications == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'rateLimitAdminNotifications' when calling replaceRateLimitSettingsAdminNotifications");
                }
        

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = { 
            "application/json"
         };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<RateLimitAdminNotifications> localReturnType = new ParameterizedTypeReference<RateLimitAdminNotifications>() {};
            ResponseEntity<RateLimitAdminNotifications> responseEntity = apiClient.invokeAPI("/api/v1/rate-limit-settings/admin-notifications", HttpMethod.PUT, Collections.<String, Object>emptyMap(), localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                    HttpHeaders headers = responseEntity.getHeaders();
                    PagedList pagedList = new PagedList();
                    List<String> linkHeaders = headers.get("link");
                    String self = null, nextPage = null;
                    for (String link : linkHeaders) {
                    if (link.contains("next")) {
                    nextPage = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    if (link.contains("self")) {
                    self = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    }
                    pagedList.addItems(Arrays.asList(responseEntity.getBody()));
                    if (Objects.nonNull(nextPage)) {
                    pagedList.setNextPage(nextPage);
                    }
                    if (Objects.nonNull(self)) {
                    pagedList.setSelf(self);
                    }
                    return pagedList;
        }

        /**
        * Replace the Per-Client Rate Limit Settings
        * Replaces the Per-Client Rate Limit Settings and returns the configured properties
            * <p><b>200</b> - Success
            * <p><b>400</b> - Bad Request
            * <p><b>403</b> - Forbidden
            * <p><b>429</b> - Too Many Requests
                * @param perClientRateLimitSettings  (required)
                * @return PerClientRateLimitSettings
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public PerClientRateLimitSettings replaceRateLimitSettingsPerClient(PerClientRateLimitSettings perClientRateLimitSettings) throws RestClientException {
                return replaceRateLimitSettingsPerClientWithHttpInfo(perClientRateLimitSettings).getBody();
            }




            /**
            * Replace the Per-Client Rate Limit Settings
            * Replaces the Per-Client Rate Limit Settings and returns the configured properties
                * <p><b>200</b> - Success
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>429</b> - Too Many Requests
                * @param T (required) - the assignable return type
                * @param perClientRateLimitSettings  (required)
                * @return T instance
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public <T> T replaceRateLimitSettingsPerClient(Class<?> T, PerClientRateLimitSettings perClientRateLimitSettings) throws RestClientException {
                return (T) getObjectMapper().convertValue(replaceRateLimitSettingsPerClientWithReturnType(T, perClientRateLimitSettings).getBody(), T);
            }




            /**
            * Replace the Per-Client Rate Limit Settings
            * Replaces the Per-Client Rate Limit Settings and returns the configured properties
                * <p><b>200</b> - Success
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>429</b> - Too Many Requests
                * @param perClientRateLimitSettings  (required)
            * @return ResponseEntity&lt;PerClientRateLimitSettings&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<PerClientRateLimitSettings> replaceRateLimitSettingsPerClientWithHttpInfo(PerClientRateLimitSettings perClientRateLimitSettings) throws RestClientException {
            Object localVarPostBody = perClientRateLimitSettings;
        
                // verify the required parameter 'perClientRateLimitSettings' is set ''
                if (perClientRateLimitSettings == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'perClientRateLimitSettings' when calling replaceRateLimitSettingsPerClient");
                }
        

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = { 
            "application/json"
         };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<PerClientRateLimitSettings> localReturnType = new ParameterizedTypeReference<PerClientRateLimitSettings>() {};
            return apiClient.invokeAPI("/api/v1/rate-limit-settings/per-client", HttpMethod.PUT, Collections.<String, Object>emptyMap(), localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }




            /**
            * Replace the Per-Client Rate Limit Settings
            * Replaces the Per-Client Rate Limit Settings and returns the configured properties
                * <p><b>200</b> - Success
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>429</b> - Too Many Requests
                * @param perClientRateLimitSettings  (required)
            * @return ResponseEntity&lt;PerClientRateLimitSettings&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private <T> ResponseEntity<T> replaceRateLimitSettingsPerClientWithReturnType(Class<?> T, PerClientRateLimitSettings perClientRateLimitSettings) throws RestClientException {
            Object localVarPostBody = perClientRateLimitSettings;
        
                // verify the required parameter 'perClientRateLimitSettings' is set
                if (perClientRateLimitSettings == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'perClientRateLimitSettings' when calling replaceRateLimitSettingsPerClient");
                }
        

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = { 
            "application/json"
         };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<T> localReturnType = new ParameterizedTypeReference<T>() {};
            return apiClient.invokeAPI("/api/v1/rate-limit-settings/per-client", HttpMethod.PUT, Collections.<String, Object>emptyMap(), localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }




            /**
            * Replace the Per-Client Rate Limit Settings
            * Replaces the Per-Client Rate Limit Settings and returns the configured properties
                * <p><b>200</b> - Success
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>429</b> - Too Many Requests
                * @param perClientRateLimitSettings  (required)
            * @return ResponseEntity&lt;PerClientRateLimitSettings&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public PagedList replaceRateLimitSettingsPerClientWithPaginationInfo(PerClientRateLimitSettings perClientRateLimitSettings) throws RestClientException {
            Object localVarPostBody = perClientRateLimitSettings;
        
                // verify the required parameter 'perClientRateLimitSettings' is set
                if (perClientRateLimitSettings == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'perClientRateLimitSettings' when calling replaceRateLimitSettingsPerClient");
                }
        

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = { 
            "application/json"
         };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<PerClientRateLimitSettings> localReturnType = new ParameterizedTypeReference<PerClientRateLimitSettings>() {};
            ResponseEntity<PerClientRateLimitSettings> responseEntity = apiClient.invokeAPI("/api/v1/rate-limit-settings/per-client", HttpMethod.PUT, Collections.<String, Object>emptyMap(), localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                    HttpHeaders headers = responseEntity.getHeaders();
                    PagedList pagedList = new PagedList();
                    List<String> linkHeaders = headers.get("link");
                    String self = null, nextPage = null;
                    for (String link : linkHeaders) {
                    if (link.contains("next")) {
                    nextPage = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    if (link.contains("self")) {
                    self = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    }
                    pagedList.addItems(Arrays.asList(responseEntity.getBody()));
                    if (Objects.nonNull(nextPage)) {
                    pagedList.setNextPage(nextPage);
                    }
                    if (Objects.nonNull(self)) {
                    pagedList.setSelf(self);
                    }
                    return pagedList;
        }


    private ObjectMapper getObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule(new JavaTimeModule());
        objectMapper.registerModule(new JsonNullableModule());
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        return objectMapper;
    }
        }
