package org.openapitools.client.api;

import org.openapitools.client.ApiClient;

import org.openapitools.client.model.Csr;
import org.openapitools.client.model.CsrMetadata;
import org.openapitools.client.model.Error;
import java.io.File;
import org.openapitools.client.model.IdentityProvider;
import org.openapitools.client.model.IdentityProviderApplicationUser;
import org.openapitools.client.model.JsonWebKey;
import org.openapitools.client.model.SocialAuthToken;
import org.openapitools.client.model.UserIdentityProviderLinkRequest;

import java.util.Collections;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.LinkedHashMap;
import java.util.stream.Collectors;

import com.okta.sdk.resource.common.PagedList;

import com.okta.commons.lang.Assert;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;

import org.openapitools.jackson.nullable.JsonNullableModule;

@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-10-28T09:44:59.080-05:00[America/Chicago]")
@Component("org.openapitools.client.api.IdentityProviderApi")
    public class IdentityProviderApi {
    private ApiClient apiClient;

    public IdentityProviderApi() {
    this(new ApiClient());
    }

    @Autowired
    public IdentityProviderApi(ApiClient apiClient) {
    this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
    return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
    this.apiClient = apiClient;
    }

        /**
        * Activate an Identity Provider
        * Activates an inactive IdP
            * <p><b>200</b> - Success
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>429</b> - Too Many Requests
                * @param idpId  (required)
                * @return IdentityProvider
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public IdentityProvider activateIdentityProvider(String idpId) throws RestClientException {
                return activateIdentityProviderWithHttpInfo(idpId).getBody();
            }






            /**
            * Activate an Identity Provider
            * Activates an inactive IdP
                * <p><b>200</b> - Success
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param idpId  (required)
            * @return ResponseEntity&lt;IdentityProvider&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<IdentityProvider> activateIdentityProviderWithHttpInfo(String idpId) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'idpId' is set ''
                if (idpId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'idpId' when calling activateIdentityProvider");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("idpId", idpId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<IdentityProvider> localReturnType = new ParameterizedTypeReference<IdentityProvider>() {};
            return apiClient.invokeAPI("/api/v1/idps/{idpId}/lifecycle/activate", HttpMethod.POST, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }







            /**
            * Activate an Identity Provider
            * Activates an inactive IdP
                * <p><b>200</b> - Success
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param idpId  (required)
            * @return ResponseEntity&lt;IdentityProvider&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public PagedList activateIdentityProviderWithPaginationInfo(String idpId) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'idpId' is set
                if (idpId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'idpId' when calling activateIdentityProvider");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("idpId", idpId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<IdentityProvider> localReturnType = new ParameterizedTypeReference<IdentityProvider>() {};
            ResponseEntity<IdentityProvider> responseEntity = apiClient.invokeAPI("/api/v1/idps/{idpId}/lifecycle/activate", HttpMethod.POST, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                    HttpHeaders headers = responseEntity.getHeaders();
                    PagedList pagedList = new PagedList();
                    List<String> linkHeaders = headers.get("link");
                    String self = null, nextPage = null;
                    for (String link : linkHeaders) {
                    if (link.contains("next")) {
                    nextPage = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    if (link.contains("self")) {
                    self = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    }
                    pagedList.addItems(Arrays.asList(responseEntity.getBody()));
                    if (Objects.nonNull(nextPage)) {
                    pagedList.setNextPage(nextPage);
                    }
                    if (Objects.nonNull(self)) {
                    pagedList.setSelf(self);
                    }
                    return pagedList;
        }

        /**
        * Clone a Signing Credential Key
        * Clones a X.509 certificate for an IdP signing key credential from a source IdP to target IdP
            * <p><b>201</b> - Created
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>429</b> - Too Many Requests
                * @param idpId  (required)
                * @param keyId  (required)
                * @param targetIdpId  (required)
                * @return JsonWebKey
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public JsonWebKey cloneIdentityProviderKey(String idpId, String keyId, String targetIdpId) throws RestClientException {
                return cloneIdentityProviderKeyWithHttpInfo(idpId, keyId, targetIdpId).getBody();
            }






            /**
            * Clone a Signing Credential Key
            * Clones a X.509 certificate for an IdP signing key credential from a source IdP to target IdP
                * <p><b>201</b> - Created
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param idpId  (required)
                * @param keyId  (required)
                * @param targetIdpId  (required)
            * @return ResponseEntity&lt;JsonWebKey&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<JsonWebKey> cloneIdentityProviderKeyWithHttpInfo(String idpId, String keyId, String targetIdpId) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'idpId' is set ''
                if (idpId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'idpId' when calling cloneIdentityProviderKey");
                }
        
                // verify the required parameter 'keyId' is set ''
                if (keyId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'keyId' when calling cloneIdentityProviderKey");
                }
        
                // verify the required parameter 'targetIdpId' is set ''
                if (targetIdpId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'targetIdpId' when calling cloneIdentityProviderKey");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("idpId", idpId);
                    uriVariables.put("keyId", keyId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "targetIdpId", targetIdpId));

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<JsonWebKey> localReturnType = new ParameterizedTypeReference<JsonWebKey>() {};
            return apiClient.invokeAPI("/api/v1/idps/{idpId}/credentials/keys/{keyId}/clone", HttpMethod.POST, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }







            /**
            * Clone a Signing Credential Key
            * Clones a X.509 certificate for an IdP signing key credential from a source IdP to target IdP
                * <p><b>201</b> - Created
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param idpId  (required)
                * @param keyId  (required)
                * @param targetIdpId  (required)
            * @return ResponseEntity&lt;JsonWebKey&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public PagedList cloneIdentityProviderKeyWithPaginationInfo(String idpId, String keyId, String targetIdpId) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'idpId' is set
                if (idpId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'idpId' when calling cloneIdentityProviderKey");
                }
        
                // verify the required parameter 'keyId' is set
                if (keyId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'keyId' when calling cloneIdentityProviderKey");
                }
        
                // verify the required parameter 'targetIdpId' is set
                if (targetIdpId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'targetIdpId' when calling cloneIdentityProviderKey");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("idpId", idpId);
                    uriVariables.put("keyId", keyId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "targetIdpId", targetIdpId));

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<JsonWebKey> localReturnType = new ParameterizedTypeReference<JsonWebKey>() {};
            ResponseEntity<JsonWebKey> responseEntity = apiClient.invokeAPI("/api/v1/idps/{idpId}/credentials/keys/{keyId}/clone", HttpMethod.POST, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                    HttpHeaders headers = responseEntity.getHeaders();
                    PagedList pagedList = new PagedList();
                    List<String> linkHeaders = headers.get("link");
                    String self = null, nextPage = null;
                    for (String link : linkHeaders) {
                    if (link.contains("next")) {
                    nextPage = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    if (link.contains("self")) {
                    self = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    }
                    pagedList.addItems(Arrays.asList(responseEntity.getBody()));
                    if (Objects.nonNull(nextPage)) {
                    pagedList.setNextPage(nextPage);
                    }
                    if (Objects.nonNull(self)) {
                    pagedList.setSelf(self);
                    }
                    return pagedList;
        }

        /**
        * Create an Identity Provider
        * Creates a new identity provider integration
            * <p><b>200</b> - Success
            * <p><b>400</b> - Bad Request
            * <p><b>403</b> - Forbidden
            * <p><b>429</b> - Too Many Requests
                * @param identityProvider  (required)
                * @return IdentityProvider
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public IdentityProvider createIdentityProvider(IdentityProvider identityProvider) throws RestClientException {
                return createIdentityProviderWithHttpInfo(identityProvider).getBody();
            }




            /**
            * Create an Identity Provider
            * Creates a new identity provider integration
                * <p><b>200</b> - Success
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>429</b> - Too Many Requests
                * @param T (required) - the assignable return type
                * @param identityProvider  (required)
                * @return T instance
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public <T> T createIdentityProvider(Class<?> T, IdentityProvider identityProvider) throws RestClientException {
                return (T) getObjectMapper().convertValue(createIdentityProviderWithReturnType(T, identityProvider).getBody(), T);
            }




            /**
            * Create an Identity Provider
            * Creates a new identity provider integration
                * <p><b>200</b> - Success
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>429</b> - Too Many Requests
                * @param identityProvider  (required)
            * @return ResponseEntity&lt;IdentityProvider&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<IdentityProvider> createIdentityProviderWithHttpInfo(IdentityProvider identityProvider) throws RestClientException {
            Object localVarPostBody = identityProvider;
        
                // verify the required parameter 'identityProvider' is set ''
                if (identityProvider == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'identityProvider' when calling createIdentityProvider");
                }
        

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = { 
            "application/json"
         };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<IdentityProvider> localReturnType = new ParameterizedTypeReference<IdentityProvider>() {};
            return apiClient.invokeAPI("/api/v1/idps", HttpMethod.POST, Collections.<String, Object>emptyMap(), localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }




            /**
            * Create an Identity Provider
            * Creates a new identity provider integration
                * <p><b>200</b> - Success
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>429</b> - Too Many Requests
                * @param identityProvider  (required)
            * @return ResponseEntity&lt;IdentityProvider&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private <T> ResponseEntity<T> createIdentityProviderWithReturnType(Class<?> T, IdentityProvider identityProvider) throws RestClientException {
            Object localVarPostBody = identityProvider;
        
                // verify the required parameter 'identityProvider' is set
                if (identityProvider == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'identityProvider' when calling createIdentityProvider");
                }
        

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = { 
            "application/json"
         };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<T> localReturnType = new ParameterizedTypeReference<T>() {};
            return apiClient.invokeAPI("/api/v1/idps", HttpMethod.POST, Collections.<String, Object>emptyMap(), localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }




            /**
            * Create an Identity Provider
            * Creates a new identity provider integration
                * <p><b>200</b> - Success
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>429</b> - Too Many Requests
                * @param identityProvider  (required)
            * @return ResponseEntity&lt;IdentityProvider&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public PagedList createIdentityProviderWithPaginationInfo(IdentityProvider identityProvider) throws RestClientException {
            Object localVarPostBody = identityProvider;
        
                // verify the required parameter 'identityProvider' is set
                if (identityProvider == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'identityProvider' when calling createIdentityProvider");
                }
        

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = { 
            "application/json"
         };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<IdentityProvider> localReturnType = new ParameterizedTypeReference<IdentityProvider>() {};
            ResponseEntity<IdentityProvider> responseEntity = apiClient.invokeAPI("/api/v1/idps", HttpMethod.POST, Collections.<String, Object>emptyMap(), localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                    HttpHeaders headers = responseEntity.getHeaders();
                    PagedList pagedList = new PagedList();
                    List<String> linkHeaders = headers.get("link");
                    String self = null, nextPage = null;
                    for (String link : linkHeaders) {
                    if (link.contains("next")) {
                    nextPage = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    if (link.contains("self")) {
                    self = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    }
                    pagedList.addItems(Arrays.asList(responseEntity.getBody()));
                    if (Objects.nonNull(nextPage)) {
                    pagedList.setNextPage(nextPage);
                    }
                    if (Objects.nonNull(self)) {
                    pagedList.setSelf(self);
                    }
                    return pagedList;
        }

        /**
        * Create an X.509 Certificate Public Key
        * Creates a new X.509 certificate credential to the IdP key store.
            * <p><b>200</b> - Success
            * <p><b>400</b> - Bad Request
            * <p><b>403</b> - Forbidden
            * <p><b>429</b> - Too Many Requests
                * @param jsonWebKey  (required)
                * @return JsonWebKey
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public JsonWebKey createIdentityProviderKey(JsonWebKey jsonWebKey) throws RestClientException {
                return createIdentityProviderKeyWithHttpInfo(jsonWebKey).getBody();
            }




            /**
            * Create an X.509 Certificate Public Key
            * Creates a new X.509 certificate credential to the IdP key store.
                * <p><b>200</b> - Success
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>429</b> - Too Many Requests
                * @param T (required) - the assignable return type
                * @param jsonWebKey  (required)
                * @return T instance
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public <T> T createIdentityProviderKey(Class<?> T, JsonWebKey jsonWebKey) throws RestClientException {
                return (T) getObjectMapper().convertValue(createIdentityProviderKeyWithReturnType(T, jsonWebKey).getBody(), T);
            }




            /**
            * Create an X.509 Certificate Public Key
            * Creates a new X.509 certificate credential to the IdP key store.
                * <p><b>200</b> - Success
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>429</b> - Too Many Requests
                * @param jsonWebKey  (required)
            * @return ResponseEntity&lt;JsonWebKey&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<JsonWebKey> createIdentityProviderKeyWithHttpInfo(JsonWebKey jsonWebKey) throws RestClientException {
            Object localVarPostBody = jsonWebKey;
        
                // verify the required parameter 'jsonWebKey' is set ''
                if (jsonWebKey == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'jsonWebKey' when calling createIdentityProviderKey");
                }
        

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = { 
            "application/json"
         };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<JsonWebKey> localReturnType = new ParameterizedTypeReference<JsonWebKey>() {};
            return apiClient.invokeAPI("/api/v1/idps/credentials/keys", HttpMethod.POST, Collections.<String, Object>emptyMap(), localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }




            /**
            * Create an X.509 Certificate Public Key
            * Creates a new X.509 certificate credential to the IdP key store.
                * <p><b>200</b> - Success
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>429</b> - Too Many Requests
                * @param jsonWebKey  (required)
            * @return ResponseEntity&lt;JsonWebKey&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private <T> ResponseEntity<T> createIdentityProviderKeyWithReturnType(Class<?> T, JsonWebKey jsonWebKey) throws RestClientException {
            Object localVarPostBody = jsonWebKey;
        
                // verify the required parameter 'jsonWebKey' is set
                if (jsonWebKey == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'jsonWebKey' when calling createIdentityProviderKey");
                }
        

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = { 
            "application/json"
         };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<T> localReturnType = new ParameterizedTypeReference<T>() {};
            return apiClient.invokeAPI("/api/v1/idps/credentials/keys", HttpMethod.POST, Collections.<String, Object>emptyMap(), localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }




            /**
            * Create an X.509 Certificate Public Key
            * Creates a new X.509 certificate credential to the IdP key store.
                * <p><b>200</b> - Success
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>429</b> - Too Many Requests
                * @param jsonWebKey  (required)
            * @return ResponseEntity&lt;JsonWebKey&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public PagedList createIdentityProviderKeyWithPaginationInfo(JsonWebKey jsonWebKey) throws RestClientException {
            Object localVarPostBody = jsonWebKey;
        
                // verify the required parameter 'jsonWebKey' is set
                if (jsonWebKey == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'jsonWebKey' when calling createIdentityProviderKey");
                }
        

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = { 
            "application/json"
         };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<JsonWebKey> localReturnType = new ParameterizedTypeReference<JsonWebKey>() {};
            ResponseEntity<JsonWebKey> responseEntity = apiClient.invokeAPI("/api/v1/idps/credentials/keys", HttpMethod.POST, Collections.<String, Object>emptyMap(), localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                    HttpHeaders headers = responseEntity.getHeaders();
                    PagedList pagedList = new PagedList();
                    List<String> linkHeaders = headers.get("link");
                    String self = null, nextPage = null;
                    for (String link : linkHeaders) {
                    if (link.contains("next")) {
                    nextPage = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    if (link.contains("self")) {
                    self = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    }
                    pagedList.addItems(Arrays.asList(responseEntity.getBody()));
                    if (Objects.nonNull(nextPage)) {
                    pagedList.setNextPage(nextPage);
                    }
                    if (Objects.nonNull(self)) {
                    pagedList.setSelf(self);
                    }
                    return pagedList;
        }

        /**
        * Deactivate an Identity Provider
        * Deactivates an active IdP
            * <p><b>200</b> - Success
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>429</b> - Too Many Requests
                * @param idpId  (required)
                * @return IdentityProvider
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public IdentityProvider deactivateIdentityProvider(String idpId) throws RestClientException {
                return deactivateIdentityProviderWithHttpInfo(idpId).getBody();
            }






            /**
            * Deactivate an Identity Provider
            * Deactivates an active IdP
                * <p><b>200</b> - Success
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param idpId  (required)
            * @return ResponseEntity&lt;IdentityProvider&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<IdentityProvider> deactivateIdentityProviderWithHttpInfo(String idpId) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'idpId' is set ''
                if (idpId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'idpId' when calling deactivateIdentityProvider");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("idpId", idpId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<IdentityProvider> localReturnType = new ParameterizedTypeReference<IdentityProvider>() {};
            return apiClient.invokeAPI("/api/v1/idps/{idpId}/lifecycle/deactivate", HttpMethod.POST, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }







            /**
            * Deactivate an Identity Provider
            * Deactivates an active IdP
                * <p><b>200</b> - Success
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param idpId  (required)
            * @return ResponseEntity&lt;IdentityProvider&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public PagedList deactivateIdentityProviderWithPaginationInfo(String idpId) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'idpId' is set
                if (idpId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'idpId' when calling deactivateIdentityProvider");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("idpId", idpId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<IdentityProvider> localReturnType = new ParameterizedTypeReference<IdentityProvider>() {};
            ResponseEntity<IdentityProvider> responseEntity = apiClient.invokeAPI("/api/v1/idps/{idpId}/lifecycle/deactivate", HttpMethod.POST, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                    HttpHeaders headers = responseEntity.getHeaders();
                    PagedList pagedList = new PagedList();
                    List<String> linkHeaders = headers.get("link");
                    String self = null, nextPage = null;
                    for (String link : linkHeaders) {
                    if (link.contains("next")) {
                    nextPage = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    if (link.contains("self")) {
                    self = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    }
                    pagedList.addItems(Arrays.asList(responseEntity.getBody()));
                    if (Objects.nonNull(nextPage)) {
                    pagedList.setNextPage(nextPage);
                    }
                    if (Objects.nonNull(self)) {
                    pagedList.setSelf(self);
                    }
                    return pagedList;
        }

        /**
        * Delete an Identity Provider
        * Deletes an identity provider integration by &#x60;idpId&#x60;
            * <p><b>204</b> - No Content
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>429</b> - Too Many Requests
                * @param idpId  (required)
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public void deleteIdentityProvider(String idpId) throws RestClientException {
            deleteIdentityProviderWithHttpInfo(idpId);
            }






            /**
            * Delete an Identity Provider
            * Deletes an identity provider integration by &#x60;idpId&#x60;
                * <p><b>204</b> - No Content
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param idpId  (required)
            * @return ResponseEntity&lt;Void&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<Void> deleteIdentityProviderWithHttpInfo(String idpId) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'idpId' is set ''
                if (idpId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'idpId' when calling deleteIdentityProvider");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("idpId", idpId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<Void> localReturnType = new ParameterizedTypeReference<Void>() {};
            return apiClient.invokeAPI("/api/v1/idps/{idpId}", HttpMethod.DELETE, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }







        /**
        * Delete a Signing Credential Key
        * Deletes a specific IdP Key Credential by &#x60;kid&#x60; if it is not currently being used by an Active or Inactive IdP
            * <p><b>204</b> - No Content
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>429</b> - Too Many Requests
                * @param keyId  (required)
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public void deleteIdentityProviderKey(String keyId) throws RestClientException {
            deleteIdentityProviderKeyWithHttpInfo(keyId);
            }






            /**
            * Delete a Signing Credential Key
            * Deletes a specific IdP Key Credential by &#x60;kid&#x60; if it is not currently being used by an Active or Inactive IdP
                * <p><b>204</b> - No Content
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param keyId  (required)
            * @return ResponseEntity&lt;Void&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<Void> deleteIdentityProviderKeyWithHttpInfo(String keyId) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'keyId' is set ''
                if (keyId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'keyId' when calling deleteIdentityProviderKey");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("keyId", keyId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<Void> localReturnType = new ParameterizedTypeReference<Void>() {};
            return apiClient.invokeAPI("/api/v1/idps/credentials/keys/{keyId}", HttpMethod.DELETE, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }







        /**
        * Generate a Certificate Signing Request
        * Generates a new key pair and returns a Certificate Signing Request for it
            * <p><b>201</b> - Created
            * <p><b>400</b> - Bad Request
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>429</b> - Too Many Requests
                * @param idpId  (required)
                * @param metadata  (required)
                * @return Csr
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public Csr generateCsrForIdentityProvider(String idpId, CsrMetadata metadata) throws RestClientException {
                return generateCsrForIdentityProviderWithHttpInfo(idpId, metadata).getBody();
            }




            /**
            * Generate a Certificate Signing Request
            * Generates a new key pair and returns a Certificate Signing Request for it
                * <p><b>201</b> - Created
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param T (required) - the assignable return type
                * @param idpId  (required)
                * @param metadata  (required)
                * @return T instance
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public <T> T generateCsrForIdentityProvider(Class<?> T, String idpId, CsrMetadata metadata) throws RestClientException {
                return (T) getObjectMapper().convertValue(generateCsrForIdentityProviderWithReturnType(T, idpId, metadata).getBody(), T);
            }




            /**
            * Generate a Certificate Signing Request
            * Generates a new key pair and returns a Certificate Signing Request for it
                * <p><b>201</b> - Created
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param idpId  (required)
                * @param metadata  (required)
            * @return ResponseEntity&lt;Csr&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<Csr> generateCsrForIdentityProviderWithHttpInfo(String idpId, CsrMetadata metadata) throws RestClientException {
            Object localVarPostBody = metadata;
        
                // verify the required parameter 'idpId' is set ''
                if (idpId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'idpId' when calling generateCsrForIdentityProvider");
                }
        
                // verify the required parameter 'metadata' is set ''
                if (metadata == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'metadata' when calling generateCsrForIdentityProvider");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("idpId", idpId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = { 
            "application/json"
         };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<Csr> localReturnType = new ParameterizedTypeReference<Csr>() {};
            return apiClient.invokeAPI("/api/v1/idps/{idpId}/credentials/csrs", HttpMethod.POST, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }




            /**
            * Generate a Certificate Signing Request
            * Generates a new key pair and returns a Certificate Signing Request for it
                * <p><b>201</b> - Created
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param idpId  (required)
                * @param metadata  (required)
            * @return ResponseEntity&lt;Csr&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private <T> ResponseEntity<T> generateCsrForIdentityProviderWithReturnType(Class<?> T, String idpId,CsrMetadata metadata) throws RestClientException {
            Object localVarPostBody = metadata;
        
                // verify the required parameter 'idpId' is set
                if (idpId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'idpId' when calling generateCsrForIdentityProvider");
                }
        
                // verify the required parameter 'metadata' is set
                if (metadata == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'metadata' when calling generateCsrForIdentityProvider");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("idpId", idpId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = { 
            "application/json"
         };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<T> localReturnType = new ParameterizedTypeReference<T>() {};
            return apiClient.invokeAPI("/api/v1/idps/{idpId}/credentials/csrs", HttpMethod.POST, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }




            /**
            * Generate a Certificate Signing Request
            * Generates a new key pair and returns a Certificate Signing Request for it
                * <p><b>201</b> - Created
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param idpId  (required)
                * @param metadata  (required)
            * @return ResponseEntity&lt;Csr&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public PagedList generateCsrForIdentityProviderWithPaginationInfo(String idpId, CsrMetadata metadata) throws RestClientException {
            Object localVarPostBody = metadata;
        
                // verify the required parameter 'idpId' is set
                if (idpId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'idpId' when calling generateCsrForIdentityProvider");
                }
        
                // verify the required parameter 'metadata' is set
                if (metadata == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'metadata' when calling generateCsrForIdentityProvider");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("idpId", idpId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = { 
            "application/json"
         };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<Csr> localReturnType = new ParameterizedTypeReference<Csr>() {};
            ResponseEntity<Csr> responseEntity = apiClient.invokeAPI("/api/v1/idps/{idpId}/credentials/csrs", HttpMethod.POST, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                    HttpHeaders headers = responseEntity.getHeaders();
                    PagedList pagedList = new PagedList();
                    List<String> linkHeaders = headers.get("link");
                    String self = null, nextPage = null;
                    for (String link : linkHeaders) {
                    if (link.contains("next")) {
                    nextPage = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    if (link.contains("self")) {
                    self = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    }
                    pagedList.addItems(Arrays.asList(responseEntity.getBody()));
                    if (Objects.nonNull(nextPage)) {
                    pagedList.setNextPage(nextPage);
                    }
                    if (Objects.nonNull(self)) {
                    pagedList.setSelf(self);
                    }
                    return pagedList;
        }

        /**
        * Generate a new Signing Credential Key
        * Generates a new X.509 certificate for an IdP signing key credential to be used for signing assertions sent to the IdP
            * <p><b>200</b> - Success
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>429</b> - Too Many Requests
                * @param idpId  (required)
                * @param validityYears expiry of the IdP Key Credential (required)
                * @return JsonWebKey
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public JsonWebKey generateIdentityProviderSigningKey(String idpId, Integer validityYears) throws RestClientException {
                return generateIdentityProviderSigningKeyWithHttpInfo(idpId, validityYears).getBody();
            }






            /**
            * Generate a new Signing Credential Key
            * Generates a new X.509 certificate for an IdP signing key credential to be used for signing assertions sent to the IdP
                * <p><b>200</b> - Success
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param idpId  (required)
                * @param validityYears expiry of the IdP Key Credential (required)
            * @return ResponseEntity&lt;JsonWebKey&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<JsonWebKey> generateIdentityProviderSigningKeyWithHttpInfo(String idpId, Integer validityYears) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'idpId' is set ''
                if (idpId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'idpId' when calling generateIdentityProviderSigningKey");
                }
        
                // verify the required parameter 'validityYears' is set ''
                if (validityYears == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'validityYears' when calling generateIdentityProviderSigningKey");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("idpId", idpId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "validityYears", validityYears));

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<JsonWebKey> localReturnType = new ParameterizedTypeReference<JsonWebKey>() {};
            return apiClient.invokeAPI("/api/v1/idps/{idpId}/credentials/keys/generate", HttpMethod.POST, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }







            /**
            * Generate a new Signing Credential Key
            * Generates a new X.509 certificate for an IdP signing key credential to be used for signing assertions sent to the IdP
                * <p><b>200</b> - Success
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param idpId  (required)
                * @param validityYears expiry of the IdP Key Credential (required)
            * @return ResponseEntity&lt;JsonWebKey&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public PagedList generateIdentityProviderSigningKeyWithPaginationInfo(String idpId, Integer validityYears) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'idpId' is set
                if (idpId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'idpId' when calling generateIdentityProviderSigningKey");
                }
        
                // verify the required parameter 'validityYears' is set
                if (validityYears == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'validityYears' when calling generateIdentityProviderSigningKey");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("idpId", idpId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "validityYears", validityYears));

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<JsonWebKey> localReturnType = new ParameterizedTypeReference<JsonWebKey>() {};
            ResponseEntity<JsonWebKey> responseEntity = apiClient.invokeAPI("/api/v1/idps/{idpId}/credentials/keys/generate", HttpMethod.POST, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                    HttpHeaders headers = responseEntity.getHeaders();
                    PagedList pagedList = new PagedList();
                    List<String> linkHeaders = headers.get("link");
                    String self = null, nextPage = null;
                    for (String link : linkHeaders) {
                    if (link.contains("next")) {
                    nextPage = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    if (link.contains("self")) {
                    self = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    }
                    pagedList.addItems(Arrays.asList(responseEntity.getBody()));
                    if (Objects.nonNull(nextPage)) {
                    pagedList.setNextPage(nextPage);
                    }
                    if (Objects.nonNull(self)) {
                    pagedList.setSelf(self);
                    }
                    return pagedList;
        }

        /**
        * Retrieve a Certificate Signing Request
        * Retrieves a specific Certificate Signing Request model by id
            * <p><b>200</b> - Success
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>429</b> - Too Many Requests
                * @param idpId  (required)
                * @param csrId  (required)
                * @return Csr
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public Csr getCsrForIdentityProvider(String idpId, String csrId) throws RestClientException {
                return getCsrForIdentityProviderWithHttpInfo(idpId, csrId).getBody();
            }






            /**
            * Retrieve a Certificate Signing Request
            * Retrieves a specific Certificate Signing Request model by id
                * <p><b>200</b> - Success
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param idpId  (required)
                * @param csrId  (required)
            * @return ResponseEntity&lt;Csr&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<Csr> getCsrForIdentityProviderWithHttpInfo(String idpId, String csrId) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'idpId' is set ''
                if (idpId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'idpId' when calling getCsrForIdentityProvider");
                }
        
                // verify the required parameter 'csrId' is set ''
                if (csrId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'csrId' when calling getCsrForIdentityProvider");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("idpId", idpId);
                    uriVariables.put("csrId", csrId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<Csr> localReturnType = new ParameterizedTypeReference<Csr>() {};
            return apiClient.invokeAPI("/api/v1/idps/{idpId}/credentials/csrs/{csrId}", HttpMethod.GET, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }







            /**
            * Retrieve a Certificate Signing Request
            * Retrieves a specific Certificate Signing Request model by id
                * <p><b>200</b> - Success
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param idpId  (required)
                * @param csrId  (required)
            * @return ResponseEntity&lt;Csr&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public PagedList getCsrForIdentityProviderWithPaginationInfo(String idpId, String csrId) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'idpId' is set
                if (idpId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'idpId' when calling getCsrForIdentityProvider");
                }
        
                // verify the required parameter 'csrId' is set
                if (csrId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'csrId' when calling getCsrForIdentityProvider");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("idpId", idpId);
                    uriVariables.put("csrId", csrId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<Csr> localReturnType = new ParameterizedTypeReference<Csr>() {};
            ResponseEntity<Csr> responseEntity = apiClient.invokeAPI("/api/v1/idps/{idpId}/credentials/csrs/{csrId}", HttpMethod.GET, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                    HttpHeaders headers = responseEntity.getHeaders();
                    PagedList pagedList = new PagedList();
                    List<String> linkHeaders = headers.get("link");
                    String self = null, nextPage = null;
                    for (String link : linkHeaders) {
                    if (link.contains("next")) {
                    nextPage = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    if (link.contains("self")) {
                    self = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    }
                    pagedList.addItems(Arrays.asList(responseEntity.getBody()));
                    if (Objects.nonNull(nextPage)) {
                    pagedList.setNextPage(nextPage);
                    }
                    if (Objects.nonNull(self)) {
                    pagedList.setSelf(self);
                    }
                    return pagedList;
        }

        /**
        * Retrieve an Identity Provider
        * Retrieves an identity provider integration by &#x60;idpId&#x60;
            * <p><b>200</b> - Success
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>429</b> - Too Many Requests
                * @param idpId  (required)
                * @return IdentityProvider
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public IdentityProvider getIdentityProvider(String idpId) throws RestClientException {
                return getIdentityProviderWithHttpInfo(idpId).getBody();
            }






            /**
            * Retrieve an Identity Provider
            * Retrieves an identity provider integration by &#x60;idpId&#x60;
                * <p><b>200</b> - Success
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param idpId  (required)
            * @return ResponseEntity&lt;IdentityProvider&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<IdentityProvider> getIdentityProviderWithHttpInfo(String idpId) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'idpId' is set ''
                if (idpId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'idpId' when calling getIdentityProvider");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("idpId", idpId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<IdentityProvider> localReturnType = new ParameterizedTypeReference<IdentityProvider>() {};
            return apiClient.invokeAPI("/api/v1/idps/{idpId}", HttpMethod.GET, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }







            /**
            * Retrieve an Identity Provider
            * Retrieves an identity provider integration by &#x60;idpId&#x60;
                * <p><b>200</b> - Success
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param idpId  (required)
            * @return ResponseEntity&lt;IdentityProvider&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public PagedList getIdentityProviderWithPaginationInfo(String idpId) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'idpId' is set
                if (idpId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'idpId' when calling getIdentityProvider");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("idpId", idpId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<IdentityProvider> localReturnType = new ParameterizedTypeReference<IdentityProvider>() {};
            ResponseEntity<IdentityProvider> responseEntity = apiClient.invokeAPI("/api/v1/idps/{idpId}", HttpMethod.GET, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                    HttpHeaders headers = responseEntity.getHeaders();
                    PagedList pagedList = new PagedList();
                    List<String> linkHeaders = headers.get("link");
                    String self = null, nextPage = null;
                    for (String link : linkHeaders) {
                    if (link.contains("next")) {
                    nextPage = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    if (link.contains("self")) {
                    self = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    }
                    pagedList.addItems(Arrays.asList(responseEntity.getBody()));
                    if (Objects.nonNull(nextPage)) {
                    pagedList.setNextPage(nextPage);
                    }
                    if (Objects.nonNull(self)) {
                    pagedList.setSelf(self);
                    }
                    return pagedList;
        }

        /**
        * Retrieve a User
        * Retrieves a linked IdP user by ID
            * <p><b>200</b> - Success
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>429</b> - Too Many Requests
                * @param idpId  (required)
                * @param userId  (required)
                * @return IdentityProviderApplicationUser
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public IdentityProviderApplicationUser getIdentityProviderApplicationUser(String idpId, String userId) throws RestClientException {
                return getIdentityProviderApplicationUserWithHttpInfo(idpId, userId).getBody();
            }






            /**
            * Retrieve a User
            * Retrieves a linked IdP user by ID
                * <p><b>200</b> - Success
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param idpId  (required)
                * @param userId  (required)
            * @return ResponseEntity&lt;IdentityProviderApplicationUser&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<IdentityProviderApplicationUser> getIdentityProviderApplicationUserWithHttpInfo(String idpId, String userId) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'idpId' is set ''
                if (idpId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'idpId' when calling getIdentityProviderApplicationUser");
                }
        
                // verify the required parameter 'userId' is set ''
                if (userId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'userId' when calling getIdentityProviderApplicationUser");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("idpId", idpId);
                    uriVariables.put("userId", userId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<IdentityProviderApplicationUser> localReturnType = new ParameterizedTypeReference<IdentityProviderApplicationUser>() {};
            return apiClient.invokeAPI("/api/v1/idps/{idpId}/users/{userId}", HttpMethod.GET, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }







            /**
            * Retrieve a User
            * Retrieves a linked IdP user by ID
                * <p><b>200</b> - Success
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param idpId  (required)
                * @param userId  (required)
            * @return ResponseEntity&lt;IdentityProviderApplicationUser&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public PagedList getIdentityProviderApplicationUserWithPaginationInfo(String idpId, String userId) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'idpId' is set
                if (idpId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'idpId' when calling getIdentityProviderApplicationUser");
                }
        
                // verify the required parameter 'userId' is set
                if (userId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'userId' when calling getIdentityProviderApplicationUser");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("idpId", idpId);
                    uriVariables.put("userId", userId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<IdentityProviderApplicationUser> localReturnType = new ParameterizedTypeReference<IdentityProviderApplicationUser>() {};
            ResponseEntity<IdentityProviderApplicationUser> responseEntity = apiClient.invokeAPI("/api/v1/idps/{idpId}/users/{userId}", HttpMethod.GET, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                    HttpHeaders headers = responseEntity.getHeaders();
                    PagedList pagedList = new PagedList();
                    List<String> linkHeaders = headers.get("link");
                    String self = null, nextPage = null;
                    for (String link : linkHeaders) {
                    if (link.contains("next")) {
                    nextPage = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    if (link.contains("self")) {
                    self = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    }
                    pagedList.addItems(Arrays.asList(responseEntity.getBody()));
                    if (Objects.nonNull(nextPage)) {
                    pagedList.setNextPage(nextPage);
                    }
                    if (Objects.nonNull(self)) {
                    pagedList.setSelf(self);
                    }
                    return pagedList;
        }

        /**
        * Retrieve an Credential Key
        * Retrieves a specific IdP Key Credential by &#x60;kid&#x60;
            * <p><b>200</b> - Success
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>429</b> - Too Many Requests
                * @param keyId  (required)
                * @return JsonWebKey
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public JsonWebKey getIdentityProviderKey(String keyId) throws RestClientException {
                return getIdentityProviderKeyWithHttpInfo(keyId).getBody();
            }






            /**
            * Retrieve an Credential Key
            * Retrieves a specific IdP Key Credential by &#x60;kid&#x60;
                * <p><b>200</b> - Success
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param keyId  (required)
            * @return ResponseEntity&lt;JsonWebKey&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<JsonWebKey> getIdentityProviderKeyWithHttpInfo(String keyId) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'keyId' is set ''
                if (keyId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'keyId' when calling getIdentityProviderKey");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("keyId", keyId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<JsonWebKey> localReturnType = new ParameterizedTypeReference<JsonWebKey>() {};
            return apiClient.invokeAPI("/api/v1/idps/credentials/keys/{keyId}", HttpMethod.GET, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }







            /**
            * Retrieve an Credential Key
            * Retrieves a specific IdP Key Credential by &#x60;kid&#x60;
                * <p><b>200</b> - Success
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param keyId  (required)
            * @return ResponseEntity&lt;JsonWebKey&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public PagedList getIdentityProviderKeyWithPaginationInfo(String keyId) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'keyId' is set
                if (keyId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'keyId' when calling getIdentityProviderKey");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("keyId", keyId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<JsonWebKey> localReturnType = new ParameterizedTypeReference<JsonWebKey>() {};
            ResponseEntity<JsonWebKey> responseEntity = apiClient.invokeAPI("/api/v1/idps/credentials/keys/{keyId}", HttpMethod.GET, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                    HttpHeaders headers = responseEntity.getHeaders();
                    PagedList pagedList = new PagedList();
                    List<String> linkHeaders = headers.get("link");
                    String self = null, nextPage = null;
                    for (String link : linkHeaders) {
                    if (link.contains("next")) {
                    nextPage = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    if (link.contains("self")) {
                    self = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    }
                    pagedList.addItems(Arrays.asList(responseEntity.getBody()));
                    if (Objects.nonNull(nextPage)) {
                    pagedList.setNextPage(nextPage);
                    }
                    if (Objects.nonNull(self)) {
                    pagedList.setSelf(self);
                    }
                    return pagedList;
        }

        /**
        * Retrieve a Signing Credential Key
        * Retrieves a specific IdP Key Credential by &#x60;kid&#x60;
            * <p><b>200</b> - Success
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>429</b> - Too Many Requests
                * @param idpId  (required)
                * @param keyId  (required)
                * @return JsonWebKey
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public JsonWebKey getIdentityProviderSigningKey(String idpId, String keyId) throws RestClientException {
                return getIdentityProviderSigningKeyWithHttpInfo(idpId, keyId).getBody();
            }






            /**
            * Retrieve a Signing Credential Key
            * Retrieves a specific IdP Key Credential by &#x60;kid&#x60;
                * <p><b>200</b> - Success
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param idpId  (required)
                * @param keyId  (required)
            * @return ResponseEntity&lt;JsonWebKey&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<JsonWebKey> getIdentityProviderSigningKeyWithHttpInfo(String idpId, String keyId) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'idpId' is set ''
                if (idpId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'idpId' when calling getIdentityProviderSigningKey");
                }
        
                // verify the required parameter 'keyId' is set ''
                if (keyId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'keyId' when calling getIdentityProviderSigningKey");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("idpId", idpId);
                    uriVariables.put("keyId", keyId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<JsonWebKey> localReturnType = new ParameterizedTypeReference<JsonWebKey>() {};
            return apiClient.invokeAPI("/api/v1/idps/{idpId}/credentials/keys/{keyId}", HttpMethod.GET, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }







            /**
            * Retrieve a Signing Credential Key
            * Retrieves a specific IdP Key Credential by &#x60;kid&#x60;
                * <p><b>200</b> - Success
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param idpId  (required)
                * @param keyId  (required)
            * @return ResponseEntity&lt;JsonWebKey&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public PagedList getIdentityProviderSigningKeyWithPaginationInfo(String idpId, String keyId) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'idpId' is set
                if (idpId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'idpId' when calling getIdentityProviderSigningKey");
                }
        
                // verify the required parameter 'keyId' is set
                if (keyId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'keyId' when calling getIdentityProviderSigningKey");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("idpId", idpId);
                    uriVariables.put("keyId", keyId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<JsonWebKey> localReturnType = new ParameterizedTypeReference<JsonWebKey>() {};
            ResponseEntity<JsonWebKey> responseEntity = apiClient.invokeAPI("/api/v1/idps/{idpId}/credentials/keys/{keyId}", HttpMethod.GET, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                    HttpHeaders headers = responseEntity.getHeaders();
                    PagedList pagedList = new PagedList();
                    List<String> linkHeaders = headers.get("link");
                    String self = null, nextPage = null;
                    for (String link : linkHeaders) {
                    if (link.contains("next")) {
                    nextPage = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    if (link.contains("self")) {
                    self = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    }
                    pagedList.addItems(Arrays.asList(responseEntity.getBody()));
                    if (Objects.nonNull(nextPage)) {
                    pagedList.setNextPage(nextPage);
                    }
                    if (Objects.nonNull(self)) {
                    pagedList.setSelf(self);
                    }
                    return pagedList;
        }

        /**
        * Link a User to a Social IdP
        * Links an Okta user to an existing Social Identity Provider. This does not support the SAML2 Identity Provider Type
            * <p><b>200</b> - Success
            * <p><b>400</b> - Bad Request
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>429</b> - Too Many Requests
                * @param idpId  (required)
                * @param userId  (required)
                * @param userIdentityProviderLinkRequest  (required)
                * @return IdentityProviderApplicationUser
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public IdentityProviderApplicationUser linkUserToIdentityProvider(String idpId, String userId, UserIdentityProviderLinkRequest userIdentityProviderLinkRequest) throws RestClientException {
                return linkUserToIdentityProviderWithHttpInfo(idpId, userId, userIdentityProviderLinkRequest).getBody();
            }




            /**
            * Link a User to a Social IdP
            * Links an Okta user to an existing Social Identity Provider. This does not support the SAML2 Identity Provider Type
                * <p><b>200</b> - Success
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param T (required) - the assignable return type
                * @param idpId  (required)
                * @param userId  (required)
                * @param userIdentityProviderLinkRequest  (required)
                * @return T instance
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public <T> T linkUserToIdentityProvider(Class<?> T, String idpId, String userId, UserIdentityProviderLinkRequest userIdentityProviderLinkRequest) throws RestClientException {
                return (T) getObjectMapper().convertValue(linkUserToIdentityProviderWithReturnType(T, idpId, userId, userIdentityProviderLinkRequest).getBody(), T);
            }




            /**
            * Link a User to a Social IdP
            * Links an Okta user to an existing Social Identity Provider. This does not support the SAML2 Identity Provider Type
                * <p><b>200</b> - Success
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param idpId  (required)
                * @param userId  (required)
                * @param userIdentityProviderLinkRequest  (required)
            * @return ResponseEntity&lt;IdentityProviderApplicationUser&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<IdentityProviderApplicationUser> linkUserToIdentityProviderWithHttpInfo(String idpId, String userId, UserIdentityProviderLinkRequest userIdentityProviderLinkRequest) throws RestClientException {
            Object localVarPostBody = userIdentityProviderLinkRequest;
        
                // verify the required parameter 'idpId' is set ''
                if (idpId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'idpId' when calling linkUserToIdentityProvider");
                }
        
                // verify the required parameter 'userId' is set ''
                if (userId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'userId' when calling linkUserToIdentityProvider");
                }
        
                // verify the required parameter 'userIdentityProviderLinkRequest' is set ''
                if (userIdentityProviderLinkRequest == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'userIdentityProviderLinkRequest' when calling linkUserToIdentityProvider");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("idpId", idpId);
                    uriVariables.put("userId", userId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = { 
            "application/json"
         };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<IdentityProviderApplicationUser> localReturnType = new ParameterizedTypeReference<IdentityProviderApplicationUser>() {};
            return apiClient.invokeAPI("/api/v1/idps/{idpId}/users/{userId}", HttpMethod.POST, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }




            /**
            * Link a User to a Social IdP
            * Links an Okta user to an existing Social Identity Provider. This does not support the SAML2 Identity Provider Type
                * <p><b>200</b> - Success
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param idpId  (required)
                * @param userId  (required)
                * @param userIdentityProviderLinkRequest  (required)
            * @return ResponseEntity&lt;IdentityProviderApplicationUser&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private <T> ResponseEntity<T> linkUserToIdentityProviderWithReturnType(Class<?> T, String idpId,String userId,UserIdentityProviderLinkRequest userIdentityProviderLinkRequest) throws RestClientException {
            Object localVarPostBody = userIdentityProviderLinkRequest;
        
                // verify the required parameter 'idpId' is set
                if (idpId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'idpId' when calling linkUserToIdentityProvider");
                }
        
                // verify the required parameter 'userId' is set
                if (userId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'userId' when calling linkUserToIdentityProvider");
                }
        
                // verify the required parameter 'userIdentityProviderLinkRequest' is set
                if (userIdentityProviderLinkRequest == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'userIdentityProviderLinkRequest' when calling linkUserToIdentityProvider");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("idpId", idpId);
                    uriVariables.put("userId", userId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = { 
            "application/json"
         };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<T> localReturnType = new ParameterizedTypeReference<T>() {};
            return apiClient.invokeAPI("/api/v1/idps/{idpId}/users/{userId}", HttpMethod.POST, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }




            /**
            * Link a User to a Social IdP
            * Links an Okta user to an existing Social Identity Provider. This does not support the SAML2 Identity Provider Type
                * <p><b>200</b> - Success
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param idpId  (required)
                * @param userId  (required)
                * @param userIdentityProviderLinkRequest  (required)
            * @return ResponseEntity&lt;IdentityProviderApplicationUser&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public PagedList linkUserToIdentityProviderWithPaginationInfo(String idpId, String userId, UserIdentityProviderLinkRequest userIdentityProviderLinkRequest) throws RestClientException {
            Object localVarPostBody = userIdentityProviderLinkRequest;
        
                // verify the required parameter 'idpId' is set
                if (idpId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'idpId' when calling linkUserToIdentityProvider");
                }
        
                // verify the required parameter 'userId' is set
                if (userId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'userId' when calling linkUserToIdentityProvider");
                }
        
                // verify the required parameter 'userIdentityProviderLinkRequest' is set
                if (userIdentityProviderLinkRequest == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'userIdentityProviderLinkRequest' when calling linkUserToIdentityProvider");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("idpId", idpId);
                    uriVariables.put("userId", userId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = { 
            "application/json"
         };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<IdentityProviderApplicationUser> localReturnType = new ParameterizedTypeReference<IdentityProviderApplicationUser>() {};
            ResponseEntity<IdentityProviderApplicationUser> responseEntity = apiClient.invokeAPI("/api/v1/idps/{idpId}/users/{userId}", HttpMethod.POST, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                    HttpHeaders headers = responseEntity.getHeaders();
                    PagedList pagedList = new PagedList();
                    List<String> linkHeaders = headers.get("link");
                    String self = null, nextPage = null;
                    for (String link : linkHeaders) {
                    if (link.contains("next")) {
                    nextPage = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    if (link.contains("self")) {
                    self = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    }
                    pagedList.addItems(Arrays.asList(responseEntity.getBody()));
                    if (Objects.nonNull(nextPage)) {
                    pagedList.setNextPage(nextPage);
                    }
                    if (Objects.nonNull(self)) {
                    pagedList.setSelf(self);
                    }
                    return pagedList;
        }

        /**
        * List all Certificate Signing Requests
        * Lists all Certificate Signing Requests for an IdP
            * <p><b>200</b> - Success
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>429</b> - Too Many Requests
                * @param idpId  (required)
                * @return List&lt;Csr&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public List<Csr> listCsrsForIdentityProvider(String idpId) throws RestClientException {
                return listCsrsForIdentityProviderWithHttpInfo(idpId).getBody();
            }






            /**
            * List all Certificate Signing Requests
            * Lists all Certificate Signing Requests for an IdP
                * <p><b>200</b> - Success
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param idpId  (required)
            * @return ResponseEntity&lt;List&lt;Csr&gt;&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<List<Csr>> listCsrsForIdentityProviderWithHttpInfo(String idpId) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'idpId' is set ''
                if (idpId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'idpId' when calling listCsrsForIdentityProvider");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("idpId", idpId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<List<Csr>> localReturnType = new ParameterizedTypeReference<List<Csr>>() {};
            return apiClient.invokeAPI("/api/v1/idps/{idpId}/credentials/csrs", HttpMethod.GET, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }







            /**
            * List all Certificate Signing Requests
            * Lists all Certificate Signing Requests for an IdP
                * <p><b>200</b> - Success
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param idpId  (required)
            * @return ResponseEntity&lt;List&lt;Csr&gt;&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public PagedList listCsrsForIdentityProviderWithPaginationInfo(String idpId) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'idpId' is set
                if (idpId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'idpId' when calling listCsrsForIdentityProvider");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("idpId", idpId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<List<Csr>> localReturnType = new ParameterizedTypeReference<List<Csr>>() {};
            ResponseEntity<List<Csr>> responseEntity = apiClient.invokeAPI("/api/v1/idps/{idpId}/credentials/csrs", HttpMethod.GET, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                    HttpHeaders headers = responseEntity.getHeaders();
                    PagedList pagedList = new PagedList();
                    List<String> linkHeaders = headers.get("link");
                    String self = null, nextPage = null;
                    for (String link : linkHeaders) {
                    if (link.contains("next")) {
                    nextPage = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    if (link.contains("self")) {
                    self = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    }
                    pagedList.addItems(Arrays.asList(responseEntity.getBody()));
                    if (Objects.nonNull(nextPage)) {
                    pagedList.setNextPage(nextPage);
                    }
                    if (Objects.nonNull(self)) {
                    pagedList.setSelf(self);
                    }
                    return pagedList;
        }

        /**
        * List all Users
        * Find all the users linked to an identity provider
            * <p><b>200</b> - Success
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>429</b> - Too Many Requests
                * @param idpId  (required)
                * @return List&lt;IdentityProviderApplicationUser&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public List<IdentityProviderApplicationUser> listIdentityProviderApplicationUsers(String idpId) throws RestClientException {
                return listIdentityProviderApplicationUsersWithHttpInfo(idpId).getBody();
            }






            /**
            * List all Users
            * Find all the users linked to an identity provider
                * <p><b>200</b> - Success
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param idpId  (required)
            * @return ResponseEntity&lt;List&lt;IdentityProviderApplicationUser&gt;&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<List<IdentityProviderApplicationUser>> listIdentityProviderApplicationUsersWithHttpInfo(String idpId) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'idpId' is set ''
                if (idpId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'idpId' when calling listIdentityProviderApplicationUsers");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("idpId", idpId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<List<IdentityProviderApplicationUser>> localReturnType = new ParameterizedTypeReference<List<IdentityProviderApplicationUser>>() {};
            return apiClient.invokeAPI("/api/v1/idps/{idpId}/users", HttpMethod.GET, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }







            /**
            * List all Users
            * Find all the users linked to an identity provider
                * <p><b>200</b> - Success
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param idpId  (required)
            * @return ResponseEntity&lt;List&lt;IdentityProviderApplicationUser&gt;&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public PagedList listIdentityProviderApplicationUsersWithPaginationInfo(String idpId) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'idpId' is set
                if (idpId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'idpId' when calling listIdentityProviderApplicationUsers");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("idpId", idpId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<List<IdentityProviderApplicationUser>> localReturnType = new ParameterizedTypeReference<List<IdentityProviderApplicationUser>>() {};
            ResponseEntity<List<IdentityProviderApplicationUser>> responseEntity = apiClient.invokeAPI("/api/v1/idps/{idpId}/users", HttpMethod.GET, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                    HttpHeaders headers = responseEntity.getHeaders();
                    PagedList pagedList = new PagedList();
                    List<String> linkHeaders = headers.get("link");
                    String self = null, nextPage = null;
                    for (String link : linkHeaders) {
                    if (link.contains("next")) {
                    nextPage = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    if (link.contains("self")) {
                    self = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    }
                    pagedList.addItems(Arrays.asList(responseEntity.getBody()));
                    if (Objects.nonNull(nextPage)) {
                    pagedList.setNextPage(nextPage);
                    }
                    if (Objects.nonNull(self)) {
                    pagedList.setSelf(self);
                    }
                    return pagedList;
        }

        /**
        * List all Credential Keys
        * Lists all IdP key credentials
            * <p><b>200</b> - Success
            * <p><b>403</b> - Forbidden
            * <p><b>429</b> - Too Many Requests
                * @param after Specifies the pagination cursor for the next page of keys (optional)
                * @param limit Specifies the number of key results in a page (optional, default to 20)
                * @return List&lt;JsonWebKey&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public List<JsonWebKey> listIdentityProviderKeys(String after, Integer limit) throws RestClientException {
                return listIdentityProviderKeysWithHttpInfo(after, limit).getBody();
            }






            /**
            * List all Credential Keys
            * Lists all IdP key credentials
                * <p><b>200</b> - Success
                * <p><b>403</b> - Forbidden
                * <p><b>429</b> - Too Many Requests
                * @param after Specifies the pagination cursor for the next page of keys (optional)
                * @param limit Specifies the number of key results in a page (optional, default to 20)
            * @return ResponseEntity&lt;List&lt;JsonWebKey&gt;&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<List<JsonWebKey>> listIdentityProviderKeysWithHttpInfo(String after, Integer limit) throws RestClientException {
            Object localVarPostBody = null;
        

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "after", after));
            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "limit", limit));

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<List<JsonWebKey>> localReturnType = new ParameterizedTypeReference<List<JsonWebKey>>() {};
            return apiClient.invokeAPI("/api/v1/idps/credentials/keys", HttpMethod.GET, Collections.<String, Object>emptyMap(), localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }







            /**
            * List all Credential Keys
            * Lists all IdP key credentials
                * <p><b>200</b> - Success
                * <p><b>403</b> - Forbidden
                * <p><b>429</b> - Too Many Requests
                * @param after Specifies the pagination cursor for the next page of keys (optional)
                * @param limit Specifies the number of key results in a page (optional, default to 20)
            * @return ResponseEntity&lt;List&lt;JsonWebKey&gt;&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public PagedList listIdentityProviderKeysWithPaginationInfo(String after, Integer limit) throws RestClientException {
            Object localVarPostBody = null;
        

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "after", after));
            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "limit", limit));

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<List<JsonWebKey>> localReturnType = new ParameterizedTypeReference<List<JsonWebKey>>() {};
            ResponseEntity<List<JsonWebKey>> responseEntity = apiClient.invokeAPI("/api/v1/idps/credentials/keys", HttpMethod.GET, Collections.<String, Object>emptyMap(), localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                    HttpHeaders headers = responseEntity.getHeaders();
                    PagedList pagedList = new PagedList();
                    List<String> linkHeaders = headers.get("link");
                    String self = null, nextPage = null;
                    for (String link : linkHeaders) {
                    if (link.contains("next")) {
                    nextPage = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    if (link.contains("self")) {
                    self = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    }
                    pagedList.addItems(Arrays.asList(responseEntity.getBody()));
                    if (Objects.nonNull(nextPage)) {
                    pagedList.setNextPage(nextPage);
                    }
                    if (Objects.nonNull(self)) {
                    pagedList.setSelf(self);
                    }
                    return pagedList;
        }

        /**
        * List all Signing Credential Keys
        * Lists all signing key credentials for an IdP
            * <p><b>200</b> - Success
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>429</b> - Too Many Requests
                * @param idpId  (required)
                * @return List&lt;JsonWebKey&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public List<JsonWebKey> listIdentityProviderSigningKeys(String idpId) throws RestClientException {
                return listIdentityProviderSigningKeysWithHttpInfo(idpId).getBody();
            }






            /**
            * List all Signing Credential Keys
            * Lists all signing key credentials for an IdP
                * <p><b>200</b> - Success
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param idpId  (required)
            * @return ResponseEntity&lt;List&lt;JsonWebKey&gt;&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<List<JsonWebKey>> listIdentityProviderSigningKeysWithHttpInfo(String idpId) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'idpId' is set ''
                if (idpId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'idpId' when calling listIdentityProviderSigningKeys");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("idpId", idpId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<List<JsonWebKey>> localReturnType = new ParameterizedTypeReference<List<JsonWebKey>>() {};
            return apiClient.invokeAPI("/api/v1/idps/{idpId}/credentials/keys", HttpMethod.GET, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }







            /**
            * List all Signing Credential Keys
            * Lists all signing key credentials for an IdP
                * <p><b>200</b> - Success
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param idpId  (required)
            * @return ResponseEntity&lt;List&lt;JsonWebKey&gt;&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public PagedList listIdentityProviderSigningKeysWithPaginationInfo(String idpId) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'idpId' is set
                if (idpId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'idpId' when calling listIdentityProviderSigningKeys");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("idpId", idpId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<List<JsonWebKey>> localReturnType = new ParameterizedTypeReference<List<JsonWebKey>>() {};
            ResponseEntity<List<JsonWebKey>> responseEntity = apiClient.invokeAPI("/api/v1/idps/{idpId}/credentials/keys", HttpMethod.GET, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                    HttpHeaders headers = responseEntity.getHeaders();
                    PagedList pagedList = new PagedList();
                    List<String> linkHeaders = headers.get("link");
                    String self = null, nextPage = null;
                    for (String link : linkHeaders) {
                    if (link.contains("next")) {
                    nextPage = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    if (link.contains("self")) {
                    self = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    }
                    pagedList.addItems(Arrays.asList(responseEntity.getBody()));
                    if (Objects.nonNull(nextPage)) {
                    pagedList.setNextPage(nextPage);
                    }
                    if (Objects.nonNull(self)) {
                    pagedList.setSelf(self);
                    }
                    return pagedList;
        }

        /**
        * List all Identity Providers
        * Lists all identity provider integrations with pagination. A subset of IdPs can be returned that match a supported filter expression or query.
            * <p><b>200</b> - Success
            * <p><b>403</b> - Forbidden
            * <p><b>429</b> - Too Many Requests
                * @param q Searches the name property of IdPs for matching value (optional)
                * @param after Specifies the pagination cursor for the next page of IdPs (optional)
                * @param limit Specifies the number of IdP results in a page (optional, default to 20)
                * @param type Filters IdPs by type (optional)
                * @return List&lt;IdentityProvider&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public List<IdentityProvider> listIdentityProviders(String q, String after, Integer limit, String type) throws RestClientException {
                return listIdentityProvidersWithHttpInfo(q, after, limit, type).getBody();
            }






            /**
            * List all Identity Providers
            * Lists all identity provider integrations with pagination. A subset of IdPs can be returned that match a supported filter expression or query.
                * <p><b>200</b> - Success
                * <p><b>403</b> - Forbidden
                * <p><b>429</b> - Too Many Requests
                * @param q Searches the name property of IdPs for matching value (optional)
                * @param after Specifies the pagination cursor for the next page of IdPs (optional)
                * @param limit Specifies the number of IdP results in a page (optional, default to 20)
                * @param type Filters IdPs by type (optional)
            * @return ResponseEntity&lt;List&lt;IdentityProvider&gt;&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<List<IdentityProvider>> listIdentityProvidersWithHttpInfo(String q, String after, Integer limit, String type) throws RestClientException {
            Object localVarPostBody = null;
        

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "q", q));
            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "after", after));
            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "limit", limit));
            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "type", type));

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<List<IdentityProvider>> localReturnType = new ParameterizedTypeReference<List<IdentityProvider>>() {};
            return apiClient.invokeAPI("/api/v1/idps", HttpMethod.GET, Collections.<String, Object>emptyMap(), localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }







            /**
            * List all Identity Providers
            * Lists all identity provider integrations with pagination. A subset of IdPs can be returned that match a supported filter expression or query.
                * <p><b>200</b> - Success
                * <p><b>403</b> - Forbidden
                * <p><b>429</b> - Too Many Requests
                * @param q Searches the name property of IdPs for matching value (optional)
                * @param after Specifies the pagination cursor for the next page of IdPs (optional)
                * @param limit Specifies the number of IdP results in a page (optional, default to 20)
                * @param type Filters IdPs by type (optional)
            * @return ResponseEntity&lt;List&lt;IdentityProvider&gt;&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public PagedList listIdentityProvidersWithPaginationInfo(String q, String after, Integer limit, String type) throws RestClientException {
            Object localVarPostBody = null;
        

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "q", q));
            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "after", after));
            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "limit", limit));
            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "type", type));

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<List<IdentityProvider>> localReturnType = new ParameterizedTypeReference<List<IdentityProvider>>() {};
            ResponseEntity<List<IdentityProvider>> responseEntity = apiClient.invokeAPI("/api/v1/idps", HttpMethod.GET, Collections.<String, Object>emptyMap(), localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                    HttpHeaders headers = responseEntity.getHeaders();
                    PagedList pagedList = new PagedList();
                    List<String> linkHeaders = headers.get("link");
                    String self = null, nextPage = null;
                    for (String link : linkHeaders) {
                    if (link.contains("next")) {
                    nextPage = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    if (link.contains("self")) {
                    self = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    }
                    pagedList.addItems(Arrays.asList(responseEntity.getBody()));
                    if (Objects.nonNull(nextPage)) {
                    pagedList.setNextPage(nextPage);
                    }
                    if (Objects.nonNull(self)) {
                    pagedList.setSelf(self);
                    }
                    return pagedList;
        }

        /**
        * List all Tokens from a OIDC Identity Provider
        * Lists the tokens minted by the Social Authentication Provider when the user authenticates with Okta via Social Auth
            * <p><b>200</b> - Success
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>429</b> - Too Many Requests
                * @param idpId  (required)
                * @param userId  (required)
                * @return List&lt;SocialAuthToken&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public List<SocialAuthToken> listSocialAuthTokens(String idpId, String userId) throws RestClientException {
                return listSocialAuthTokensWithHttpInfo(idpId, userId).getBody();
            }






            /**
            * List all Tokens from a OIDC Identity Provider
            * Lists the tokens minted by the Social Authentication Provider when the user authenticates with Okta via Social Auth
                * <p><b>200</b> - Success
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param idpId  (required)
                * @param userId  (required)
            * @return ResponseEntity&lt;List&lt;SocialAuthToken&gt;&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<List<SocialAuthToken>> listSocialAuthTokensWithHttpInfo(String idpId, String userId) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'idpId' is set ''
                if (idpId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'idpId' when calling listSocialAuthTokens");
                }
        
                // verify the required parameter 'userId' is set ''
                if (userId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'userId' when calling listSocialAuthTokens");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("idpId", idpId);
                    uriVariables.put("userId", userId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<List<SocialAuthToken>> localReturnType = new ParameterizedTypeReference<List<SocialAuthToken>>() {};
            return apiClient.invokeAPI("/api/v1/idps/{idpId}/users/{userId}/credentials/tokens", HttpMethod.GET, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }







            /**
            * List all Tokens from a OIDC Identity Provider
            * Lists the tokens minted by the Social Authentication Provider when the user authenticates with Okta via Social Auth
                * <p><b>200</b> - Success
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param idpId  (required)
                * @param userId  (required)
            * @return ResponseEntity&lt;List&lt;SocialAuthToken&gt;&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public PagedList listSocialAuthTokensWithPaginationInfo(String idpId, String userId) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'idpId' is set
                if (idpId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'idpId' when calling listSocialAuthTokens");
                }
        
                // verify the required parameter 'userId' is set
                if (userId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'userId' when calling listSocialAuthTokens");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("idpId", idpId);
                    uriVariables.put("userId", userId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<List<SocialAuthToken>> localReturnType = new ParameterizedTypeReference<List<SocialAuthToken>>() {};
            ResponseEntity<List<SocialAuthToken>> responseEntity = apiClient.invokeAPI("/api/v1/idps/{idpId}/users/{userId}/credentials/tokens", HttpMethod.GET, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                    HttpHeaders headers = responseEntity.getHeaders();
                    PagedList pagedList = new PagedList();
                    List<String> linkHeaders = headers.get("link");
                    String self = null, nextPage = null;
                    for (String link : linkHeaders) {
                    if (link.contains("next")) {
                    nextPage = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    if (link.contains("self")) {
                    self = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    }
                    pagedList.addItems(Arrays.asList(responseEntity.getBody()));
                    if (Objects.nonNull(nextPage)) {
                    pagedList.setNextPage(nextPage);
                    }
                    if (Objects.nonNull(self)) {
                    pagedList.setSelf(self);
                    }
                    return pagedList;
        }

        /**
        * Publish a Certificate Signing Request
        * Update the Certificate Signing Request with a signed X.509 certificate and add it into the signing key credentials for the IdP.
            * <p><b>201</b> - Created
            * <p><b>400</b> - Bad Request
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>429</b> - Too Many Requests
                * @param idpId  (required)
                * @param csrId  (required)
                * @param body  (required)
                * @return JsonWebKey
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public JsonWebKey publishCsrForIdentityProvider(String idpId, String csrId, File body) throws RestClientException {
                return publishCsrForIdentityProviderWithHttpInfo(idpId, csrId, body).getBody();
            }




            /**
            * Publish a Certificate Signing Request
            * Update the Certificate Signing Request with a signed X.509 certificate and add it into the signing key credentials for the IdP.
                * <p><b>201</b> - Created
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param T (required) - the assignable return type
                * @param idpId  (required)
                * @param csrId  (required)
                * @param body  (required)
                * @return T instance
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public <T> T publishCsrForIdentityProvider(Class<?> T, String idpId, String csrId, File body) throws RestClientException {
                return (T) getObjectMapper().convertValue(publishCsrForIdentityProviderWithReturnType(T, idpId, csrId, body).getBody(), T);
            }




            /**
            * Publish a Certificate Signing Request
            * Update the Certificate Signing Request with a signed X.509 certificate and add it into the signing key credentials for the IdP.
                * <p><b>201</b> - Created
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param idpId  (required)
                * @param csrId  (required)
                * @param body  (required)
            * @return ResponseEntity&lt;JsonWebKey&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<JsonWebKey> publishCsrForIdentityProviderWithHttpInfo(String idpId, String csrId, File body) throws RestClientException {
            Object localVarPostBody = body;
        
                // verify the required parameter 'idpId' is set ''
                if (idpId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'idpId' when calling publishCsrForIdentityProvider");
                }
        
                // verify the required parameter 'csrId' is set ''
                if (csrId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'csrId' when calling publishCsrForIdentityProvider");
                }
        
                // verify the required parameter 'body' is set ''
                if (body == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'body' when calling publishCsrForIdentityProvider");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("idpId", idpId);
                    uriVariables.put("csrId", csrId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = { 
            "application/x-x509-ca-cert", "application/pkix-cert", "application/x-pem-file"
         };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<JsonWebKey> localReturnType = new ParameterizedTypeReference<JsonWebKey>() {};
            return apiClient.invokeAPI("/api/v1/idps/{idpId}/credentials/csrs/{csrId}/lifecycle/publish", HttpMethod.POST, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }




            /**
            * Publish a Certificate Signing Request
            * Update the Certificate Signing Request with a signed X.509 certificate and add it into the signing key credentials for the IdP.
                * <p><b>201</b> - Created
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param idpId  (required)
                * @param csrId  (required)
                * @param body  (required)
            * @return ResponseEntity&lt;JsonWebKey&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private <T> ResponseEntity<T> publishCsrForIdentityProviderWithReturnType(Class<?> T, String idpId,String csrId,File body) throws RestClientException {
            Object localVarPostBody = body;
        
                // verify the required parameter 'idpId' is set
                if (idpId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'idpId' when calling publishCsrForIdentityProvider");
                }
        
                // verify the required parameter 'csrId' is set
                if (csrId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'csrId' when calling publishCsrForIdentityProvider");
                }
        
                // verify the required parameter 'body' is set
                if (body == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'body' when calling publishCsrForIdentityProvider");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("idpId", idpId);
                    uriVariables.put("csrId", csrId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = { 
            "application/x-x509-ca-cert", "application/pkix-cert", "application/x-pem-file"
         };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<T> localReturnType = new ParameterizedTypeReference<T>() {};
            return apiClient.invokeAPI("/api/v1/idps/{idpId}/credentials/csrs/{csrId}/lifecycle/publish", HttpMethod.POST, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }




            /**
            * Publish a Certificate Signing Request
            * Update the Certificate Signing Request with a signed X.509 certificate and add it into the signing key credentials for the IdP.
                * <p><b>201</b> - Created
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param idpId  (required)
                * @param csrId  (required)
                * @param body  (required)
            * @return ResponseEntity&lt;JsonWebKey&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public PagedList publishCsrForIdentityProviderWithPaginationInfo(String idpId, String csrId, File body) throws RestClientException {
            Object localVarPostBody = body;
        
                // verify the required parameter 'idpId' is set
                if (idpId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'idpId' when calling publishCsrForIdentityProvider");
                }
        
                // verify the required parameter 'csrId' is set
                if (csrId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'csrId' when calling publishCsrForIdentityProvider");
                }
        
                // verify the required parameter 'body' is set
                if (body == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'body' when calling publishCsrForIdentityProvider");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("idpId", idpId);
                    uriVariables.put("csrId", csrId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = { 
            "application/x-x509-ca-cert", "application/pkix-cert", "application/x-pem-file"
         };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<JsonWebKey> localReturnType = new ParameterizedTypeReference<JsonWebKey>() {};
            ResponseEntity<JsonWebKey> responseEntity = apiClient.invokeAPI("/api/v1/idps/{idpId}/credentials/csrs/{csrId}/lifecycle/publish", HttpMethod.POST, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                    HttpHeaders headers = responseEntity.getHeaders();
                    PagedList pagedList = new PagedList();
                    List<String> linkHeaders = headers.get("link");
                    String self = null, nextPage = null;
                    for (String link : linkHeaders) {
                    if (link.contains("next")) {
                    nextPage = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    if (link.contains("self")) {
                    self = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    }
                    pagedList.addItems(Arrays.asList(responseEntity.getBody()));
                    if (Objects.nonNull(nextPage)) {
                    pagedList.setNextPage(nextPage);
                    }
                    if (Objects.nonNull(self)) {
                    pagedList.setSelf(self);
                    }
                    return pagedList;
        }

        /**
        * Replace an Identity Provider
        * Replaces an identity provider integration by &#x60;idpId&#x60;
            * <p><b>200</b> - Success
            * <p><b>400</b> - Bad Request
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>429</b> - Too Many Requests
                * @param idpId  (required)
                * @param identityProvider  (required)
                * @return IdentityProvider
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public IdentityProvider replaceIdentityProvider(String idpId, IdentityProvider identityProvider) throws RestClientException {
                return replaceIdentityProviderWithHttpInfo(idpId, identityProvider).getBody();
            }




            /**
            * Replace an Identity Provider
            * Replaces an identity provider integration by &#x60;idpId&#x60;
                * <p><b>200</b> - Success
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param T (required) - the assignable return type
                * @param idpId  (required)
                * @param identityProvider  (required)
                * @return T instance
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public <T> T replaceIdentityProvider(Class<?> T, String idpId, IdentityProvider identityProvider) throws RestClientException {
                return (T) getObjectMapper().convertValue(replaceIdentityProviderWithReturnType(T, idpId, identityProvider).getBody(), T);
            }




            /**
            * Replace an Identity Provider
            * Replaces an identity provider integration by &#x60;idpId&#x60;
                * <p><b>200</b> - Success
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param idpId  (required)
                * @param identityProvider  (required)
            * @return ResponseEntity&lt;IdentityProvider&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<IdentityProvider> replaceIdentityProviderWithHttpInfo(String idpId, IdentityProvider identityProvider) throws RestClientException {
            Object localVarPostBody = identityProvider;
        
                // verify the required parameter 'idpId' is set ''
                if (idpId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'idpId' when calling replaceIdentityProvider");
                }
        
                // verify the required parameter 'identityProvider' is set ''
                if (identityProvider == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'identityProvider' when calling replaceIdentityProvider");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("idpId", idpId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = { 
            "application/json"
         };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<IdentityProvider> localReturnType = new ParameterizedTypeReference<IdentityProvider>() {};
            return apiClient.invokeAPI("/api/v1/idps/{idpId}", HttpMethod.PUT, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }




            /**
            * Replace an Identity Provider
            * Replaces an identity provider integration by &#x60;idpId&#x60;
                * <p><b>200</b> - Success
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param idpId  (required)
                * @param identityProvider  (required)
            * @return ResponseEntity&lt;IdentityProvider&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private <T> ResponseEntity<T> replaceIdentityProviderWithReturnType(Class<?> T, String idpId,IdentityProvider identityProvider) throws RestClientException {
            Object localVarPostBody = identityProvider;
        
                // verify the required parameter 'idpId' is set
                if (idpId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'idpId' when calling replaceIdentityProvider");
                }
        
                // verify the required parameter 'identityProvider' is set
                if (identityProvider == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'identityProvider' when calling replaceIdentityProvider");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("idpId", idpId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = { 
            "application/json"
         };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<T> localReturnType = new ParameterizedTypeReference<T>() {};
            return apiClient.invokeAPI("/api/v1/idps/{idpId}", HttpMethod.PUT, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }




            /**
            * Replace an Identity Provider
            * Replaces an identity provider integration by &#x60;idpId&#x60;
                * <p><b>200</b> - Success
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param idpId  (required)
                * @param identityProvider  (required)
            * @return ResponseEntity&lt;IdentityProvider&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public PagedList replaceIdentityProviderWithPaginationInfo(String idpId, IdentityProvider identityProvider) throws RestClientException {
            Object localVarPostBody = identityProvider;
        
                // verify the required parameter 'idpId' is set
                if (idpId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'idpId' when calling replaceIdentityProvider");
                }
        
                // verify the required parameter 'identityProvider' is set
                if (identityProvider == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'identityProvider' when calling replaceIdentityProvider");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("idpId", idpId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = { 
            "application/json"
         };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<IdentityProvider> localReturnType = new ParameterizedTypeReference<IdentityProvider>() {};
            ResponseEntity<IdentityProvider> responseEntity = apiClient.invokeAPI("/api/v1/idps/{idpId}", HttpMethod.PUT, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                    HttpHeaders headers = responseEntity.getHeaders();
                    PagedList pagedList = new PagedList();
                    List<String> linkHeaders = headers.get("link");
                    String self = null, nextPage = null;
                    for (String link : linkHeaders) {
                    if (link.contains("next")) {
                    nextPage = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    if (link.contains("self")) {
                    self = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    }
                    pagedList.addItems(Arrays.asList(responseEntity.getBody()));
                    if (Objects.nonNull(nextPage)) {
                    pagedList.setNextPage(nextPage);
                    }
                    if (Objects.nonNull(self)) {
                    pagedList.setSelf(self);
                    }
                    return pagedList;
        }

        /**
        * Revoke a Certificate Signing Request
        * Revoke a Certificate Signing Request and delete the key pair from the IdP
            * <p><b>204</b> - No Content
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>429</b> - Too Many Requests
                * @param idpId  (required)
                * @param csrId  (required)
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public void revokeCsrForIdentityProvider(String idpId, String csrId) throws RestClientException {
            revokeCsrForIdentityProviderWithHttpInfo(idpId, csrId);
            }






            /**
            * Revoke a Certificate Signing Request
            * Revoke a Certificate Signing Request and delete the key pair from the IdP
                * <p><b>204</b> - No Content
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param idpId  (required)
                * @param csrId  (required)
            * @return ResponseEntity&lt;Void&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<Void> revokeCsrForIdentityProviderWithHttpInfo(String idpId, String csrId) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'idpId' is set ''
                if (idpId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'idpId' when calling revokeCsrForIdentityProvider");
                }
        
                // verify the required parameter 'csrId' is set ''
                if (csrId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'csrId' when calling revokeCsrForIdentityProvider");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("idpId", idpId);
                    uriVariables.put("csrId", csrId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<Void> localReturnType = new ParameterizedTypeReference<Void>() {};
            return apiClient.invokeAPI("/api/v1/idps/{idpId}/credentials/csrs/{csrId}", HttpMethod.DELETE, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }







        /**
        * Unlink a User from IdP
        * Unlinks the link between the Okta user and the IdP user
            * <p><b>204</b> - No Content
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>429</b> - Too Many Requests
                * @param idpId  (required)
                * @param userId  (required)
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public void unlinkUserFromIdentityProvider(String idpId, String userId) throws RestClientException {
            unlinkUserFromIdentityProviderWithHttpInfo(idpId, userId);
            }






            /**
            * Unlink a User from IdP
            * Unlinks the link between the Okta user and the IdP user
                * <p><b>204</b> - No Content
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param idpId  (required)
                * @param userId  (required)
            * @return ResponseEntity&lt;Void&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<Void> unlinkUserFromIdentityProviderWithHttpInfo(String idpId, String userId) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'idpId' is set ''
                if (idpId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'idpId' when calling unlinkUserFromIdentityProvider");
                }
        
                // verify the required parameter 'userId' is set ''
                if (userId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'userId' when calling unlinkUserFromIdentityProvider");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("idpId", idpId);
                    uriVariables.put("userId", userId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<Void> localReturnType = new ParameterizedTypeReference<Void>() {};
            return apiClient.invokeAPI("/api/v1/idps/{idpId}/users/{userId}", HttpMethod.DELETE, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }








    private ObjectMapper getObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule(new JavaTimeModule());
        objectMapper.registerModule(new JsonNullableModule());
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        return objectMapper;
    }
        }
