package org.openapitools.client.api;

import org.openapitools.client.ApiClient;

import org.openapitools.client.model.AuthorizationServer;
import org.openapitools.client.model.AuthorizationServerPolicy;
import org.openapitools.client.model.AuthorizationServerPolicyRule;
import org.openapitools.client.model.Error;
import org.openapitools.client.model.JsonWebKey;
import org.openapitools.client.model.JwkUse;
import org.openapitools.client.model.OAuth2Claim;
import org.openapitools.client.model.OAuth2Client;
import org.openapitools.client.model.OAuth2RefreshToken;
import org.openapitools.client.model.OAuth2Scope;

import java.util.Collections;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.LinkedHashMap;
import java.util.stream.Collectors;

import com.okta.sdk.resource.common.PagedList;

import com.okta.commons.lang.Assert;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;

import org.openapitools.jackson.nullable.JsonNullableModule;

@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-10-28T09:44:59.080-05:00[America/Chicago]")
@Component("org.openapitools.client.api.AuthorizationServerApi")
    public class AuthorizationServerApi {
    private ApiClient apiClient;

    public AuthorizationServerApi() {
    this(new ApiClient());
    }

    @Autowired
    public AuthorizationServerApi(ApiClient apiClient) {
    this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
    return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
    this.apiClient = apiClient;
    }

        /**
        * Activate an Authorization Server
        * Activates an authorization server
            * <p><b>204</b> - No Content
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>429</b> - Too Many Requests
                * @param authServerId  (required)
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public void activateAuthorizationServer(String authServerId) throws RestClientException {
            activateAuthorizationServerWithHttpInfo(authServerId);
            }






            /**
            * Activate an Authorization Server
            * Activates an authorization server
                * <p><b>204</b> - No Content
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param authServerId  (required)
            * @return ResponseEntity&lt;Void&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<Void> activateAuthorizationServerWithHttpInfo(String authServerId) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'authServerId' is set ''
                if (authServerId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'authServerId' when calling activateAuthorizationServer");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("authServerId", authServerId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<Void> localReturnType = new ParameterizedTypeReference<Void>() {};
            return apiClient.invokeAPI("/api/v1/authorizationServers/{authServerId}/lifecycle/activate", HttpMethod.POST, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }







        /**
        * Activate a Policy
        * Activates an authorization server policy
            * <p><b>204</b> - No Content
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>429</b> - Too Many Requests
                * @param authServerId  (required)
                * @param policyId  (required)
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public void activateAuthorizationServerPolicy(String authServerId, String policyId) throws RestClientException {
            activateAuthorizationServerPolicyWithHttpInfo(authServerId, policyId);
            }






            /**
            * Activate a Policy
            * Activates an authorization server policy
                * <p><b>204</b> - No Content
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param authServerId  (required)
                * @param policyId  (required)
            * @return ResponseEntity&lt;Void&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<Void> activateAuthorizationServerPolicyWithHttpInfo(String authServerId, String policyId) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'authServerId' is set ''
                if (authServerId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'authServerId' when calling activateAuthorizationServerPolicy");
                }
        
                // verify the required parameter 'policyId' is set ''
                if (policyId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'policyId' when calling activateAuthorizationServerPolicy");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("authServerId", authServerId);
                    uriVariables.put("policyId", policyId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<Void> localReturnType = new ParameterizedTypeReference<Void>() {};
            return apiClient.invokeAPI("/api/v1/authorizationServers/{authServerId}/policies/{policyId}/lifecycle/activate", HttpMethod.POST, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }







        /**
        * Activate a Policy Rule
        * Activates an authorization server policy rule
            * <p><b>204</b> - No Content
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>429</b> - Too Many Requests
                * @param authServerId  (required)
                * @param policyId  (required)
                * @param ruleId  (required)
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public void activateAuthorizationServerPolicyRule(String authServerId, String policyId, String ruleId) throws RestClientException {
            activateAuthorizationServerPolicyRuleWithHttpInfo(authServerId, policyId, ruleId);
            }






            /**
            * Activate a Policy Rule
            * Activates an authorization server policy rule
                * <p><b>204</b> - No Content
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param authServerId  (required)
                * @param policyId  (required)
                * @param ruleId  (required)
            * @return ResponseEntity&lt;Void&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<Void> activateAuthorizationServerPolicyRuleWithHttpInfo(String authServerId, String policyId, String ruleId) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'authServerId' is set ''
                if (authServerId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'authServerId' when calling activateAuthorizationServerPolicyRule");
                }
        
                // verify the required parameter 'policyId' is set ''
                if (policyId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'policyId' when calling activateAuthorizationServerPolicyRule");
                }
        
                // verify the required parameter 'ruleId' is set ''
                if (ruleId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'ruleId' when calling activateAuthorizationServerPolicyRule");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("authServerId", authServerId);
                    uriVariables.put("policyId", policyId);
                    uriVariables.put("ruleId", ruleId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<Void> localReturnType = new ParameterizedTypeReference<Void>() {};
            return apiClient.invokeAPI("/api/v1/authorizationServers/{authServerId}/policies/{policyId}/rules/{ruleId}/lifecycle/activate", HttpMethod.POST, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }







        /**
        * Create an Authorization Server
        * Creates an authorization server
            * <p><b>201</b> - Created
            * <p><b>400</b> - Bad Request
            * <p><b>403</b> - Forbidden
            * <p><b>429</b> - Too Many Requests
                * @param authorizationServer  (required)
                * @return AuthorizationServer
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public AuthorizationServer createAuthorizationServer(AuthorizationServer authorizationServer) throws RestClientException {
                return createAuthorizationServerWithHttpInfo(authorizationServer).getBody();
            }




            /**
            * Create an Authorization Server
            * Creates an authorization server
                * <p><b>201</b> - Created
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>429</b> - Too Many Requests
                * @param T (required) - the assignable return type
                * @param authorizationServer  (required)
                * @return T instance
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public <T> T createAuthorizationServer(Class<?> T, AuthorizationServer authorizationServer) throws RestClientException {
                return (T) getObjectMapper().convertValue(createAuthorizationServerWithReturnType(T, authorizationServer).getBody(), T);
            }




            /**
            * Create an Authorization Server
            * Creates an authorization server
                * <p><b>201</b> - Created
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>429</b> - Too Many Requests
                * @param authorizationServer  (required)
            * @return ResponseEntity&lt;AuthorizationServer&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<AuthorizationServer> createAuthorizationServerWithHttpInfo(AuthorizationServer authorizationServer) throws RestClientException {
            Object localVarPostBody = authorizationServer;
        
                // verify the required parameter 'authorizationServer' is set ''
                if (authorizationServer == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'authorizationServer' when calling createAuthorizationServer");
                }
        

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = { 
            "application/json"
         };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<AuthorizationServer> localReturnType = new ParameterizedTypeReference<AuthorizationServer>() {};
            return apiClient.invokeAPI("/api/v1/authorizationServers", HttpMethod.POST, Collections.<String, Object>emptyMap(), localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }




            /**
            * Create an Authorization Server
            * Creates an authorization server
                * <p><b>201</b> - Created
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>429</b> - Too Many Requests
                * @param authorizationServer  (required)
            * @return ResponseEntity&lt;AuthorizationServer&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private <T> ResponseEntity<T> createAuthorizationServerWithReturnType(Class<?> T, AuthorizationServer authorizationServer) throws RestClientException {
            Object localVarPostBody = authorizationServer;
        
                // verify the required parameter 'authorizationServer' is set
                if (authorizationServer == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'authorizationServer' when calling createAuthorizationServer");
                }
        

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = { 
            "application/json"
         };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<T> localReturnType = new ParameterizedTypeReference<T>() {};
            return apiClient.invokeAPI("/api/v1/authorizationServers", HttpMethod.POST, Collections.<String, Object>emptyMap(), localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }




            /**
            * Create an Authorization Server
            * Creates an authorization server
                * <p><b>201</b> - Created
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>429</b> - Too Many Requests
                * @param authorizationServer  (required)
            * @return ResponseEntity&lt;AuthorizationServer&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public PagedList createAuthorizationServerWithPaginationInfo(AuthorizationServer authorizationServer) throws RestClientException {
            Object localVarPostBody = authorizationServer;
        
                // verify the required parameter 'authorizationServer' is set
                if (authorizationServer == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'authorizationServer' when calling createAuthorizationServer");
                }
        

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = { 
            "application/json"
         };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<AuthorizationServer> localReturnType = new ParameterizedTypeReference<AuthorizationServer>() {};
            ResponseEntity<AuthorizationServer> responseEntity = apiClient.invokeAPI("/api/v1/authorizationServers", HttpMethod.POST, Collections.<String, Object>emptyMap(), localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                    HttpHeaders headers = responseEntity.getHeaders();
                    PagedList pagedList = new PagedList();
                    List<String> linkHeaders = headers.get("link");
                    String self = null, nextPage = null;
                    for (String link : linkHeaders) {
                    if (link.contains("next")) {
                    nextPage = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    if (link.contains("self")) {
                    self = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    }
                    pagedList.addItems(Arrays.asList(responseEntity.getBody()));
                    if (Objects.nonNull(nextPage)) {
                    pagedList.setNextPage(nextPage);
                    }
                    if (Objects.nonNull(self)) {
                    pagedList.setSelf(self);
                    }
                    return pagedList;
        }

        /**
        * Create a Policy
        * Creates a policy
            * <p><b>201</b> - Created
            * <p><b>400</b> - Bad Request
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>429</b> - Too Many Requests
                * @param authServerId  (required)
                * @param policy  (required)
                * @return AuthorizationServerPolicy
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public AuthorizationServerPolicy createAuthorizationServerPolicy(String authServerId, AuthorizationServerPolicy policy) throws RestClientException {
                return createAuthorizationServerPolicyWithHttpInfo(authServerId, policy).getBody();
            }




            /**
            * Create a Policy
            * Creates a policy
                * <p><b>201</b> - Created
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param T (required) - the assignable return type
                * @param authServerId  (required)
                * @param policy  (required)
                * @return T instance
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public <T> T createAuthorizationServerPolicy(Class<?> T, String authServerId, AuthorizationServerPolicy policy) throws RestClientException {
                return (T) getObjectMapper().convertValue(createAuthorizationServerPolicyWithReturnType(T, authServerId, policy).getBody(), T);
            }




            /**
            * Create a Policy
            * Creates a policy
                * <p><b>201</b> - Created
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param authServerId  (required)
                * @param policy  (required)
            * @return ResponseEntity&lt;AuthorizationServerPolicy&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<AuthorizationServerPolicy> createAuthorizationServerPolicyWithHttpInfo(String authServerId, AuthorizationServerPolicy policy) throws RestClientException {
            Object localVarPostBody = policy;
        
                // verify the required parameter 'authServerId' is set ''
                if (authServerId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'authServerId' when calling createAuthorizationServerPolicy");
                }
        
                // verify the required parameter 'policy' is set ''
                if (policy == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'policy' when calling createAuthorizationServerPolicy");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("authServerId", authServerId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = { 
            "application/json"
         };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<AuthorizationServerPolicy> localReturnType = new ParameterizedTypeReference<AuthorizationServerPolicy>() {};
            return apiClient.invokeAPI("/api/v1/authorizationServers/{authServerId}/policies", HttpMethod.POST, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }




            /**
            * Create a Policy
            * Creates a policy
                * <p><b>201</b> - Created
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param authServerId  (required)
                * @param policy  (required)
            * @return ResponseEntity&lt;AuthorizationServerPolicy&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private <T> ResponseEntity<T> createAuthorizationServerPolicyWithReturnType(Class<?> T, String authServerId,AuthorizationServerPolicy policy) throws RestClientException {
            Object localVarPostBody = policy;
        
                // verify the required parameter 'authServerId' is set
                if (authServerId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'authServerId' when calling createAuthorizationServerPolicy");
                }
        
                // verify the required parameter 'policy' is set
                if (policy == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'policy' when calling createAuthorizationServerPolicy");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("authServerId", authServerId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = { 
            "application/json"
         };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<T> localReturnType = new ParameterizedTypeReference<T>() {};
            return apiClient.invokeAPI("/api/v1/authorizationServers/{authServerId}/policies", HttpMethod.POST, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }




            /**
            * Create a Policy
            * Creates a policy
                * <p><b>201</b> - Created
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param authServerId  (required)
                * @param policy  (required)
            * @return ResponseEntity&lt;AuthorizationServerPolicy&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public PagedList createAuthorizationServerPolicyWithPaginationInfo(String authServerId, AuthorizationServerPolicy policy) throws RestClientException {
            Object localVarPostBody = policy;
        
                // verify the required parameter 'authServerId' is set
                if (authServerId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'authServerId' when calling createAuthorizationServerPolicy");
                }
        
                // verify the required parameter 'policy' is set
                if (policy == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'policy' when calling createAuthorizationServerPolicy");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("authServerId", authServerId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = { 
            "application/json"
         };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<AuthorizationServerPolicy> localReturnType = new ParameterizedTypeReference<AuthorizationServerPolicy>() {};
            ResponseEntity<AuthorizationServerPolicy> responseEntity = apiClient.invokeAPI("/api/v1/authorizationServers/{authServerId}/policies", HttpMethod.POST, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                    HttpHeaders headers = responseEntity.getHeaders();
                    PagedList pagedList = new PagedList();
                    List<String> linkHeaders = headers.get("link");
                    String self = null, nextPage = null;
                    for (String link : linkHeaders) {
                    if (link.contains("next")) {
                    nextPage = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    if (link.contains("self")) {
                    self = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    }
                    pagedList.addItems(Arrays.asList(responseEntity.getBody()));
                    if (Objects.nonNull(nextPage)) {
                    pagedList.setNextPage(nextPage);
                    }
                    if (Objects.nonNull(self)) {
                    pagedList.setSelf(self);
                    }
                    return pagedList;
        }

        /**
        * Create a Policy Rule
        * Creates a policy rule for the specified Custom Authorization Server and Policy
            * <p><b>201</b> - Created
            * <p><b>400</b> - Bad Request
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>429</b> - Too Many Requests
                * @param policyId  (required)
                * @param authServerId  (required)
                * @param policyRule  (required)
                * @return AuthorizationServerPolicyRule
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public AuthorizationServerPolicyRule createAuthorizationServerPolicyRule(String policyId, String authServerId, AuthorizationServerPolicyRule policyRule) throws RestClientException {
                return createAuthorizationServerPolicyRuleWithHttpInfo(policyId, authServerId, policyRule).getBody();
            }




            /**
            * Create a Policy Rule
            * Creates a policy rule for the specified Custom Authorization Server and Policy
                * <p><b>201</b> - Created
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param T (required) - the assignable return type
                * @param policyId  (required)
                * @param authServerId  (required)
                * @param policyRule  (required)
                * @return T instance
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public <T> T createAuthorizationServerPolicyRule(Class<?> T, String policyId, String authServerId, AuthorizationServerPolicyRule policyRule) throws RestClientException {
                return (T) getObjectMapper().convertValue(createAuthorizationServerPolicyRuleWithReturnType(T, policyId, authServerId, policyRule).getBody(), T);
            }




            /**
            * Create a Policy Rule
            * Creates a policy rule for the specified Custom Authorization Server and Policy
                * <p><b>201</b> - Created
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param policyId  (required)
                * @param authServerId  (required)
                * @param policyRule  (required)
            * @return ResponseEntity&lt;AuthorizationServerPolicyRule&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<AuthorizationServerPolicyRule> createAuthorizationServerPolicyRuleWithHttpInfo(String policyId, String authServerId, AuthorizationServerPolicyRule policyRule) throws RestClientException {
            Object localVarPostBody = policyRule;
        
                // verify the required parameter 'policyId' is set ''
                if (policyId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'policyId' when calling createAuthorizationServerPolicyRule");
                }
        
                // verify the required parameter 'authServerId' is set ''
                if (authServerId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'authServerId' when calling createAuthorizationServerPolicyRule");
                }
        
                // verify the required parameter 'policyRule' is set ''
                if (policyRule == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'policyRule' when calling createAuthorizationServerPolicyRule");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("policyId", policyId);
                    uriVariables.put("authServerId", authServerId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = { 
            "application/json"
         };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<AuthorizationServerPolicyRule> localReturnType = new ParameterizedTypeReference<AuthorizationServerPolicyRule>() {};
            return apiClient.invokeAPI("/api/v1/authorizationServers/{authServerId}/policies/{policyId}/rules", HttpMethod.POST, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }




            /**
            * Create a Policy Rule
            * Creates a policy rule for the specified Custom Authorization Server and Policy
                * <p><b>201</b> - Created
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param policyId  (required)
                * @param authServerId  (required)
                * @param policyRule  (required)
            * @return ResponseEntity&lt;AuthorizationServerPolicyRule&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private <T> ResponseEntity<T> createAuthorizationServerPolicyRuleWithReturnType(Class<?> T, String policyId,String authServerId,AuthorizationServerPolicyRule policyRule) throws RestClientException {
            Object localVarPostBody = policyRule;
        
                // verify the required parameter 'policyId' is set
                if (policyId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'policyId' when calling createAuthorizationServerPolicyRule");
                }
        
                // verify the required parameter 'authServerId' is set
                if (authServerId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'authServerId' when calling createAuthorizationServerPolicyRule");
                }
        
                // verify the required parameter 'policyRule' is set
                if (policyRule == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'policyRule' when calling createAuthorizationServerPolicyRule");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("policyId", policyId);
                    uriVariables.put("authServerId", authServerId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = { 
            "application/json"
         };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<T> localReturnType = new ParameterizedTypeReference<T>() {};
            return apiClient.invokeAPI("/api/v1/authorizationServers/{authServerId}/policies/{policyId}/rules", HttpMethod.POST, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }




            /**
            * Create a Policy Rule
            * Creates a policy rule for the specified Custom Authorization Server and Policy
                * <p><b>201</b> - Created
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param policyId  (required)
                * @param authServerId  (required)
                * @param policyRule  (required)
            * @return ResponseEntity&lt;AuthorizationServerPolicyRule&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public PagedList createAuthorizationServerPolicyRuleWithPaginationInfo(String policyId, String authServerId, AuthorizationServerPolicyRule policyRule) throws RestClientException {
            Object localVarPostBody = policyRule;
        
                // verify the required parameter 'policyId' is set
                if (policyId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'policyId' when calling createAuthorizationServerPolicyRule");
                }
        
                // verify the required parameter 'authServerId' is set
                if (authServerId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'authServerId' when calling createAuthorizationServerPolicyRule");
                }
        
                // verify the required parameter 'policyRule' is set
                if (policyRule == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'policyRule' when calling createAuthorizationServerPolicyRule");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("policyId", policyId);
                    uriVariables.put("authServerId", authServerId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = { 
            "application/json"
         };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<AuthorizationServerPolicyRule> localReturnType = new ParameterizedTypeReference<AuthorizationServerPolicyRule>() {};
            ResponseEntity<AuthorizationServerPolicyRule> responseEntity = apiClient.invokeAPI("/api/v1/authorizationServers/{authServerId}/policies/{policyId}/rules", HttpMethod.POST, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                    HttpHeaders headers = responseEntity.getHeaders();
                    PagedList pagedList = new PagedList();
                    List<String> linkHeaders = headers.get("link");
                    String self = null, nextPage = null;
                    for (String link : linkHeaders) {
                    if (link.contains("next")) {
                    nextPage = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    if (link.contains("self")) {
                    self = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    }
                    pagedList.addItems(Arrays.asList(responseEntity.getBody()));
                    if (Objects.nonNull(nextPage)) {
                    pagedList.setNextPage(nextPage);
                    }
                    if (Objects.nonNull(self)) {
                    pagedList.setSelf(self);
                    }
                    return pagedList;
        }

        /**
        * Create a Custom Token Claim
        * Creates a custom token claim
            * <p><b>201</b> - Success
            * <p><b>400</b> - Bad Request
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>429</b> - Too Many Requests
                * @param authServerId  (required)
                * @param oAuth2Claim  (required)
                * @return OAuth2Claim
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public OAuth2Claim createOAuth2Claim(String authServerId, OAuth2Claim oAuth2Claim) throws RestClientException {
                return createOAuth2ClaimWithHttpInfo(authServerId, oAuth2Claim).getBody();
            }




            /**
            * Create a Custom Token Claim
            * Creates a custom token claim
                * <p><b>201</b> - Success
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param T (required) - the assignable return type
                * @param authServerId  (required)
                * @param oAuth2Claim  (required)
                * @return T instance
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public <T> T createOAuth2Claim(Class<?> T, String authServerId, OAuth2Claim oAuth2Claim) throws RestClientException {
                return (T) getObjectMapper().convertValue(createOAuth2ClaimWithReturnType(T, authServerId, oAuth2Claim).getBody(), T);
            }




            /**
            * Create a Custom Token Claim
            * Creates a custom token claim
                * <p><b>201</b> - Success
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param authServerId  (required)
                * @param oAuth2Claim  (required)
            * @return ResponseEntity&lt;OAuth2Claim&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<OAuth2Claim> createOAuth2ClaimWithHttpInfo(String authServerId, OAuth2Claim oAuth2Claim) throws RestClientException {
            Object localVarPostBody = oAuth2Claim;
        
                // verify the required parameter 'authServerId' is set ''
                if (authServerId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'authServerId' when calling createOAuth2Claim");
                }
        
                // verify the required parameter 'oAuth2Claim' is set ''
                if (oAuth2Claim == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'oAuth2Claim' when calling createOAuth2Claim");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("authServerId", authServerId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = { 
            "application/json"
         };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<OAuth2Claim> localReturnType = new ParameterizedTypeReference<OAuth2Claim>() {};
            return apiClient.invokeAPI("/api/v1/authorizationServers/{authServerId}/claims", HttpMethod.POST, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }




            /**
            * Create a Custom Token Claim
            * Creates a custom token claim
                * <p><b>201</b> - Success
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param authServerId  (required)
                * @param oAuth2Claim  (required)
            * @return ResponseEntity&lt;OAuth2Claim&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private <T> ResponseEntity<T> createOAuth2ClaimWithReturnType(Class<?> T, String authServerId,OAuth2Claim oAuth2Claim) throws RestClientException {
            Object localVarPostBody = oAuth2Claim;
        
                // verify the required parameter 'authServerId' is set
                if (authServerId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'authServerId' when calling createOAuth2Claim");
                }
        
                // verify the required parameter 'oAuth2Claim' is set
                if (oAuth2Claim == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'oAuth2Claim' when calling createOAuth2Claim");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("authServerId", authServerId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = { 
            "application/json"
         };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<T> localReturnType = new ParameterizedTypeReference<T>() {};
            return apiClient.invokeAPI("/api/v1/authorizationServers/{authServerId}/claims", HttpMethod.POST, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }




            /**
            * Create a Custom Token Claim
            * Creates a custom token claim
                * <p><b>201</b> - Success
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param authServerId  (required)
                * @param oAuth2Claim  (required)
            * @return ResponseEntity&lt;OAuth2Claim&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public PagedList createOAuth2ClaimWithPaginationInfo(String authServerId, OAuth2Claim oAuth2Claim) throws RestClientException {
            Object localVarPostBody = oAuth2Claim;
        
                // verify the required parameter 'authServerId' is set
                if (authServerId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'authServerId' when calling createOAuth2Claim");
                }
        
                // verify the required parameter 'oAuth2Claim' is set
                if (oAuth2Claim == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'oAuth2Claim' when calling createOAuth2Claim");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("authServerId", authServerId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = { 
            "application/json"
         };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<OAuth2Claim> localReturnType = new ParameterizedTypeReference<OAuth2Claim>() {};
            ResponseEntity<OAuth2Claim> responseEntity = apiClient.invokeAPI("/api/v1/authorizationServers/{authServerId}/claims", HttpMethod.POST, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                    HttpHeaders headers = responseEntity.getHeaders();
                    PagedList pagedList = new PagedList();
                    List<String> linkHeaders = headers.get("link");
                    String self = null, nextPage = null;
                    for (String link : linkHeaders) {
                    if (link.contains("next")) {
                    nextPage = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    if (link.contains("self")) {
                    self = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    }
                    pagedList.addItems(Arrays.asList(responseEntity.getBody()));
                    if (Objects.nonNull(nextPage)) {
                    pagedList.setNextPage(nextPage);
                    }
                    if (Objects.nonNull(self)) {
                    pagedList.setSelf(self);
                    }
                    return pagedList;
        }

        /**
        * Create a Custom Token Scope
        * Creates a custom token scope
            * <p><b>201</b> - Success
            * <p><b>400</b> - Bad Request
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>429</b> - Too Many Requests
                * @param authServerId  (required)
                * @param oAuth2Scope  (required)
                * @return OAuth2Scope
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public OAuth2Scope createOAuth2Scope(String authServerId, OAuth2Scope oAuth2Scope) throws RestClientException {
                return createOAuth2ScopeWithHttpInfo(authServerId, oAuth2Scope).getBody();
            }




            /**
            * Create a Custom Token Scope
            * Creates a custom token scope
                * <p><b>201</b> - Success
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param T (required) - the assignable return type
                * @param authServerId  (required)
                * @param oAuth2Scope  (required)
                * @return T instance
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public <T> T createOAuth2Scope(Class<?> T, String authServerId, OAuth2Scope oAuth2Scope) throws RestClientException {
                return (T) getObjectMapper().convertValue(createOAuth2ScopeWithReturnType(T, authServerId, oAuth2Scope).getBody(), T);
            }




            /**
            * Create a Custom Token Scope
            * Creates a custom token scope
                * <p><b>201</b> - Success
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param authServerId  (required)
                * @param oAuth2Scope  (required)
            * @return ResponseEntity&lt;OAuth2Scope&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<OAuth2Scope> createOAuth2ScopeWithHttpInfo(String authServerId, OAuth2Scope oAuth2Scope) throws RestClientException {
            Object localVarPostBody = oAuth2Scope;
        
                // verify the required parameter 'authServerId' is set ''
                if (authServerId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'authServerId' when calling createOAuth2Scope");
                }
        
                // verify the required parameter 'oAuth2Scope' is set ''
                if (oAuth2Scope == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'oAuth2Scope' when calling createOAuth2Scope");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("authServerId", authServerId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = { 
            "application/json"
         };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<OAuth2Scope> localReturnType = new ParameterizedTypeReference<OAuth2Scope>() {};
            return apiClient.invokeAPI("/api/v1/authorizationServers/{authServerId}/scopes", HttpMethod.POST, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }




            /**
            * Create a Custom Token Scope
            * Creates a custom token scope
                * <p><b>201</b> - Success
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param authServerId  (required)
                * @param oAuth2Scope  (required)
            * @return ResponseEntity&lt;OAuth2Scope&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private <T> ResponseEntity<T> createOAuth2ScopeWithReturnType(Class<?> T, String authServerId,OAuth2Scope oAuth2Scope) throws RestClientException {
            Object localVarPostBody = oAuth2Scope;
        
                // verify the required parameter 'authServerId' is set
                if (authServerId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'authServerId' when calling createOAuth2Scope");
                }
        
                // verify the required parameter 'oAuth2Scope' is set
                if (oAuth2Scope == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'oAuth2Scope' when calling createOAuth2Scope");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("authServerId", authServerId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = { 
            "application/json"
         };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<T> localReturnType = new ParameterizedTypeReference<T>() {};
            return apiClient.invokeAPI("/api/v1/authorizationServers/{authServerId}/scopes", HttpMethod.POST, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }




            /**
            * Create a Custom Token Scope
            * Creates a custom token scope
                * <p><b>201</b> - Success
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param authServerId  (required)
                * @param oAuth2Scope  (required)
            * @return ResponseEntity&lt;OAuth2Scope&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public PagedList createOAuth2ScopeWithPaginationInfo(String authServerId, OAuth2Scope oAuth2Scope) throws RestClientException {
            Object localVarPostBody = oAuth2Scope;
        
                // verify the required parameter 'authServerId' is set
                if (authServerId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'authServerId' when calling createOAuth2Scope");
                }
        
                // verify the required parameter 'oAuth2Scope' is set
                if (oAuth2Scope == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'oAuth2Scope' when calling createOAuth2Scope");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("authServerId", authServerId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = { 
            "application/json"
         };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<OAuth2Scope> localReturnType = new ParameterizedTypeReference<OAuth2Scope>() {};
            ResponseEntity<OAuth2Scope> responseEntity = apiClient.invokeAPI("/api/v1/authorizationServers/{authServerId}/scopes", HttpMethod.POST, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                    HttpHeaders headers = responseEntity.getHeaders();
                    PagedList pagedList = new PagedList();
                    List<String> linkHeaders = headers.get("link");
                    String self = null, nextPage = null;
                    for (String link : linkHeaders) {
                    if (link.contains("next")) {
                    nextPage = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    if (link.contains("self")) {
                    self = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    }
                    pagedList.addItems(Arrays.asList(responseEntity.getBody()));
                    if (Objects.nonNull(nextPage)) {
                    pagedList.setNextPage(nextPage);
                    }
                    if (Objects.nonNull(self)) {
                    pagedList.setSelf(self);
                    }
                    return pagedList;
        }

        /**
        * Deactivate an Authorization Server
        * Deactivates an authorization server
            * <p><b>204</b> - No Content
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>429</b> - Too Many Requests
                * @param authServerId  (required)
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public void deactivateAuthorizationServer(String authServerId) throws RestClientException {
            deactivateAuthorizationServerWithHttpInfo(authServerId);
            }






            /**
            * Deactivate an Authorization Server
            * Deactivates an authorization server
                * <p><b>204</b> - No Content
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param authServerId  (required)
            * @return ResponseEntity&lt;Void&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<Void> deactivateAuthorizationServerWithHttpInfo(String authServerId) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'authServerId' is set ''
                if (authServerId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'authServerId' when calling deactivateAuthorizationServer");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("authServerId", authServerId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<Void> localReturnType = new ParameterizedTypeReference<Void>() {};
            return apiClient.invokeAPI("/api/v1/authorizationServers/{authServerId}/lifecycle/deactivate", HttpMethod.POST, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }







        /**
        * Deactivate a Policy
        * Deactivates an authorization server policy
            * <p><b>204</b> - No Content
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>429</b> - Too Many Requests
                * @param authServerId  (required)
                * @param policyId  (required)
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public void deactivateAuthorizationServerPolicy(String authServerId, String policyId) throws RestClientException {
            deactivateAuthorizationServerPolicyWithHttpInfo(authServerId, policyId);
            }






            /**
            * Deactivate a Policy
            * Deactivates an authorization server policy
                * <p><b>204</b> - No Content
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param authServerId  (required)
                * @param policyId  (required)
            * @return ResponseEntity&lt;Void&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<Void> deactivateAuthorizationServerPolicyWithHttpInfo(String authServerId, String policyId) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'authServerId' is set ''
                if (authServerId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'authServerId' when calling deactivateAuthorizationServerPolicy");
                }
        
                // verify the required parameter 'policyId' is set ''
                if (policyId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'policyId' when calling deactivateAuthorizationServerPolicy");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("authServerId", authServerId);
                    uriVariables.put("policyId", policyId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<Void> localReturnType = new ParameterizedTypeReference<Void>() {};
            return apiClient.invokeAPI("/api/v1/authorizationServers/{authServerId}/policies/{policyId}/lifecycle/deactivate", HttpMethod.POST, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }







        /**
        * Deactivate a Policy Rule
        * Deactivates an authorization server policy rule
            * <p><b>204</b> - No Content
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>429</b> - Too Many Requests
                * @param authServerId  (required)
                * @param policyId  (required)
                * @param ruleId  (required)
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public void deactivateAuthorizationServerPolicyRule(String authServerId, String policyId, String ruleId) throws RestClientException {
            deactivateAuthorizationServerPolicyRuleWithHttpInfo(authServerId, policyId, ruleId);
            }






            /**
            * Deactivate a Policy Rule
            * Deactivates an authorization server policy rule
                * <p><b>204</b> - No Content
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param authServerId  (required)
                * @param policyId  (required)
                * @param ruleId  (required)
            * @return ResponseEntity&lt;Void&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<Void> deactivateAuthorizationServerPolicyRuleWithHttpInfo(String authServerId, String policyId, String ruleId) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'authServerId' is set ''
                if (authServerId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'authServerId' when calling deactivateAuthorizationServerPolicyRule");
                }
        
                // verify the required parameter 'policyId' is set ''
                if (policyId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'policyId' when calling deactivateAuthorizationServerPolicyRule");
                }
        
                // verify the required parameter 'ruleId' is set ''
                if (ruleId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'ruleId' when calling deactivateAuthorizationServerPolicyRule");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("authServerId", authServerId);
                    uriVariables.put("policyId", policyId);
                    uriVariables.put("ruleId", ruleId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<Void> localReturnType = new ParameterizedTypeReference<Void>() {};
            return apiClient.invokeAPI("/api/v1/authorizationServers/{authServerId}/policies/{policyId}/rules/{ruleId}/lifecycle/deactivate", HttpMethod.POST, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }







        /**
        * Delete an Authorization Server
        * Deletes an authorization server
            * <p><b>204</b> - No Content
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>429</b> - Too Many Requests
                * @param authServerId  (required)
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public void deleteAuthorizationServer(String authServerId) throws RestClientException {
            deleteAuthorizationServerWithHttpInfo(authServerId);
            }






            /**
            * Delete an Authorization Server
            * Deletes an authorization server
                * <p><b>204</b> - No Content
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param authServerId  (required)
            * @return ResponseEntity&lt;Void&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<Void> deleteAuthorizationServerWithHttpInfo(String authServerId) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'authServerId' is set ''
                if (authServerId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'authServerId' when calling deleteAuthorizationServer");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("authServerId", authServerId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<Void> localReturnType = new ParameterizedTypeReference<Void>() {};
            return apiClient.invokeAPI("/api/v1/authorizationServers/{authServerId}", HttpMethod.DELETE, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }







        /**
        * Delete a Policy
        * Deletes a policy
            * <p><b>204</b> - No Content
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>429</b> - Too Many Requests
                * @param authServerId  (required)
                * @param policyId  (required)
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public void deleteAuthorizationServerPolicy(String authServerId, String policyId) throws RestClientException {
            deleteAuthorizationServerPolicyWithHttpInfo(authServerId, policyId);
            }






            /**
            * Delete a Policy
            * Deletes a policy
                * <p><b>204</b> - No Content
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param authServerId  (required)
                * @param policyId  (required)
            * @return ResponseEntity&lt;Void&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<Void> deleteAuthorizationServerPolicyWithHttpInfo(String authServerId, String policyId) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'authServerId' is set ''
                if (authServerId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'authServerId' when calling deleteAuthorizationServerPolicy");
                }
        
                // verify the required parameter 'policyId' is set ''
                if (policyId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'policyId' when calling deleteAuthorizationServerPolicy");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("authServerId", authServerId);
                    uriVariables.put("policyId", policyId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<Void> localReturnType = new ParameterizedTypeReference<Void>() {};
            return apiClient.invokeAPI("/api/v1/authorizationServers/{authServerId}/policies/{policyId}", HttpMethod.DELETE, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }







        /**
        * Delete a Policy Rule
        * Deletes a Policy Rule defined in the specified Custom Authorization Server and Policy
            * <p><b>204</b> - No Content
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>429</b> - Too Many Requests
                * @param policyId  (required)
                * @param authServerId  (required)
                * @param ruleId  (required)
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public void deleteAuthorizationServerPolicyRule(String policyId, String authServerId, String ruleId) throws RestClientException {
            deleteAuthorizationServerPolicyRuleWithHttpInfo(policyId, authServerId, ruleId);
            }






            /**
            * Delete a Policy Rule
            * Deletes a Policy Rule defined in the specified Custom Authorization Server and Policy
                * <p><b>204</b> - No Content
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param policyId  (required)
                * @param authServerId  (required)
                * @param ruleId  (required)
            * @return ResponseEntity&lt;Void&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<Void> deleteAuthorizationServerPolicyRuleWithHttpInfo(String policyId, String authServerId, String ruleId) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'policyId' is set ''
                if (policyId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'policyId' when calling deleteAuthorizationServerPolicyRule");
                }
        
                // verify the required parameter 'authServerId' is set ''
                if (authServerId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'authServerId' when calling deleteAuthorizationServerPolicyRule");
                }
        
                // verify the required parameter 'ruleId' is set ''
                if (ruleId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'ruleId' when calling deleteAuthorizationServerPolicyRule");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("policyId", policyId);
                    uriVariables.put("authServerId", authServerId);
                    uriVariables.put("ruleId", ruleId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<Void> localReturnType = new ParameterizedTypeReference<Void>() {};
            return apiClient.invokeAPI("/api/v1/authorizationServers/{authServerId}/policies/{policyId}/rules/{ruleId}", HttpMethod.DELETE, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }







        /**
        * Delete a Custom Token Claim
        * Deletes a custom token claim
            * <p><b>204</b> - No Content
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>429</b> - Too Many Requests
                * @param authServerId  (required)
                * @param claimId  (required)
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public void deleteOAuth2Claim(String authServerId, String claimId) throws RestClientException {
            deleteOAuth2ClaimWithHttpInfo(authServerId, claimId);
            }






            /**
            * Delete a Custom Token Claim
            * Deletes a custom token claim
                * <p><b>204</b> - No Content
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param authServerId  (required)
                * @param claimId  (required)
            * @return ResponseEntity&lt;Void&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<Void> deleteOAuth2ClaimWithHttpInfo(String authServerId, String claimId) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'authServerId' is set ''
                if (authServerId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'authServerId' when calling deleteOAuth2Claim");
                }
        
                // verify the required parameter 'claimId' is set ''
                if (claimId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'claimId' when calling deleteOAuth2Claim");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("authServerId", authServerId);
                    uriVariables.put("claimId", claimId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<Void> localReturnType = new ParameterizedTypeReference<Void>() {};
            return apiClient.invokeAPI("/api/v1/authorizationServers/{authServerId}/claims/{claimId}", HttpMethod.DELETE, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }







        /**
        * Delete a Custom Token Scope
        * Deletes a custom token scope
            * <p><b>204</b> - No Content
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>429</b> - Too Many Requests
                * @param authServerId  (required)
                * @param scopeId  (required)
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public void deleteOAuth2Scope(String authServerId, String scopeId) throws RestClientException {
            deleteOAuth2ScopeWithHttpInfo(authServerId, scopeId);
            }






            /**
            * Delete a Custom Token Scope
            * Deletes a custom token scope
                * <p><b>204</b> - No Content
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param authServerId  (required)
                * @param scopeId  (required)
            * @return ResponseEntity&lt;Void&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<Void> deleteOAuth2ScopeWithHttpInfo(String authServerId, String scopeId) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'authServerId' is set ''
                if (authServerId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'authServerId' when calling deleteOAuth2Scope");
                }
        
                // verify the required parameter 'scopeId' is set ''
                if (scopeId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'scopeId' when calling deleteOAuth2Scope");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("authServerId", authServerId);
                    uriVariables.put("scopeId", scopeId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<Void> localReturnType = new ParameterizedTypeReference<Void>() {};
            return apiClient.invokeAPI("/api/v1/authorizationServers/{authServerId}/scopes/{scopeId}", HttpMethod.DELETE, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }







        /**
        * Retrieve an Authorization Server
        * Retrieves an authorization server
            * <p><b>200</b> - Success
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>429</b> - Too Many Requests
                * @param authServerId  (required)
                * @return AuthorizationServer
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public AuthorizationServer getAuthorizationServer(String authServerId) throws RestClientException {
                return getAuthorizationServerWithHttpInfo(authServerId).getBody();
            }






            /**
            * Retrieve an Authorization Server
            * Retrieves an authorization server
                * <p><b>200</b> - Success
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param authServerId  (required)
            * @return ResponseEntity&lt;AuthorizationServer&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<AuthorizationServer> getAuthorizationServerWithHttpInfo(String authServerId) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'authServerId' is set ''
                if (authServerId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'authServerId' when calling getAuthorizationServer");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("authServerId", authServerId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<AuthorizationServer> localReturnType = new ParameterizedTypeReference<AuthorizationServer>() {};
            return apiClient.invokeAPI("/api/v1/authorizationServers/{authServerId}", HttpMethod.GET, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }







            /**
            * Retrieve an Authorization Server
            * Retrieves an authorization server
                * <p><b>200</b> - Success
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param authServerId  (required)
            * @return ResponseEntity&lt;AuthorizationServer&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public PagedList getAuthorizationServerWithPaginationInfo(String authServerId) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'authServerId' is set
                if (authServerId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'authServerId' when calling getAuthorizationServer");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("authServerId", authServerId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<AuthorizationServer> localReturnType = new ParameterizedTypeReference<AuthorizationServer>() {};
            ResponseEntity<AuthorizationServer> responseEntity = apiClient.invokeAPI("/api/v1/authorizationServers/{authServerId}", HttpMethod.GET, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                    HttpHeaders headers = responseEntity.getHeaders();
                    PagedList pagedList = new PagedList();
                    List<String> linkHeaders = headers.get("link");
                    String self = null, nextPage = null;
                    for (String link : linkHeaders) {
                    if (link.contains("next")) {
                    nextPage = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    if (link.contains("self")) {
                    self = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    }
                    pagedList.addItems(Arrays.asList(responseEntity.getBody()));
                    if (Objects.nonNull(nextPage)) {
                    pagedList.setNextPage(nextPage);
                    }
                    if (Objects.nonNull(self)) {
                    pagedList.setSelf(self);
                    }
                    return pagedList;
        }

        /**
        * Retrieve a Policy
        * Retrieves a policy
            * <p><b>200</b> - Success
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>429</b> - Too Many Requests
                * @param authServerId  (required)
                * @param policyId  (required)
                * @return AuthorizationServerPolicy
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public AuthorizationServerPolicy getAuthorizationServerPolicy(String authServerId, String policyId) throws RestClientException {
                return getAuthorizationServerPolicyWithHttpInfo(authServerId, policyId).getBody();
            }






            /**
            * Retrieve a Policy
            * Retrieves a policy
                * <p><b>200</b> - Success
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param authServerId  (required)
                * @param policyId  (required)
            * @return ResponseEntity&lt;AuthorizationServerPolicy&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<AuthorizationServerPolicy> getAuthorizationServerPolicyWithHttpInfo(String authServerId, String policyId) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'authServerId' is set ''
                if (authServerId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'authServerId' when calling getAuthorizationServerPolicy");
                }
        
                // verify the required parameter 'policyId' is set ''
                if (policyId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'policyId' when calling getAuthorizationServerPolicy");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("authServerId", authServerId);
                    uriVariables.put("policyId", policyId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<AuthorizationServerPolicy> localReturnType = new ParameterizedTypeReference<AuthorizationServerPolicy>() {};
            return apiClient.invokeAPI("/api/v1/authorizationServers/{authServerId}/policies/{policyId}", HttpMethod.GET, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }







            /**
            * Retrieve a Policy
            * Retrieves a policy
                * <p><b>200</b> - Success
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param authServerId  (required)
                * @param policyId  (required)
            * @return ResponseEntity&lt;AuthorizationServerPolicy&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public PagedList getAuthorizationServerPolicyWithPaginationInfo(String authServerId, String policyId) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'authServerId' is set
                if (authServerId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'authServerId' when calling getAuthorizationServerPolicy");
                }
        
                // verify the required parameter 'policyId' is set
                if (policyId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'policyId' when calling getAuthorizationServerPolicy");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("authServerId", authServerId);
                    uriVariables.put("policyId", policyId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<AuthorizationServerPolicy> localReturnType = new ParameterizedTypeReference<AuthorizationServerPolicy>() {};
            ResponseEntity<AuthorizationServerPolicy> responseEntity = apiClient.invokeAPI("/api/v1/authorizationServers/{authServerId}/policies/{policyId}", HttpMethod.GET, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                    HttpHeaders headers = responseEntity.getHeaders();
                    PagedList pagedList = new PagedList();
                    List<String> linkHeaders = headers.get("link");
                    String self = null, nextPage = null;
                    for (String link : linkHeaders) {
                    if (link.contains("next")) {
                    nextPage = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    if (link.contains("self")) {
                    self = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    }
                    pagedList.addItems(Arrays.asList(responseEntity.getBody()));
                    if (Objects.nonNull(nextPage)) {
                    pagedList.setNextPage(nextPage);
                    }
                    if (Objects.nonNull(self)) {
                    pagedList.setSelf(self);
                    }
                    return pagedList;
        }

        /**
        * Retrieve a Policy Rule
        * Returns a Policy Rule by ID that is defined in the specified Custom Authorization Server and Policy
            * <p><b>200</b> - Success
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>429</b> - Too Many Requests
                * @param policyId  (required)
                * @param authServerId  (required)
                * @param ruleId  (required)
                * @return AuthorizationServerPolicyRule
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public AuthorizationServerPolicyRule getAuthorizationServerPolicyRule(String policyId, String authServerId, String ruleId) throws RestClientException {
                return getAuthorizationServerPolicyRuleWithHttpInfo(policyId, authServerId, ruleId).getBody();
            }






            /**
            * Retrieve a Policy Rule
            * Returns a Policy Rule by ID that is defined in the specified Custom Authorization Server and Policy
                * <p><b>200</b> - Success
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param policyId  (required)
                * @param authServerId  (required)
                * @param ruleId  (required)
            * @return ResponseEntity&lt;AuthorizationServerPolicyRule&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<AuthorizationServerPolicyRule> getAuthorizationServerPolicyRuleWithHttpInfo(String policyId, String authServerId, String ruleId) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'policyId' is set ''
                if (policyId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'policyId' when calling getAuthorizationServerPolicyRule");
                }
        
                // verify the required parameter 'authServerId' is set ''
                if (authServerId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'authServerId' when calling getAuthorizationServerPolicyRule");
                }
        
                // verify the required parameter 'ruleId' is set ''
                if (ruleId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'ruleId' when calling getAuthorizationServerPolicyRule");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("policyId", policyId);
                    uriVariables.put("authServerId", authServerId);
                    uriVariables.put("ruleId", ruleId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<AuthorizationServerPolicyRule> localReturnType = new ParameterizedTypeReference<AuthorizationServerPolicyRule>() {};
            return apiClient.invokeAPI("/api/v1/authorizationServers/{authServerId}/policies/{policyId}/rules/{ruleId}", HttpMethod.GET, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }







            /**
            * Retrieve a Policy Rule
            * Returns a Policy Rule by ID that is defined in the specified Custom Authorization Server and Policy
                * <p><b>200</b> - Success
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param policyId  (required)
                * @param authServerId  (required)
                * @param ruleId  (required)
            * @return ResponseEntity&lt;AuthorizationServerPolicyRule&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public PagedList getAuthorizationServerPolicyRuleWithPaginationInfo(String policyId, String authServerId, String ruleId) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'policyId' is set
                if (policyId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'policyId' when calling getAuthorizationServerPolicyRule");
                }
        
                // verify the required parameter 'authServerId' is set
                if (authServerId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'authServerId' when calling getAuthorizationServerPolicyRule");
                }
        
                // verify the required parameter 'ruleId' is set
                if (ruleId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'ruleId' when calling getAuthorizationServerPolicyRule");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("policyId", policyId);
                    uriVariables.put("authServerId", authServerId);
                    uriVariables.put("ruleId", ruleId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<AuthorizationServerPolicyRule> localReturnType = new ParameterizedTypeReference<AuthorizationServerPolicyRule>() {};
            ResponseEntity<AuthorizationServerPolicyRule> responseEntity = apiClient.invokeAPI("/api/v1/authorizationServers/{authServerId}/policies/{policyId}/rules/{ruleId}", HttpMethod.GET, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                    HttpHeaders headers = responseEntity.getHeaders();
                    PagedList pagedList = new PagedList();
                    List<String> linkHeaders = headers.get("link");
                    String self = null, nextPage = null;
                    for (String link : linkHeaders) {
                    if (link.contains("next")) {
                    nextPage = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    if (link.contains("self")) {
                    self = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    }
                    pagedList.addItems(Arrays.asList(responseEntity.getBody()));
                    if (Objects.nonNull(nextPage)) {
                    pagedList.setNextPage(nextPage);
                    }
                    if (Objects.nonNull(self)) {
                    pagedList.setSelf(self);
                    }
                    return pagedList;
        }

        /**
        * Retrieve a Custom Token Claim
        * Retrieves a custom token claim
            * <p><b>200</b> - Success
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>429</b> - Too Many Requests
                * @param authServerId  (required)
                * @param claimId  (required)
                * @return OAuth2Claim
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public OAuth2Claim getOAuth2Claim(String authServerId, String claimId) throws RestClientException {
                return getOAuth2ClaimWithHttpInfo(authServerId, claimId).getBody();
            }






            /**
            * Retrieve a Custom Token Claim
            * Retrieves a custom token claim
                * <p><b>200</b> - Success
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param authServerId  (required)
                * @param claimId  (required)
            * @return ResponseEntity&lt;OAuth2Claim&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<OAuth2Claim> getOAuth2ClaimWithHttpInfo(String authServerId, String claimId) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'authServerId' is set ''
                if (authServerId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'authServerId' when calling getOAuth2Claim");
                }
        
                // verify the required parameter 'claimId' is set ''
                if (claimId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'claimId' when calling getOAuth2Claim");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("authServerId", authServerId);
                    uriVariables.put("claimId", claimId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<OAuth2Claim> localReturnType = new ParameterizedTypeReference<OAuth2Claim>() {};
            return apiClient.invokeAPI("/api/v1/authorizationServers/{authServerId}/claims/{claimId}", HttpMethod.GET, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }







            /**
            * Retrieve a Custom Token Claim
            * Retrieves a custom token claim
                * <p><b>200</b> - Success
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param authServerId  (required)
                * @param claimId  (required)
            * @return ResponseEntity&lt;OAuth2Claim&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public PagedList getOAuth2ClaimWithPaginationInfo(String authServerId, String claimId) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'authServerId' is set
                if (authServerId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'authServerId' when calling getOAuth2Claim");
                }
        
                // verify the required parameter 'claimId' is set
                if (claimId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'claimId' when calling getOAuth2Claim");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("authServerId", authServerId);
                    uriVariables.put("claimId", claimId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<OAuth2Claim> localReturnType = new ParameterizedTypeReference<OAuth2Claim>() {};
            ResponseEntity<OAuth2Claim> responseEntity = apiClient.invokeAPI("/api/v1/authorizationServers/{authServerId}/claims/{claimId}", HttpMethod.GET, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                    HttpHeaders headers = responseEntity.getHeaders();
                    PagedList pagedList = new PagedList();
                    List<String> linkHeaders = headers.get("link");
                    String self = null, nextPage = null;
                    for (String link : linkHeaders) {
                    if (link.contains("next")) {
                    nextPage = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    if (link.contains("self")) {
                    self = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    }
                    pagedList.addItems(Arrays.asList(responseEntity.getBody()));
                    if (Objects.nonNull(nextPage)) {
                    pagedList.setNextPage(nextPage);
                    }
                    if (Objects.nonNull(self)) {
                    pagedList.setSelf(self);
                    }
                    return pagedList;
        }

        /**
        * Retrieve a Custom Token Scope
        * Retrieves a custom token scope
            * <p><b>200</b> - Success
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>429</b> - Too Many Requests
                * @param authServerId  (required)
                * @param scopeId  (required)
                * @return OAuth2Scope
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public OAuth2Scope getOAuth2Scope(String authServerId, String scopeId) throws RestClientException {
                return getOAuth2ScopeWithHttpInfo(authServerId, scopeId).getBody();
            }






            /**
            * Retrieve a Custom Token Scope
            * Retrieves a custom token scope
                * <p><b>200</b> - Success
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param authServerId  (required)
                * @param scopeId  (required)
            * @return ResponseEntity&lt;OAuth2Scope&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<OAuth2Scope> getOAuth2ScopeWithHttpInfo(String authServerId, String scopeId) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'authServerId' is set ''
                if (authServerId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'authServerId' when calling getOAuth2Scope");
                }
        
                // verify the required parameter 'scopeId' is set ''
                if (scopeId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'scopeId' when calling getOAuth2Scope");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("authServerId", authServerId);
                    uriVariables.put("scopeId", scopeId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<OAuth2Scope> localReturnType = new ParameterizedTypeReference<OAuth2Scope>() {};
            return apiClient.invokeAPI("/api/v1/authorizationServers/{authServerId}/scopes/{scopeId}", HttpMethod.GET, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }







            /**
            * Retrieve a Custom Token Scope
            * Retrieves a custom token scope
                * <p><b>200</b> - Success
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param authServerId  (required)
                * @param scopeId  (required)
            * @return ResponseEntity&lt;OAuth2Scope&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public PagedList getOAuth2ScopeWithPaginationInfo(String authServerId, String scopeId) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'authServerId' is set
                if (authServerId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'authServerId' when calling getOAuth2Scope");
                }
        
                // verify the required parameter 'scopeId' is set
                if (scopeId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'scopeId' when calling getOAuth2Scope");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("authServerId", authServerId);
                    uriVariables.put("scopeId", scopeId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<OAuth2Scope> localReturnType = new ParameterizedTypeReference<OAuth2Scope>() {};
            ResponseEntity<OAuth2Scope> responseEntity = apiClient.invokeAPI("/api/v1/authorizationServers/{authServerId}/scopes/{scopeId}", HttpMethod.GET, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                    HttpHeaders headers = responseEntity.getHeaders();
                    PagedList pagedList = new PagedList();
                    List<String> linkHeaders = headers.get("link");
                    String self = null, nextPage = null;
                    for (String link : linkHeaders) {
                    if (link.contains("next")) {
                    nextPage = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    if (link.contains("self")) {
                    self = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    }
                    pagedList.addItems(Arrays.asList(responseEntity.getBody()));
                    if (Objects.nonNull(nextPage)) {
                    pagedList.setNextPage(nextPage);
                    }
                    if (Objects.nonNull(self)) {
                    pagedList.setSelf(self);
                    }
                    return pagedList;
        }

        /**
        * Retrieve a Refresh Token for a Client
        * Retrieves a refresh token for a client
            * <p><b>200</b> - Success
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>429</b> - Too Many Requests
                * @param authServerId  (required)
                * @param clientId  (required)
                * @param tokenId  (required)
                * @param expand  (optional)
                * @return OAuth2RefreshToken
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public OAuth2RefreshToken getRefreshTokenForAuthorizationServerAndClient(String authServerId, String clientId, String tokenId, String expand) throws RestClientException {
                return getRefreshTokenForAuthorizationServerAndClientWithHttpInfo(authServerId, clientId, tokenId, expand).getBody();
            }






            /**
            * Retrieve a Refresh Token for a Client
            * Retrieves a refresh token for a client
                * <p><b>200</b> - Success
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param authServerId  (required)
                * @param clientId  (required)
                * @param tokenId  (required)
                * @param expand  (optional)
            * @return ResponseEntity&lt;OAuth2RefreshToken&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<OAuth2RefreshToken> getRefreshTokenForAuthorizationServerAndClientWithHttpInfo(String authServerId, String clientId, String tokenId, String expand) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'authServerId' is set ''
                if (authServerId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'authServerId' when calling getRefreshTokenForAuthorizationServerAndClient");
                }
        
                // verify the required parameter 'clientId' is set ''
                if (clientId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'clientId' when calling getRefreshTokenForAuthorizationServerAndClient");
                }
        
                // verify the required parameter 'tokenId' is set ''
                if (tokenId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'tokenId' when calling getRefreshTokenForAuthorizationServerAndClient");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("authServerId", authServerId);
                    uriVariables.put("clientId", clientId);
                    uriVariables.put("tokenId", tokenId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "expand", expand));

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<OAuth2RefreshToken> localReturnType = new ParameterizedTypeReference<OAuth2RefreshToken>() {};
            return apiClient.invokeAPI("/api/v1/authorizationServers/{authServerId}/clients/{clientId}/tokens/{tokenId}", HttpMethod.GET, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }







            /**
            * Retrieve a Refresh Token for a Client
            * Retrieves a refresh token for a client
                * <p><b>200</b> - Success
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param authServerId  (required)
                * @param clientId  (required)
                * @param tokenId  (required)
                * @param expand  (optional)
            * @return ResponseEntity&lt;OAuth2RefreshToken&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public PagedList getRefreshTokenForAuthorizationServerAndClientWithPaginationInfo(String authServerId, String clientId, String tokenId, String expand) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'authServerId' is set
                if (authServerId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'authServerId' when calling getRefreshTokenForAuthorizationServerAndClient");
                }
        
                // verify the required parameter 'clientId' is set
                if (clientId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'clientId' when calling getRefreshTokenForAuthorizationServerAndClient");
                }
        
                // verify the required parameter 'tokenId' is set
                if (tokenId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'tokenId' when calling getRefreshTokenForAuthorizationServerAndClient");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("authServerId", authServerId);
                    uriVariables.put("clientId", clientId);
                    uriVariables.put("tokenId", tokenId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "expand", expand));

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<OAuth2RefreshToken> localReturnType = new ParameterizedTypeReference<OAuth2RefreshToken>() {};
            ResponseEntity<OAuth2RefreshToken> responseEntity = apiClient.invokeAPI("/api/v1/authorizationServers/{authServerId}/clients/{clientId}/tokens/{tokenId}", HttpMethod.GET, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                    HttpHeaders headers = responseEntity.getHeaders();
                    PagedList pagedList = new PagedList();
                    List<String> linkHeaders = headers.get("link");
                    String self = null, nextPage = null;
                    for (String link : linkHeaders) {
                    if (link.contains("next")) {
                    nextPage = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    if (link.contains("self")) {
                    self = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    }
                    pagedList.addItems(Arrays.asList(responseEntity.getBody()));
                    if (Objects.nonNull(nextPage)) {
                    pagedList.setNextPage(nextPage);
                    }
                    if (Objects.nonNull(self)) {
                    pagedList.setSelf(self);
                    }
                    return pagedList;
        }

        /**
        * List all Credential Keys
        * Lists all credential keys
            * <p><b>200</b> - Success
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>429</b> - Too Many Requests
                * @param authServerId  (required)
                * @return List&lt;JsonWebKey&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public List<JsonWebKey> listAuthorizationServerKeys(String authServerId) throws RestClientException {
                return listAuthorizationServerKeysWithHttpInfo(authServerId).getBody();
            }






            /**
            * List all Credential Keys
            * Lists all credential keys
                * <p><b>200</b> - Success
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param authServerId  (required)
            * @return ResponseEntity&lt;List&lt;JsonWebKey&gt;&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<List<JsonWebKey>> listAuthorizationServerKeysWithHttpInfo(String authServerId) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'authServerId' is set ''
                if (authServerId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'authServerId' when calling listAuthorizationServerKeys");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("authServerId", authServerId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<List<JsonWebKey>> localReturnType = new ParameterizedTypeReference<List<JsonWebKey>>() {};
            return apiClient.invokeAPI("/api/v1/authorizationServers/{authServerId}/credentials/keys", HttpMethod.GET, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }







            /**
            * List all Credential Keys
            * Lists all credential keys
                * <p><b>200</b> - Success
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param authServerId  (required)
            * @return ResponseEntity&lt;List&lt;JsonWebKey&gt;&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public PagedList listAuthorizationServerKeysWithPaginationInfo(String authServerId) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'authServerId' is set
                if (authServerId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'authServerId' when calling listAuthorizationServerKeys");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("authServerId", authServerId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<List<JsonWebKey>> localReturnType = new ParameterizedTypeReference<List<JsonWebKey>>() {};
            ResponseEntity<List<JsonWebKey>> responseEntity = apiClient.invokeAPI("/api/v1/authorizationServers/{authServerId}/credentials/keys", HttpMethod.GET, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                    HttpHeaders headers = responseEntity.getHeaders();
                    PagedList pagedList = new PagedList();
                    List<String> linkHeaders = headers.get("link");
                    String self = null, nextPage = null;
                    for (String link : linkHeaders) {
                    if (link.contains("next")) {
                    nextPage = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    if (link.contains("self")) {
                    self = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    }
                    pagedList.addItems(Arrays.asList(responseEntity.getBody()));
                    if (Objects.nonNull(nextPage)) {
                    pagedList.setNextPage(nextPage);
                    }
                    if (Objects.nonNull(self)) {
                    pagedList.setSelf(self);
                    }
                    return pagedList;
        }

        /**
        * List all Policies
        * Lists all policies
            * <p><b>200</b> - Success
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>429</b> - Too Many Requests
                * @param authServerId  (required)
                * @return List&lt;AuthorizationServerPolicy&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public List<AuthorizationServerPolicy> listAuthorizationServerPolicies(String authServerId) throws RestClientException {
                return listAuthorizationServerPoliciesWithHttpInfo(authServerId).getBody();
            }






            /**
            * List all Policies
            * Lists all policies
                * <p><b>200</b> - Success
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param authServerId  (required)
            * @return ResponseEntity&lt;List&lt;AuthorizationServerPolicy&gt;&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<List<AuthorizationServerPolicy>> listAuthorizationServerPoliciesWithHttpInfo(String authServerId) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'authServerId' is set ''
                if (authServerId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'authServerId' when calling listAuthorizationServerPolicies");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("authServerId", authServerId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<List<AuthorizationServerPolicy>> localReturnType = new ParameterizedTypeReference<List<AuthorizationServerPolicy>>() {};
            return apiClient.invokeAPI("/api/v1/authorizationServers/{authServerId}/policies", HttpMethod.GET, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }







            /**
            * List all Policies
            * Lists all policies
                * <p><b>200</b> - Success
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param authServerId  (required)
            * @return ResponseEntity&lt;List&lt;AuthorizationServerPolicy&gt;&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public PagedList listAuthorizationServerPoliciesWithPaginationInfo(String authServerId) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'authServerId' is set
                if (authServerId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'authServerId' when calling listAuthorizationServerPolicies");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("authServerId", authServerId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<List<AuthorizationServerPolicy>> localReturnType = new ParameterizedTypeReference<List<AuthorizationServerPolicy>>() {};
            ResponseEntity<List<AuthorizationServerPolicy>> responseEntity = apiClient.invokeAPI("/api/v1/authorizationServers/{authServerId}/policies", HttpMethod.GET, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                    HttpHeaders headers = responseEntity.getHeaders();
                    PagedList pagedList = new PagedList();
                    List<String> linkHeaders = headers.get("link");
                    String self = null, nextPage = null;
                    for (String link : linkHeaders) {
                    if (link.contains("next")) {
                    nextPage = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    if (link.contains("self")) {
                    self = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    }
                    pagedList.addItems(Arrays.asList(responseEntity.getBody()));
                    if (Objects.nonNull(nextPage)) {
                    pagedList.setNextPage(nextPage);
                    }
                    if (Objects.nonNull(self)) {
                    pagedList.setSelf(self);
                    }
                    return pagedList;
        }

        /**
        * List all Policy Rules
        * Lists all policy rules for the specified Custom Authorization Server and Policy
            * <p><b>200</b> - Success
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>429</b> - Too Many Requests
                * @param policyId  (required)
                * @param authServerId  (required)
                * @return List&lt;AuthorizationServerPolicyRule&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public List<AuthorizationServerPolicyRule> listAuthorizationServerPolicyRules(String policyId, String authServerId) throws RestClientException {
                return listAuthorizationServerPolicyRulesWithHttpInfo(policyId, authServerId).getBody();
            }






            /**
            * List all Policy Rules
            * Lists all policy rules for the specified Custom Authorization Server and Policy
                * <p><b>200</b> - Success
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param policyId  (required)
                * @param authServerId  (required)
            * @return ResponseEntity&lt;List&lt;AuthorizationServerPolicyRule&gt;&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<List<AuthorizationServerPolicyRule>> listAuthorizationServerPolicyRulesWithHttpInfo(String policyId, String authServerId) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'policyId' is set ''
                if (policyId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'policyId' when calling listAuthorizationServerPolicyRules");
                }
        
                // verify the required parameter 'authServerId' is set ''
                if (authServerId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'authServerId' when calling listAuthorizationServerPolicyRules");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("policyId", policyId);
                    uriVariables.put("authServerId", authServerId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<List<AuthorizationServerPolicyRule>> localReturnType = new ParameterizedTypeReference<List<AuthorizationServerPolicyRule>>() {};
            return apiClient.invokeAPI("/api/v1/authorizationServers/{authServerId}/policies/{policyId}/rules", HttpMethod.GET, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }







            /**
            * List all Policy Rules
            * Lists all policy rules for the specified Custom Authorization Server and Policy
                * <p><b>200</b> - Success
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param policyId  (required)
                * @param authServerId  (required)
            * @return ResponseEntity&lt;List&lt;AuthorizationServerPolicyRule&gt;&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public PagedList listAuthorizationServerPolicyRulesWithPaginationInfo(String policyId, String authServerId) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'policyId' is set
                if (policyId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'policyId' when calling listAuthorizationServerPolicyRules");
                }
        
                // verify the required parameter 'authServerId' is set
                if (authServerId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'authServerId' when calling listAuthorizationServerPolicyRules");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("policyId", policyId);
                    uriVariables.put("authServerId", authServerId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<List<AuthorizationServerPolicyRule>> localReturnType = new ParameterizedTypeReference<List<AuthorizationServerPolicyRule>>() {};
            ResponseEntity<List<AuthorizationServerPolicyRule>> responseEntity = apiClient.invokeAPI("/api/v1/authorizationServers/{authServerId}/policies/{policyId}/rules", HttpMethod.GET, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                    HttpHeaders headers = responseEntity.getHeaders();
                    PagedList pagedList = new PagedList();
                    List<String> linkHeaders = headers.get("link");
                    String self = null, nextPage = null;
                    for (String link : linkHeaders) {
                    if (link.contains("next")) {
                    nextPage = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    if (link.contains("self")) {
                    self = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    }
                    pagedList.addItems(Arrays.asList(responseEntity.getBody()));
                    if (Objects.nonNull(nextPage)) {
                    pagedList.setNextPage(nextPage);
                    }
                    if (Objects.nonNull(self)) {
                    pagedList.setSelf(self);
                    }
                    return pagedList;
        }

        /**
        * List all Authorization Servers
        * Lists all authorization servers
            * <p><b>200</b> - Success
            * <p><b>403</b> - Forbidden
            * <p><b>429</b> - Too Many Requests
                * @param q  (optional)
                * @param limit  (optional, default to 200)
                * @param after  (optional)
                * @return List&lt;AuthorizationServer&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public List<AuthorizationServer> listAuthorizationServers(String q, Integer limit, String after) throws RestClientException {
                return listAuthorizationServersWithHttpInfo(q, limit, after).getBody();
            }






            /**
            * List all Authorization Servers
            * Lists all authorization servers
                * <p><b>200</b> - Success
                * <p><b>403</b> - Forbidden
                * <p><b>429</b> - Too Many Requests
                * @param q  (optional)
                * @param limit  (optional, default to 200)
                * @param after  (optional)
            * @return ResponseEntity&lt;List&lt;AuthorizationServer&gt;&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<List<AuthorizationServer>> listAuthorizationServersWithHttpInfo(String q, Integer limit, String after) throws RestClientException {
            Object localVarPostBody = null;
        

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "q", q));
            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "limit", limit));
            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "after", after));

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<List<AuthorizationServer>> localReturnType = new ParameterizedTypeReference<List<AuthorizationServer>>() {};
            return apiClient.invokeAPI("/api/v1/authorizationServers", HttpMethod.GET, Collections.<String, Object>emptyMap(), localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }







            /**
            * List all Authorization Servers
            * Lists all authorization servers
                * <p><b>200</b> - Success
                * <p><b>403</b> - Forbidden
                * <p><b>429</b> - Too Many Requests
                * @param q  (optional)
                * @param limit  (optional, default to 200)
                * @param after  (optional)
            * @return ResponseEntity&lt;List&lt;AuthorizationServer&gt;&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public PagedList listAuthorizationServersWithPaginationInfo(String q, Integer limit, String after) throws RestClientException {
            Object localVarPostBody = null;
        

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "q", q));
            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "limit", limit));
            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "after", after));

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<List<AuthorizationServer>> localReturnType = new ParameterizedTypeReference<List<AuthorizationServer>>() {};
            ResponseEntity<List<AuthorizationServer>> responseEntity = apiClient.invokeAPI("/api/v1/authorizationServers", HttpMethod.GET, Collections.<String, Object>emptyMap(), localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                    HttpHeaders headers = responseEntity.getHeaders();
                    PagedList pagedList = new PagedList();
                    List<String> linkHeaders = headers.get("link");
                    String self = null, nextPage = null;
                    for (String link : linkHeaders) {
                    if (link.contains("next")) {
                    nextPage = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    if (link.contains("self")) {
                    self = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    }
                    pagedList.addItems(Arrays.asList(responseEntity.getBody()));
                    if (Objects.nonNull(nextPage)) {
                    pagedList.setNextPage(nextPage);
                    }
                    if (Objects.nonNull(self)) {
                    pagedList.setSelf(self);
                    }
                    return pagedList;
        }

        /**
        * List all Custom Token Claims
        * Lists all custom token claims
            * <p><b>200</b> - Success
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>429</b> - Too Many Requests
                * @param authServerId  (required)
                * @return List&lt;OAuth2Claim&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public List<OAuth2Claim> listOAuth2Claims(String authServerId) throws RestClientException {
                return listOAuth2ClaimsWithHttpInfo(authServerId).getBody();
            }






            /**
            * List all Custom Token Claims
            * Lists all custom token claims
                * <p><b>200</b> - Success
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param authServerId  (required)
            * @return ResponseEntity&lt;List&lt;OAuth2Claim&gt;&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<List<OAuth2Claim>> listOAuth2ClaimsWithHttpInfo(String authServerId) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'authServerId' is set ''
                if (authServerId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'authServerId' when calling listOAuth2Claims");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("authServerId", authServerId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<List<OAuth2Claim>> localReturnType = new ParameterizedTypeReference<List<OAuth2Claim>>() {};
            return apiClient.invokeAPI("/api/v1/authorizationServers/{authServerId}/claims", HttpMethod.GET, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }







            /**
            * List all Custom Token Claims
            * Lists all custom token claims
                * <p><b>200</b> - Success
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param authServerId  (required)
            * @return ResponseEntity&lt;List&lt;OAuth2Claim&gt;&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public PagedList listOAuth2ClaimsWithPaginationInfo(String authServerId) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'authServerId' is set
                if (authServerId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'authServerId' when calling listOAuth2Claims");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("authServerId", authServerId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<List<OAuth2Claim>> localReturnType = new ParameterizedTypeReference<List<OAuth2Claim>>() {};
            ResponseEntity<List<OAuth2Claim>> responseEntity = apiClient.invokeAPI("/api/v1/authorizationServers/{authServerId}/claims", HttpMethod.GET, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                    HttpHeaders headers = responseEntity.getHeaders();
                    PagedList pagedList = new PagedList();
                    List<String> linkHeaders = headers.get("link");
                    String self = null, nextPage = null;
                    for (String link : linkHeaders) {
                    if (link.contains("next")) {
                    nextPage = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    if (link.contains("self")) {
                    self = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    }
                    pagedList.addItems(Arrays.asList(responseEntity.getBody()));
                    if (Objects.nonNull(nextPage)) {
                    pagedList.setNextPage(nextPage);
                    }
                    if (Objects.nonNull(self)) {
                    pagedList.setSelf(self);
                    }
                    return pagedList;
        }

        /**
        * List all Clients
        * Lists all clients
            * <p><b>200</b> - Success
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>429</b> - Too Many Requests
                * @param authServerId  (required)
                * @return List&lt;OAuth2Client&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public List<OAuth2Client> listOAuth2ClientsForAuthorizationServer(String authServerId) throws RestClientException {
                return listOAuth2ClientsForAuthorizationServerWithHttpInfo(authServerId).getBody();
            }






            /**
            * List all Clients
            * Lists all clients
                * <p><b>200</b> - Success
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param authServerId  (required)
            * @return ResponseEntity&lt;List&lt;OAuth2Client&gt;&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<List<OAuth2Client>> listOAuth2ClientsForAuthorizationServerWithHttpInfo(String authServerId) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'authServerId' is set ''
                if (authServerId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'authServerId' when calling listOAuth2ClientsForAuthorizationServer");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("authServerId", authServerId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<List<OAuth2Client>> localReturnType = new ParameterizedTypeReference<List<OAuth2Client>>() {};
            return apiClient.invokeAPI("/api/v1/authorizationServers/{authServerId}/clients", HttpMethod.GET, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }







            /**
            * List all Clients
            * Lists all clients
                * <p><b>200</b> - Success
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param authServerId  (required)
            * @return ResponseEntity&lt;List&lt;OAuth2Client&gt;&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public PagedList listOAuth2ClientsForAuthorizationServerWithPaginationInfo(String authServerId) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'authServerId' is set
                if (authServerId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'authServerId' when calling listOAuth2ClientsForAuthorizationServer");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("authServerId", authServerId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<List<OAuth2Client>> localReturnType = new ParameterizedTypeReference<List<OAuth2Client>>() {};
            ResponseEntity<List<OAuth2Client>> responseEntity = apiClient.invokeAPI("/api/v1/authorizationServers/{authServerId}/clients", HttpMethod.GET, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                    HttpHeaders headers = responseEntity.getHeaders();
                    PagedList pagedList = new PagedList();
                    List<String> linkHeaders = headers.get("link");
                    String self = null, nextPage = null;
                    for (String link : linkHeaders) {
                    if (link.contains("next")) {
                    nextPage = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    if (link.contains("self")) {
                    self = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    }
                    pagedList.addItems(Arrays.asList(responseEntity.getBody()));
                    if (Objects.nonNull(nextPage)) {
                    pagedList.setNextPage(nextPage);
                    }
                    if (Objects.nonNull(self)) {
                    pagedList.setSelf(self);
                    }
                    return pagedList;
        }

        /**
        * List all Custom Token Scopes
        * Lists all custom token scopes
            * <p><b>200</b> - Success
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>429</b> - Too Many Requests
                * @param authServerId  (required)
                * @param q  (optional)
                * @param filter  (optional)
                * @param cursor  (optional)
                * @param limit  (optional, default to -1)
                * @return List&lt;OAuth2Scope&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public List<OAuth2Scope> listOAuth2Scopes(String authServerId, String q, String filter, String cursor, Integer limit) throws RestClientException {
                return listOAuth2ScopesWithHttpInfo(authServerId, q, filter, cursor, limit).getBody();
            }






            /**
            * List all Custom Token Scopes
            * Lists all custom token scopes
                * <p><b>200</b> - Success
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param authServerId  (required)
                * @param q  (optional)
                * @param filter  (optional)
                * @param cursor  (optional)
                * @param limit  (optional, default to -1)
            * @return ResponseEntity&lt;List&lt;OAuth2Scope&gt;&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<List<OAuth2Scope>> listOAuth2ScopesWithHttpInfo(String authServerId, String q, String filter, String cursor, Integer limit) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'authServerId' is set ''
                if (authServerId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'authServerId' when calling listOAuth2Scopes");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("authServerId", authServerId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "q", q));
            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "filter", filter));
            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "cursor", cursor));
            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "limit", limit));

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<List<OAuth2Scope>> localReturnType = new ParameterizedTypeReference<List<OAuth2Scope>>() {};
            return apiClient.invokeAPI("/api/v1/authorizationServers/{authServerId}/scopes", HttpMethod.GET, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }







            /**
            * List all Custom Token Scopes
            * Lists all custom token scopes
                * <p><b>200</b> - Success
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param authServerId  (required)
                * @param q  (optional)
                * @param filter  (optional)
                * @param cursor  (optional)
                * @param limit  (optional, default to -1)
            * @return ResponseEntity&lt;List&lt;OAuth2Scope&gt;&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public PagedList listOAuth2ScopesWithPaginationInfo(String authServerId, String q, String filter, String cursor, Integer limit) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'authServerId' is set
                if (authServerId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'authServerId' when calling listOAuth2Scopes");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("authServerId", authServerId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "q", q));
            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "filter", filter));
            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "cursor", cursor));
            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "limit", limit));

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<List<OAuth2Scope>> localReturnType = new ParameterizedTypeReference<List<OAuth2Scope>>() {};
            ResponseEntity<List<OAuth2Scope>> responseEntity = apiClient.invokeAPI("/api/v1/authorizationServers/{authServerId}/scopes", HttpMethod.GET, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                    HttpHeaders headers = responseEntity.getHeaders();
                    PagedList pagedList = new PagedList();
                    List<String> linkHeaders = headers.get("link");
                    String self = null, nextPage = null;
                    for (String link : linkHeaders) {
                    if (link.contains("next")) {
                    nextPage = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    if (link.contains("self")) {
                    self = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    }
                    pagedList.addItems(Arrays.asList(responseEntity.getBody()));
                    if (Objects.nonNull(nextPage)) {
                    pagedList.setNextPage(nextPage);
                    }
                    if (Objects.nonNull(self)) {
                    pagedList.setSelf(self);
                    }
                    return pagedList;
        }

        /**
        * List all Refresh Tokens for a Client
        * Lists all refresh tokens for a client
            * <p><b>200</b> - Success
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>429</b> - Too Many Requests
                * @param authServerId  (required)
                * @param clientId  (required)
                * @param expand  (optional)
                * @param after  (optional)
                * @param limit  (optional, default to -1)
                * @return List&lt;OAuth2RefreshToken&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public List<OAuth2RefreshToken> listRefreshTokensForAuthorizationServerAndClient(String authServerId, String clientId, String expand, String after, Integer limit) throws RestClientException {
                return listRefreshTokensForAuthorizationServerAndClientWithHttpInfo(authServerId, clientId, expand, after, limit).getBody();
            }






            /**
            * List all Refresh Tokens for a Client
            * Lists all refresh tokens for a client
                * <p><b>200</b> - Success
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param authServerId  (required)
                * @param clientId  (required)
                * @param expand  (optional)
                * @param after  (optional)
                * @param limit  (optional, default to -1)
            * @return ResponseEntity&lt;List&lt;OAuth2RefreshToken&gt;&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<List<OAuth2RefreshToken>> listRefreshTokensForAuthorizationServerAndClientWithHttpInfo(String authServerId, String clientId, String expand, String after, Integer limit) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'authServerId' is set ''
                if (authServerId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'authServerId' when calling listRefreshTokensForAuthorizationServerAndClient");
                }
        
                // verify the required parameter 'clientId' is set ''
                if (clientId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'clientId' when calling listRefreshTokensForAuthorizationServerAndClient");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("authServerId", authServerId);
                    uriVariables.put("clientId", clientId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "expand", expand));
            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "after", after));
            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "limit", limit));

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<List<OAuth2RefreshToken>> localReturnType = new ParameterizedTypeReference<List<OAuth2RefreshToken>>() {};
            return apiClient.invokeAPI("/api/v1/authorizationServers/{authServerId}/clients/{clientId}/tokens", HttpMethod.GET, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }







            /**
            * List all Refresh Tokens for a Client
            * Lists all refresh tokens for a client
                * <p><b>200</b> - Success
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param authServerId  (required)
                * @param clientId  (required)
                * @param expand  (optional)
                * @param after  (optional)
                * @param limit  (optional, default to -1)
            * @return ResponseEntity&lt;List&lt;OAuth2RefreshToken&gt;&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public PagedList listRefreshTokensForAuthorizationServerAndClientWithPaginationInfo(String authServerId, String clientId, String expand, String after, Integer limit) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'authServerId' is set
                if (authServerId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'authServerId' when calling listRefreshTokensForAuthorizationServerAndClient");
                }
        
                // verify the required parameter 'clientId' is set
                if (clientId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'clientId' when calling listRefreshTokensForAuthorizationServerAndClient");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("authServerId", authServerId);
                    uriVariables.put("clientId", clientId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "expand", expand));
            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "after", after));
            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "limit", limit));

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<List<OAuth2RefreshToken>> localReturnType = new ParameterizedTypeReference<List<OAuth2RefreshToken>>() {};
            ResponseEntity<List<OAuth2RefreshToken>> responseEntity = apiClient.invokeAPI("/api/v1/authorizationServers/{authServerId}/clients/{clientId}/tokens", HttpMethod.GET, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                    HttpHeaders headers = responseEntity.getHeaders();
                    PagedList pagedList = new PagedList();
                    List<String> linkHeaders = headers.get("link");
                    String self = null, nextPage = null;
                    for (String link : linkHeaders) {
                    if (link.contains("next")) {
                    nextPage = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    if (link.contains("self")) {
                    self = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    }
                    pagedList.addItems(Arrays.asList(responseEntity.getBody()));
                    if (Objects.nonNull(nextPage)) {
                    pagedList.setNextPage(nextPage);
                    }
                    if (Objects.nonNull(self)) {
                    pagedList.setSelf(self);
                    }
                    return pagedList;
        }

        /**
        * Replace an Authorization Server
        * Replace an authorization server
            * <p><b>200</b> - Success
            * <p><b>400</b> - Bad Request
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>429</b> - Too Many Requests
                * @param authServerId  (required)
                * @param authorizationServer  (required)
                * @return AuthorizationServer
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public AuthorizationServer replaceAuthorizationServer(String authServerId, AuthorizationServer authorizationServer) throws RestClientException {
                return replaceAuthorizationServerWithHttpInfo(authServerId, authorizationServer).getBody();
            }




            /**
            * Replace an Authorization Server
            * Replace an authorization server
                * <p><b>200</b> - Success
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param T (required) - the assignable return type
                * @param authServerId  (required)
                * @param authorizationServer  (required)
                * @return T instance
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public <T> T replaceAuthorizationServer(Class<?> T, String authServerId, AuthorizationServer authorizationServer) throws RestClientException {
                return (T) getObjectMapper().convertValue(replaceAuthorizationServerWithReturnType(T, authServerId, authorizationServer).getBody(), T);
            }




            /**
            * Replace an Authorization Server
            * Replace an authorization server
                * <p><b>200</b> - Success
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param authServerId  (required)
                * @param authorizationServer  (required)
            * @return ResponseEntity&lt;AuthorizationServer&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<AuthorizationServer> replaceAuthorizationServerWithHttpInfo(String authServerId, AuthorizationServer authorizationServer) throws RestClientException {
            Object localVarPostBody = authorizationServer;
        
                // verify the required parameter 'authServerId' is set ''
                if (authServerId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'authServerId' when calling replaceAuthorizationServer");
                }
        
                // verify the required parameter 'authorizationServer' is set ''
                if (authorizationServer == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'authorizationServer' when calling replaceAuthorizationServer");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("authServerId", authServerId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = { 
            "application/json"
         };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<AuthorizationServer> localReturnType = new ParameterizedTypeReference<AuthorizationServer>() {};
            return apiClient.invokeAPI("/api/v1/authorizationServers/{authServerId}", HttpMethod.PUT, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }




            /**
            * Replace an Authorization Server
            * Replace an authorization server
                * <p><b>200</b> - Success
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param authServerId  (required)
                * @param authorizationServer  (required)
            * @return ResponseEntity&lt;AuthorizationServer&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private <T> ResponseEntity<T> replaceAuthorizationServerWithReturnType(Class<?> T, String authServerId,AuthorizationServer authorizationServer) throws RestClientException {
            Object localVarPostBody = authorizationServer;
        
                // verify the required parameter 'authServerId' is set
                if (authServerId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'authServerId' when calling replaceAuthorizationServer");
                }
        
                // verify the required parameter 'authorizationServer' is set
                if (authorizationServer == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'authorizationServer' when calling replaceAuthorizationServer");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("authServerId", authServerId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = { 
            "application/json"
         };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<T> localReturnType = new ParameterizedTypeReference<T>() {};
            return apiClient.invokeAPI("/api/v1/authorizationServers/{authServerId}", HttpMethod.PUT, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }




            /**
            * Replace an Authorization Server
            * Replace an authorization server
                * <p><b>200</b> - Success
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param authServerId  (required)
                * @param authorizationServer  (required)
            * @return ResponseEntity&lt;AuthorizationServer&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public PagedList replaceAuthorizationServerWithPaginationInfo(String authServerId, AuthorizationServer authorizationServer) throws RestClientException {
            Object localVarPostBody = authorizationServer;
        
                // verify the required parameter 'authServerId' is set
                if (authServerId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'authServerId' when calling replaceAuthorizationServer");
                }
        
                // verify the required parameter 'authorizationServer' is set
                if (authorizationServer == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'authorizationServer' when calling replaceAuthorizationServer");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("authServerId", authServerId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = { 
            "application/json"
         };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<AuthorizationServer> localReturnType = new ParameterizedTypeReference<AuthorizationServer>() {};
            ResponseEntity<AuthorizationServer> responseEntity = apiClient.invokeAPI("/api/v1/authorizationServers/{authServerId}", HttpMethod.PUT, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                    HttpHeaders headers = responseEntity.getHeaders();
                    PagedList pagedList = new PagedList();
                    List<String> linkHeaders = headers.get("link");
                    String self = null, nextPage = null;
                    for (String link : linkHeaders) {
                    if (link.contains("next")) {
                    nextPage = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    if (link.contains("self")) {
                    self = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    }
                    pagedList.addItems(Arrays.asList(responseEntity.getBody()));
                    if (Objects.nonNull(nextPage)) {
                    pagedList.setNextPage(nextPage);
                    }
                    if (Objects.nonNull(self)) {
                    pagedList.setSelf(self);
                    }
                    return pagedList;
        }

        /**
        * Replace a Policy
        * Replaces a policy
            * <p><b>200</b> - Success
            * <p><b>400</b> - Bad Request
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>429</b> - Too Many Requests
                * @param authServerId  (required)
                * @param policyId  (required)
                * @param policy  (required)
                * @return AuthorizationServerPolicy
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public AuthorizationServerPolicy replaceAuthorizationServerPolicy(String authServerId, String policyId, AuthorizationServerPolicy policy) throws RestClientException {
                return replaceAuthorizationServerPolicyWithHttpInfo(authServerId, policyId, policy).getBody();
            }




            /**
            * Replace a Policy
            * Replaces a policy
                * <p><b>200</b> - Success
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param T (required) - the assignable return type
                * @param authServerId  (required)
                * @param policyId  (required)
                * @param policy  (required)
                * @return T instance
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public <T> T replaceAuthorizationServerPolicy(Class<?> T, String authServerId, String policyId, AuthorizationServerPolicy policy) throws RestClientException {
                return (T) getObjectMapper().convertValue(replaceAuthorizationServerPolicyWithReturnType(T, authServerId, policyId, policy).getBody(), T);
            }




            /**
            * Replace a Policy
            * Replaces a policy
                * <p><b>200</b> - Success
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param authServerId  (required)
                * @param policyId  (required)
                * @param policy  (required)
            * @return ResponseEntity&lt;AuthorizationServerPolicy&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<AuthorizationServerPolicy> replaceAuthorizationServerPolicyWithHttpInfo(String authServerId, String policyId, AuthorizationServerPolicy policy) throws RestClientException {
            Object localVarPostBody = policy;
        
                // verify the required parameter 'authServerId' is set ''
                if (authServerId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'authServerId' when calling replaceAuthorizationServerPolicy");
                }
        
                // verify the required parameter 'policyId' is set ''
                if (policyId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'policyId' when calling replaceAuthorizationServerPolicy");
                }
        
                // verify the required parameter 'policy' is set ''
                if (policy == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'policy' when calling replaceAuthorizationServerPolicy");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("authServerId", authServerId);
                    uriVariables.put("policyId", policyId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = { 
            "application/json"
         };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<AuthorizationServerPolicy> localReturnType = new ParameterizedTypeReference<AuthorizationServerPolicy>() {};
            return apiClient.invokeAPI("/api/v1/authorizationServers/{authServerId}/policies/{policyId}", HttpMethod.PUT, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }




            /**
            * Replace a Policy
            * Replaces a policy
                * <p><b>200</b> - Success
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param authServerId  (required)
                * @param policyId  (required)
                * @param policy  (required)
            * @return ResponseEntity&lt;AuthorizationServerPolicy&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private <T> ResponseEntity<T> replaceAuthorizationServerPolicyWithReturnType(Class<?> T, String authServerId,String policyId,AuthorizationServerPolicy policy) throws RestClientException {
            Object localVarPostBody = policy;
        
                // verify the required parameter 'authServerId' is set
                if (authServerId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'authServerId' when calling replaceAuthorizationServerPolicy");
                }
        
                // verify the required parameter 'policyId' is set
                if (policyId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'policyId' when calling replaceAuthorizationServerPolicy");
                }
        
                // verify the required parameter 'policy' is set
                if (policy == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'policy' when calling replaceAuthorizationServerPolicy");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("authServerId", authServerId);
                    uriVariables.put("policyId", policyId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = { 
            "application/json"
         };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<T> localReturnType = new ParameterizedTypeReference<T>() {};
            return apiClient.invokeAPI("/api/v1/authorizationServers/{authServerId}/policies/{policyId}", HttpMethod.PUT, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }




            /**
            * Replace a Policy
            * Replaces a policy
                * <p><b>200</b> - Success
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param authServerId  (required)
                * @param policyId  (required)
                * @param policy  (required)
            * @return ResponseEntity&lt;AuthorizationServerPolicy&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public PagedList replaceAuthorizationServerPolicyWithPaginationInfo(String authServerId, String policyId, AuthorizationServerPolicy policy) throws RestClientException {
            Object localVarPostBody = policy;
        
                // verify the required parameter 'authServerId' is set
                if (authServerId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'authServerId' when calling replaceAuthorizationServerPolicy");
                }
        
                // verify the required parameter 'policyId' is set
                if (policyId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'policyId' when calling replaceAuthorizationServerPolicy");
                }
        
                // verify the required parameter 'policy' is set
                if (policy == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'policy' when calling replaceAuthorizationServerPolicy");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("authServerId", authServerId);
                    uriVariables.put("policyId", policyId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = { 
            "application/json"
         };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<AuthorizationServerPolicy> localReturnType = new ParameterizedTypeReference<AuthorizationServerPolicy>() {};
            ResponseEntity<AuthorizationServerPolicy> responseEntity = apiClient.invokeAPI("/api/v1/authorizationServers/{authServerId}/policies/{policyId}", HttpMethod.PUT, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                    HttpHeaders headers = responseEntity.getHeaders();
                    PagedList pagedList = new PagedList();
                    List<String> linkHeaders = headers.get("link");
                    String self = null, nextPage = null;
                    for (String link : linkHeaders) {
                    if (link.contains("next")) {
                    nextPage = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    if (link.contains("self")) {
                    self = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    }
                    pagedList.addItems(Arrays.asList(responseEntity.getBody()));
                    if (Objects.nonNull(nextPage)) {
                    pagedList.setNextPage(nextPage);
                    }
                    if (Objects.nonNull(self)) {
                    pagedList.setSelf(self);
                    }
                    return pagedList;
        }

        /**
        * Replace a Policy Rule
        * Replaces the configuration of the Policy Rule defined in the specified Custom Authorization Server and Policy
            * <p><b>200</b> - Success
            * <p><b>400</b> - Bad Request
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>429</b> - Too Many Requests
                * @param policyId  (required)
                * @param authServerId  (required)
                * @param ruleId  (required)
                * @param policyRule  (required)
                * @return AuthorizationServerPolicyRule
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public AuthorizationServerPolicyRule replaceAuthorizationServerPolicyRule(String policyId, String authServerId, String ruleId, AuthorizationServerPolicyRule policyRule) throws RestClientException {
                return replaceAuthorizationServerPolicyRuleWithHttpInfo(policyId, authServerId, ruleId, policyRule).getBody();
            }




            /**
            * Replace a Policy Rule
            * Replaces the configuration of the Policy Rule defined in the specified Custom Authorization Server and Policy
                * <p><b>200</b> - Success
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param T (required) - the assignable return type
                * @param policyId  (required)
                * @param authServerId  (required)
                * @param ruleId  (required)
                * @param policyRule  (required)
                * @return T instance
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public <T> T replaceAuthorizationServerPolicyRule(Class<?> T, String policyId, String authServerId, String ruleId, AuthorizationServerPolicyRule policyRule) throws RestClientException {
                return (T) getObjectMapper().convertValue(replaceAuthorizationServerPolicyRuleWithReturnType(T, policyId, authServerId, ruleId, policyRule).getBody(), T);
            }




            /**
            * Replace a Policy Rule
            * Replaces the configuration of the Policy Rule defined in the specified Custom Authorization Server and Policy
                * <p><b>200</b> - Success
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param policyId  (required)
                * @param authServerId  (required)
                * @param ruleId  (required)
                * @param policyRule  (required)
            * @return ResponseEntity&lt;AuthorizationServerPolicyRule&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<AuthorizationServerPolicyRule> replaceAuthorizationServerPolicyRuleWithHttpInfo(String policyId, String authServerId, String ruleId, AuthorizationServerPolicyRule policyRule) throws RestClientException {
            Object localVarPostBody = policyRule;
        
                // verify the required parameter 'policyId' is set ''
                if (policyId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'policyId' when calling replaceAuthorizationServerPolicyRule");
                }
        
                // verify the required parameter 'authServerId' is set ''
                if (authServerId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'authServerId' when calling replaceAuthorizationServerPolicyRule");
                }
        
                // verify the required parameter 'ruleId' is set ''
                if (ruleId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'ruleId' when calling replaceAuthorizationServerPolicyRule");
                }
        
                // verify the required parameter 'policyRule' is set ''
                if (policyRule == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'policyRule' when calling replaceAuthorizationServerPolicyRule");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("policyId", policyId);
                    uriVariables.put("authServerId", authServerId);
                    uriVariables.put("ruleId", ruleId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = { 
            "application/json"
         };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<AuthorizationServerPolicyRule> localReturnType = new ParameterizedTypeReference<AuthorizationServerPolicyRule>() {};
            return apiClient.invokeAPI("/api/v1/authorizationServers/{authServerId}/policies/{policyId}/rules/{ruleId}", HttpMethod.PUT, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }




            /**
            * Replace a Policy Rule
            * Replaces the configuration of the Policy Rule defined in the specified Custom Authorization Server and Policy
                * <p><b>200</b> - Success
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param policyId  (required)
                * @param authServerId  (required)
                * @param ruleId  (required)
                * @param policyRule  (required)
            * @return ResponseEntity&lt;AuthorizationServerPolicyRule&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private <T> ResponseEntity<T> replaceAuthorizationServerPolicyRuleWithReturnType(Class<?> T, String policyId,String authServerId,String ruleId,AuthorizationServerPolicyRule policyRule) throws RestClientException {
            Object localVarPostBody = policyRule;
        
                // verify the required parameter 'policyId' is set
                if (policyId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'policyId' when calling replaceAuthorizationServerPolicyRule");
                }
        
                // verify the required parameter 'authServerId' is set
                if (authServerId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'authServerId' when calling replaceAuthorizationServerPolicyRule");
                }
        
                // verify the required parameter 'ruleId' is set
                if (ruleId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'ruleId' when calling replaceAuthorizationServerPolicyRule");
                }
        
                // verify the required parameter 'policyRule' is set
                if (policyRule == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'policyRule' when calling replaceAuthorizationServerPolicyRule");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("policyId", policyId);
                    uriVariables.put("authServerId", authServerId);
                    uriVariables.put("ruleId", ruleId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = { 
            "application/json"
         };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<T> localReturnType = new ParameterizedTypeReference<T>() {};
            return apiClient.invokeAPI("/api/v1/authorizationServers/{authServerId}/policies/{policyId}/rules/{ruleId}", HttpMethod.PUT, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }




            /**
            * Replace a Policy Rule
            * Replaces the configuration of the Policy Rule defined in the specified Custom Authorization Server and Policy
                * <p><b>200</b> - Success
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param policyId  (required)
                * @param authServerId  (required)
                * @param ruleId  (required)
                * @param policyRule  (required)
            * @return ResponseEntity&lt;AuthorizationServerPolicyRule&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public PagedList replaceAuthorizationServerPolicyRuleWithPaginationInfo(String policyId, String authServerId, String ruleId, AuthorizationServerPolicyRule policyRule) throws RestClientException {
            Object localVarPostBody = policyRule;
        
                // verify the required parameter 'policyId' is set
                if (policyId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'policyId' when calling replaceAuthorizationServerPolicyRule");
                }
        
                // verify the required parameter 'authServerId' is set
                if (authServerId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'authServerId' when calling replaceAuthorizationServerPolicyRule");
                }
        
                // verify the required parameter 'ruleId' is set
                if (ruleId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'ruleId' when calling replaceAuthorizationServerPolicyRule");
                }
        
                // verify the required parameter 'policyRule' is set
                if (policyRule == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'policyRule' when calling replaceAuthorizationServerPolicyRule");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("policyId", policyId);
                    uriVariables.put("authServerId", authServerId);
                    uriVariables.put("ruleId", ruleId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = { 
            "application/json"
         };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<AuthorizationServerPolicyRule> localReturnType = new ParameterizedTypeReference<AuthorizationServerPolicyRule>() {};
            ResponseEntity<AuthorizationServerPolicyRule> responseEntity = apiClient.invokeAPI("/api/v1/authorizationServers/{authServerId}/policies/{policyId}/rules/{ruleId}", HttpMethod.PUT, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                    HttpHeaders headers = responseEntity.getHeaders();
                    PagedList pagedList = new PagedList();
                    List<String> linkHeaders = headers.get("link");
                    String self = null, nextPage = null;
                    for (String link : linkHeaders) {
                    if (link.contains("next")) {
                    nextPage = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    if (link.contains("self")) {
                    self = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    }
                    pagedList.addItems(Arrays.asList(responseEntity.getBody()));
                    if (Objects.nonNull(nextPage)) {
                    pagedList.setNextPage(nextPage);
                    }
                    if (Objects.nonNull(self)) {
                    pagedList.setSelf(self);
                    }
                    return pagedList;
        }

        /**
        * Replace a Custom Token Claim
        * Replace a custom token claim
            * <p><b>200</b> - Success
            * <p><b>400</b> - Bad Request
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>429</b> - Too Many Requests
                * @param authServerId  (required)
                * @param claimId  (required)
                * @param oAuth2Claim  (required)
                * @return OAuth2Claim
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public OAuth2Claim replaceOAuth2Claim(String authServerId, String claimId, OAuth2Claim oAuth2Claim) throws RestClientException {
                return replaceOAuth2ClaimWithHttpInfo(authServerId, claimId, oAuth2Claim).getBody();
            }




            /**
            * Replace a Custom Token Claim
            * Replace a custom token claim
                * <p><b>200</b> - Success
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param T (required) - the assignable return type
                * @param authServerId  (required)
                * @param claimId  (required)
                * @param oAuth2Claim  (required)
                * @return T instance
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public <T> T replaceOAuth2Claim(Class<?> T, String authServerId, String claimId, OAuth2Claim oAuth2Claim) throws RestClientException {
                return (T) getObjectMapper().convertValue(replaceOAuth2ClaimWithReturnType(T, authServerId, claimId, oAuth2Claim).getBody(), T);
            }




            /**
            * Replace a Custom Token Claim
            * Replace a custom token claim
                * <p><b>200</b> - Success
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param authServerId  (required)
                * @param claimId  (required)
                * @param oAuth2Claim  (required)
            * @return ResponseEntity&lt;OAuth2Claim&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<OAuth2Claim> replaceOAuth2ClaimWithHttpInfo(String authServerId, String claimId, OAuth2Claim oAuth2Claim) throws RestClientException {
            Object localVarPostBody = oAuth2Claim;
        
                // verify the required parameter 'authServerId' is set ''
                if (authServerId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'authServerId' when calling replaceOAuth2Claim");
                }
        
                // verify the required parameter 'claimId' is set ''
                if (claimId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'claimId' when calling replaceOAuth2Claim");
                }
        
                // verify the required parameter 'oAuth2Claim' is set ''
                if (oAuth2Claim == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'oAuth2Claim' when calling replaceOAuth2Claim");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("authServerId", authServerId);
                    uriVariables.put("claimId", claimId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = { 
            "application/json"
         };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<OAuth2Claim> localReturnType = new ParameterizedTypeReference<OAuth2Claim>() {};
            return apiClient.invokeAPI("/api/v1/authorizationServers/{authServerId}/claims/{claimId}", HttpMethod.PUT, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }




            /**
            * Replace a Custom Token Claim
            * Replace a custom token claim
                * <p><b>200</b> - Success
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param authServerId  (required)
                * @param claimId  (required)
                * @param oAuth2Claim  (required)
            * @return ResponseEntity&lt;OAuth2Claim&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private <T> ResponseEntity<T> replaceOAuth2ClaimWithReturnType(Class<?> T, String authServerId,String claimId,OAuth2Claim oAuth2Claim) throws RestClientException {
            Object localVarPostBody = oAuth2Claim;
        
                // verify the required parameter 'authServerId' is set
                if (authServerId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'authServerId' when calling replaceOAuth2Claim");
                }
        
                // verify the required parameter 'claimId' is set
                if (claimId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'claimId' when calling replaceOAuth2Claim");
                }
        
                // verify the required parameter 'oAuth2Claim' is set
                if (oAuth2Claim == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'oAuth2Claim' when calling replaceOAuth2Claim");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("authServerId", authServerId);
                    uriVariables.put("claimId", claimId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = { 
            "application/json"
         };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<T> localReturnType = new ParameterizedTypeReference<T>() {};
            return apiClient.invokeAPI("/api/v1/authorizationServers/{authServerId}/claims/{claimId}", HttpMethod.PUT, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }




            /**
            * Replace a Custom Token Claim
            * Replace a custom token claim
                * <p><b>200</b> - Success
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param authServerId  (required)
                * @param claimId  (required)
                * @param oAuth2Claim  (required)
            * @return ResponseEntity&lt;OAuth2Claim&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public PagedList replaceOAuth2ClaimWithPaginationInfo(String authServerId, String claimId, OAuth2Claim oAuth2Claim) throws RestClientException {
            Object localVarPostBody = oAuth2Claim;
        
                // verify the required parameter 'authServerId' is set
                if (authServerId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'authServerId' when calling replaceOAuth2Claim");
                }
        
                // verify the required parameter 'claimId' is set
                if (claimId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'claimId' when calling replaceOAuth2Claim");
                }
        
                // verify the required parameter 'oAuth2Claim' is set
                if (oAuth2Claim == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'oAuth2Claim' when calling replaceOAuth2Claim");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("authServerId", authServerId);
                    uriVariables.put("claimId", claimId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = { 
            "application/json"
         };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<OAuth2Claim> localReturnType = new ParameterizedTypeReference<OAuth2Claim>() {};
            ResponseEntity<OAuth2Claim> responseEntity = apiClient.invokeAPI("/api/v1/authorizationServers/{authServerId}/claims/{claimId}", HttpMethod.PUT, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                    HttpHeaders headers = responseEntity.getHeaders();
                    PagedList pagedList = new PagedList();
                    List<String> linkHeaders = headers.get("link");
                    String self = null, nextPage = null;
                    for (String link : linkHeaders) {
                    if (link.contains("next")) {
                    nextPage = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    if (link.contains("self")) {
                    self = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    }
                    pagedList.addItems(Arrays.asList(responseEntity.getBody()));
                    if (Objects.nonNull(nextPage)) {
                    pagedList.setNextPage(nextPage);
                    }
                    if (Objects.nonNull(self)) {
                    pagedList.setSelf(self);
                    }
                    return pagedList;
        }

        /**
        * Replace a Custom Token Scope
        * Replace a custom token scope
            * <p><b>200</b> - Success
            * <p><b>400</b> - Bad Request
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>429</b> - Too Many Requests
                * @param authServerId  (required)
                * @param scopeId  (required)
                * @param oAuth2Scope  (required)
                * @return OAuth2Scope
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public OAuth2Scope replaceOAuth2Scope(String authServerId, String scopeId, OAuth2Scope oAuth2Scope) throws RestClientException {
                return replaceOAuth2ScopeWithHttpInfo(authServerId, scopeId, oAuth2Scope).getBody();
            }




            /**
            * Replace a Custom Token Scope
            * Replace a custom token scope
                * <p><b>200</b> - Success
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param T (required) - the assignable return type
                * @param authServerId  (required)
                * @param scopeId  (required)
                * @param oAuth2Scope  (required)
                * @return T instance
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public <T> T replaceOAuth2Scope(Class<?> T, String authServerId, String scopeId, OAuth2Scope oAuth2Scope) throws RestClientException {
                return (T) getObjectMapper().convertValue(replaceOAuth2ScopeWithReturnType(T, authServerId, scopeId, oAuth2Scope).getBody(), T);
            }




            /**
            * Replace a Custom Token Scope
            * Replace a custom token scope
                * <p><b>200</b> - Success
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param authServerId  (required)
                * @param scopeId  (required)
                * @param oAuth2Scope  (required)
            * @return ResponseEntity&lt;OAuth2Scope&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<OAuth2Scope> replaceOAuth2ScopeWithHttpInfo(String authServerId, String scopeId, OAuth2Scope oAuth2Scope) throws RestClientException {
            Object localVarPostBody = oAuth2Scope;
        
                // verify the required parameter 'authServerId' is set ''
                if (authServerId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'authServerId' when calling replaceOAuth2Scope");
                }
        
                // verify the required parameter 'scopeId' is set ''
                if (scopeId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'scopeId' when calling replaceOAuth2Scope");
                }
        
                // verify the required parameter 'oAuth2Scope' is set ''
                if (oAuth2Scope == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'oAuth2Scope' when calling replaceOAuth2Scope");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("authServerId", authServerId);
                    uriVariables.put("scopeId", scopeId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = { 
            "application/json"
         };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<OAuth2Scope> localReturnType = new ParameterizedTypeReference<OAuth2Scope>() {};
            return apiClient.invokeAPI("/api/v1/authorizationServers/{authServerId}/scopes/{scopeId}", HttpMethod.PUT, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }




            /**
            * Replace a Custom Token Scope
            * Replace a custom token scope
                * <p><b>200</b> - Success
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param authServerId  (required)
                * @param scopeId  (required)
                * @param oAuth2Scope  (required)
            * @return ResponseEntity&lt;OAuth2Scope&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private <T> ResponseEntity<T> replaceOAuth2ScopeWithReturnType(Class<?> T, String authServerId,String scopeId,OAuth2Scope oAuth2Scope) throws RestClientException {
            Object localVarPostBody = oAuth2Scope;
        
                // verify the required parameter 'authServerId' is set
                if (authServerId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'authServerId' when calling replaceOAuth2Scope");
                }
        
                // verify the required parameter 'scopeId' is set
                if (scopeId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'scopeId' when calling replaceOAuth2Scope");
                }
        
                // verify the required parameter 'oAuth2Scope' is set
                if (oAuth2Scope == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'oAuth2Scope' when calling replaceOAuth2Scope");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("authServerId", authServerId);
                    uriVariables.put("scopeId", scopeId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = { 
            "application/json"
         };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<T> localReturnType = new ParameterizedTypeReference<T>() {};
            return apiClient.invokeAPI("/api/v1/authorizationServers/{authServerId}/scopes/{scopeId}", HttpMethod.PUT, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }




            /**
            * Replace a Custom Token Scope
            * Replace a custom token scope
                * <p><b>200</b> - Success
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param authServerId  (required)
                * @param scopeId  (required)
                * @param oAuth2Scope  (required)
            * @return ResponseEntity&lt;OAuth2Scope&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public PagedList replaceOAuth2ScopeWithPaginationInfo(String authServerId, String scopeId, OAuth2Scope oAuth2Scope) throws RestClientException {
            Object localVarPostBody = oAuth2Scope;
        
                // verify the required parameter 'authServerId' is set
                if (authServerId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'authServerId' when calling replaceOAuth2Scope");
                }
        
                // verify the required parameter 'scopeId' is set
                if (scopeId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'scopeId' when calling replaceOAuth2Scope");
                }
        
                // verify the required parameter 'oAuth2Scope' is set
                if (oAuth2Scope == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'oAuth2Scope' when calling replaceOAuth2Scope");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("authServerId", authServerId);
                    uriVariables.put("scopeId", scopeId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = { 
            "application/json"
         };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<OAuth2Scope> localReturnType = new ParameterizedTypeReference<OAuth2Scope>() {};
            ResponseEntity<OAuth2Scope> responseEntity = apiClient.invokeAPI("/api/v1/authorizationServers/{authServerId}/scopes/{scopeId}", HttpMethod.PUT, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                    HttpHeaders headers = responseEntity.getHeaders();
                    PagedList pagedList = new PagedList();
                    List<String> linkHeaders = headers.get("link");
                    String self = null, nextPage = null;
                    for (String link : linkHeaders) {
                    if (link.contains("next")) {
                    nextPage = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    if (link.contains("self")) {
                    self = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    }
                    pagedList.addItems(Arrays.asList(responseEntity.getBody()));
                    if (Objects.nonNull(nextPage)) {
                    pagedList.setNextPage(nextPage);
                    }
                    if (Objects.nonNull(self)) {
                    pagedList.setSelf(self);
                    }
                    return pagedList;
        }

        /**
        * Revoke a Refresh Token for a Client
        * Revoke a refresh token for a client
            * <p><b>204</b> - No Content
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>429</b> - Too Many Requests
                * @param authServerId  (required)
                * @param clientId  (required)
                * @param tokenId  (required)
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public void revokeRefreshTokenForAuthorizationServerAndClient(String authServerId, String clientId, String tokenId) throws RestClientException {
            revokeRefreshTokenForAuthorizationServerAndClientWithHttpInfo(authServerId, clientId, tokenId);
            }






            /**
            * Revoke a Refresh Token for a Client
            * Revoke a refresh token for a client
                * <p><b>204</b> - No Content
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param authServerId  (required)
                * @param clientId  (required)
                * @param tokenId  (required)
            * @return ResponseEntity&lt;Void&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<Void> revokeRefreshTokenForAuthorizationServerAndClientWithHttpInfo(String authServerId, String clientId, String tokenId) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'authServerId' is set ''
                if (authServerId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'authServerId' when calling revokeRefreshTokenForAuthorizationServerAndClient");
                }
        
                // verify the required parameter 'clientId' is set ''
                if (clientId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'clientId' when calling revokeRefreshTokenForAuthorizationServerAndClient");
                }
        
                // verify the required parameter 'tokenId' is set ''
                if (tokenId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'tokenId' when calling revokeRefreshTokenForAuthorizationServerAndClient");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("authServerId", authServerId);
                    uriVariables.put("clientId", clientId);
                    uriVariables.put("tokenId", tokenId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<Void> localReturnType = new ParameterizedTypeReference<Void>() {};
            return apiClient.invokeAPI("/api/v1/authorizationServers/{authServerId}/clients/{clientId}/tokens/{tokenId}", HttpMethod.DELETE, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }







        /**
        * Revoke all Refresh Tokens for a Client
        * Revoke all refresh tokens for a client
            * <p><b>204</b> - No Content
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>429</b> - Too Many Requests
                * @param authServerId  (required)
                * @param clientId  (required)
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public void revokeRefreshTokensForAuthorizationServerAndClient(String authServerId, String clientId) throws RestClientException {
            revokeRefreshTokensForAuthorizationServerAndClientWithHttpInfo(authServerId, clientId);
            }






            /**
            * Revoke all Refresh Tokens for a Client
            * Revoke all refresh tokens for a client
                * <p><b>204</b> - No Content
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param authServerId  (required)
                * @param clientId  (required)
            * @return ResponseEntity&lt;Void&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<Void> revokeRefreshTokensForAuthorizationServerAndClientWithHttpInfo(String authServerId, String clientId) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'authServerId' is set ''
                if (authServerId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'authServerId' when calling revokeRefreshTokensForAuthorizationServerAndClient");
                }
        
                // verify the required parameter 'clientId' is set ''
                if (clientId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'clientId' when calling revokeRefreshTokensForAuthorizationServerAndClient");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("authServerId", authServerId);
                    uriVariables.put("clientId", clientId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<Void> localReturnType = new ParameterizedTypeReference<Void>() {};
            return apiClient.invokeAPI("/api/v1/authorizationServers/{authServerId}/clients/{clientId}/tokens", HttpMethod.DELETE, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }







        /**
        * Rotate all Credential Keys
        * Rotate all credential keys
            * <p><b>200</b> - Success
            * <p><b>400</b> - Bad Request
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>429</b> - Too Many Requests
                * @param authServerId  (required)
                * @param use  (required)
                * @return List&lt;JsonWebKey&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public List<JsonWebKey> rotateAuthorizationServerKeys(String authServerId, JwkUse use) throws RestClientException {
                return rotateAuthorizationServerKeysWithHttpInfo(authServerId, use).getBody();
            }




            /**
            * Rotate all Credential Keys
            * Rotate all credential keys
                * <p><b>200</b> - Success
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param T (required) - the assignable return type
                * @param authServerId  (required)
                * @param use  (required)
                * @return T instance
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public <T> T rotateAuthorizationServerKeys(Class<?> T, String authServerId, JwkUse use) throws RestClientException {
                return (T) getObjectMapper().convertValue(rotateAuthorizationServerKeysWithReturnType(T, authServerId, use).getBody(), T);
            }




            /**
            * Rotate all Credential Keys
            * Rotate all credential keys
                * <p><b>200</b> - Success
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param authServerId  (required)
                * @param use  (required)
            * @return ResponseEntity&lt;List&lt;JsonWebKey&gt;&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<List<JsonWebKey>> rotateAuthorizationServerKeysWithHttpInfo(String authServerId, JwkUse use) throws RestClientException {
            Object localVarPostBody = use;
        
                // verify the required parameter 'authServerId' is set ''
                if (authServerId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'authServerId' when calling rotateAuthorizationServerKeys");
                }
        
                // verify the required parameter 'use' is set ''
                if (use == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'use' when calling rotateAuthorizationServerKeys");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("authServerId", authServerId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = { 
            "application/json"
         };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<List<JsonWebKey>> localReturnType = new ParameterizedTypeReference<List<JsonWebKey>>() {};
            return apiClient.invokeAPI("/api/v1/authorizationServers/{authServerId}/credentials/lifecycle/keyRotate", HttpMethod.POST, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }




            /**
            * Rotate all Credential Keys
            * Rotate all credential keys
                * <p><b>200</b> - Success
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param authServerId  (required)
                * @param use  (required)
            * @return ResponseEntity&lt;List&lt;JsonWebKey&gt;&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private <T> ResponseEntity<T> rotateAuthorizationServerKeysWithReturnType(Class<?> T, String authServerId,JwkUse use) throws RestClientException {
            Object localVarPostBody = use;
        
                // verify the required parameter 'authServerId' is set
                if (authServerId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'authServerId' when calling rotateAuthorizationServerKeys");
                }
        
                // verify the required parameter 'use' is set
                if (use == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'use' when calling rotateAuthorizationServerKeys");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("authServerId", authServerId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = { 
            "application/json"
         };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<T> localReturnType = new ParameterizedTypeReference<T>() {};
            return apiClient.invokeAPI("/api/v1/authorizationServers/{authServerId}/credentials/lifecycle/keyRotate", HttpMethod.POST, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }




            /**
            * Rotate all Credential Keys
            * Rotate all credential keys
                * <p><b>200</b> - Success
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param authServerId  (required)
                * @param use  (required)
            * @return ResponseEntity&lt;List&lt;JsonWebKey&gt;&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public PagedList rotateAuthorizationServerKeysWithPaginationInfo(String authServerId, JwkUse use) throws RestClientException {
            Object localVarPostBody = use;
        
                // verify the required parameter 'authServerId' is set
                if (authServerId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'authServerId' when calling rotateAuthorizationServerKeys");
                }
        
                // verify the required parameter 'use' is set
                if (use == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'use' when calling rotateAuthorizationServerKeys");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("authServerId", authServerId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = { 
            "application/json"
         };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<List<JsonWebKey>> localReturnType = new ParameterizedTypeReference<List<JsonWebKey>>() {};
            ResponseEntity<List<JsonWebKey>> responseEntity = apiClient.invokeAPI("/api/v1/authorizationServers/{authServerId}/credentials/lifecycle/keyRotate", HttpMethod.POST, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                    HttpHeaders headers = responseEntity.getHeaders();
                    PagedList pagedList = new PagedList();
                    List<String> linkHeaders = headers.get("link");
                    String self = null, nextPage = null;
                    for (String link : linkHeaders) {
                    if (link.contains("next")) {
                    nextPage = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    if (link.contains("self")) {
                    self = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    }
                    pagedList.addItems(Arrays.asList(responseEntity.getBody()));
                    if (Objects.nonNull(nextPage)) {
                    pagedList.setNextPage(nextPage);
                    }
                    if (Objects.nonNull(self)) {
                    pagedList.setSelf(self);
                    }
                    return pagedList;
        }


    private ObjectMapper getObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule(new JavaTimeModule());
        objectMapper.registerModule(new JsonNullableModule());
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        return objectMapper;
    }
        }
