package org.openapitools.client.api;

import org.openapitools.client.ApiClient;

import org.openapitools.client.model.AgentPool;
import org.openapitools.client.model.AgentPoolUpdate;
import org.openapitools.client.model.AgentPoolUpdateSetting;
import org.openapitools.client.model.AgentType;
import org.openapitools.client.model.Error;

import java.util.Collections;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.LinkedHashMap;
import java.util.stream.Collectors;

import com.okta.sdk.resource.common.PagedList;

import com.okta.commons.lang.Assert;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;

import org.openapitools.jackson.nullable.JsonNullableModule;

@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-10-28T09:44:59.080-05:00[America/Chicago]")
@Component("org.openapitools.client.api.AgentPoolsApi")
    public class AgentPoolsApi {
    private ApiClient apiClient;

    public AgentPoolsApi() {
    this(new ApiClient());
    }

    @Autowired
    public AgentPoolsApi(ApiClient apiClient) {
    this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
    return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
    this.apiClient = apiClient;
    }

        /**
        * Activate an Agent Pool update
        * Activates scheduled Agent pool update
            * <p><b>201</b> - Activated
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>429</b> - Too Many Requests
                * @param poolId Id of the agent pool for which the settings will apply (required)
                * @param updateId Id of the update (required)
                * @return AgentPoolUpdate
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public AgentPoolUpdate activateAgentPoolsUpdate(String poolId, String updateId) throws RestClientException {
                return activateAgentPoolsUpdateWithHttpInfo(poolId, updateId).getBody();
            }






            /**
            * Activate an Agent Pool update
            * Activates scheduled Agent pool update
                * <p><b>201</b> - Activated
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param poolId Id of the agent pool for which the settings will apply (required)
                * @param updateId Id of the update (required)
            * @return ResponseEntity&lt;AgentPoolUpdate&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<AgentPoolUpdate> activateAgentPoolsUpdateWithHttpInfo(String poolId, String updateId) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'poolId' is set ''
                if (poolId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'poolId' when calling activateAgentPoolsUpdate");
                }
        
                // verify the required parameter 'updateId' is set ''
                if (updateId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'updateId' when calling activateAgentPoolsUpdate");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("poolId", poolId);
                    uriVariables.put("updateId", updateId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<AgentPoolUpdate> localReturnType = new ParameterizedTypeReference<AgentPoolUpdate>() {};
            return apiClient.invokeAPI("/api/v1/agentPools/{poolId}/updates/{updateId}/activate", HttpMethod.POST, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }







            /**
            * Activate an Agent Pool update
            * Activates scheduled Agent pool update
                * <p><b>201</b> - Activated
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param poolId Id of the agent pool for which the settings will apply (required)
                * @param updateId Id of the update (required)
            * @return ResponseEntity&lt;AgentPoolUpdate&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public PagedList activateAgentPoolsUpdateWithPaginationInfo(String poolId, String updateId) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'poolId' is set
                if (poolId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'poolId' when calling activateAgentPoolsUpdate");
                }
        
                // verify the required parameter 'updateId' is set
                if (updateId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'updateId' when calling activateAgentPoolsUpdate");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("poolId", poolId);
                    uriVariables.put("updateId", updateId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<AgentPoolUpdate> localReturnType = new ParameterizedTypeReference<AgentPoolUpdate>() {};
            ResponseEntity<AgentPoolUpdate> responseEntity = apiClient.invokeAPI("/api/v1/agentPools/{poolId}/updates/{updateId}/activate", HttpMethod.POST, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                    HttpHeaders headers = responseEntity.getHeaders();
                    PagedList pagedList = new PagedList();
                    List<String> linkHeaders = headers.get("link");
                    String self = null, nextPage = null;
                    for (String link : linkHeaders) {
                    if (link.contains("next")) {
                    nextPage = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    if (link.contains("self")) {
                    self = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    }
                    pagedList.addItems(Arrays.asList(responseEntity.getBody()));
                    if (Objects.nonNull(nextPage)) {
                    pagedList.setNextPage(nextPage);
                    }
                    if (Objects.nonNull(self)) {
                    pagedList.setSelf(self);
                    }
                    return pagedList;
        }

        /**
        * Create an Agent Pool update
        * Creates an Agent pool update \\n For user flow 2 manual update, starts the update immediately. \\n For user flow 3, schedules the update based on the configured update window and delay.
            * <p><b>201</b> - Created
            * <p><b>400</b> - Bad Request
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>429</b> - Too Many Requests
                * @param poolId Id of the agent pool for which the settings will apply (required)
                * @param agentPoolUpdate  (required)
                * @return AgentPoolUpdate
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public AgentPoolUpdate createAgentPoolsUpdate(String poolId, AgentPoolUpdate agentPoolUpdate) throws RestClientException {
                return createAgentPoolsUpdateWithHttpInfo(poolId, agentPoolUpdate).getBody();
            }




            /**
            * Create an Agent Pool update
            * Creates an Agent pool update \\n For user flow 2 manual update, starts the update immediately. \\n For user flow 3, schedules the update based on the configured update window and delay.
                * <p><b>201</b> - Created
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param T (required) - the assignable return type
                * @param poolId Id of the agent pool for which the settings will apply (required)
                * @param agentPoolUpdate  (required)
                * @return T instance
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public <T> T createAgentPoolsUpdate(Class<?> T, String poolId, AgentPoolUpdate agentPoolUpdate) throws RestClientException {
                return (T) getObjectMapper().convertValue(createAgentPoolsUpdateWithReturnType(T, poolId, agentPoolUpdate).getBody(), T);
            }




            /**
            * Create an Agent Pool update
            * Creates an Agent pool update \\n For user flow 2 manual update, starts the update immediately. \\n For user flow 3, schedules the update based on the configured update window and delay.
                * <p><b>201</b> - Created
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param poolId Id of the agent pool for which the settings will apply (required)
                * @param agentPoolUpdate  (required)
            * @return ResponseEntity&lt;AgentPoolUpdate&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<AgentPoolUpdate> createAgentPoolsUpdateWithHttpInfo(String poolId, AgentPoolUpdate agentPoolUpdate) throws RestClientException {
            Object localVarPostBody = agentPoolUpdate;
        
                // verify the required parameter 'poolId' is set ''
                if (poolId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'poolId' when calling createAgentPoolsUpdate");
                }
        
                // verify the required parameter 'agentPoolUpdate' is set ''
                if (agentPoolUpdate == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'agentPoolUpdate' when calling createAgentPoolsUpdate");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("poolId", poolId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = { 
            "application/json"
         };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<AgentPoolUpdate> localReturnType = new ParameterizedTypeReference<AgentPoolUpdate>() {};
            return apiClient.invokeAPI("/api/v1/agentPools/{poolId}/updates", HttpMethod.POST, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }




            /**
            * Create an Agent Pool update
            * Creates an Agent pool update \\n For user flow 2 manual update, starts the update immediately. \\n For user flow 3, schedules the update based on the configured update window and delay.
                * <p><b>201</b> - Created
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param poolId Id of the agent pool for which the settings will apply (required)
                * @param agentPoolUpdate  (required)
            * @return ResponseEntity&lt;AgentPoolUpdate&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private <T> ResponseEntity<T> createAgentPoolsUpdateWithReturnType(Class<?> T, String poolId,AgentPoolUpdate agentPoolUpdate) throws RestClientException {
            Object localVarPostBody = agentPoolUpdate;
        
                // verify the required parameter 'poolId' is set
                if (poolId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'poolId' when calling createAgentPoolsUpdate");
                }
        
                // verify the required parameter 'agentPoolUpdate' is set
                if (agentPoolUpdate == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'agentPoolUpdate' when calling createAgentPoolsUpdate");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("poolId", poolId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = { 
            "application/json"
         };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<T> localReturnType = new ParameterizedTypeReference<T>() {};
            return apiClient.invokeAPI("/api/v1/agentPools/{poolId}/updates", HttpMethod.POST, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }




            /**
            * Create an Agent Pool update
            * Creates an Agent pool update \\n For user flow 2 manual update, starts the update immediately. \\n For user flow 3, schedules the update based on the configured update window and delay.
                * <p><b>201</b> - Created
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param poolId Id of the agent pool for which the settings will apply (required)
                * @param agentPoolUpdate  (required)
            * @return ResponseEntity&lt;AgentPoolUpdate&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public PagedList createAgentPoolsUpdateWithPaginationInfo(String poolId, AgentPoolUpdate agentPoolUpdate) throws RestClientException {
            Object localVarPostBody = agentPoolUpdate;
        
                // verify the required parameter 'poolId' is set
                if (poolId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'poolId' when calling createAgentPoolsUpdate");
                }
        
                // verify the required parameter 'agentPoolUpdate' is set
                if (agentPoolUpdate == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'agentPoolUpdate' when calling createAgentPoolsUpdate");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("poolId", poolId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = { 
            "application/json"
         };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<AgentPoolUpdate> localReturnType = new ParameterizedTypeReference<AgentPoolUpdate>() {};
            ResponseEntity<AgentPoolUpdate> responseEntity = apiClient.invokeAPI("/api/v1/agentPools/{poolId}/updates", HttpMethod.POST, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                    HttpHeaders headers = responseEntity.getHeaders();
                    PagedList pagedList = new PagedList();
                    List<String> linkHeaders = headers.get("link");
                    String self = null, nextPage = null;
                    for (String link : linkHeaders) {
                    if (link.contains("next")) {
                    nextPage = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    if (link.contains("self")) {
                    self = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    }
                    pagedList.addItems(Arrays.asList(responseEntity.getBody()));
                    if (Objects.nonNull(nextPage)) {
                    pagedList.setNextPage(nextPage);
                    }
                    if (Objects.nonNull(self)) {
                    pagedList.setSelf(self);
                    }
                    return pagedList;
        }

        /**
        * Deactivate an Agent Pool update
        * Deactivates scheduled Agent pool update
            * <p><b>201</b> - Deactivated
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>429</b> - Too Many Requests
                * @param poolId Id of the agent pool for which the settings will apply (required)
                * @param updateId Id of the update (required)
                * @return AgentPoolUpdate
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public AgentPoolUpdate deactivateAgentPoolsUpdate(String poolId, String updateId) throws RestClientException {
                return deactivateAgentPoolsUpdateWithHttpInfo(poolId, updateId).getBody();
            }






            /**
            * Deactivate an Agent Pool update
            * Deactivates scheduled Agent pool update
                * <p><b>201</b> - Deactivated
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param poolId Id of the agent pool for which the settings will apply (required)
                * @param updateId Id of the update (required)
            * @return ResponseEntity&lt;AgentPoolUpdate&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<AgentPoolUpdate> deactivateAgentPoolsUpdateWithHttpInfo(String poolId, String updateId) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'poolId' is set ''
                if (poolId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'poolId' when calling deactivateAgentPoolsUpdate");
                }
        
                // verify the required parameter 'updateId' is set ''
                if (updateId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'updateId' when calling deactivateAgentPoolsUpdate");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("poolId", poolId);
                    uriVariables.put("updateId", updateId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<AgentPoolUpdate> localReturnType = new ParameterizedTypeReference<AgentPoolUpdate>() {};
            return apiClient.invokeAPI("/api/v1/agentPools/{poolId}/updates/{updateId}/deactivate", HttpMethod.POST, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }







            /**
            * Deactivate an Agent Pool update
            * Deactivates scheduled Agent pool update
                * <p><b>201</b> - Deactivated
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param poolId Id of the agent pool for which the settings will apply (required)
                * @param updateId Id of the update (required)
            * @return ResponseEntity&lt;AgentPoolUpdate&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public PagedList deactivateAgentPoolsUpdateWithPaginationInfo(String poolId, String updateId) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'poolId' is set
                if (poolId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'poolId' when calling deactivateAgentPoolsUpdate");
                }
        
                // verify the required parameter 'updateId' is set
                if (updateId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'updateId' when calling deactivateAgentPoolsUpdate");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("poolId", poolId);
                    uriVariables.put("updateId", updateId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<AgentPoolUpdate> localReturnType = new ParameterizedTypeReference<AgentPoolUpdate>() {};
            ResponseEntity<AgentPoolUpdate> responseEntity = apiClient.invokeAPI("/api/v1/agentPools/{poolId}/updates/{updateId}/deactivate", HttpMethod.POST, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                    HttpHeaders headers = responseEntity.getHeaders();
                    PagedList pagedList = new PagedList();
                    List<String> linkHeaders = headers.get("link");
                    String self = null, nextPage = null;
                    for (String link : linkHeaders) {
                    if (link.contains("next")) {
                    nextPage = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    if (link.contains("self")) {
                    self = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    }
                    pagedList.addItems(Arrays.asList(responseEntity.getBody()));
                    if (Objects.nonNull(nextPage)) {
                    pagedList.setNextPage(nextPage);
                    }
                    if (Objects.nonNull(self)) {
                    pagedList.setSelf(self);
                    }
                    return pagedList;
        }

        /**
        * Delete an Agent Pool update
        * Deletes Agent pool update
            * <p><b>204</b> - Deleted
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>429</b> - Too Many Requests
                * @param poolId Id of the agent pool for which the settings will apply (required)
                * @param updateId Id of the update (required)
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public void deleteAgentPoolsUpdate(String poolId, String updateId) throws RestClientException {
            deleteAgentPoolsUpdateWithHttpInfo(poolId, updateId);
            }






            /**
            * Delete an Agent Pool update
            * Deletes Agent pool update
                * <p><b>204</b> - Deleted
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param poolId Id of the agent pool for which the settings will apply (required)
                * @param updateId Id of the update (required)
            * @return ResponseEntity&lt;Void&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<Void> deleteAgentPoolsUpdateWithHttpInfo(String poolId, String updateId) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'poolId' is set ''
                if (poolId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'poolId' when calling deleteAgentPoolsUpdate");
                }
        
                // verify the required parameter 'updateId' is set ''
                if (updateId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'updateId' when calling deleteAgentPoolsUpdate");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("poolId", poolId);
                    uriVariables.put("updateId", updateId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<Void> localReturnType = new ParameterizedTypeReference<Void>() {};
            return apiClient.invokeAPI("/api/v1/agentPools/{poolId}/updates/{updateId}", HttpMethod.DELETE, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }







        /**
        * Retrieve an Agent Pool update by id
        * Retrieves Agent pool update from updateId
            * <p><b>200</b> - OK
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>429</b> - Too Many Requests
                * @param poolId Id of the agent pool for which the settings will apply (required)
                * @param updateId Id of the update (required)
                * @return AgentPoolUpdate
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public AgentPoolUpdate getAgentPoolsUpdateInstance(String poolId, String updateId) throws RestClientException {
                return getAgentPoolsUpdateInstanceWithHttpInfo(poolId, updateId).getBody();
            }






            /**
            * Retrieve an Agent Pool update by id
            * Retrieves Agent pool update from updateId
                * <p><b>200</b> - OK
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param poolId Id of the agent pool for which the settings will apply (required)
                * @param updateId Id of the update (required)
            * @return ResponseEntity&lt;AgentPoolUpdate&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<AgentPoolUpdate> getAgentPoolsUpdateInstanceWithHttpInfo(String poolId, String updateId) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'poolId' is set ''
                if (poolId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'poolId' when calling getAgentPoolsUpdateInstance");
                }
        
                // verify the required parameter 'updateId' is set ''
                if (updateId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'updateId' when calling getAgentPoolsUpdateInstance");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("poolId", poolId);
                    uriVariables.put("updateId", updateId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<AgentPoolUpdate> localReturnType = new ParameterizedTypeReference<AgentPoolUpdate>() {};
            return apiClient.invokeAPI("/api/v1/agentPools/{poolId}/updates/{updateId}", HttpMethod.GET, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }







            /**
            * Retrieve an Agent Pool update by id
            * Retrieves Agent pool update from updateId
                * <p><b>200</b> - OK
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param poolId Id of the agent pool for which the settings will apply (required)
                * @param updateId Id of the update (required)
            * @return ResponseEntity&lt;AgentPoolUpdate&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public PagedList getAgentPoolsUpdateInstanceWithPaginationInfo(String poolId, String updateId) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'poolId' is set
                if (poolId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'poolId' when calling getAgentPoolsUpdateInstance");
                }
        
                // verify the required parameter 'updateId' is set
                if (updateId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'updateId' when calling getAgentPoolsUpdateInstance");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("poolId", poolId);
                    uriVariables.put("updateId", updateId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<AgentPoolUpdate> localReturnType = new ParameterizedTypeReference<AgentPoolUpdate>() {};
            ResponseEntity<AgentPoolUpdate> responseEntity = apiClient.invokeAPI("/api/v1/agentPools/{poolId}/updates/{updateId}", HttpMethod.GET, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                    HttpHeaders headers = responseEntity.getHeaders();
                    PagedList pagedList = new PagedList();
                    List<String> linkHeaders = headers.get("link");
                    String self = null, nextPage = null;
                    for (String link : linkHeaders) {
                    if (link.contains("next")) {
                    nextPage = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    if (link.contains("self")) {
                    self = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    }
                    pagedList.addItems(Arrays.asList(responseEntity.getBody()));
                    if (Objects.nonNull(nextPage)) {
                    pagedList.setNextPage(nextPage);
                    }
                    if (Objects.nonNull(self)) {
                    pagedList.setSelf(self);
                    }
                    return pagedList;
        }

        /**
        * Retrieve an Agent Pool update&#39;s settings
        * Retrieves the current state of the agent pool update instance settings
            * <p><b>200</b> - OK
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>429</b> - Too Many Requests
                * @param poolId Id of the agent pool for which the settings will apply (required)
                * @return AgentPoolUpdateSetting
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public AgentPoolUpdateSetting getAgentPoolsUpdateSettings(String poolId) throws RestClientException {
                return getAgentPoolsUpdateSettingsWithHttpInfo(poolId).getBody();
            }






            /**
            * Retrieve an Agent Pool update&#39;s settings
            * Retrieves the current state of the agent pool update instance settings
                * <p><b>200</b> - OK
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param poolId Id of the agent pool for which the settings will apply (required)
            * @return ResponseEntity&lt;AgentPoolUpdateSetting&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<AgentPoolUpdateSetting> getAgentPoolsUpdateSettingsWithHttpInfo(String poolId) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'poolId' is set ''
                if (poolId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'poolId' when calling getAgentPoolsUpdateSettings");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("poolId", poolId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<AgentPoolUpdateSetting> localReturnType = new ParameterizedTypeReference<AgentPoolUpdateSetting>() {};
            return apiClient.invokeAPI("/api/v1/agentPools/{poolId}/updates/settings", HttpMethod.GET, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }







            /**
            * Retrieve an Agent Pool update&#39;s settings
            * Retrieves the current state of the agent pool update instance settings
                * <p><b>200</b> - OK
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param poolId Id of the agent pool for which the settings will apply (required)
            * @return ResponseEntity&lt;AgentPoolUpdateSetting&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public PagedList getAgentPoolsUpdateSettingsWithPaginationInfo(String poolId) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'poolId' is set
                if (poolId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'poolId' when calling getAgentPoolsUpdateSettings");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("poolId", poolId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<AgentPoolUpdateSetting> localReturnType = new ParameterizedTypeReference<AgentPoolUpdateSetting>() {};
            ResponseEntity<AgentPoolUpdateSetting> responseEntity = apiClient.invokeAPI("/api/v1/agentPools/{poolId}/updates/settings", HttpMethod.GET, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                    HttpHeaders headers = responseEntity.getHeaders();
                    PagedList pagedList = new PagedList();
                    List<String> linkHeaders = headers.get("link");
                    String self = null, nextPage = null;
                    for (String link : linkHeaders) {
                    if (link.contains("next")) {
                    nextPage = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    if (link.contains("self")) {
                    self = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    }
                    pagedList.addItems(Arrays.asList(responseEntity.getBody()));
                    if (Objects.nonNull(nextPage)) {
                    pagedList.setNextPage(nextPage);
                    }
                    if (Objects.nonNull(self)) {
                    pagedList.setSelf(self);
                    }
                    return pagedList;
        }

        /**
        * List all Agent Pools
        * Lists all agent pools with pagination support
            * <p><b>200</b> - OK
            * <p><b>403</b> - Forbidden
            * <p><b>429</b> - Too Many Requests
                * @param limitPerPoolType Maximum number of AgentPools being returned (optional, default to 5)
                * @param poolType Agent type to search for (optional)
                * @param after The cursor to use for pagination. It is an opaque string that specifies your current location in the list and is obtained from the &#x60;Link&#x60; response header. See [Pagination](/#pagination) for more information. (optional)
                * @return List&lt;AgentPool&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public List<AgentPool> listAgentPools(Integer limitPerPoolType, AgentType poolType, String after) throws RestClientException {
                return listAgentPoolsWithHttpInfo(limitPerPoolType, poolType, after).getBody();
            }






            /**
            * List all Agent Pools
            * Lists all agent pools with pagination support
                * <p><b>200</b> - OK
                * <p><b>403</b> - Forbidden
                * <p><b>429</b> - Too Many Requests
                * @param limitPerPoolType Maximum number of AgentPools being returned (optional, default to 5)
                * @param poolType Agent type to search for (optional)
                * @param after The cursor to use for pagination. It is an opaque string that specifies your current location in the list and is obtained from the &#x60;Link&#x60; response header. See [Pagination](/#pagination) for more information. (optional)
            * @return ResponseEntity&lt;List&lt;AgentPool&gt;&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<List<AgentPool>> listAgentPoolsWithHttpInfo(Integer limitPerPoolType, AgentType poolType, String after) throws RestClientException {
            Object localVarPostBody = null;
        

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "limitPerPoolType", limitPerPoolType));
            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "poolType", poolType));
            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "after", after));

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<List<AgentPool>> localReturnType = new ParameterizedTypeReference<List<AgentPool>>() {};
            return apiClient.invokeAPI("/api/v1/agentPools", HttpMethod.GET, Collections.<String, Object>emptyMap(), localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }







            /**
            * List all Agent Pools
            * Lists all agent pools with pagination support
                * <p><b>200</b> - OK
                * <p><b>403</b> - Forbidden
                * <p><b>429</b> - Too Many Requests
                * @param limitPerPoolType Maximum number of AgentPools being returned (optional, default to 5)
                * @param poolType Agent type to search for (optional)
                * @param after The cursor to use for pagination. It is an opaque string that specifies your current location in the list and is obtained from the &#x60;Link&#x60; response header. See [Pagination](/#pagination) for more information. (optional)
            * @return ResponseEntity&lt;List&lt;AgentPool&gt;&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public PagedList listAgentPoolsWithPaginationInfo(Integer limitPerPoolType, AgentType poolType, String after) throws RestClientException {
            Object localVarPostBody = null;
        

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "limitPerPoolType", limitPerPoolType));
            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "poolType", poolType));
            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "after", after));

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<List<AgentPool>> localReturnType = new ParameterizedTypeReference<List<AgentPool>>() {};
            ResponseEntity<List<AgentPool>> responseEntity = apiClient.invokeAPI("/api/v1/agentPools", HttpMethod.GET, Collections.<String, Object>emptyMap(), localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                    HttpHeaders headers = responseEntity.getHeaders();
                    PagedList pagedList = new PagedList();
                    List<String> linkHeaders = headers.get("link");
                    String self = null, nextPage = null;
                    for (String link : linkHeaders) {
                    if (link.contains("next")) {
                    nextPage = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    if (link.contains("self")) {
                    self = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    }
                    pagedList.addItems(Arrays.asList(responseEntity.getBody()));
                    if (Objects.nonNull(nextPage)) {
                    pagedList.setNextPage(nextPage);
                    }
                    if (Objects.nonNull(self)) {
                    pagedList.setSelf(self);
                    }
                    return pagedList;
        }

        /**
        * List all Agent Pool updates
        * Lists all agent pool updates
            * <p><b>200</b> - OK
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>429</b> - Too Many Requests
                * @param poolId Id of the agent pool for which the settings will apply (required)
                * @param scheduled Scope the list only to scheduled or ad-hoc updates. If the parameter is not provided we will return the whole list of updates. (optional)
                * @return List&lt;AgentPoolUpdate&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public List<AgentPoolUpdate> listAgentPoolsUpdates(String poolId, Boolean scheduled) throws RestClientException {
                return listAgentPoolsUpdatesWithHttpInfo(poolId, scheduled).getBody();
            }






            /**
            * List all Agent Pool updates
            * Lists all agent pool updates
                * <p><b>200</b> - OK
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param poolId Id of the agent pool for which the settings will apply (required)
                * @param scheduled Scope the list only to scheduled or ad-hoc updates. If the parameter is not provided we will return the whole list of updates. (optional)
            * @return ResponseEntity&lt;List&lt;AgentPoolUpdate&gt;&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<List<AgentPoolUpdate>> listAgentPoolsUpdatesWithHttpInfo(String poolId, Boolean scheduled) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'poolId' is set ''
                if (poolId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'poolId' when calling listAgentPoolsUpdates");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("poolId", poolId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "scheduled", scheduled));

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<List<AgentPoolUpdate>> localReturnType = new ParameterizedTypeReference<List<AgentPoolUpdate>>() {};
            return apiClient.invokeAPI("/api/v1/agentPools/{poolId}/updates", HttpMethod.GET, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }







            /**
            * List all Agent Pool updates
            * Lists all agent pool updates
                * <p><b>200</b> - OK
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param poolId Id of the agent pool for which the settings will apply (required)
                * @param scheduled Scope the list only to scheduled or ad-hoc updates. If the parameter is not provided we will return the whole list of updates. (optional)
            * @return ResponseEntity&lt;List&lt;AgentPoolUpdate&gt;&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public PagedList listAgentPoolsUpdatesWithPaginationInfo(String poolId, Boolean scheduled) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'poolId' is set
                if (poolId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'poolId' when calling listAgentPoolsUpdates");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("poolId", poolId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "scheduled", scheduled));

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<List<AgentPoolUpdate>> localReturnType = new ParameterizedTypeReference<List<AgentPoolUpdate>>() {};
            ResponseEntity<List<AgentPoolUpdate>> responseEntity = apiClient.invokeAPI("/api/v1/agentPools/{poolId}/updates", HttpMethod.GET, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                    HttpHeaders headers = responseEntity.getHeaders();
                    PagedList pagedList = new PagedList();
                    List<String> linkHeaders = headers.get("link");
                    String self = null, nextPage = null;
                    for (String link : linkHeaders) {
                    if (link.contains("next")) {
                    nextPage = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    if (link.contains("self")) {
                    self = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    }
                    pagedList.addItems(Arrays.asList(responseEntity.getBody()));
                    if (Objects.nonNull(nextPage)) {
                    pagedList.setNextPage(nextPage);
                    }
                    if (Objects.nonNull(self)) {
                    pagedList.setSelf(self);
                    }
                    return pagedList;
        }

        /**
        * Pause an Agent Pool update
        * Pauses running or queued Agent pool update
            * <p><b>201</b> - Paused
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>429</b> - Too Many Requests
                * @param poolId Id of the agent pool for which the settings will apply (required)
                * @param updateId Id of the update (required)
                * @return AgentPoolUpdate
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public AgentPoolUpdate pauseAgentPoolsUpdate(String poolId, String updateId) throws RestClientException {
                return pauseAgentPoolsUpdateWithHttpInfo(poolId, updateId).getBody();
            }






            /**
            * Pause an Agent Pool update
            * Pauses running or queued Agent pool update
                * <p><b>201</b> - Paused
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param poolId Id of the agent pool for which the settings will apply (required)
                * @param updateId Id of the update (required)
            * @return ResponseEntity&lt;AgentPoolUpdate&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<AgentPoolUpdate> pauseAgentPoolsUpdateWithHttpInfo(String poolId, String updateId) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'poolId' is set ''
                if (poolId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'poolId' when calling pauseAgentPoolsUpdate");
                }
        
                // verify the required parameter 'updateId' is set ''
                if (updateId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'updateId' when calling pauseAgentPoolsUpdate");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("poolId", poolId);
                    uriVariables.put("updateId", updateId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<AgentPoolUpdate> localReturnType = new ParameterizedTypeReference<AgentPoolUpdate>() {};
            return apiClient.invokeAPI("/api/v1/agentPools/{poolId}/updates/{updateId}/pause", HttpMethod.POST, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }







            /**
            * Pause an Agent Pool update
            * Pauses running or queued Agent pool update
                * <p><b>201</b> - Paused
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param poolId Id of the agent pool for which the settings will apply (required)
                * @param updateId Id of the update (required)
            * @return ResponseEntity&lt;AgentPoolUpdate&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public PagedList pauseAgentPoolsUpdateWithPaginationInfo(String poolId, String updateId) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'poolId' is set
                if (poolId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'poolId' when calling pauseAgentPoolsUpdate");
                }
        
                // verify the required parameter 'updateId' is set
                if (updateId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'updateId' when calling pauseAgentPoolsUpdate");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("poolId", poolId);
                    uriVariables.put("updateId", updateId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<AgentPoolUpdate> localReturnType = new ParameterizedTypeReference<AgentPoolUpdate>() {};
            ResponseEntity<AgentPoolUpdate> responseEntity = apiClient.invokeAPI("/api/v1/agentPools/{poolId}/updates/{updateId}/pause", HttpMethod.POST, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                    HttpHeaders headers = responseEntity.getHeaders();
                    PagedList pagedList = new PagedList();
                    List<String> linkHeaders = headers.get("link");
                    String self = null, nextPage = null;
                    for (String link : linkHeaders) {
                    if (link.contains("next")) {
                    nextPage = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    if (link.contains("self")) {
                    self = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    }
                    pagedList.addItems(Arrays.asList(responseEntity.getBody()));
                    if (Objects.nonNull(nextPage)) {
                    pagedList.setNextPage(nextPage);
                    }
                    if (Objects.nonNull(self)) {
                    pagedList.setSelf(self);
                    }
                    return pagedList;
        }

        /**
        * Resume an Agent Pool update
        * Resumes running or queued Agent pool update
            * <p><b>201</b> - Resumed
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>429</b> - Too Many Requests
                * @param poolId Id of the agent pool for which the settings will apply (required)
                * @param updateId Id of the update (required)
                * @return AgentPoolUpdate
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public AgentPoolUpdate resumeAgentPoolsUpdate(String poolId, String updateId) throws RestClientException {
                return resumeAgentPoolsUpdateWithHttpInfo(poolId, updateId).getBody();
            }






            /**
            * Resume an Agent Pool update
            * Resumes running or queued Agent pool update
                * <p><b>201</b> - Resumed
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param poolId Id of the agent pool for which the settings will apply (required)
                * @param updateId Id of the update (required)
            * @return ResponseEntity&lt;AgentPoolUpdate&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<AgentPoolUpdate> resumeAgentPoolsUpdateWithHttpInfo(String poolId, String updateId) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'poolId' is set ''
                if (poolId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'poolId' when calling resumeAgentPoolsUpdate");
                }
        
                // verify the required parameter 'updateId' is set ''
                if (updateId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'updateId' when calling resumeAgentPoolsUpdate");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("poolId", poolId);
                    uriVariables.put("updateId", updateId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<AgentPoolUpdate> localReturnType = new ParameterizedTypeReference<AgentPoolUpdate>() {};
            return apiClient.invokeAPI("/api/v1/agentPools/{poolId}/updates/{updateId}/resume", HttpMethod.POST, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }







            /**
            * Resume an Agent Pool update
            * Resumes running or queued Agent pool update
                * <p><b>201</b> - Resumed
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param poolId Id of the agent pool for which the settings will apply (required)
                * @param updateId Id of the update (required)
            * @return ResponseEntity&lt;AgentPoolUpdate&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public PagedList resumeAgentPoolsUpdateWithPaginationInfo(String poolId, String updateId) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'poolId' is set
                if (poolId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'poolId' when calling resumeAgentPoolsUpdate");
                }
        
                // verify the required parameter 'updateId' is set
                if (updateId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'updateId' when calling resumeAgentPoolsUpdate");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("poolId", poolId);
                    uriVariables.put("updateId", updateId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<AgentPoolUpdate> localReturnType = new ParameterizedTypeReference<AgentPoolUpdate>() {};
            ResponseEntity<AgentPoolUpdate> responseEntity = apiClient.invokeAPI("/api/v1/agentPools/{poolId}/updates/{updateId}/resume", HttpMethod.POST, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                    HttpHeaders headers = responseEntity.getHeaders();
                    PagedList pagedList = new PagedList();
                    List<String> linkHeaders = headers.get("link");
                    String self = null, nextPage = null;
                    for (String link : linkHeaders) {
                    if (link.contains("next")) {
                    nextPage = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    if (link.contains("self")) {
                    self = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    }
                    pagedList.addItems(Arrays.asList(responseEntity.getBody()));
                    if (Objects.nonNull(nextPage)) {
                    pagedList.setNextPage(nextPage);
                    }
                    if (Objects.nonNull(self)) {
                    pagedList.setSelf(self);
                    }
                    return pagedList;
        }

        /**
        * Retry an Agent Pool update
        * Retries Agent pool update
            * <p><b>201</b> - Retried
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>429</b> - Too Many Requests
                * @param poolId Id of the agent pool for which the settings will apply (required)
                * @param updateId Id of the update (required)
                * @return AgentPoolUpdate
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public AgentPoolUpdate retryAgentPoolsUpdate(String poolId, String updateId) throws RestClientException {
                return retryAgentPoolsUpdateWithHttpInfo(poolId, updateId).getBody();
            }






            /**
            * Retry an Agent Pool update
            * Retries Agent pool update
                * <p><b>201</b> - Retried
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param poolId Id of the agent pool for which the settings will apply (required)
                * @param updateId Id of the update (required)
            * @return ResponseEntity&lt;AgentPoolUpdate&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<AgentPoolUpdate> retryAgentPoolsUpdateWithHttpInfo(String poolId, String updateId) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'poolId' is set ''
                if (poolId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'poolId' when calling retryAgentPoolsUpdate");
                }
        
                // verify the required parameter 'updateId' is set ''
                if (updateId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'updateId' when calling retryAgentPoolsUpdate");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("poolId", poolId);
                    uriVariables.put("updateId", updateId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<AgentPoolUpdate> localReturnType = new ParameterizedTypeReference<AgentPoolUpdate>() {};
            return apiClient.invokeAPI("/api/v1/agentPools/{poolId}/updates/{updateId}/retry", HttpMethod.POST, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }







            /**
            * Retry an Agent Pool update
            * Retries Agent pool update
                * <p><b>201</b> - Retried
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param poolId Id of the agent pool for which the settings will apply (required)
                * @param updateId Id of the update (required)
            * @return ResponseEntity&lt;AgentPoolUpdate&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public PagedList retryAgentPoolsUpdateWithPaginationInfo(String poolId, String updateId) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'poolId' is set
                if (poolId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'poolId' when calling retryAgentPoolsUpdate");
                }
        
                // verify the required parameter 'updateId' is set
                if (updateId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'updateId' when calling retryAgentPoolsUpdate");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("poolId", poolId);
                    uriVariables.put("updateId", updateId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<AgentPoolUpdate> localReturnType = new ParameterizedTypeReference<AgentPoolUpdate>() {};
            ResponseEntity<AgentPoolUpdate> responseEntity = apiClient.invokeAPI("/api/v1/agentPools/{poolId}/updates/{updateId}/retry", HttpMethod.POST, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                    HttpHeaders headers = responseEntity.getHeaders();
                    PagedList pagedList = new PagedList();
                    List<String> linkHeaders = headers.get("link");
                    String self = null, nextPage = null;
                    for (String link : linkHeaders) {
                    if (link.contains("next")) {
                    nextPage = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    if (link.contains("self")) {
                    self = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    }
                    pagedList.addItems(Arrays.asList(responseEntity.getBody()));
                    if (Objects.nonNull(nextPage)) {
                    pagedList.setNextPage(nextPage);
                    }
                    if (Objects.nonNull(self)) {
                    pagedList.setSelf(self);
                    }
                    return pagedList;
        }

        /**
        * Stop an Agent Pool update
        * Stops Agent pool update
            * <p><b>201</b> - Stopped
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>429</b> - Too Many Requests
                * @param poolId Id of the agent pool for which the settings will apply (required)
                * @param updateId Id of the update (required)
                * @return AgentPoolUpdate
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public AgentPoolUpdate stopAgentPoolsUpdate(String poolId, String updateId) throws RestClientException {
                return stopAgentPoolsUpdateWithHttpInfo(poolId, updateId).getBody();
            }






            /**
            * Stop an Agent Pool update
            * Stops Agent pool update
                * <p><b>201</b> - Stopped
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param poolId Id of the agent pool for which the settings will apply (required)
                * @param updateId Id of the update (required)
            * @return ResponseEntity&lt;AgentPoolUpdate&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<AgentPoolUpdate> stopAgentPoolsUpdateWithHttpInfo(String poolId, String updateId) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'poolId' is set ''
                if (poolId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'poolId' when calling stopAgentPoolsUpdate");
                }
        
                // verify the required parameter 'updateId' is set ''
                if (updateId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'updateId' when calling stopAgentPoolsUpdate");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("poolId", poolId);
                    uriVariables.put("updateId", updateId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<AgentPoolUpdate> localReturnType = new ParameterizedTypeReference<AgentPoolUpdate>() {};
            return apiClient.invokeAPI("/api/v1/agentPools/{poolId}/updates/{updateId}/stop", HttpMethod.POST, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }







            /**
            * Stop an Agent Pool update
            * Stops Agent pool update
                * <p><b>201</b> - Stopped
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param poolId Id of the agent pool for which the settings will apply (required)
                * @param updateId Id of the update (required)
            * @return ResponseEntity&lt;AgentPoolUpdate&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public PagedList stopAgentPoolsUpdateWithPaginationInfo(String poolId, String updateId) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'poolId' is set
                if (poolId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'poolId' when calling stopAgentPoolsUpdate");
                }
        
                // verify the required parameter 'updateId' is set
                if (updateId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'updateId' when calling stopAgentPoolsUpdate");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("poolId", poolId);
                    uriVariables.put("updateId", updateId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<AgentPoolUpdate> localReturnType = new ParameterizedTypeReference<AgentPoolUpdate>() {};
            ResponseEntity<AgentPoolUpdate> responseEntity = apiClient.invokeAPI("/api/v1/agentPools/{poolId}/updates/{updateId}/stop", HttpMethod.POST, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                    HttpHeaders headers = responseEntity.getHeaders();
                    PagedList pagedList = new PagedList();
                    List<String> linkHeaders = headers.get("link");
                    String self = null, nextPage = null;
                    for (String link : linkHeaders) {
                    if (link.contains("next")) {
                    nextPage = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    if (link.contains("self")) {
                    self = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    }
                    pagedList.addItems(Arrays.asList(responseEntity.getBody()));
                    if (Objects.nonNull(nextPage)) {
                    pagedList.setNextPage(nextPage);
                    }
                    if (Objects.nonNull(self)) {
                    pagedList.setSelf(self);
                    }
                    return pagedList;
        }

        /**
        * Update an Agent Pool update by id
        * Updates Agent pool update and return latest agent pool update
            * <p><b>201</b> - Updated
            * <p><b>400</b> - Bad Request
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>429</b> - Too Many Requests
                * @param poolId Id of the agent pool for which the settings will apply (required)
                * @param updateId Id of the update (required)
                * @param agentPoolUpdate  (required)
                * @return AgentPoolUpdate
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public AgentPoolUpdate updateAgentPoolsUpdate(String poolId, String updateId, AgentPoolUpdate agentPoolUpdate) throws RestClientException {
                return updateAgentPoolsUpdateWithHttpInfo(poolId, updateId, agentPoolUpdate).getBody();
            }




            /**
            * Update an Agent Pool update by id
            * Updates Agent pool update and return latest agent pool update
                * <p><b>201</b> - Updated
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param T (required) - the assignable return type
                * @param poolId Id of the agent pool for which the settings will apply (required)
                * @param updateId Id of the update (required)
                * @param agentPoolUpdate  (required)
                * @return T instance
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public <T> T updateAgentPoolsUpdate(Class<?> T, String poolId, String updateId, AgentPoolUpdate agentPoolUpdate) throws RestClientException {
                return (T) getObjectMapper().convertValue(updateAgentPoolsUpdateWithReturnType(T, poolId, updateId, agentPoolUpdate).getBody(), T);
            }




            /**
            * Update an Agent Pool update by id
            * Updates Agent pool update and return latest agent pool update
                * <p><b>201</b> - Updated
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param poolId Id of the agent pool for which the settings will apply (required)
                * @param updateId Id of the update (required)
                * @param agentPoolUpdate  (required)
            * @return ResponseEntity&lt;AgentPoolUpdate&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<AgentPoolUpdate> updateAgentPoolsUpdateWithHttpInfo(String poolId, String updateId, AgentPoolUpdate agentPoolUpdate) throws RestClientException {
            Object localVarPostBody = agentPoolUpdate;
        
                // verify the required parameter 'poolId' is set ''
                if (poolId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'poolId' when calling updateAgentPoolsUpdate");
                }
        
                // verify the required parameter 'updateId' is set ''
                if (updateId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'updateId' when calling updateAgentPoolsUpdate");
                }
        
                // verify the required parameter 'agentPoolUpdate' is set ''
                if (agentPoolUpdate == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'agentPoolUpdate' when calling updateAgentPoolsUpdate");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("poolId", poolId);
                    uriVariables.put("updateId", updateId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = { 
            "application/json"
         };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<AgentPoolUpdate> localReturnType = new ParameterizedTypeReference<AgentPoolUpdate>() {};
            return apiClient.invokeAPI("/api/v1/agentPools/{poolId}/updates/{updateId}", HttpMethod.POST, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }




            /**
            * Update an Agent Pool update by id
            * Updates Agent pool update and return latest agent pool update
                * <p><b>201</b> - Updated
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param poolId Id of the agent pool for which the settings will apply (required)
                * @param updateId Id of the update (required)
                * @param agentPoolUpdate  (required)
            * @return ResponseEntity&lt;AgentPoolUpdate&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private <T> ResponseEntity<T> updateAgentPoolsUpdateWithReturnType(Class<?> T, String poolId,String updateId,AgentPoolUpdate agentPoolUpdate) throws RestClientException {
            Object localVarPostBody = agentPoolUpdate;
        
                // verify the required parameter 'poolId' is set
                if (poolId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'poolId' when calling updateAgentPoolsUpdate");
                }
        
                // verify the required parameter 'updateId' is set
                if (updateId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'updateId' when calling updateAgentPoolsUpdate");
                }
        
                // verify the required parameter 'agentPoolUpdate' is set
                if (agentPoolUpdate == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'agentPoolUpdate' when calling updateAgentPoolsUpdate");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("poolId", poolId);
                    uriVariables.put("updateId", updateId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = { 
            "application/json"
         };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<T> localReturnType = new ParameterizedTypeReference<T>() {};
            return apiClient.invokeAPI("/api/v1/agentPools/{poolId}/updates/{updateId}", HttpMethod.POST, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }




            /**
            * Update an Agent Pool update by id
            * Updates Agent pool update and return latest agent pool update
                * <p><b>201</b> - Updated
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param poolId Id of the agent pool for which the settings will apply (required)
                * @param updateId Id of the update (required)
                * @param agentPoolUpdate  (required)
            * @return ResponseEntity&lt;AgentPoolUpdate&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public PagedList updateAgentPoolsUpdateWithPaginationInfo(String poolId, String updateId, AgentPoolUpdate agentPoolUpdate) throws RestClientException {
            Object localVarPostBody = agentPoolUpdate;
        
                // verify the required parameter 'poolId' is set
                if (poolId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'poolId' when calling updateAgentPoolsUpdate");
                }
        
                // verify the required parameter 'updateId' is set
                if (updateId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'updateId' when calling updateAgentPoolsUpdate");
                }
        
                // verify the required parameter 'agentPoolUpdate' is set
                if (agentPoolUpdate == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'agentPoolUpdate' when calling updateAgentPoolsUpdate");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("poolId", poolId);
                    uriVariables.put("updateId", updateId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = { 
            "application/json"
         };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<AgentPoolUpdate> localReturnType = new ParameterizedTypeReference<AgentPoolUpdate>() {};
            ResponseEntity<AgentPoolUpdate> responseEntity = apiClient.invokeAPI("/api/v1/agentPools/{poolId}/updates/{updateId}", HttpMethod.POST, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                    HttpHeaders headers = responseEntity.getHeaders();
                    PagedList pagedList = new PagedList();
                    List<String> linkHeaders = headers.get("link");
                    String self = null, nextPage = null;
                    for (String link : linkHeaders) {
                    if (link.contains("next")) {
                    nextPage = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    if (link.contains("self")) {
                    self = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    }
                    pagedList.addItems(Arrays.asList(responseEntity.getBody()));
                    if (Objects.nonNull(nextPage)) {
                    pagedList.setNextPage(nextPage);
                    }
                    if (Objects.nonNull(self)) {
                    pagedList.setSelf(self);
                    }
                    return pagedList;
        }

        /**
        * Update an Agent Pool update settings
        * Updates an agent pool update settings
            * <p><b>201</b> - Updated
            * <p><b>400</b> - Bad Request
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>429</b> - Too Many Requests
                * @param poolId Id of the agent pool for which the settings will apply (required)
                * @param agentPoolUpdateSetting  (required)
                * @return AgentPoolUpdateSetting
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public AgentPoolUpdateSetting updateAgentPoolsUpdateSettings(String poolId, AgentPoolUpdateSetting agentPoolUpdateSetting) throws RestClientException {
                return updateAgentPoolsUpdateSettingsWithHttpInfo(poolId, agentPoolUpdateSetting).getBody();
            }




            /**
            * Update an Agent Pool update settings
            * Updates an agent pool update settings
                * <p><b>201</b> - Updated
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param T (required) - the assignable return type
                * @param poolId Id of the agent pool for which the settings will apply (required)
                * @param agentPoolUpdateSetting  (required)
                * @return T instance
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public <T> T updateAgentPoolsUpdateSettings(Class<?> T, String poolId, AgentPoolUpdateSetting agentPoolUpdateSetting) throws RestClientException {
                return (T) getObjectMapper().convertValue(updateAgentPoolsUpdateSettingsWithReturnType(T, poolId, agentPoolUpdateSetting).getBody(), T);
            }




            /**
            * Update an Agent Pool update settings
            * Updates an agent pool update settings
                * <p><b>201</b> - Updated
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param poolId Id of the agent pool for which the settings will apply (required)
                * @param agentPoolUpdateSetting  (required)
            * @return ResponseEntity&lt;AgentPoolUpdateSetting&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<AgentPoolUpdateSetting> updateAgentPoolsUpdateSettingsWithHttpInfo(String poolId, AgentPoolUpdateSetting agentPoolUpdateSetting) throws RestClientException {
            Object localVarPostBody = agentPoolUpdateSetting;
        
                // verify the required parameter 'poolId' is set ''
                if (poolId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'poolId' when calling updateAgentPoolsUpdateSettings");
                }
        
                // verify the required parameter 'agentPoolUpdateSetting' is set ''
                if (agentPoolUpdateSetting == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'agentPoolUpdateSetting' when calling updateAgentPoolsUpdateSettings");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("poolId", poolId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = { 
            "application/json"
         };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<AgentPoolUpdateSetting> localReturnType = new ParameterizedTypeReference<AgentPoolUpdateSetting>() {};
            return apiClient.invokeAPI("/api/v1/agentPools/{poolId}/updates/settings", HttpMethod.POST, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }




            /**
            * Update an Agent Pool update settings
            * Updates an agent pool update settings
                * <p><b>201</b> - Updated
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param poolId Id of the agent pool for which the settings will apply (required)
                * @param agentPoolUpdateSetting  (required)
            * @return ResponseEntity&lt;AgentPoolUpdateSetting&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private <T> ResponseEntity<T> updateAgentPoolsUpdateSettingsWithReturnType(Class<?> T, String poolId,AgentPoolUpdateSetting agentPoolUpdateSetting) throws RestClientException {
            Object localVarPostBody = agentPoolUpdateSetting;
        
                // verify the required parameter 'poolId' is set
                if (poolId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'poolId' when calling updateAgentPoolsUpdateSettings");
                }
        
                // verify the required parameter 'agentPoolUpdateSetting' is set
                if (agentPoolUpdateSetting == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'agentPoolUpdateSetting' when calling updateAgentPoolsUpdateSettings");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("poolId", poolId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = { 
            "application/json"
         };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<T> localReturnType = new ParameterizedTypeReference<T>() {};
            return apiClient.invokeAPI("/api/v1/agentPools/{poolId}/updates/settings", HttpMethod.POST, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }




            /**
            * Update an Agent Pool update settings
            * Updates an agent pool update settings
                * <p><b>201</b> - Updated
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param poolId Id of the agent pool for which the settings will apply (required)
                * @param agentPoolUpdateSetting  (required)
            * @return ResponseEntity&lt;AgentPoolUpdateSetting&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public PagedList updateAgentPoolsUpdateSettingsWithPaginationInfo(String poolId, AgentPoolUpdateSetting agentPoolUpdateSetting) throws RestClientException {
            Object localVarPostBody = agentPoolUpdateSetting;
        
                // verify the required parameter 'poolId' is set
                if (poolId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'poolId' when calling updateAgentPoolsUpdateSettings");
                }
        
                // verify the required parameter 'agentPoolUpdateSetting' is set
                if (agentPoolUpdateSetting == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'agentPoolUpdateSetting' when calling updateAgentPoolsUpdateSettings");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("poolId", poolId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = { 
            "application/json"
         };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<AgentPoolUpdateSetting> localReturnType = new ParameterizedTypeReference<AgentPoolUpdateSetting>() {};
            ResponseEntity<AgentPoolUpdateSetting> responseEntity = apiClient.invokeAPI("/api/v1/agentPools/{poolId}/updates/settings", HttpMethod.POST, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                    HttpHeaders headers = responseEntity.getHeaders();
                    PagedList pagedList = new PagedList();
                    List<String> linkHeaders = headers.get("link");
                    String self = null, nextPage = null;
                    for (String link : linkHeaders) {
                    if (link.contains("next")) {
                    nextPage = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    if (link.contains("self")) {
                    self = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    }
                    pagedList.addItems(Arrays.asList(responseEntity.getBody()));
                    if (Objects.nonNull(nextPage)) {
                    pagedList.setNextPage(nextPage);
                    }
                    if (Objects.nonNull(self)) {
                    pagedList.setSelf(self);
                    }
                    return pagedList;
        }


    private ObjectMapper getObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule(new JavaTimeModule());
        objectMapper.registerModule(new JsonNullableModule());
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        return objectMapper;
    }
        }
