# UserFactorApi

All URIs are relative to *https://subdomain.okta.com*

| Method | HTTP request | Description |
|------------- | ------------- | -------------|
| [**activateFactor**](UserFactorApi.md#activateFactor) | **POST** /api/v1/users/{userId}/factors/{factorId}/lifecycle/activate | Activate a Factor |
| [**deleteFactor**](UserFactorApi.md#deleteFactor) | **DELETE** /api/v1/users/{userId}/factors/{factorId} | Delete a Factor |
| [**enrollFactor**](UserFactorApi.md#enrollFactor) | **POST** /api/v1/users/{userId}/factors | Enroll a Factor |
| [**getFactor**](UserFactorApi.md#getFactor) | **GET** /api/v1/users/{userId}/factors/{factorId} | Retrieve a Factor |
| [**getFactorTransactionStatus**](UserFactorApi.md#getFactorTransactionStatus) | **GET** /api/v1/users/{userId}/factors/{factorId}/transactions/{transactionId} | Retrieve a Factor Transaction Status |
| [**listFactors**](UserFactorApi.md#listFactors) | **GET** /api/v1/users/{userId}/factors | List all Factors |
| [**listSupportedFactors**](UserFactorApi.md#listSupportedFactors) | **GET** /api/v1/users/{userId}/factors/catalog | List all Supported Factors |
| [**listSupportedSecurityQuestions**](UserFactorApi.md#listSupportedSecurityQuestions) | **GET** /api/v1/users/{userId}/factors/questions | List all Supported Security Questions |
| [**verifyFactor**](UserFactorApi.md#verifyFactor) | **POST** /api/v1/users/{userId}/factors/{factorId}/verify | Verify an MFA Factor |



## activateFactor

> UserFactor activateFactor(userId, factorId, body)

Activate a Factor

The &#x60;sms&#x60; and &#x60;token:software:totp&#x60; factor types require activation to complete the enrollment process

### Example

```java
// Import classes:
import org.openapitools.client.ApiClient;
import org.openapitools.client.ApiException;
import org.openapitools.client.Configuration;
import org.openapitools.client.auth.*;
import org.openapitools.client.models.*;
import org.openapitools.client.api.UserFactorApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("https://subdomain.okta.com");
        
        // Configure API key authorization: apiToken
        ApiKeyAuth apiToken = (ApiKeyAuth) defaultClient.getAuthentication("apiToken");
        apiToken.setApiKey("YOUR API KEY");
        // Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
        //apiToken.setApiKeyPrefix("Token");

        // Configure OAuth2 access token for authorization: oauth2
        OAuth oauth2 = (OAuth) defaultClient.getAuthentication("oauth2");
        oauth2.setAccessToken("YOUR ACCESS TOKEN");

        UserFactorApi apiInstance = new UserFactorApi(defaultClient);
        String userId = "userId_example"; // String | 
        String factorId = "factorId_example"; // String | 
        ActivateFactorRequest body = new ActivateFactorRequest(); // ActivateFactorRequest | 
        try {
            UserFactor result = apiInstance.activateFactor(userId, factorId, body);
            System.out.println(result);
        } catch (ApiException e) {
            System.err.println("Exception when calling UserFactorApi#activateFactor");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **userId** | **String**|  | |
| **factorId** | **String**|  | |
| **body** | [**ActivateFactorRequest**](ActivateFactorRequest.md)|  | [optional] |

### Return type

[**UserFactor**](UserFactor.md)

### Authorization

[apiToken](../README.md#apiToken), [oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: application/json
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | Success |  -  |
| **400** | Bad Request |  -  |
| **403** | Forbidden |  -  |
| **404** | Not Found |  -  |
| **429** | Too Many Requests |  -  |


## deleteFactor

> deleteFactor(userId, factorId, removeEnrollmentRecovery)

Delete a Factor

Unenrolls an existing factor for the specified user, allowing the user to enroll a new factor

### Example

```java
// Import classes:
import org.openapitools.client.ApiClient;
import org.openapitools.client.ApiException;
import org.openapitools.client.Configuration;
import org.openapitools.client.auth.*;
import org.openapitools.client.models.*;
import org.openapitools.client.api.UserFactorApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("https://subdomain.okta.com");
        
        // Configure API key authorization: apiToken
        ApiKeyAuth apiToken = (ApiKeyAuth) defaultClient.getAuthentication("apiToken");
        apiToken.setApiKey("YOUR API KEY");
        // Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
        //apiToken.setApiKeyPrefix("Token");

        // Configure OAuth2 access token for authorization: oauth2
        OAuth oauth2 = (OAuth) defaultClient.getAuthentication("oauth2");
        oauth2.setAccessToken("YOUR ACCESS TOKEN");

        UserFactorApi apiInstance = new UserFactorApi(defaultClient);
        String userId = "userId_example"; // String | 
        String factorId = "factorId_example"; // String | 
        Boolean removeEnrollmentRecovery = false; // Boolean | 
        try {
            apiInstance.deleteFactor(userId, factorId, removeEnrollmentRecovery);
        } catch (ApiException e) {
            System.err.println("Exception when calling UserFactorApi#deleteFactor");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **userId** | **String**|  | |
| **factorId** | **String**|  | |
| **removeEnrollmentRecovery** | **Boolean**|  | [optional] [default to false] |

### Return type

null (empty response body)

### Authorization

[apiToken](../README.md#apiToken), [oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **204** | No Content |  -  |
| **403** | Forbidden |  -  |
| **404** | Not Found |  -  |
| **429** | Too Many Requests |  -  |


## enrollFactor

> UserFactor enrollFactor(userId, body, updatePhone, templateId, tokenLifetimeSeconds, activate)

Enroll a Factor

Enrolls a user with a supported factor

### Example

```java
// Import classes:
import org.openapitools.client.ApiClient;
import org.openapitools.client.ApiException;
import org.openapitools.client.Configuration;
import org.openapitools.client.auth.*;
import org.openapitools.client.models.*;
import org.openapitools.client.api.UserFactorApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("https://subdomain.okta.com");
        
        // Configure API key authorization: apiToken
        ApiKeyAuth apiToken = (ApiKeyAuth) defaultClient.getAuthentication("apiToken");
        apiToken.setApiKey("YOUR API KEY");
        // Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
        //apiToken.setApiKeyPrefix("Token");

        // Configure OAuth2 access token for authorization: oauth2
        OAuth oauth2 = (OAuth) defaultClient.getAuthentication("oauth2");
        oauth2.setAccessToken("YOUR ACCESS TOKEN");

        UserFactorApi apiInstance = new UserFactorApi(defaultClient);
        String userId = "userId_example"; // String | 
        UserFactor body = new UserFactor(); // UserFactor | Factor
        Boolean updatePhone = false; // Boolean | 
        String templateId = "templateId_example"; // String | id of SMS template (only for SMS factor)
        Integer tokenLifetimeSeconds = 300; // Integer | 
        Boolean activate = false; // Boolean | 
        try {
            UserFactor result = apiInstance.enrollFactor(userId, body, updatePhone, templateId, tokenLifetimeSeconds, activate);
            System.out.println(result);
        } catch (ApiException e) {
            System.err.println("Exception when calling UserFactorApi#enrollFactor");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **userId** | **String**|  | |
| **body** | [**UserFactor**](UserFactor.md)| Factor | |
| **updatePhone** | **Boolean**|  | [optional] [default to false] |
| **templateId** | **String**| id of SMS template (only for SMS factor) | [optional] |
| **tokenLifetimeSeconds** | **Integer**|  | [optional] [default to 300] |
| **activate** | **Boolean**|  | [optional] [default to false] |

### Return type

[**UserFactor**](UserFactor.md)

### Authorization

[apiToken](../README.md#apiToken), [oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: application/json
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | Success |  -  |
| **400** | Bad Request |  -  |
| **403** | Forbidden |  -  |
| **404** | Not Found |  -  |
| **429** | Too Many Requests |  -  |


## getFactor

> UserFactor getFactor(userId, factorId)

Retrieve a Factor

Retrieves a factor for the specified user

### Example

```java
// Import classes:
import org.openapitools.client.ApiClient;
import org.openapitools.client.ApiException;
import org.openapitools.client.Configuration;
import org.openapitools.client.auth.*;
import org.openapitools.client.models.*;
import org.openapitools.client.api.UserFactorApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("https://subdomain.okta.com");
        
        // Configure API key authorization: apiToken
        ApiKeyAuth apiToken = (ApiKeyAuth) defaultClient.getAuthentication("apiToken");
        apiToken.setApiKey("YOUR API KEY");
        // Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
        //apiToken.setApiKeyPrefix("Token");

        // Configure OAuth2 access token for authorization: oauth2
        OAuth oauth2 = (OAuth) defaultClient.getAuthentication("oauth2");
        oauth2.setAccessToken("YOUR ACCESS TOKEN");

        UserFactorApi apiInstance = new UserFactorApi(defaultClient);
        String userId = "userId_example"; // String | 
        String factorId = "factorId_example"; // String | 
        try {
            UserFactor result = apiInstance.getFactor(userId, factorId);
            System.out.println(result);
        } catch (ApiException e) {
            System.err.println("Exception when calling UserFactorApi#getFactor");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **userId** | **String**|  | |
| **factorId** | **String**|  | |

### Return type

[**UserFactor**](UserFactor.md)

### Authorization

[apiToken](../README.md#apiToken), [oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | Success |  -  |
| **403** | Forbidden |  -  |
| **404** | Not Found |  -  |
| **429** | Too Many Requests |  -  |


## getFactorTransactionStatus

> VerifyUserFactorResponse getFactorTransactionStatus(userId, factorId, transactionId)

Retrieve a Factor Transaction Status

Polls factors verification transaction for status

### Example

```java
// Import classes:
import org.openapitools.client.ApiClient;
import org.openapitools.client.ApiException;
import org.openapitools.client.Configuration;
import org.openapitools.client.auth.*;
import org.openapitools.client.models.*;
import org.openapitools.client.api.UserFactorApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("https://subdomain.okta.com");
        
        // Configure API key authorization: apiToken
        ApiKeyAuth apiToken = (ApiKeyAuth) defaultClient.getAuthentication("apiToken");
        apiToken.setApiKey("YOUR API KEY");
        // Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
        //apiToken.setApiKeyPrefix("Token");

        // Configure OAuth2 access token for authorization: oauth2
        OAuth oauth2 = (OAuth) defaultClient.getAuthentication("oauth2");
        oauth2.setAccessToken("YOUR ACCESS TOKEN");

        UserFactorApi apiInstance = new UserFactorApi(defaultClient);
        String userId = "userId_example"; // String | 
        String factorId = "factorId_example"; // String | 
        String transactionId = "transactionId_example"; // String | 
        try {
            VerifyUserFactorResponse result = apiInstance.getFactorTransactionStatus(userId, factorId, transactionId);
            System.out.println(result);
        } catch (ApiException e) {
            System.err.println("Exception when calling UserFactorApi#getFactorTransactionStatus");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **userId** | **String**|  | |
| **factorId** | **String**|  | |
| **transactionId** | **String**|  | |

### Return type

[**VerifyUserFactorResponse**](VerifyUserFactorResponse.md)

### Authorization

[apiToken](../README.md#apiToken), [oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | Success |  -  |
| **403** | Forbidden |  -  |
| **404** | Not Found |  -  |
| **429** | Too Many Requests |  -  |


## listFactors

> List&lt;UserFactor&gt; listFactors(userId)

List all Factors

Lists all the enrolled factors for the specified user

### Example

```java
// Import classes:
import org.openapitools.client.ApiClient;
import org.openapitools.client.ApiException;
import org.openapitools.client.Configuration;
import org.openapitools.client.auth.*;
import org.openapitools.client.models.*;
import org.openapitools.client.api.UserFactorApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("https://subdomain.okta.com");
        
        // Configure API key authorization: apiToken
        ApiKeyAuth apiToken = (ApiKeyAuth) defaultClient.getAuthentication("apiToken");
        apiToken.setApiKey("YOUR API KEY");
        // Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
        //apiToken.setApiKeyPrefix("Token");

        // Configure OAuth2 access token for authorization: oauth2
        OAuth oauth2 = (OAuth) defaultClient.getAuthentication("oauth2");
        oauth2.setAccessToken("YOUR ACCESS TOKEN");

        UserFactorApi apiInstance = new UserFactorApi(defaultClient);
        String userId = "userId_example"; // String | 
        try {
            List<UserFactor> result = apiInstance.listFactors(userId);
            System.out.println(result);
        } catch (ApiException e) {
            System.err.println("Exception when calling UserFactorApi#listFactors");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **userId** | **String**|  | |

### Return type

[**List&lt;UserFactor&gt;**](UserFactor.md)

### Authorization

[apiToken](../README.md#apiToken), [oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | Success |  -  |
| **403** | Forbidden |  -  |
| **404** | Not Found |  -  |
| **429** | Too Many Requests |  -  |


## listSupportedFactors

> List&lt;UserFactor&gt; listSupportedFactors(userId)

List all Supported Factors

Lists all the supported factors that can be enrolled for the specified user

### Example

```java
// Import classes:
import org.openapitools.client.ApiClient;
import org.openapitools.client.ApiException;
import org.openapitools.client.Configuration;
import org.openapitools.client.auth.*;
import org.openapitools.client.models.*;
import org.openapitools.client.api.UserFactorApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("https://subdomain.okta.com");
        
        // Configure API key authorization: apiToken
        ApiKeyAuth apiToken = (ApiKeyAuth) defaultClient.getAuthentication("apiToken");
        apiToken.setApiKey("YOUR API KEY");
        // Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
        //apiToken.setApiKeyPrefix("Token");

        // Configure OAuth2 access token for authorization: oauth2
        OAuth oauth2 = (OAuth) defaultClient.getAuthentication("oauth2");
        oauth2.setAccessToken("YOUR ACCESS TOKEN");

        UserFactorApi apiInstance = new UserFactorApi(defaultClient);
        String userId = "userId_example"; // String | 
        try {
            List<UserFactor> result = apiInstance.listSupportedFactors(userId);
            System.out.println(result);
        } catch (ApiException e) {
            System.err.println("Exception when calling UserFactorApi#listSupportedFactors");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **userId** | **String**|  | |

### Return type

[**List&lt;UserFactor&gt;**](UserFactor.md)

### Authorization

[apiToken](../README.md#apiToken), [oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | Success |  -  |
| **403** | Forbidden |  -  |
| **404** | Not Found |  -  |
| **429** | Too Many Requests |  -  |


## listSupportedSecurityQuestions

> List&lt;SecurityQuestion&gt; listSupportedSecurityQuestions(userId)

List all Supported Security Questions

Lists all available security questions for a user&#39;s &#x60;question&#x60; factor

### Example

```java
// Import classes:
import org.openapitools.client.ApiClient;
import org.openapitools.client.ApiException;
import org.openapitools.client.Configuration;
import org.openapitools.client.auth.*;
import org.openapitools.client.models.*;
import org.openapitools.client.api.UserFactorApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("https://subdomain.okta.com");
        
        // Configure API key authorization: apiToken
        ApiKeyAuth apiToken = (ApiKeyAuth) defaultClient.getAuthentication("apiToken");
        apiToken.setApiKey("YOUR API KEY");
        // Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
        //apiToken.setApiKeyPrefix("Token");

        UserFactorApi apiInstance = new UserFactorApi(defaultClient);
        String userId = "userId_example"; // String | 
        try {
            List<SecurityQuestion> result = apiInstance.listSupportedSecurityQuestions(userId);
            System.out.println(result);
        } catch (ApiException e) {
            System.err.println("Exception when calling UserFactorApi#listSupportedSecurityQuestions");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **userId** | **String**|  | |

### Return type

[**List&lt;SecurityQuestion&gt;**](SecurityQuestion.md)

### Authorization

[apiToken](../README.md#apiToken)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | Success |  -  |
| **403** | Forbidden |  -  |
| **404** | Not Found |  -  |
| **429** | Too Many Requests |  -  |


## verifyFactor

> VerifyUserFactorResponse verifyFactor(userId, factorId, templateId, tokenLifetimeSeconds, xForwardedFor, userAgent, acceptLanguage, body)

Verify an MFA Factor

Verifies an OTP for a &#x60;token&#x60; or &#x60;token:hardware&#x60; factor

### Example

```java
// Import classes:
import org.openapitools.client.ApiClient;
import org.openapitools.client.ApiException;
import org.openapitools.client.Configuration;
import org.openapitools.client.auth.*;
import org.openapitools.client.models.*;
import org.openapitools.client.api.UserFactorApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("https://subdomain.okta.com");
        
        // Configure API key authorization: apiToken
        ApiKeyAuth apiToken = (ApiKeyAuth) defaultClient.getAuthentication("apiToken");
        apiToken.setApiKey("YOUR API KEY");
        // Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
        //apiToken.setApiKeyPrefix("Token");

        // Configure OAuth2 access token for authorization: oauth2
        OAuth oauth2 = (OAuth) defaultClient.getAuthentication("oauth2");
        oauth2.setAccessToken("YOUR ACCESS TOKEN");

        UserFactorApi apiInstance = new UserFactorApi(defaultClient);
        String userId = "userId_example"; // String | 
        String factorId = "factorId_example"; // String | 
        String templateId = "templateId_example"; // String | 
        Integer tokenLifetimeSeconds = 300; // Integer | 
        String xForwardedFor = "xForwardedFor_example"; // String | 
        String userAgent = "userAgent_example"; // String | 
        String acceptLanguage = "acceptLanguage_example"; // String | 
        VerifyFactorRequest body = new VerifyFactorRequest(); // VerifyFactorRequest | 
        try {
            VerifyUserFactorResponse result = apiInstance.verifyFactor(userId, factorId, templateId, tokenLifetimeSeconds, xForwardedFor, userAgent, acceptLanguage, body);
            System.out.println(result);
        } catch (ApiException e) {
            System.err.println("Exception when calling UserFactorApi#verifyFactor");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **userId** | **String**|  | |
| **factorId** | **String**|  | |
| **templateId** | **String**|  | [optional] |
| **tokenLifetimeSeconds** | **Integer**|  | [optional] [default to 300] |
| **xForwardedFor** | **String**|  | [optional] |
| **userAgent** | **String**|  | [optional] |
| **acceptLanguage** | **String**|  | [optional] |
| **body** | [**VerifyFactorRequest**](VerifyFactorRequest.md)|  | [optional] |

### Return type

[**VerifyUserFactorResponse**](VerifyUserFactorResponse.md)

### Authorization

[apiToken](../README.md#apiToken), [oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: application/json
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | Success |  -  |
| **400** | Bad Request |  -  |
| **403** | Forbidden |  -  |
| **404** | Not Found |  -  |
| **429** | Too Many Requests |  -  |

