# SystemLogApi

All URIs are relative to *https://subdomain.okta.com*

| Method | HTTP request | Description |
|------------- | ------------- | -------------|
| [**listLogEvents**](SystemLogApi.md#listLogEvents) | **GET** /api/v1/logs | List all System Log Events |



## listLogEvents

> List&lt;LogEvent&gt; listLogEvents(since, until, filter, q, limit, sortOrder, after)

List all System Log Events

The Okta System Log API provides read access to your organization’s system log. This API provides more functionality than the Events API

### Example

```java
// Import classes:
import org.openapitools.client.ApiClient;
import org.openapitools.client.ApiException;
import org.openapitools.client.Configuration;
import org.openapitools.client.auth.*;
import org.openapitools.client.models.*;
import org.openapitools.client.api.SystemLogApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("https://subdomain.okta.com");
        
        // Configure API key authorization: apiToken
        ApiKeyAuth apiToken = (ApiKeyAuth) defaultClient.getAuthentication("apiToken");
        apiToken.setApiKey("YOUR API KEY");
        // Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
        //apiToken.setApiKeyPrefix("Token");

        // Configure OAuth2 access token for authorization: oauth2
        OAuth oauth2 = (OAuth) defaultClient.getAuthentication("oauth2");
        oauth2.setAccessToken("YOUR ACCESS TOKEN");

        SystemLogApi apiInstance = new SystemLogApi(defaultClient);
        OffsetDateTime since = OffsetDateTime.now(); // OffsetDateTime | 
        OffsetDateTime until = OffsetDateTime.now(); // OffsetDateTime | 
        String filter = "filter_example"; // String | 
        String q = "q_example"; // String | 
        Integer limit = 100; // Integer | 
        String sortOrder = "ASCENDING"; // String | 
        String after = "after_example"; // String | 
        try {
            List<LogEvent> result = apiInstance.listLogEvents(since, until, filter, q, limit, sortOrder, after);
            System.out.println(result);
        } catch (ApiException e) {
            System.err.println("Exception when calling SystemLogApi#listLogEvents");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **since** | **OffsetDateTime**|  | [optional] |
| **until** | **OffsetDateTime**|  | [optional] |
| **filter** | **String**|  | [optional] |
| **q** | **String**|  | [optional] |
| **limit** | **Integer**|  | [optional] [default to 100] |
| **sortOrder** | **String**|  | [optional] [default to ASCENDING] |
| **after** | **String**|  | [optional] |

### Return type

[**List&lt;LogEvent&gt;**](LogEvent.md)

### Authorization

[apiToken](../README.md#apiToken), [oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | Success |  -  |
| **403** | Forbidden |  -  |
| **429** | Too Many Requests |  -  |

