# ProfileMappingApi

All URIs are relative to *https://subdomain.okta.com*

| Method | HTTP request | Description |
|------------- | ------------- | -------------|
| [**getProfileMapping**](ProfileMappingApi.md#getProfileMapping) | **GET** /api/v1/mappings/{mappingId} | Retrieve a Profile Mapping |
| [**listProfileMappings**](ProfileMappingApi.md#listProfileMappings) | **GET** /api/v1/mappings | List all Profile Mappings |
| [**updateProfileMapping**](ProfileMappingApi.md#updateProfileMapping) | **POST** /api/v1/mappings/{mappingId} | Update a Profile Mapping |



## getProfileMapping

> ProfileMapping getProfileMapping(mappingId)

Retrieve a Profile Mapping

Retrieves a single Profile Mapping referenced by its ID

### Example

```java
// Import classes:
import org.openapitools.client.ApiClient;
import org.openapitools.client.ApiException;
import org.openapitools.client.Configuration;
import org.openapitools.client.auth.*;
import org.openapitools.client.models.*;
import org.openapitools.client.api.ProfileMappingApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("https://subdomain.okta.com");
        
        // Configure API key authorization: apiToken
        ApiKeyAuth apiToken = (ApiKeyAuth) defaultClient.getAuthentication("apiToken");
        apiToken.setApiKey("YOUR API KEY");
        // Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
        //apiToken.setApiKeyPrefix("Token");

        // Configure OAuth2 access token for authorization: oauth2
        OAuth oauth2 = (OAuth) defaultClient.getAuthentication("oauth2");
        oauth2.setAccessToken("YOUR ACCESS TOKEN");

        ProfileMappingApi apiInstance = new ProfileMappingApi(defaultClient);
        String mappingId = "mappingId_example"; // String | 
        try {
            ProfileMapping result = apiInstance.getProfileMapping(mappingId);
            System.out.println(result);
        } catch (ApiException e) {
            System.err.println("Exception when calling ProfileMappingApi#getProfileMapping");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **mappingId** | **String**|  | |

### Return type

[**ProfileMapping**](ProfileMapping.md)

### Authorization

[apiToken](../README.md#apiToken), [oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | Success |  -  |
| **403** | Forbidden |  -  |
| **404** | Not Found |  -  |
| **429** | Too Many Requests |  -  |


## listProfileMappings

> List&lt;ProfileMapping&gt; listProfileMappings(after, limit, sourceId, targetId)

List all Profile Mappings

Lists all profile mappings with pagination

### Example

```java
// Import classes:
import org.openapitools.client.ApiClient;
import org.openapitools.client.ApiException;
import org.openapitools.client.Configuration;
import org.openapitools.client.auth.*;
import org.openapitools.client.models.*;
import org.openapitools.client.api.ProfileMappingApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("https://subdomain.okta.com");
        
        // Configure API key authorization: apiToken
        ApiKeyAuth apiToken = (ApiKeyAuth) defaultClient.getAuthentication("apiToken");
        apiToken.setApiKey("YOUR API KEY");
        // Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
        //apiToken.setApiKeyPrefix("Token");

        // Configure OAuth2 access token for authorization: oauth2
        OAuth oauth2 = (OAuth) defaultClient.getAuthentication("oauth2");
        oauth2.setAccessToken("YOUR ACCESS TOKEN");

        ProfileMappingApi apiInstance = new ProfileMappingApi(defaultClient);
        String after = "after_example"; // String | 
        Integer limit = -1; // Integer | 
        String sourceId = "sourceId_example"; // String | 
        String targetId = ""; // String | 
        try {
            List<ProfileMapping> result = apiInstance.listProfileMappings(after, limit, sourceId, targetId);
            System.out.println(result);
        } catch (ApiException e) {
            System.err.println("Exception when calling ProfileMappingApi#listProfileMappings");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **after** | **String**|  | [optional] |
| **limit** | **Integer**|  | [optional] [default to -1] |
| **sourceId** | **String**|  | [optional] |
| **targetId** | **String**|  | [optional] [default to ] |

### Return type

[**List&lt;ProfileMapping&gt;**](ProfileMapping.md)

### Authorization

[apiToken](../README.md#apiToken), [oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | Success |  -  |
| **403** | Forbidden |  -  |
| **429** | Too Many Requests |  -  |


## updateProfileMapping

> ProfileMapping updateProfileMapping(mappingId, profileMapping)

Update a Profile Mapping

Updates an existing Profile Mapping by adding, updating, or removing one or many Property Mappings

### Example

```java
// Import classes:
import org.openapitools.client.ApiClient;
import org.openapitools.client.ApiException;
import org.openapitools.client.Configuration;
import org.openapitools.client.auth.*;
import org.openapitools.client.models.*;
import org.openapitools.client.api.ProfileMappingApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("https://subdomain.okta.com");
        
        // Configure API key authorization: apiToken
        ApiKeyAuth apiToken = (ApiKeyAuth) defaultClient.getAuthentication("apiToken");
        apiToken.setApiKey("YOUR API KEY");
        // Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
        //apiToken.setApiKeyPrefix("Token");

        // Configure OAuth2 access token for authorization: oauth2
        OAuth oauth2 = (OAuth) defaultClient.getAuthentication("oauth2");
        oauth2.setAccessToken("YOUR ACCESS TOKEN");

        ProfileMappingApi apiInstance = new ProfileMappingApi(defaultClient);
        String mappingId = "mappingId_example"; // String | 
        ProfileMapping profileMapping = new ProfileMapping(); // ProfileMapping | 
        try {
            ProfileMapping result = apiInstance.updateProfileMapping(mappingId, profileMapping);
            System.out.println(result);
        } catch (ApiException e) {
            System.err.println("Exception when calling ProfileMappingApi#updateProfileMapping");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **mappingId** | **String**|  | |
| **profileMapping** | [**ProfileMapping**](ProfileMapping.md)|  | |

### Return type

[**ProfileMapping**](ProfileMapping.md)

### Authorization

[apiToken](../README.md#apiToken), [oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: application/json
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | Success |  -  |
| **400** | Bad Request |  -  |
| **403** | Forbidden |  -  |
| **404** | Not Found |  -  |
| **429** | Too Many Requests |  -  |

