/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client.api;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.okta.sdk.resource.common.PagedList;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.openapitools.client.ApiClient;
import org.openapitools.client.model.LogEvent;
import org.openapitools.jackson.nullable.JsonNullableModule;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestClientException;

@Component(value="org.openapitools.client.api.SystemLogApi")
public class SystemLogApi {
    private ApiClient apiClient;

    public SystemLogApi() {
        this(new ApiClient());
    }

    @Autowired
    public SystemLogApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public List<LogEvent> getLogs(OffsetDateTime since, OffsetDateTime until, String filter, String q, Integer limit, String sortOrder, String after) throws RestClientException {
        return (List)this.getLogsWithHttpInfo(since, until, filter, q, limit, sortOrder, after).getBody();
    }

    private ResponseEntity<List<LogEvent>> getLogsWithHttpInfo(OffsetDateTime since, OffsetDateTime until, String filter, String q, Integer limit, String sortOrder, String after) throws RestClientException {
        Object localVarPostBody = null;
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "since", since));
        localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "until", until));
        localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "filter", filter));
        localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "q", q));
        localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "limit", limit));
        localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "sortOrder", sortOrder));
        localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "after", after));
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"API_Token", "OAuth_2.0"};
        ParameterizedTypeReference<List<LogEvent>> localReturnType = new ParameterizedTypeReference<List<LogEvent>>(){};
        return this.apiClient.invokeAPI("/api/v1/logs", HttpMethod.GET, Collections.emptyMap(), (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    public PagedList getLogsWithPaginationInfo(OffsetDateTime since, OffsetDateTime until, String filter, String q, Integer limit, String sortOrder, String after) throws RestClientException {
        Object localVarPostBody = null;
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "since", since));
        localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "until", until));
        localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "filter", filter));
        localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "q", q));
        localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "limit", limit));
        localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "sortOrder", sortOrder));
        localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "after", after));
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"API_Token", "OAuth_2.0"};
        ParameterizedTypeReference<List<LogEvent>> localReturnType = new ParameterizedTypeReference<List<LogEvent>>(){};
        ResponseEntity<List<LogEvent>> responseEntity = this.apiClient.invokeAPI("/api/v1/logs", HttpMethod.GET, Collections.emptyMap(), (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
        HttpHeaders headers = responseEntity.getHeaders();
        PagedList<List> pagedList = new PagedList<List>();
        List linkHeaders = headers.get((Object)"link");
        String self = null;
        String nextPage = null;
        for (String link : linkHeaders) {
            if (link.contains("next")) {
                nextPage = link.split(";")[0].replaceAll("<", "").replaceAll(">", "");
            }
            if (!link.contains("self")) continue;
            self = link.split(";")[0].replaceAll("<", "").replaceAll(">", "");
        }
        pagedList.addItems(Arrays.asList((List)responseEntity.getBody()));
        if (Objects.nonNull(nextPage)) {
            pagedList.setNextPage(nextPage);
        }
        if (Objects.nonNull(self)) {
            pagedList.setSelf(self);
        }
        return pagedList;
    }

    private ObjectMapper getObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule((Module)new JavaTimeModule());
        objectMapper.registerModule((Module)new JsonNullableModule());
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        return objectMapper;
    }
}

