/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client.api;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.okta.sdk.resource.common.PagedList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import org.openapitools.client.ApiClient;
import org.openapitools.client.model.NetworkZone;
import org.openapitools.jackson.nullable.JsonNullableModule;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.RestClientException;

@Component(value="org.openapitools.client.api.NetworkZoneApi")
public class NetworkZoneApi {
    private ApiClient apiClient;

    public NetworkZoneApi() {
        this(new ApiClient());
    }

    @Autowired
    public NetworkZoneApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public NetworkZone activateNetworkZone(String zoneId) throws RestClientException {
        return (NetworkZone)this.activateNetworkZoneWithHttpInfo(zoneId).getBody();
    }

    private ResponseEntity<NetworkZone> activateNetworkZoneWithHttpInfo(String zoneId) throws RestClientException {
        Object localVarPostBody = null;
        if (zoneId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'zoneId' when calling activateNetworkZone");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("zoneId", zoneId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"API_Token", "OAuth_2.0"};
        ParameterizedTypeReference<NetworkZone> localReturnType = new ParameterizedTypeReference<NetworkZone>(){};
        return this.apiClient.invokeAPI("/api/v1/zones/{zoneId}/lifecycle/activate", HttpMethod.POST, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    public PagedList activateNetworkZoneWithPaginationInfo(String zoneId) throws RestClientException {
        Object localVarPostBody = null;
        if (zoneId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'zoneId' when calling activateNetworkZone");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("zoneId", zoneId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"API_Token", "OAuth_2.0"};
        ParameterizedTypeReference<NetworkZone> localReturnType = new ParameterizedTypeReference<NetworkZone>(){};
        ResponseEntity<NetworkZone> responseEntity = this.apiClient.invokeAPI("/api/v1/zones/{zoneId}/lifecycle/activate", HttpMethod.POST, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
        HttpHeaders headers = responseEntity.getHeaders();
        PagedList<NetworkZone> pagedList = new PagedList<NetworkZone>();
        List linkHeaders = headers.get((Object)"link");
        String self = null;
        String nextPage = null;
        for (String link : linkHeaders) {
            if (link.contains("next")) {
                nextPage = link.split(";")[0].replaceAll("<", "").replaceAll(">", "");
            }
            if (!link.contains("self")) continue;
            self = link.split(";")[0].replaceAll("<", "").replaceAll(">", "");
        }
        pagedList.addItems(Arrays.asList((NetworkZone)responseEntity.getBody()));
        if (Objects.nonNull(nextPage)) {
            pagedList.setNextPage(nextPage);
        }
        if (Objects.nonNull(self)) {
            pagedList.setSelf(self);
        }
        return pagedList;
    }

    public NetworkZone createNetworkZone(NetworkZone zone) throws RestClientException {
        return (NetworkZone)this.createNetworkZoneWithHttpInfo(zone).getBody();
    }

    public <T> T createNetworkZone(Class<?> T, NetworkZone zone) throws RestClientException {
        return (T)this.getObjectMapper().convertValue(this.createNetworkZoneWithReturnType(T, zone).getBody(), T);
    }

    private ResponseEntity<NetworkZone> createNetworkZoneWithHttpInfo(NetworkZone zone) throws RestClientException {
        NetworkZone localVarPostBody = zone;
        if (zone == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'zone' when calling createNetworkZone");
        }
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"API_Token", "OAuth_2.0"};
        ParameterizedTypeReference<NetworkZone> localReturnType = new ParameterizedTypeReference<NetworkZone>(){};
        return this.apiClient.invokeAPI("/api/v1/zones", HttpMethod.POST, Collections.emptyMap(), (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    private <T> ResponseEntity<T> createNetworkZoneWithReturnType(Class<?> T, NetworkZone zone) throws RestClientException {
        NetworkZone localVarPostBody = zone;
        if (zone == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'zone' when calling createNetworkZone");
        }
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"API_Token", "OAuth_2.0"};
        ParameterizedTypeReference localReturnType = new ParameterizedTypeReference<T>(){};
        return this.apiClient.invokeAPI("/api/v1/zones", HttpMethod.POST, Collections.emptyMap(), (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    public PagedList createNetworkZoneWithPaginationInfo(NetworkZone zone) throws RestClientException {
        NetworkZone localVarPostBody = zone;
        if (zone == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'zone' when calling createNetworkZone");
        }
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"API_Token", "OAuth_2.0"};
        ParameterizedTypeReference<NetworkZone> localReturnType = new ParameterizedTypeReference<NetworkZone>(){};
        ResponseEntity<NetworkZone> responseEntity = this.apiClient.invokeAPI("/api/v1/zones", HttpMethod.POST, Collections.emptyMap(), (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
        HttpHeaders headers = responseEntity.getHeaders();
        PagedList<NetworkZone> pagedList = new PagedList<NetworkZone>();
        List linkHeaders = headers.get((Object)"link");
        String self = null;
        String nextPage = null;
        for (String link : linkHeaders) {
            if (link.contains("next")) {
                nextPage = link.split(";")[0].replaceAll("<", "").replaceAll(">", "");
            }
            if (!link.contains("self")) continue;
            self = link.split(";")[0].replaceAll("<", "").replaceAll(">", "");
        }
        pagedList.addItems(Arrays.asList((NetworkZone)responseEntity.getBody()));
        if (Objects.nonNull(nextPage)) {
            pagedList.setNextPage(nextPage);
        }
        if (Objects.nonNull(self)) {
            pagedList.setSelf(self);
        }
        return pagedList;
    }

    public NetworkZone deactivateNetworkZone(String zoneId) throws RestClientException {
        return (NetworkZone)this.deactivateNetworkZoneWithHttpInfo(zoneId).getBody();
    }

    private ResponseEntity<NetworkZone> deactivateNetworkZoneWithHttpInfo(String zoneId) throws RestClientException {
        Object localVarPostBody = null;
        if (zoneId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'zoneId' when calling deactivateNetworkZone");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("zoneId", zoneId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"API_Token", "OAuth_2.0"};
        ParameterizedTypeReference<NetworkZone> localReturnType = new ParameterizedTypeReference<NetworkZone>(){};
        return this.apiClient.invokeAPI("/api/v1/zones/{zoneId}/lifecycle/deactivate", HttpMethod.POST, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    public PagedList deactivateNetworkZoneWithPaginationInfo(String zoneId) throws RestClientException {
        Object localVarPostBody = null;
        if (zoneId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'zoneId' when calling deactivateNetworkZone");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("zoneId", zoneId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"API_Token", "OAuth_2.0"};
        ParameterizedTypeReference<NetworkZone> localReturnType = new ParameterizedTypeReference<NetworkZone>(){};
        ResponseEntity<NetworkZone> responseEntity = this.apiClient.invokeAPI("/api/v1/zones/{zoneId}/lifecycle/deactivate", HttpMethod.POST, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
        HttpHeaders headers = responseEntity.getHeaders();
        PagedList<NetworkZone> pagedList = new PagedList<NetworkZone>();
        List linkHeaders = headers.get((Object)"link");
        String self = null;
        String nextPage = null;
        for (String link : linkHeaders) {
            if (link.contains("next")) {
                nextPage = link.split(";")[0].replaceAll("<", "").replaceAll(">", "");
            }
            if (!link.contains("self")) continue;
            self = link.split(";")[0].replaceAll("<", "").replaceAll(">", "");
        }
        pagedList.addItems(Arrays.asList((NetworkZone)responseEntity.getBody()));
        if (Objects.nonNull(nextPage)) {
            pagedList.setNextPage(nextPage);
        }
        if (Objects.nonNull(self)) {
            pagedList.setSelf(self);
        }
        return pagedList;
    }

    public void deleteNetworkZone(String zoneId) throws RestClientException {
        this.deleteNetworkZoneWithHttpInfo(zoneId);
    }

    private ResponseEntity<Void> deleteNetworkZoneWithHttpInfo(String zoneId) throws RestClientException {
        Object localVarPostBody = null;
        if (zoneId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'zoneId' when calling deleteNetworkZone");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("zoneId", zoneId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"API_Token", "OAuth_2.0"};
        ParameterizedTypeReference<Void> localReturnType = new ParameterizedTypeReference<Void>(){};
        return this.apiClient.invokeAPI("/api/v1/zones/{zoneId}", HttpMethod.DELETE, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    public NetworkZone getNetworkZone(String zoneId) throws RestClientException {
        return (NetworkZone)this.getNetworkZoneWithHttpInfo(zoneId).getBody();
    }

    private ResponseEntity<NetworkZone> getNetworkZoneWithHttpInfo(String zoneId) throws RestClientException {
        Object localVarPostBody = null;
        if (zoneId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'zoneId' when calling getNetworkZone");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("zoneId", zoneId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"API_Token", "OAuth_2.0"};
        ParameterizedTypeReference<NetworkZone> localReturnType = new ParameterizedTypeReference<NetworkZone>(){};
        return this.apiClient.invokeAPI("/api/v1/zones/{zoneId}", HttpMethod.GET, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    public PagedList getNetworkZoneWithPaginationInfo(String zoneId) throws RestClientException {
        Object localVarPostBody = null;
        if (zoneId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'zoneId' when calling getNetworkZone");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("zoneId", zoneId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"API_Token", "OAuth_2.0"};
        ParameterizedTypeReference<NetworkZone> localReturnType = new ParameterizedTypeReference<NetworkZone>(){};
        ResponseEntity<NetworkZone> responseEntity = this.apiClient.invokeAPI("/api/v1/zones/{zoneId}", HttpMethod.GET, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
        HttpHeaders headers = responseEntity.getHeaders();
        PagedList<NetworkZone> pagedList = new PagedList<NetworkZone>();
        List linkHeaders = headers.get((Object)"link");
        String self = null;
        String nextPage = null;
        for (String link : linkHeaders) {
            if (link.contains("next")) {
                nextPage = link.split(";")[0].replaceAll("<", "").replaceAll(">", "");
            }
            if (!link.contains("self")) continue;
            self = link.split(";")[0].replaceAll("<", "").replaceAll(">", "");
        }
        pagedList.addItems(Arrays.asList((NetworkZone)responseEntity.getBody()));
        if (Objects.nonNull(nextPage)) {
            pagedList.setNextPage(nextPage);
        }
        if (Objects.nonNull(self)) {
            pagedList.setSelf(self);
        }
        return pagedList;
    }

    public List<NetworkZone> listNetworkZones(String after, Integer limit, String filter) throws RestClientException {
        return (List)this.listNetworkZonesWithHttpInfo(after, limit, filter).getBody();
    }

    private ResponseEntity<List<NetworkZone>> listNetworkZonesWithHttpInfo(String after, Integer limit, String filter) throws RestClientException {
        Object localVarPostBody = null;
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "after", after));
        localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "limit", limit));
        localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "filter", filter));
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"API_Token", "OAuth_2.0"};
        ParameterizedTypeReference<List<NetworkZone>> localReturnType = new ParameterizedTypeReference<List<NetworkZone>>(){};
        return this.apiClient.invokeAPI("/api/v1/zones", HttpMethod.GET, Collections.emptyMap(), (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    public PagedList listNetworkZonesWithPaginationInfo(String after, Integer limit, String filter) throws RestClientException {
        Object localVarPostBody = null;
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "after", after));
        localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "limit", limit));
        localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "filter", filter));
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"API_Token", "OAuth_2.0"};
        ParameterizedTypeReference<List<NetworkZone>> localReturnType = new ParameterizedTypeReference<List<NetworkZone>>(){};
        ResponseEntity<List<NetworkZone>> responseEntity = this.apiClient.invokeAPI("/api/v1/zones", HttpMethod.GET, Collections.emptyMap(), (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
        HttpHeaders headers = responseEntity.getHeaders();
        PagedList<List> pagedList = new PagedList<List>();
        List linkHeaders = headers.get((Object)"link");
        String self = null;
        String nextPage = null;
        for (String link : linkHeaders) {
            if (link.contains("next")) {
                nextPage = link.split(";")[0].replaceAll("<", "").replaceAll(">", "");
            }
            if (!link.contains("self")) continue;
            self = link.split(";")[0].replaceAll("<", "").replaceAll(">", "");
        }
        pagedList.addItems(Arrays.asList((List)responseEntity.getBody()));
        if (Objects.nonNull(nextPage)) {
            pagedList.setNextPage(nextPage);
        }
        if (Objects.nonNull(self)) {
            pagedList.setSelf(self);
        }
        return pagedList;
    }

    public NetworkZone updateNetworkZone(String zoneId, NetworkZone zone) throws RestClientException {
        return (NetworkZone)this.updateNetworkZoneWithHttpInfo(zoneId, zone).getBody();
    }

    public <T> T updateNetworkZone(Class<?> T, String zoneId, NetworkZone zone) throws RestClientException {
        return (T)this.getObjectMapper().convertValue(this.updateNetworkZoneWithReturnType(T, zoneId, zone).getBody(), T);
    }

    private ResponseEntity<NetworkZone> updateNetworkZoneWithHttpInfo(String zoneId, NetworkZone zone) throws RestClientException {
        NetworkZone localVarPostBody = zone;
        if (zoneId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'zoneId' when calling updateNetworkZone");
        }
        if (zone == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'zone' when calling updateNetworkZone");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("zoneId", zoneId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"API_Token", "OAuth_2.0"};
        ParameterizedTypeReference<NetworkZone> localReturnType = new ParameterizedTypeReference<NetworkZone>(){};
        return this.apiClient.invokeAPI("/api/v1/zones/{zoneId}", HttpMethod.PUT, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    private <T> ResponseEntity<T> updateNetworkZoneWithReturnType(Class<?> T, String zoneId, NetworkZone zone) throws RestClientException {
        NetworkZone localVarPostBody = zone;
        if (zoneId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'zoneId' when calling updateNetworkZone");
        }
        if (zone == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'zone' when calling updateNetworkZone");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("zoneId", zoneId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"API_Token", "OAuth_2.0"};
        ParameterizedTypeReference localReturnType = new ParameterizedTypeReference<T>(){};
        return this.apiClient.invokeAPI("/api/v1/zones/{zoneId}", HttpMethod.PUT, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    public PagedList updateNetworkZoneWithPaginationInfo(String zoneId, NetworkZone zone) throws RestClientException {
        NetworkZone localVarPostBody = zone;
        if (zoneId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'zoneId' when calling updateNetworkZone");
        }
        if (zone == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'zone' when calling updateNetworkZone");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("zoneId", zoneId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"API_Token", "OAuth_2.0"};
        ParameterizedTypeReference<NetworkZone> localReturnType = new ParameterizedTypeReference<NetworkZone>(){};
        ResponseEntity<NetworkZone> responseEntity = this.apiClient.invokeAPI("/api/v1/zones/{zoneId}", HttpMethod.PUT, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
        HttpHeaders headers = responseEntity.getHeaders();
        PagedList<NetworkZone> pagedList = new PagedList<NetworkZone>();
        List linkHeaders = headers.get((Object)"link");
        String self = null;
        String nextPage = null;
        for (String link : linkHeaders) {
            if (link.contains("next")) {
                nextPage = link.split(";")[0].replaceAll("<", "").replaceAll(">", "");
            }
            if (!link.contains("self")) continue;
            self = link.split(";")[0].replaceAll("<", "").replaceAll(">", "");
        }
        pagedList.addItems(Arrays.asList((NetworkZone)responseEntity.getBody()));
        if (Objects.nonNull(nextPage)) {
            pagedList.setNextPage(nextPage);
        }
        if (Objects.nonNull(self)) {
            pagedList.setSelf(self);
        }
        return pagedList;
    }

    private ObjectMapper getObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule((Module)new JavaTimeModule());
        objectMapper.registerModule((Module)new JsonNullableModule());
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        return objectMapper;
    }
}

