/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client.api;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.okta.sdk.resource.common.PagedList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import org.openapitools.client.ApiClient;
import org.openapitools.client.model.AgentPool;
import org.openapitools.client.model.AgentPoolUpdate;
import org.openapitools.client.model.AgentPoolUpdateSetting;
import org.openapitools.jackson.nullable.JsonNullableModule;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.RestClientException;

@Component(value="org.openapitools.client.api.AgentPoolsApi")
public class AgentPoolsApi {
    private ApiClient apiClient;

    public AgentPoolsApi() {
        this(new ApiClient());
    }

    @Autowired
    public AgentPoolsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public AgentPoolUpdate activateAgentPoolsUpdate(String poolId, String updateId) throws RestClientException {
        return (AgentPoolUpdate)this.activateAgentPoolsUpdateWithHttpInfo(poolId, updateId).getBody();
    }

    private ResponseEntity<AgentPoolUpdate> activateAgentPoolsUpdateWithHttpInfo(String poolId, String updateId) throws RestClientException {
        Object localVarPostBody = null;
        if (poolId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'poolId' when calling activateAgentPoolsUpdate");
        }
        if (updateId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'updateId' when calling activateAgentPoolsUpdate");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("poolId", poolId);
        uriVariables.put("updateId", updateId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"API_Token", "OAuth_2.0"};
        ParameterizedTypeReference<AgentPoolUpdate> localReturnType = new ParameterizedTypeReference<AgentPoolUpdate>(){};
        return this.apiClient.invokeAPI("/api/v1/agentPools/{poolId}/updates/{updateId}/activate", HttpMethod.POST, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    public PagedList activateAgentPoolsUpdateWithPaginationInfo(String poolId, String updateId) throws RestClientException {
        Object localVarPostBody = null;
        if (poolId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'poolId' when calling activateAgentPoolsUpdate");
        }
        if (updateId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'updateId' when calling activateAgentPoolsUpdate");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("poolId", poolId);
        uriVariables.put("updateId", updateId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"API_Token", "OAuth_2.0"};
        ParameterizedTypeReference<AgentPoolUpdate> localReturnType = new ParameterizedTypeReference<AgentPoolUpdate>(){};
        ResponseEntity<AgentPoolUpdate> responseEntity = this.apiClient.invokeAPI("/api/v1/agentPools/{poolId}/updates/{updateId}/activate", HttpMethod.POST, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
        HttpHeaders headers = responseEntity.getHeaders();
        PagedList<AgentPoolUpdate> pagedList = new PagedList<AgentPoolUpdate>();
        List linkHeaders = headers.get((Object)"link");
        String self = null;
        String nextPage = null;
        for (String link : linkHeaders) {
            if (link.contains("next")) {
                nextPage = link.split(";")[0].replaceAll("<", "").replaceAll(">", "");
            }
            if (!link.contains("self")) continue;
            self = link.split(";")[0].replaceAll("<", "").replaceAll(">", "");
        }
        pagedList.addItems(Arrays.asList((AgentPoolUpdate)responseEntity.getBody()));
        if (Objects.nonNull(nextPage)) {
            pagedList.setNextPage(nextPage);
        }
        if (Objects.nonNull(self)) {
            pagedList.setSelf(self);
        }
        return pagedList;
    }

    public AgentPoolUpdate createAgentPoolsUpdate(String poolId, AgentPoolUpdate agentPoolUpdate) throws RestClientException {
        return (AgentPoolUpdate)this.createAgentPoolsUpdateWithHttpInfo(poolId, agentPoolUpdate).getBody();
    }

    public <T> T createAgentPoolsUpdate(Class<?> T, String poolId, AgentPoolUpdate agentPoolUpdate) throws RestClientException {
        return (T)this.getObjectMapper().convertValue(this.createAgentPoolsUpdateWithReturnType(T, poolId, agentPoolUpdate).getBody(), T);
    }

    private ResponseEntity<AgentPoolUpdate> createAgentPoolsUpdateWithHttpInfo(String poolId, AgentPoolUpdate agentPoolUpdate) throws RestClientException {
        AgentPoolUpdate localVarPostBody = agentPoolUpdate;
        if (poolId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'poolId' when calling createAgentPoolsUpdate");
        }
        if (agentPoolUpdate == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'agentPoolUpdate' when calling createAgentPoolsUpdate");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("poolId", poolId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"API_Token", "OAuth_2.0"};
        ParameterizedTypeReference<AgentPoolUpdate> localReturnType = new ParameterizedTypeReference<AgentPoolUpdate>(){};
        return this.apiClient.invokeAPI("/api/v1/agentPools/{poolId}/updates", HttpMethod.POST, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    private <T> ResponseEntity<T> createAgentPoolsUpdateWithReturnType(Class<?> T, String poolId, AgentPoolUpdate agentPoolUpdate) throws RestClientException {
        AgentPoolUpdate localVarPostBody = agentPoolUpdate;
        if (poolId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'poolId' when calling createAgentPoolsUpdate");
        }
        if (agentPoolUpdate == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'agentPoolUpdate' when calling createAgentPoolsUpdate");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("poolId", poolId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"API_Token", "OAuth_2.0"};
        ParameterizedTypeReference localReturnType = new ParameterizedTypeReference<T>(){};
        return this.apiClient.invokeAPI("/api/v1/agentPools/{poolId}/updates", HttpMethod.POST, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    public PagedList createAgentPoolsUpdateWithPaginationInfo(String poolId, AgentPoolUpdate agentPoolUpdate) throws RestClientException {
        AgentPoolUpdate localVarPostBody = agentPoolUpdate;
        if (poolId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'poolId' when calling createAgentPoolsUpdate");
        }
        if (agentPoolUpdate == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'agentPoolUpdate' when calling createAgentPoolsUpdate");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("poolId", poolId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"API_Token", "OAuth_2.0"};
        ParameterizedTypeReference<AgentPoolUpdate> localReturnType = new ParameterizedTypeReference<AgentPoolUpdate>(){};
        ResponseEntity<AgentPoolUpdate> responseEntity = this.apiClient.invokeAPI("/api/v1/agentPools/{poolId}/updates", HttpMethod.POST, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
        HttpHeaders headers = responseEntity.getHeaders();
        PagedList<AgentPoolUpdate> pagedList = new PagedList<AgentPoolUpdate>();
        List linkHeaders = headers.get((Object)"link");
        String self = null;
        String nextPage = null;
        for (String link : linkHeaders) {
            if (link.contains("next")) {
                nextPage = link.split(";")[0].replaceAll("<", "").replaceAll(">", "");
            }
            if (!link.contains("self")) continue;
            self = link.split(";")[0].replaceAll("<", "").replaceAll(">", "");
        }
        pagedList.addItems(Arrays.asList((AgentPoolUpdate)responseEntity.getBody()));
        if (Objects.nonNull(nextPage)) {
            pagedList.setNextPage(nextPage);
        }
        if (Objects.nonNull(self)) {
            pagedList.setSelf(self);
        }
        return pagedList;
    }

    public AgentPoolUpdate deactivateAgentPoolsUpdate(String poolId, String updateId) throws RestClientException {
        return (AgentPoolUpdate)this.deactivateAgentPoolsUpdateWithHttpInfo(poolId, updateId).getBody();
    }

    private ResponseEntity<AgentPoolUpdate> deactivateAgentPoolsUpdateWithHttpInfo(String poolId, String updateId) throws RestClientException {
        Object localVarPostBody = null;
        if (poolId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'poolId' when calling deactivateAgentPoolsUpdate");
        }
        if (updateId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'updateId' when calling deactivateAgentPoolsUpdate");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("poolId", poolId);
        uriVariables.put("updateId", updateId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"API_Token", "OAuth_2.0"};
        ParameterizedTypeReference<AgentPoolUpdate> localReturnType = new ParameterizedTypeReference<AgentPoolUpdate>(){};
        return this.apiClient.invokeAPI("/api/v1/agentPools/{poolId}/updates/{updateId}/deactivate", HttpMethod.POST, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    public PagedList deactivateAgentPoolsUpdateWithPaginationInfo(String poolId, String updateId) throws RestClientException {
        Object localVarPostBody = null;
        if (poolId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'poolId' when calling deactivateAgentPoolsUpdate");
        }
        if (updateId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'updateId' when calling deactivateAgentPoolsUpdate");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("poolId", poolId);
        uriVariables.put("updateId", updateId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"API_Token", "OAuth_2.0"};
        ParameterizedTypeReference<AgentPoolUpdate> localReturnType = new ParameterizedTypeReference<AgentPoolUpdate>(){};
        ResponseEntity<AgentPoolUpdate> responseEntity = this.apiClient.invokeAPI("/api/v1/agentPools/{poolId}/updates/{updateId}/deactivate", HttpMethod.POST, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
        HttpHeaders headers = responseEntity.getHeaders();
        PagedList<AgentPoolUpdate> pagedList = new PagedList<AgentPoolUpdate>();
        List linkHeaders = headers.get((Object)"link");
        String self = null;
        String nextPage = null;
        for (String link : linkHeaders) {
            if (link.contains("next")) {
                nextPage = link.split(";")[0].replaceAll("<", "").replaceAll(">", "");
            }
            if (!link.contains("self")) continue;
            self = link.split(";")[0].replaceAll("<", "").replaceAll(">", "");
        }
        pagedList.addItems(Arrays.asList((AgentPoolUpdate)responseEntity.getBody()));
        if (Objects.nonNull(nextPage)) {
            pagedList.setNextPage(nextPage);
        }
        if (Objects.nonNull(self)) {
            pagedList.setSelf(self);
        }
        return pagedList;
    }

    public void deleteAgentPoolsUpdate(String poolId, String updateId) throws RestClientException {
        this.deleteAgentPoolsUpdateWithHttpInfo(poolId, updateId);
    }

    private ResponseEntity<Void> deleteAgentPoolsUpdateWithHttpInfo(String poolId, String updateId) throws RestClientException {
        Object localVarPostBody = null;
        if (poolId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'poolId' when calling deleteAgentPoolsUpdate");
        }
        if (updateId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'updateId' when calling deleteAgentPoolsUpdate");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("poolId", poolId);
        uriVariables.put("updateId", updateId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"API_Token", "OAuth_2.0"};
        ParameterizedTypeReference<Void> localReturnType = new ParameterizedTypeReference<Void>(){};
        return this.apiClient.invokeAPI("/api/v1/agentPools/{poolId}/updates/{updateId}", HttpMethod.DELETE, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    public List<AgentPool> getAgentPools(Integer limitPerPoolType, String poolType, String after) throws RestClientException {
        return (List)this.getAgentPoolsWithHttpInfo(limitPerPoolType, poolType, after).getBody();
    }

    private ResponseEntity<List<AgentPool>> getAgentPoolsWithHttpInfo(Integer limitPerPoolType, String poolType, String after) throws RestClientException {
        Object localVarPostBody = null;
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "limitPerPoolType", limitPerPoolType));
        localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "poolType", poolType));
        localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "after", after));
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"API_Token", "OAuth_2.0"};
        ParameterizedTypeReference<List<AgentPool>> localReturnType = new ParameterizedTypeReference<List<AgentPool>>(){};
        return this.apiClient.invokeAPI("/api/v1/agentPools", HttpMethod.GET, Collections.emptyMap(), (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    public PagedList getAgentPoolsWithPaginationInfo(Integer limitPerPoolType, String poolType, String after) throws RestClientException {
        Object localVarPostBody = null;
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "limitPerPoolType", limitPerPoolType));
        localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "poolType", poolType));
        localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "after", after));
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"API_Token", "OAuth_2.0"};
        ParameterizedTypeReference<List<AgentPool>> localReturnType = new ParameterizedTypeReference<List<AgentPool>>(){};
        ResponseEntity<List<AgentPool>> responseEntity = this.apiClient.invokeAPI("/api/v1/agentPools", HttpMethod.GET, Collections.emptyMap(), (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
        HttpHeaders headers = responseEntity.getHeaders();
        PagedList<List> pagedList = new PagedList<List>();
        List linkHeaders = headers.get((Object)"link");
        String self = null;
        String nextPage = null;
        for (String link : linkHeaders) {
            if (link.contains("next")) {
                nextPage = link.split(";")[0].replaceAll("<", "").replaceAll(">", "");
            }
            if (!link.contains("self")) continue;
            self = link.split(";")[0].replaceAll("<", "").replaceAll(">", "");
        }
        pagedList.addItems(Arrays.asList((List)responseEntity.getBody()));
        if (Objects.nonNull(nextPage)) {
            pagedList.setNextPage(nextPage);
        }
        if (Objects.nonNull(self)) {
            pagedList.setSelf(self);
        }
        return pagedList;
    }

    public AgentPoolUpdate getAgentPoolsUpdateInstance(String poolId, String updateId) throws RestClientException {
        return (AgentPoolUpdate)this.getAgentPoolsUpdateInstanceWithHttpInfo(poolId, updateId).getBody();
    }

    private ResponseEntity<AgentPoolUpdate> getAgentPoolsUpdateInstanceWithHttpInfo(String poolId, String updateId) throws RestClientException {
        Object localVarPostBody = null;
        if (poolId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'poolId' when calling getAgentPoolsUpdateInstance");
        }
        if (updateId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'updateId' when calling getAgentPoolsUpdateInstance");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("poolId", poolId);
        uriVariables.put("updateId", updateId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"API_Token", "OAuth_2.0"};
        ParameterizedTypeReference<AgentPoolUpdate> localReturnType = new ParameterizedTypeReference<AgentPoolUpdate>(){};
        return this.apiClient.invokeAPI("/api/v1/agentPools/{poolId}/updates/{updateId}", HttpMethod.GET, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    public PagedList getAgentPoolsUpdateInstanceWithPaginationInfo(String poolId, String updateId) throws RestClientException {
        Object localVarPostBody = null;
        if (poolId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'poolId' when calling getAgentPoolsUpdateInstance");
        }
        if (updateId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'updateId' when calling getAgentPoolsUpdateInstance");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("poolId", poolId);
        uriVariables.put("updateId", updateId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"API_Token", "OAuth_2.0"};
        ParameterizedTypeReference<AgentPoolUpdate> localReturnType = new ParameterizedTypeReference<AgentPoolUpdate>(){};
        ResponseEntity<AgentPoolUpdate> responseEntity = this.apiClient.invokeAPI("/api/v1/agentPools/{poolId}/updates/{updateId}", HttpMethod.GET, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
        HttpHeaders headers = responseEntity.getHeaders();
        PagedList<AgentPoolUpdate> pagedList = new PagedList<AgentPoolUpdate>();
        List linkHeaders = headers.get((Object)"link");
        String self = null;
        String nextPage = null;
        for (String link : linkHeaders) {
            if (link.contains("next")) {
                nextPage = link.split(";")[0].replaceAll("<", "").replaceAll(">", "");
            }
            if (!link.contains("self")) continue;
            self = link.split(";")[0].replaceAll("<", "").replaceAll(">", "");
        }
        pagedList.addItems(Arrays.asList((AgentPoolUpdate)responseEntity.getBody()));
        if (Objects.nonNull(nextPage)) {
            pagedList.setNextPage(nextPage);
        }
        if (Objects.nonNull(self)) {
            pagedList.setSelf(self);
        }
        return pagedList;
    }

    public AgentPoolUpdateSetting getAgentPoolsUpdateSettings(String poolId) throws RestClientException {
        return (AgentPoolUpdateSetting)this.getAgentPoolsUpdateSettingsWithHttpInfo(poolId).getBody();
    }

    private ResponseEntity<AgentPoolUpdateSetting> getAgentPoolsUpdateSettingsWithHttpInfo(String poolId) throws RestClientException {
        Object localVarPostBody = null;
        if (poolId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'poolId' when calling getAgentPoolsUpdateSettings");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("poolId", poolId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"API_Token", "OAuth_2.0"};
        ParameterizedTypeReference<AgentPoolUpdateSetting> localReturnType = new ParameterizedTypeReference<AgentPoolUpdateSetting>(){};
        return this.apiClient.invokeAPI("/api/v1/agentPools/{poolId}/updates/settings", HttpMethod.GET, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    public PagedList getAgentPoolsUpdateSettingsWithPaginationInfo(String poolId) throws RestClientException {
        Object localVarPostBody = null;
        if (poolId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'poolId' when calling getAgentPoolsUpdateSettings");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("poolId", poolId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"API_Token", "OAuth_2.0"};
        ParameterizedTypeReference<AgentPoolUpdateSetting> localReturnType = new ParameterizedTypeReference<AgentPoolUpdateSetting>(){};
        ResponseEntity<AgentPoolUpdateSetting> responseEntity = this.apiClient.invokeAPI("/api/v1/agentPools/{poolId}/updates/settings", HttpMethod.GET, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
        HttpHeaders headers = responseEntity.getHeaders();
        PagedList<AgentPoolUpdateSetting> pagedList = new PagedList<AgentPoolUpdateSetting>();
        List linkHeaders = headers.get((Object)"link");
        String self = null;
        String nextPage = null;
        for (String link : linkHeaders) {
            if (link.contains("next")) {
                nextPage = link.split(";")[0].replaceAll("<", "").replaceAll(">", "");
            }
            if (!link.contains("self")) continue;
            self = link.split(";")[0].replaceAll("<", "").replaceAll(">", "");
        }
        pagedList.addItems(Arrays.asList((AgentPoolUpdateSetting)responseEntity.getBody()));
        if (Objects.nonNull(nextPage)) {
            pagedList.setNextPage(nextPage);
        }
        if (Objects.nonNull(self)) {
            pagedList.setSelf(self);
        }
        return pagedList;
    }

    public List<AgentPoolUpdate> getAgentPoolsUpdates(String poolId, Boolean scheduled) throws RestClientException {
        return (List)this.getAgentPoolsUpdatesWithHttpInfo(poolId, scheduled).getBody();
    }

    private ResponseEntity<List<AgentPoolUpdate>> getAgentPoolsUpdatesWithHttpInfo(String poolId, Boolean scheduled) throws RestClientException {
        Object localVarPostBody = null;
        if (poolId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'poolId' when calling getAgentPoolsUpdates");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("poolId", poolId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "scheduled", scheduled));
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"API_Token", "OAuth_2.0"};
        ParameterizedTypeReference<List<AgentPoolUpdate>> localReturnType = new ParameterizedTypeReference<List<AgentPoolUpdate>>(){};
        return this.apiClient.invokeAPI("/api/v1/agentPools/{poolId}/updates", HttpMethod.GET, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    public PagedList getAgentPoolsUpdatesWithPaginationInfo(String poolId, Boolean scheduled) throws RestClientException {
        Object localVarPostBody = null;
        if (poolId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'poolId' when calling getAgentPoolsUpdates");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("poolId", poolId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "scheduled", scheduled));
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"API_Token", "OAuth_2.0"};
        ParameterizedTypeReference<List<AgentPoolUpdate>> localReturnType = new ParameterizedTypeReference<List<AgentPoolUpdate>>(){};
        ResponseEntity<List<AgentPoolUpdate>> responseEntity = this.apiClient.invokeAPI("/api/v1/agentPools/{poolId}/updates", HttpMethod.GET, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
        HttpHeaders headers = responseEntity.getHeaders();
        PagedList<List> pagedList = new PagedList<List>();
        List linkHeaders = headers.get((Object)"link");
        String self = null;
        String nextPage = null;
        for (String link : linkHeaders) {
            if (link.contains("next")) {
                nextPage = link.split(";")[0].replaceAll("<", "").replaceAll(">", "");
            }
            if (!link.contains("self")) continue;
            self = link.split(";")[0].replaceAll("<", "").replaceAll(">", "");
        }
        pagedList.addItems(Arrays.asList((List)responseEntity.getBody()));
        if (Objects.nonNull(nextPage)) {
            pagedList.setNextPage(nextPage);
        }
        if (Objects.nonNull(self)) {
            pagedList.setSelf(self);
        }
        return pagedList;
    }

    public AgentPoolUpdate pauseAgentPoolsUpdate(String poolId, String updateId) throws RestClientException {
        return (AgentPoolUpdate)this.pauseAgentPoolsUpdateWithHttpInfo(poolId, updateId).getBody();
    }

    private ResponseEntity<AgentPoolUpdate> pauseAgentPoolsUpdateWithHttpInfo(String poolId, String updateId) throws RestClientException {
        Object localVarPostBody = null;
        if (poolId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'poolId' when calling pauseAgentPoolsUpdate");
        }
        if (updateId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'updateId' when calling pauseAgentPoolsUpdate");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("poolId", poolId);
        uriVariables.put("updateId", updateId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"API_Token", "OAuth_2.0"};
        ParameterizedTypeReference<AgentPoolUpdate> localReturnType = new ParameterizedTypeReference<AgentPoolUpdate>(){};
        return this.apiClient.invokeAPI("/api/v1/agentPools/{poolId}/updates/{updateId}/pause", HttpMethod.POST, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    public PagedList pauseAgentPoolsUpdateWithPaginationInfo(String poolId, String updateId) throws RestClientException {
        Object localVarPostBody = null;
        if (poolId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'poolId' when calling pauseAgentPoolsUpdate");
        }
        if (updateId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'updateId' when calling pauseAgentPoolsUpdate");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("poolId", poolId);
        uriVariables.put("updateId", updateId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"API_Token", "OAuth_2.0"};
        ParameterizedTypeReference<AgentPoolUpdate> localReturnType = new ParameterizedTypeReference<AgentPoolUpdate>(){};
        ResponseEntity<AgentPoolUpdate> responseEntity = this.apiClient.invokeAPI("/api/v1/agentPools/{poolId}/updates/{updateId}/pause", HttpMethod.POST, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
        HttpHeaders headers = responseEntity.getHeaders();
        PagedList<AgentPoolUpdate> pagedList = new PagedList<AgentPoolUpdate>();
        List linkHeaders = headers.get((Object)"link");
        String self = null;
        String nextPage = null;
        for (String link : linkHeaders) {
            if (link.contains("next")) {
                nextPage = link.split(";")[0].replaceAll("<", "").replaceAll(">", "");
            }
            if (!link.contains("self")) continue;
            self = link.split(";")[0].replaceAll("<", "").replaceAll(">", "");
        }
        pagedList.addItems(Arrays.asList((AgentPoolUpdate)responseEntity.getBody()));
        if (Objects.nonNull(nextPage)) {
            pagedList.setNextPage(nextPage);
        }
        if (Objects.nonNull(self)) {
            pagedList.setSelf(self);
        }
        return pagedList;
    }

    public AgentPoolUpdate resumeAgentPoolsUpdate(String poolId, String updateId) throws RestClientException {
        return (AgentPoolUpdate)this.resumeAgentPoolsUpdateWithHttpInfo(poolId, updateId).getBody();
    }

    private ResponseEntity<AgentPoolUpdate> resumeAgentPoolsUpdateWithHttpInfo(String poolId, String updateId) throws RestClientException {
        Object localVarPostBody = null;
        if (poolId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'poolId' when calling resumeAgentPoolsUpdate");
        }
        if (updateId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'updateId' when calling resumeAgentPoolsUpdate");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("poolId", poolId);
        uriVariables.put("updateId", updateId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"API_Token", "OAuth_2.0"};
        ParameterizedTypeReference<AgentPoolUpdate> localReturnType = new ParameterizedTypeReference<AgentPoolUpdate>(){};
        return this.apiClient.invokeAPI("/api/v1/agentPools/{poolId}/updates/{updateId}/resume", HttpMethod.POST, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    public PagedList resumeAgentPoolsUpdateWithPaginationInfo(String poolId, String updateId) throws RestClientException {
        Object localVarPostBody = null;
        if (poolId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'poolId' when calling resumeAgentPoolsUpdate");
        }
        if (updateId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'updateId' when calling resumeAgentPoolsUpdate");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("poolId", poolId);
        uriVariables.put("updateId", updateId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"API_Token", "OAuth_2.0"};
        ParameterizedTypeReference<AgentPoolUpdate> localReturnType = new ParameterizedTypeReference<AgentPoolUpdate>(){};
        ResponseEntity<AgentPoolUpdate> responseEntity = this.apiClient.invokeAPI("/api/v1/agentPools/{poolId}/updates/{updateId}/resume", HttpMethod.POST, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
        HttpHeaders headers = responseEntity.getHeaders();
        PagedList<AgentPoolUpdate> pagedList = new PagedList<AgentPoolUpdate>();
        List linkHeaders = headers.get((Object)"link");
        String self = null;
        String nextPage = null;
        for (String link : linkHeaders) {
            if (link.contains("next")) {
                nextPage = link.split(";")[0].replaceAll("<", "").replaceAll(">", "");
            }
            if (!link.contains("self")) continue;
            self = link.split(";")[0].replaceAll("<", "").replaceAll(">", "");
        }
        pagedList.addItems(Arrays.asList((AgentPoolUpdate)responseEntity.getBody()));
        if (Objects.nonNull(nextPage)) {
            pagedList.setNextPage(nextPage);
        }
        if (Objects.nonNull(self)) {
            pagedList.setSelf(self);
        }
        return pagedList;
    }

    public AgentPoolUpdate retryAgentPoolsUpdate(String poolId, String updateId) throws RestClientException {
        return (AgentPoolUpdate)this.retryAgentPoolsUpdateWithHttpInfo(poolId, updateId).getBody();
    }

    private ResponseEntity<AgentPoolUpdate> retryAgentPoolsUpdateWithHttpInfo(String poolId, String updateId) throws RestClientException {
        Object localVarPostBody = null;
        if (poolId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'poolId' when calling retryAgentPoolsUpdate");
        }
        if (updateId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'updateId' when calling retryAgentPoolsUpdate");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("poolId", poolId);
        uriVariables.put("updateId", updateId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"API_Token", "OAuth_2.0"};
        ParameterizedTypeReference<AgentPoolUpdate> localReturnType = new ParameterizedTypeReference<AgentPoolUpdate>(){};
        return this.apiClient.invokeAPI("/api/v1/agentPools/{poolId}/updates/{updateId}/retry", HttpMethod.POST, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    public PagedList retryAgentPoolsUpdateWithPaginationInfo(String poolId, String updateId) throws RestClientException {
        Object localVarPostBody = null;
        if (poolId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'poolId' when calling retryAgentPoolsUpdate");
        }
        if (updateId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'updateId' when calling retryAgentPoolsUpdate");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("poolId", poolId);
        uriVariables.put("updateId", updateId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"API_Token", "OAuth_2.0"};
        ParameterizedTypeReference<AgentPoolUpdate> localReturnType = new ParameterizedTypeReference<AgentPoolUpdate>(){};
        ResponseEntity<AgentPoolUpdate> responseEntity = this.apiClient.invokeAPI("/api/v1/agentPools/{poolId}/updates/{updateId}/retry", HttpMethod.POST, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
        HttpHeaders headers = responseEntity.getHeaders();
        PagedList<AgentPoolUpdate> pagedList = new PagedList<AgentPoolUpdate>();
        List linkHeaders = headers.get((Object)"link");
        String self = null;
        String nextPage = null;
        for (String link : linkHeaders) {
            if (link.contains("next")) {
                nextPage = link.split(";")[0].replaceAll("<", "").replaceAll(">", "");
            }
            if (!link.contains("self")) continue;
            self = link.split(";")[0].replaceAll("<", "").replaceAll(">", "");
        }
        pagedList.addItems(Arrays.asList((AgentPoolUpdate)responseEntity.getBody()));
        if (Objects.nonNull(nextPage)) {
            pagedList.setNextPage(nextPage);
        }
        if (Objects.nonNull(self)) {
            pagedList.setSelf(self);
        }
        return pagedList;
    }

    public AgentPoolUpdateSetting setAgentPoolsUpdateSettings(String poolId, AgentPoolUpdateSetting agentPoolUpdateSetting) throws RestClientException {
        return (AgentPoolUpdateSetting)this.setAgentPoolsUpdateSettingsWithHttpInfo(poolId, agentPoolUpdateSetting).getBody();
    }

    public <T> T setAgentPoolsUpdateSettings(Class<?> T, String poolId, AgentPoolUpdateSetting agentPoolUpdateSetting) throws RestClientException {
        return (T)this.getObjectMapper().convertValue(this.setAgentPoolsUpdateSettingsWithReturnType(T, poolId, agentPoolUpdateSetting).getBody(), T);
    }

    private ResponseEntity<AgentPoolUpdateSetting> setAgentPoolsUpdateSettingsWithHttpInfo(String poolId, AgentPoolUpdateSetting agentPoolUpdateSetting) throws RestClientException {
        AgentPoolUpdateSetting localVarPostBody = agentPoolUpdateSetting;
        if (poolId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'poolId' when calling setAgentPoolsUpdateSettings");
        }
        if (agentPoolUpdateSetting == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'agentPoolUpdateSetting' when calling setAgentPoolsUpdateSettings");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("poolId", poolId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"API_Token", "OAuth_2.0"};
        ParameterizedTypeReference<AgentPoolUpdateSetting> localReturnType = new ParameterizedTypeReference<AgentPoolUpdateSetting>(){};
        return this.apiClient.invokeAPI("/api/v1/agentPools/{poolId}/updates/settings", HttpMethod.POST, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    private <T> ResponseEntity<T> setAgentPoolsUpdateSettingsWithReturnType(Class<?> T, String poolId, AgentPoolUpdateSetting agentPoolUpdateSetting) throws RestClientException {
        AgentPoolUpdateSetting localVarPostBody = agentPoolUpdateSetting;
        if (poolId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'poolId' when calling setAgentPoolsUpdateSettings");
        }
        if (agentPoolUpdateSetting == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'agentPoolUpdateSetting' when calling setAgentPoolsUpdateSettings");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("poolId", poolId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"API_Token", "OAuth_2.0"};
        ParameterizedTypeReference localReturnType = new ParameterizedTypeReference<T>(){};
        return this.apiClient.invokeAPI("/api/v1/agentPools/{poolId}/updates/settings", HttpMethod.POST, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    public PagedList setAgentPoolsUpdateSettingsWithPaginationInfo(String poolId, AgentPoolUpdateSetting agentPoolUpdateSetting) throws RestClientException {
        AgentPoolUpdateSetting localVarPostBody = agentPoolUpdateSetting;
        if (poolId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'poolId' when calling setAgentPoolsUpdateSettings");
        }
        if (agentPoolUpdateSetting == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'agentPoolUpdateSetting' when calling setAgentPoolsUpdateSettings");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("poolId", poolId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"API_Token", "OAuth_2.0"};
        ParameterizedTypeReference<AgentPoolUpdateSetting> localReturnType = new ParameterizedTypeReference<AgentPoolUpdateSetting>(){};
        ResponseEntity<AgentPoolUpdateSetting> responseEntity = this.apiClient.invokeAPI("/api/v1/agentPools/{poolId}/updates/settings", HttpMethod.POST, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
        HttpHeaders headers = responseEntity.getHeaders();
        PagedList<AgentPoolUpdateSetting> pagedList = new PagedList<AgentPoolUpdateSetting>();
        List linkHeaders = headers.get((Object)"link");
        String self = null;
        String nextPage = null;
        for (String link : linkHeaders) {
            if (link.contains("next")) {
                nextPage = link.split(";")[0].replaceAll("<", "").replaceAll(">", "");
            }
            if (!link.contains("self")) continue;
            self = link.split(";")[0].replaceAll("<", "").replaceAll(">", "");
        }
        pagedList.addItems(Arrays.asList((AgentPoolUpdateSetting)responseEntity.getBody()));
        if (Objects.nonNull(nextPage)) {
            pagedList.setNextPage(nextPage);
        }
        if (Objects.nonNull(self)) {
            pagedList.setSelf(self);
        }
        return pagedList;
    }

    public AgentPoolUpdate stopAgentPoolsUpdate(String poolId, String updateId) throws RestClientException {
        return (AgentPoolUpdate)this.stopAgentPoolsUpdateWithHttpInfo(poolId, updateId).getBody();
    }

    private ResponseEntity<AgentPoolUpdate> stopAgentPoolsUpdateWithHttpInfo(String poolId, String updateId) throws RestClientException {
        Object localVarPostBody = null;
        if (poolId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'poolId' when calling stopAgentPoolsUpdate");
        }
        if (updateId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'updateId' when calling stopAgentPoolsUpdate");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("poolId", poolId);
        uriVariables.put("updateId", updateId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"API_Token", "OAuth_2.0"};
        ParameterizedTypeReference<AgentPoolUpdate> localReturnType = new ParameterizedTypeReference<AgentPoolUpdate>(){};
        return this.apiClient.invokeAPI("/api/v1/agentPools/{poolId}/updates/{updateId}/stop", HttpMethod.POST, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    public PagedList stopAgentPoolsUpdateWithPaginationInfo(String poolId, String updateId) throws RestClientException {
        Object localVarPostBody = null;
        if (poolId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'poolId' when calling stopAgentPoolsUpdate");
        }
        if (updateId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'updateId' when calling stopAgentPoolsUpdate");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("poolId", poolId);
        uriVariables.put("updateId", updateId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"API_Token", "OAuth_2.0"};
        ParameterizedTypeReference<AgentPoolUpdate> localReturnType = new ParameterizedTypeReference<AgentPoolUpdate>(){};
        ResponseEntity<AgentPoolUpdate> responseEntity = this.apiClient.invokeAPI("/api/v1/agentPools/{poolId}/updates/{updateId}/stop", HttpMethod.POST, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
        HttpHeaders headers = responseEntity.getHeaders();
        PagedList<AgentPoolUpdate> pagedList = new PagedList<AgentPoolUpdate>();
        List linkHeaders = headers.get((Object)"link");
        String self = null;
        String nextPage = null;
        for (String link : linkHeaders) {
            if (link.contains("next")) {
                nextPage = link.split(";")[0].replaceAll("<", "").replaceAll(">", "");
            }
            if (!link.contains("self")) continue;
            self = link.split(";")[0].replaceAll("<", "").replaceAll(">", "");
        }
        pagedList.addItems(Arrays.asList((AgentPoolUpdate)responseEntity.getBody()));
        if (Objects.nonNull(nextPage)) {
            pagedList.setNextPage(nextPage);
        }
        if (Objects.nonNull(self)) {
            pagedList.setSelf(self);
        }
        return pagedList;
    }

    public AgentPoolUpdate updateAgentPoolsUpdate(String poolId, String updateId, AgentPoolUpdate agentPoolUpdate) throws RestClientException {
        return (AgentPoolUpdate)this.updateAgentPoolsUpdateWithHttpInfo(poolId, updateId, agentPoolUpdate).getBody();
    }

    public <T> T updateAgentPoolsUpdate(Class<?> T, String poolId, String updateId, AgentPoolUpdate agentPoolUpdate) throws RestClientException {
        return (T)this.getObjectMapper().convertValue(this.updateAgentPoolsUpdateWithReturnType(T, poolId, updateId, agentPoolUpdate).getBody(), T);
    }

    private ResponseEntity<AgentPoolUpdate> updateAgentPoolsUpdateWithHttpInfo(String poolId, String updateId, AgentPoolUpdate agentPoolUpdate) throws RestClientException {
        AgentPoolUpdate localVarPostBody = agentPoolUpdate;
        if (poolId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'poolId' when calling updateAgentPoolsUpdate");
        }
        if (updateId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'updateId' when calling updateAgentPoolsUpdate");
        }
        if (agentPoolUpdate == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'agentPoolUpdate' when calling updateAgentPoolsUpdate");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("poolId", poolId);
        uriVariables.put("updateId", updateId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"API_Token", "OAuth_2.0"};
        ParameterizedTypeReference<AgentPoolUpdate> localReturnType = new ParameterizedTypeReference<AgentPoolUpdate>(){};
        return this.apiClient.invokeAPI("/api/v1/agentPools/{poolId}/updates/{updateId}", HttpMethod.POST, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    private <T> ResponseEntity<T> updateAgentPoolsUpdateWithReturnType(Class<?> T, String poolId, String updateId, AgentPoolUpdate agentPoolUpdate) throws RestClientException {
        AgentPoolUpdate localVarPostBody = agentPoolUpdate;
        if (poolId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'poolId' when calling updateAgentPoolsUpdate");
        }
        if (updateId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'updateId' when calling updateAgentPoolsUpdate");
        }
        if (agentPoolUpdate == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'agentPoolUpdate' when calling updateAgentPoolsUpdate");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("poolId", poolId);
        uriVariables.put("updateId", updateId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"API_Token", "OAuth_2.0"};
        ParameterizedTypeReference localReturnType = new ParameterizedTypeReference<T>(){};
        return this.apiClient.invokeAPI("/api/v1/agentPools/{poolId}/updates/{updateId}", HttpMethod.POST, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    public PagedList updateAgentPoolsUpdateWithPaginationInfo(String poolId, String updateId, AgentPoolUpdate agentPoolUpdate) throws RestClientException {
        AgentPoolUpdate localVarPostBody = agentPoolUpdate;
        if (poolId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'poolId' when calling updateAgentPoolsUpdate");
        }
        if (updateId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'updateId' when calling updateAgentPoolsUpdate");
        }
        if (agentPoolUpdate == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'agentPoolUpdate' when calling updateAgentPoolsUpdate");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("poolId", poolId);
        uriVariables.put("updateId", updateId);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"API_Token", "OAuth_2.0"};
        ParameterizedTypeReference<AgentPoolUpdate> localReturnType = new ParameterizedTypeReference<AgentPoolUpdate>(){};
        ResponseEntity<AgentPoolUpdate> responseEntity = this.apiClient.invokeAPI("/api/v1/agentPools/{poolId}/updates/{updateId}", HttpMethod.POST, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
        HttpHeaders headers = responseEntity.getHeaders();
        PagedList<AgentPoolUpdate> pagedList = new PagedList<AgentPoolUpdate>();
        List linkHeaders = headers.get((Object)"link");
        String self = null;
        String nextPage = null;
        for (String link : linkHeaders) {
            if (link.contains("next")) {
                nextPage = link.split(";")[0].replaceAll("<", "").replaceAll(">", "");
            }
            if (!link.contains("self")) continue;
            self = link.split(";")[0].replaceAll("<", "").replaceAll(">", "");
        }
        pagedList.addItems(Arrays.asList((AgentPoolUpdate)responseEntity.getBody()));
        if (Objects.nonNull(nextPage)) {
            pagedList.setNextPage(nextPage);
        }
        if (Objects.nonNull(self)) {
            pagedList.setSelf(self);
        }
        return pagedList;
    }

    private ObjectMapper getObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule((Module)new JavaTimeModule());
        objectMapper.registerModule((Module)new JsonNullableModule());
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        return objectMapper;
    }
}

