/*
 * Okta API
 * Allows customers to easily access the Okta API
 *
 * OpenAPI spec version: 1.9.0
 * Contact: devex-public@okta.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package com.okta.sdk.resource.user.factor;

import com.okta.sdk.resource.user.factor.Factor;
import com.okta.sdk.resource.user.factor.FactorProfile;
import com.okta.sdk.resource.user.factor.FactorProvider;
import com.okta.sdk.resource.user.factor.FactorStatus;
import com.okta.sdk.resource.user.factor.FactorType;
import com.okta.sdk.resource.user.factor.VerifyFactorRequest;
import com.okta.sdk.resource.user.factor.VerifyFactorResponse;
import java.util.HashMap;
import java.util.List;
import java.util.Map;


import java.util.Map;
import com.okta.sdk.resource.ExtensibleResource;
import com.okta.sdk.resource.Deletable;
import com.okta.sdk.resource.Saveable;


/**
 * Factor
 */
@javax.annotation.Generated(value = "com.okta.swagger.codegen.OktaJavaClientApiCodegen", date = "2019-03-28T17:04:39.356-04:00")
public interface Factor extends ExtensibleResource, Deletable {

    Map<String, Object> getEmbedded();

    Map<String, Object> getLinks();

    String getDevice();

    Factor setDevice(String device);

    String getDeviceType();

    FactorType getFactorType();

    Factor setFactorType(FactorType factorType);

    String getId();

    String getMfaStateTokenId();

    Factor setMfaStateTokenId(String mfaStateTokenId);

    FactorProfile getProfile();

    Factor setProfile(FactorProfile profile);

    FactorProvider getProvider();

    Factor setProvider(FactorProvider provider);

    Boolean getRechallengeExistingFactor();

    Factor setRechallengeExistingFactor(Boolean rechallengeExistingFactor);

    String getSessionId();

    Factor setSessionId(String sessionId);

    FactorStatus getStatus();

    Integer getTokenLifetimeSeconds();

    Factor setTokenLifetimeSeconds(Integer tokenLifetimeSeconds);

    String getUserId();

    Factor setUserId(String userId);

    VerifyFactorRequest getVerify();

    Factor setVerify(VerifyFactorRequest verify);


    /**
    * 
    * Unenrolls an existing factor for the specified user, allowing the user to enroll a new factor.
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2019-03-28T17:04:39.356-04:00",
            comments = "DELETE - /api/v1/users/{userId}/factors/{factorId}")
    void delete();


    /**
    * Activate Factor
    * The &#x60;sms&#x60; and &#x60;token:software:totp&#x60; [factor types](#factor-type) require activation to complete the enrollment process.
    * @param body  (required)
    * @return Factor
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2019-03-28T17:04:39.356-04:00",
            comments = "POST - /api/v1/users/{userId}/factors/{factorId}/lifecycle/activate")
    Factor activate(VerifyFactorRequest body);


    /**
    * Verify MFA Factor
    * Verifies an OTP for a &#x60;token&#x60; or &#x60;token:hardware&#x60; factor
    * @param body  (required)
    * @param templateId  (optional)
    * @param tokenLifetimeSeconds  (optional, default to 300)
    * @return VerifyFactorResponse
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2019-03-28T17:04:39.356-04:00",
            comments = "POST - /api/v1/users/{userId}/factors/{factorId}/verify")
    VerifyFactorResponse verify(VerifyFactorRequest body, String templateId, Integer tokenLifetimeSeconds);

    /**
    * Verify MFA Factor
    * Verifies an OTP for a &#x60;token&#x60; or &#x60;token:hardware&#x60; factor
    * @param body  (required)
    * @return VerifyFactorResponse
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2019-03-28T17:04:39.356-04:00",
            comments = "POST - /api/v1/users/{userId}/factors/{factorId}/verify")
    VerifyFactorResponse verify(VerifyFactorRequest body);
    /**
    * Verify MFA Factor
    * Verifies an OTP for a &#x60;token&#x60; or &#x60;token:hardware&#x60; factor
    * @param body  (required)
    * @param templateId  (required)
    * @return VerifyFactorResponse
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2019-03-28T17:04:39.356-04:00",
            comments = "POST - /api/v1/users/{userId}/factors/{factorId}/verify")
    VerifyFactorResponse verify(VerifyFactorRequest body, String templateId);

    /**
     * Verify MFA Factor
     * Verifies an OTP for a &#x60;token&#x60; or &#x60;token:hardware&#x60; factor
     * @param templateId  (required)
     * @param body  (required)
     * @return VerifyFactorResponse
     * @deprecated use {@link Factor#verify(VerifyFactorRequest, String)}
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            comments = "POST - /api/v1/users/{userId}/factors/{factorId}/verify")
    @Deprecated
    VerifyFactorResponse verify(String templateId, VerifyFactorRequest body);

    /**
    * Verify MFA Factor
    * Verifies an OTP for a &#x60;token&#x60; or &#x60;token:hardware&#x60; factor
    * @param templateId  (optional)
    * @param tokenLifetimeSeconds  (optional, default to 300)
    * @param body  (required)
    * @return VerifyFactorResponse
     * @deprecated use {@link Factor#verify(VerifyFactorRequest, String, Integer)}
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            comments = "POST - /api/v1/users/{userId}/factors/{factorId}/verify")
    @Deprecated
    VerifyFactorResponse verify(String templateId, Integer tokenLifetimeSeconds, VerifyFactorRequest body);
}

