/*
 * Okta API
 * Allows customers to easily access the Okta API
 *
 * OpenAPI spec version: 1.9.0
 * Contact: devex-public@okta.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package com.okta.sdk.resource.application;

import com.okta.sdk.resource.application.AppUser;
import com.okta.sdk.resource.application.AppUserList;
import com.okta.sdk.resource.application.Application;
import com.okta.sdk.resource.application.ApplicationAccessibility;
import com.okta.sdk.resource.application.ApplicationCredentials;
import com.okta.sdk.resource.application.ApplicationGroupAssignment;
import com.okta.sdk.resource.application.ApplicationGroupAssignmentList;
import com.okta.sdk.resource.application.ApplicationLicensing;
import com.okta.sdk.resource.application.ApplicationSettings;
import com.okta.sdk.resource.application.ApplicationSignOnMode;
import com.okta.sdk.resource.application.ApplicationVisibility;
import com.okta.sdk.resource.application.JsonWebKey;
import com.okta.sdk.resource.application.JsonWebKeyList;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;


import java.util.Map;
import com.okta.sdk.resource.ExtensibleResource;
import com.okta.sdk.resource.Deletable;
import com.okta.sdk.resource.Saveable;


/**
 * Application
 */
@javax.annotation.Generated(value = "com.okta.swagger.codegen.OktaJavaClientApiCodegen", date = "2019-03-28T17:04:39.356-04:00")
public interface Application extends ExtensibleResource, Deletable {

    Map<String, Object> getEmbedded();

    Map<String, Object> getLinks();

    ApplicationAccessibility getAccessibility();

    Application setAccessibility(ApplicationAccessibility accessibility);

    Date getCreated();

    ApplicationCredentials getCredentials();

    Application setCredentials(ApplicationCredentials credentials);

    List<String> getFeatures();

    Application setFeatures(List<String> features);

    String getId();

    String getLabel();

    Application setLabel(String label);

    Date getLastUpdated();

    ApplicationLicensing getLicensing();

    Application setLicensing(ApplicationLicensing licensing);

    String getName();

    Map<String, Object> getProfile();

    Application setProfile(Map<String, Object> profile);

    ApplicationSettings getSettings();

    Application setSettings(ApplicationSettings settings);

    ApplicationSignOnMode getSignOnMode();

    Application setSignOnMode(ApplicationSignOnMode signOnMode);

    StatusEnum getStatus();

          /**
   * Enum status
   */
  public enum StatusEnum {
    ACTIVE("ACTIVE"),
    
    INACTIVE("INACTIVE"),
    
    DELETED("DELETED");

    private String value;

    StatusEnum(String value) {
      this.value = value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }
  }

    ApplicationVisibility getVisibility();

    Application setVisibility(ApplicationVisibility visibility);


    /**
    * Activate Application
    * Activates an inactive application.
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2019-03-28T17:04:39.356-04:00",
            comments = "POST - /api/v1/apps/{appId}/lifecycle/activate")
    void activate();


    /**
    * Assign Group to Application
    * Assigns a group to an application
    * @param groupId  (required)
    * @param applicationGroupAssignment  (required)
    * @return ApplicationGroupAssignment
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2019-03-28T17:04:39.356-04:00",
            comments = "PUT - /api/v1/apps/{appId}/groups/{groupId}")
    ApplicationGroupAssignment createApplicationGroupAssignment(String groupId, ApplicationGroupAssignment applicationGroupAssignment);


    /**
    * Get Assigned Group for Application
    * Fetches an application group assignment
    * @param groupId  (required)
    * @param expand  (optional)
    * @return ApplicationGroupAssignment
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2019-03-28T17:04:39.356-04:00",
            comments = "GET - /api/v1/apps/{appId}/groups/{groupId}")
    ApplicationGroupAssignment getApplicationGroupAssignment(String groupId, String expand);

    /**
    * Get Assigned Group for Application
    * Fetches an application group assignment
    * @param groupId  (required)
    * @return ApplicationGroupAssignment
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2019-03-28T17:04:39.356-04:00",
            comments = "GET - /api/v1/apps/{appId}/groups/{groupId}")
    ApplicationGroupAssignment getApplicationGroupAssignment(String groupId);

    /**
    * Get Assigned User for Application
    * Fetches a specific user assignment for application by &#x60;id&#x60;.
    * @param userId  (required)
    * @param expand  (optional)
    * @return AppUser
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2019-03-28T17:04:39.356-04:00",
            comments = "GET - /api/v1/apps/{appId}/users/{userId}")
    AppUser getApplicationUser(String userId, String expand);

    /**
    * Get Assigned User for Application
    * Fetches a specific user assignment for application by &#x60;id&#x60;.
    * @param userId  (required)
    * @return AppUser
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2019-03-28T17:04:39.356-04:00",
            comments = "GET - /api/v1/apps/{appId}/users/{userId}")
    AppUser getApplicationUser(String userId);

    /**
    * Clone Application Key Credential
    * Clones a X.509 certificate for an application key credential from a source application to target application.
    * @param keyId  (required)
    * @param targetAid Unique key of the target Application (required)
    * @return JsonWebKey
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2019-03-28T17:04:39.356-04:00",
            comments = "POST - /api/v1/apps/{appId}/credentials/keys/{keyId}/clone")
    JsonWebKey cloneApplicationKey(String keyId, String targetAid);


    /**
    * Deactivate Application
    * Deactivates an active application.
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2019-03-28T17:04:39.356-04:00",
            comments = "POST - /api/v1/apps/{appId}/lifecycle/deactivate")
    void deactivate();


    /**
    * Update Application
    * Updates an application in your organization.
    * @return Application
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2019-03-28T17:04:39.356-04:00",
            comments = "PUT - /api/v1/apps/{appId}")
    Application update();


    /**
    * List Key Credentials for Application
    * Enumerates key credentials for an application
    * @return JsonWebKeyList
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2019-03-28T17:04:39.356-04:00",
            comments = "GET - /api/v1/apps/{appId}/credentials/keys")
    JsonWebKeyList listKeys();


    /**
    * List Groups Assigned to Application
    * Enumerates group assignments for an application.
    * @param q  (optional)
    * @param expand  (optional)
    * @return ApplicationGroupAssignmentList
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2019-03-28T17:04:39.356-04:00",
            comments = "GET - /api/v1/apps/{appId}/groups")
    ApplicationGroupAssignmentList listGroupAssignments(String q, String expand);

    /**
    * List Groups Assigned to Application
    * Enumerates group assignments for an application.
    * @return ApplicationGroupAssignmentList
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2019-03-28T17:04:39.356-04:00",
            comments = "GET - /api/v1/apps/{appId}/groups")
    ApplicationGroupAssignmentList listGroupAssignments();

    /**
    * List Users Assigned to Application
    * Enumerates all assigned [application users](#application-user-model) for an application.
    * @param q  (optional)
    * @param queryScope  (optional)
    * @param filter  (optional)
    * @param expand  (optional)
    * @return AppUserList
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2019-03-28T17:04:39.356-04:00",
            comments = "GET - /api/v1/apps/{appId}/users")
    AppUserList listApplicationUsers(String q, String queryScope, String filter, String expand);

    /**
    * List Users Assigned to Application
    * Enumerates all assigned [application users](#application-user-model) for an application.
    * @return AppUserList
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2019-03-28T17:04:39.356-04:00",
            comments = "GET - /api/v1/apps/{appId}/users")
    AppUserList listApplicationUsers();

    /**
    * Get Key Credential for Application
    * Gets a specific [application key credential](#application-key-credential-model) by &#x60;kid&#x60;
    * @param keyId  (required)
    * @return JsonWebKey
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2019-03-28T17:04:39.356-04:00",
            comments = "GET - /api/v1/apps/{appId}/credentials/keys/{keyId}")
    JsonWebKey getApplicationKey(String keyId);


    /**
    * Assign User to Application for SSO &amp; Provisioning
    * Assigns an user to an application with [credentials](#application-user-credentials-object) and an app-specific [profile](#application-user-profile-object). Profile mappings defined for the application are first applied before applying any profile properties specified in the request.
    * @param appUser  (required)
    * @return AppUser
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2019-03-28T17:04:39.356-04:00",
            comments = "POST - /api/v1/apps/{appId}/users")
    AppUser assignUserToApplication(AppUser appUser);


    /**
    * Delete Application
    * Removes an inactive application.
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2019-03-28T17:04:39.356-04:00",
            comments = "DELETE - /api/v1/apps/{appId}")
    void delete();


}

