/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.lang;

import com.okta.sdk.lang.Classes;
import com.okta.sdk.lang.RuntimeEnvironment;
import com.okta.sdk.lang.UnknownClassException;
import java.security.Provider;
import java.security.Security;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DefaultRuntimeEnvironment
implements RuntimeEnvironment {
    private static final Logger log = LoggerFactory.getLogger(DefaultRuntimeEnvironment.class);
    public static final DefaultRuntimeEnvironment INSTANCE = new DefaultRuntimeEnvironment();
    private static final String BC_PROVIDER_CLASS_NAME = "org.bouncycastle.jce.provider.BouncyCastleProvider";
    private static final AtomicBoolean bcLoaded = new AtomicBoolean(false);

    private DefaultRuntimeEnvironment() {
    }

    private static void enableBouncyCastleIfPossible() {
        if (bcLoaded.get()) {
            return;
        }
        try {
            Provider[] providers;
            Class clazz = Classes.forName(BC_PROVIDER_CLASS_NAME);
            for (Provider provider : providers = Security.getProviders()) {
                if (!clazz.isInstance(provider)) continue;
                bcLoaded.set(true);
                return;
            }
            Security.addProvider((Provider)Classes.newInstance(clazz));
            bcLoaded.set(true);
        }
        catch (UnknownClassException e) {
            log.debug("Unable to load BouncyCastle.  This is an acceptable outcome and this exception does not necessarily reflect a problem and can be ignored.", (Throwable)e);
        }
    }

    @Override
    public boolean isClassAvailable(String fqcn) {
        return Classes.isAvailable(fqcn);
    }

    static {
        DefaultRuntimeEnvironment.enableBouncyCastleIfPossible();
    }
}

