/*
 * Decompiled with CFR 0.152.
 */
package com.okta.maven.doclist;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.NavigableMap;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader;
import org.codehaus.plexus.util.FileUtils;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;

@Mojo(name="generate", defaultPhase=LifecyclePhase.VERIFY, threadSafe=true, aggregator=true)
public class DocListMojo
extends AbstractMojo {
    @Parameter(property="outputDirectory", defaultValue="${project.reporting.outputDirectory}/okta-doclist")
    private File outputDirectory;
    @Parameter(defaultValue="${project.artifactId}-(?<version>.*)")
    private String gitTagToVersionRegex;
    @Parameter(property="legacyVersions")
    private List<String> legacyVersions;
    @Parameter(defaultValue="${project}")
    private MavenProject project;

    public void execute() throws MojoExecutionException {
        try {
            String currentVersionName;
            this.outputDirectory.mkdirs();
            String imageName = "/images/okta-dev-logo-48.png";
            File imageDest = new File(this.outputDirectory, imageName);
            imageDest.getParentFile().mkdir();
            FileUtils.copyURLToFile((URL)DocListMojo.class.getResource(imageName), (File)imageDest);
            NavigableMap<String, String> versionsMap = new TreeMap<String, String>(this.getVersions().stream().collect(Collectors.toMap(v -> v, v -> v))).descendingMap();
            String currentVersion = versionsMap.isEmpty() ? this.project.getVersion() : versionsMap.firstEntry().getKey();
            String devVersion = "development";
            String devVersionName = "Development";
            if (versionsMap.get(currentVersion) != null) {
                currentVersionName = currentVersion + " [Current]";
                versionsMap.put(currentVersion, currentVersionName);
            } else {
                currentVersion = devVersion;
                currentVersionName = devVersionName = devVersionName + " [Current]";
            }
            VelocityEngine velocityEngine = new VelocityEngine();
            velocityEngine.setProperty("resource.loader", (Object)"classpath");
            velocityEngine.setProperty("classpath.resource.loader.class", (Object)ClasspathResourceLoader.class.getName());
            velocityEngine.init();
            Template template = velocityEngine.getTemplate("/templates/index.vm");
            VelocityContext context = new VelocityContext();
            context.put("name", (Object)this.project.getName());
            context.put("url", (Object)this.project.getUrl());
            context.put("current", (Object)currentVersion);
            context.put("currentName", (Object)currentVersionName);
            context.put("versions", versionsMap);
            context.put("legacy", this.getLegacyVersions());
            context.put("devVersion", (Object)devVersion);
            context.put("devVersionName", (Object)devVersionName);
            try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(new File(this.outputDirectory, "index.html")), StandardCharsets.UTF_8);){
                template.merge((Context)context, (Writer)writer);
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed generate report", (Exception)e);
        }
    }

    private List<String> getLegacyVersions() {
        return this.legacyVersions;
    }

    private Repository gitRepository() throws IOException {
        return ((FileRepositoryBuilder)((FileRepositoryBuilder)new FileRepositoryBuilder().readEnvironment()).findGitDir()).build();
    }

    List<String> getVersions() throws IOException {
        ArrayList<String> versions = new ArrayList<String>();
        Repository repository = this.gitRepository();
        Pattern pattern = Pattern.compile(this.gitTagToVersionRegex);
        repository.getTags().keySet().forEach(tag -> {
            Matcher matcher = pattern.matcher((CharSequence)tag);
            if (matcher.matches()) {
                String version = matcher.group("version");
                versions.add(version);
            }
        });
        return versions;
    }

    DocListMojo setOutputDirectory(File outputDirectory) {
        this.outputDirectory = outputDirectory;
        return this;
    }

    DocListMojo setGitTagToVersionRegex(String gitTagToVersionRegex) {
        this.gitTagToVersionRegex = gitTagToVersionRegex;
        return this;
    }

    DocListMojo setLegacyVersions(List<String> legacyVersions) {
        this.legacyVersions = legacyVersions;
        return this;
    }

    DocListMojo setProject(MavenProject project) {
        this.project = project;
        return this;
    }
}

