/*
 * Decompiled with CFR 0.152.
 */
package com.okta.jwt.impl.jjwt;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.okta.jwt.impl.http.HttpClient;
import com.okta.jwt.impl.jjwt.models.JwkKey;
import com.okta.jwt.impl.jjwt.models.JwkKeys;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.JwsHeader;
import io.jsonwebtoken.JwtException;
import io.jsonwebtoken.SigningKeyResolver;
import io.jsonwebtoken.io.Decoders;
import java.io.IOException;
import java.math.BigInteger;
import java.net.URL;
import java.security.Key;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.RSAPublicKeySpec;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.spec.SecretKeySpec;

final class RemoteJwkSigningKeyResolver
implements SigningKeyResolver {
    private final URL jwkUri;
    private final HttpClient httpClient;
    private final ObjectMapper objectMapper = new ObjectMapper();
    private final Object lock = new Object();
    private volatile Map<String, Key> keyMap = new HashMap<String, Key>();

    RemoteJwkSigningKeyResolver(URL jwkUri, HttpClient httpClient) {
        this.jwkUri = jwkUri;
        this.httpClient = httpClient;
    }

    public Key resolveSigningKey(JwsHeader header, Claims claims) {
        return this.getKey(header.getKeyId());
    }

    public Key resolveSigningKey(JwsHeader header, byte[] bytes) {
        return this.getKey(header.getKeyId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Key getKey(String keyId) {
        Key result = this.keyMap.get(keyId);
        if (result != null) {
            return result;
        }
        Object object = this.lock;
        synchronized (object) {
            result = this.keyMap.get(keyId);
            if (result != null) {
                return result;
            }
            this.updateKeys();
            return this.keyMap.get(keyId);
        }
    }

    void updateKeys() {
        try {
            HashMap<String, Key> newKeys = new HashMap<String, Key>();
            for (JwkKey jwkKey : ((JwkKeys)this.objectMapper.readValue(this.httpClient.get(this.jwkUri), JwkKeys.class)).getKeys()) {
                if (!"sig".equals(jwkKey.getPublicKeyUse())) continue;
                Key key = null;
                String keyType = jwkKey.getKeyType();
                if ("RSA".equals(keyType)) {
                    key = this.parseRsaKey(jwkKey);
                } else if ("oct".equals(keyType)) {
                    key = this.parseSymmetricKey(jwkKey);
                }
                if (key == null || jwkKey.getKeyId() == null) continue;
                newKeys.put(jwkKey.getKeyId(), key);
            }
            this.keyMap = Collections.unmodifiableMap(newKeys);
        }
        catch (IOException e) {
            throw new JwtException("Failed to fetch keys from URL: " + this.jwkUri, (Throwable)e);
        }
    }

    private Key parseRsaKey(JwkKey jwkKey) {
        BigInteger modulus = this.base64ToBigInteger(jwkKey.getPublicKeyModulus());
        BigInteger exponent = this.base64ToBigInteger(jwkKey.getPublicKeyExponent());
        RSAPublicKeySpec rsaPublicKeySpec = new RSAPublicKeySpec(modulus, exponent);
        try {
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            return keyFactory.generatePublic(rsaPublicKeySpec);
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
            throw new IllegalStateException("Failed to parse RSA public key", e);
        }
    }

    private Key parseSymmetricKey(JwkKey jwkKey) {
        String k = jwkKey.getSymmetricKey();
        if (k == null) {
            throw new IllegalStateException("Symmetric key 'k' value is missing");
        }
        byte[] keyBytes = (byte[])Decoders.BASE64URL.decode((Object)k);
        String algorithm = this.determineHmacAlgorithm(jwkKey.getAlgorithm(), keyBytes.length);
        return new SecretKeySpec(keyBytes, algorithm);
    }

    private String determineHmacAlgorithm(String alg, int keyLength) {
        if (alg != null) {
            switch (alg) {
                case "HS256": {
                    return "HmacSHA256";
                }
                case "HS384": {
                    return "HmacSHA384";
                }
                case "HS512": {
                    return "HmacSHA512";
                }
            }
        }
        if (keyLength >= 64) {
            return "HmacSHA512";
        }
        if (keyLength >= 48) {
            return "HmacSHA384";
        }
        return "HmacSHA256";
    }

    private BigInteger base64ToBigInteger(String value) {
        return new BigInteger(1, (byte[])Decoders.BASE64URL.decode((Object)value));
    }
}

