/*
 * Decompiled with CFR 0.152.
 */
package com.okta.jwt.impl.http;

import com.okta.commons.http.DefaultRequest;
import com.okta.commons.http.HttpHeaders;
import com.okta.commons.http.HttpMethod;
import com.okta.commons.http.Request;
import com.okta.commons.http.RequestExecutor;
import com.okta.commons.http.RequestExecutorFactory;
import com.okta.commons.http.Response;
import com.okta.commons.http.config.HttpClientConfiguration;
import com.okta.commons.lang.Classes;
import com.okta.jwt.impl.http.HttpClient;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;

public class OktaCommonsHttpClient
implements HttpClient {
    private static final String USER_AGENT_VALUE = "okta-jwt-verifier-java";
    private final RequestExecutor requestExecutor;

    protected OktaCommonsHttpClient(RequestExecutor requestExecutor) {
        this.requestExecutor = requestExecutor;
    }

    public OktaCommonsHttpClient(HttpClientConfiguration httpClientConfiguration) {
        this.requestExecutor = OktaCommonsHttpClient.createRequestExecutor(httpClientConfiguration);
    }

    @Override
    public InputStream get(URL url) throws IOException {
        HttpHeaders headers = new HttpHeaders();
        headers.add("User-Agent", USER_AGENT_VALUE);
        Response response = this.requestExecutor.executeRequest((Request)new DefaultRequest(HttpMethod.GET, url.toExternalForm(), null, headers));
        if (response.getHttpStatus() != 200) {
            throw new IOException("GET request to '" + url + "' failed with status of: " + response.getHttpStatus());
        }
        return response.getBody();
    }

    private static RequestExecutor createRequestExecutor(HttpClientConfiguration httpClientConfiguration) {
        String msg = "Unable to find a '" + RequestExecutorFactory.class.getName() + "' implementation on the classpath.  Please ensure you have added the okta-http-okhttp.jar file to your runtime classpath.";
        return ((RequestExecutorFactory)Classes.loadFromService(RequestExecutorFactory.class, (String)msg)).create(httpClientConfiguration);
    }
}

