/*
 * Decompiled with CFR 0.152.
 */
package com.okta.jwt.impl.jjwt;

import io.jsonwebtoken.Claims;
import io.jsonwebtoken.Header;
import io.jsonwebtoken.IncorrectClaimException;
import io.jsonwebtoken.JwsHeader;
import io.jsonwebtoken.SigningKeyResolver;
import java.nio.charset.StandardCharsets;
import java.security.Key;

final class IssuerMatchingSigningKeyResolver
implements SigningKeyResolver {
    private final String issuer;
    private final SigningKeyResolver delegate;

    IssuerMatchingSigningKeyResolver(String issuer, SigningKeyResolver delegate) {
        this.issuer = issuer;
        this.delegate = delegate;
    }

    public Key resolveSigningKey(JwsHeader header, Claims claims) {
        if (!this.issuer.equals(claims.getIssuer())) {
            String msg = String.format("Expected %s claim to be: %s, but was: %s.", "iss", this.issuer, claims.getIssuer());
            IncorrectClaimException incorrectClaimException = new IncorrectClaimException((Header)header, claims, "iss", null, msg);
            throw incorrectClaimException;
        }
        return this.delegate.resolveSigningKey(header, claims);
    }

    public Key resolveSigningKey(JwsHeader jwsHeader, byte[] bytes) {
        return this.delegate.resolveSigningKey(jwsHeader, new String(bytes, StandardCharsets.UTF_8).getBytes());
    }
}

