/*
 * Decompiled with CFR 0.152.
 */
package com.okta.idx.sdk.api.util;

import com.okta.commons.lang.Assert;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Base64;

public class PkceUtil {
    public static final String CODE_CHALLENGE_METHOD = "S256";
    private static final int URL_SAFE_FLAG = 8;

    public static String generateCodeChallenge(String codeVerifier) throws NoSuchAlgorithmException {
        Assert.hasText((String)codeVerifier, (String)"codeVerifier is required");
        byte[] bytes = codeVerifier.getBytes(StandardCharsets.US_ASCII);
        MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
        messageDigest.update(bytes, 0, bytes.length);
        byte[] digest = messageDigest.digest();
        return PkceUtil.base64Encode(digest);
    }

    public static String generateCodeVerifier() {
        SecureRandom secureRandom = new SecureRandom();
        byte[] codeVerifier = new byte[32];
        secureRandom.nextBytes(codeVerifier);
        return PkceUtil.base64Encode(codeVerifier);
    }

    private static String base64Encode(byte[] source) {
        try {
            return Base64.getUrlEncoder().withoutPadding().encodeToString(source);
        }
        catch (NoClassDefFoundError e) {
            try {
                Method method = Class.forName("android.util.Base64").getMethod("encodeToString", byte[].class, Integer.TYPE);
                String encoded = (String)method.invoke(null, source, 8);
                return encoded.substring(0, encoded.length() - 2);
            }
            catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException exception) {
                throw new IllegalStateException("No Base64 Encoder found.", exception);
            }
        }
    }
}

