/*
 * Decompiled with CFR 0.152.
 */
package com.okta.idx.sdk.api.client;

import com.okta.idx.sdk.api.exception.ProcessingException;
import com.okta.idx.sdk.api.model.FormValue;
import com.okta.idx.sdk.api.model.RemediationOption;
import com.okta.idx.sdk.api.response.AuthenticationResponse;
import com.okta.idx.sdk.api.response.ErrorResponse;
import com.okta.idx.sdk.api.response.IDXResponse;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class WrapperUtil {
    private static final Logger logger = LoggerFactory.getLogger(WrapperUtil.class);

    WrapperUtil() {
    }

    static AuthenticationResponse handleIllegalArgumentException(IllegalArgumentException e) {
        AuthenticationResponse authenticationResponse = new AuthenticationResponse();
        logger.error("Exception occurred", (Throwable)e);
        authenticationResponse.addError("The current flow is not supported. Please check your policy configuration.");
        return authenticationResponse;
    }

    static AuthenticationResponse handleProcessingException(ProcessingException e) {
        logger.error("Exception occurred", (Throwable)e);
        AuthenticationResponse authenticationResponse = new AuthenticationResponse();
        ErrorResponse errorResponse = e.getErrorResponse();
        if (errorResponse != null) {
            if (errorResponse.getMessages() != null) {
                errorResponse.getMessages().getValue().stream().forEach(msg -> authenticationResponse.addError(msg.getMessage()));
            } else {
                authenticationResponse.addError(errorResponse.getError() + ":" + errorResponse.getErrorDescription());
            }
        } else {
            authenticationResponse.addError(e.getMessage());
        }
        logger.error("Error Detail: {}", authenticationResponse.getErrors());
        return authenticationResponse;
    }

    static void printRemediationOptions(IDXResponse idxResponse) {
        if (idxResponse != null && idxResponse.remediation() != null) {
            List<RemediationOption> remediationOptions = idxResponse.remediation().remediationOptions();
            logger.debug("Remediation options: {}", remediationOptions.stream().map(RemediationOption::getName).collect(Collectors.toList()));
        } else {
            logger.debug("Remediation options unavailable");
        }
    }

    static void printMessage(IDXResponse idxResponse) {
        if (idxResponse != null && idxResponse.getMessages() != null && idxResponse.getMessages().hasErrorValue()) {
            idxResponse.getMessages().getValue().stream().forEach(messageValue -> logger.error(messageValue.getMessage()));
        }
    }

    static String getStateHandle(List<FormValue> formValues) {
        if (formValues == null) {
            return null;
        }
        for (FormValue formValue : formValues) {
            if (!"stateHandle".equals(formValue.name)) continue;
            return formValue.value.toString();
        }
        return null;
    }
}

