/*
 * Decompiled with CFR 0.152.
 */
package com.okta.commons.http.httpclient;

import com.okta.commons.http.HttpException;
import com.okta.commons.http.HttpMethod;
import com.okta.commons.http.QueryString;
import com.okta.commons.http.Request;
import com.okta.commons.http.RequestUtils;
import com.okta.commons.http.httpclient.RepeatableInputStreamEntity;
import com.okta.commons.lang.Assert;
import com.okta.commons.lang.Strings;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.BufferedHttpEntity;

class HttpClientRequestFactory {
    private final RequestConfig defaultRequestConfig;

    HttpClientRequestFactory(RequestConfig defaultRequestConfig) {
        Assert.notNull((Object)defaultRequestConfig, (String)"defaultRequestConfig");
        this.defaultRequestConfig = defaultRequestConfig;
    }

    HttpRequestBase createHttpClientRequest(Request request, HttpEntity previousEntity) {
        HttpDelete base;
        HttpMethod method = request.getMethod();
        URI uri = this.getFullyQualifiedUri(request);
        InputStream body = request.getBody();
        long contentLength = request.getHeaders().getContentLength();
        switch (method) {
            case DELETE: {
                base = new HttpDelete(uri);
                break;
            }
            case GET: {
                base = new HttpGet(uri);
                break;
            }
            case HEAD: {
                base = new HttpHead(uri);
                break;
            }
            case POST: {
                base = new HttpPost(uri);
                ((HttpEntityEnclosingRequestBase)base).setEntity((HttpEntity)new RepeatableInputStreamEntity(request));
                break;
            }
            case PUT: {
                base = new HttpPut(uri);
                base.setConfig(RequestConfig.copy((RequestConfig)this.defaultRequestConfig).setExpectContinueEnabled(true).build());
                if (previousEntity != null) {
                    ((HttpEntityEnclosingRequestBase)base).setEntity(previousEntity);
                    break;
                }
                if (body == null) break;
                RepeatableInputStreamEntity entity = new RepeatableInputStreamEntity(request);
                if (contentLength < 0L) {
                    entity = this.newBufferedHttpEntity((HttpEntity)entity);
                }
                ((HttpEntityEnclosingRequestBase)base).setEntity((HttpEntity)entity);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unrecognized HttpMethod: " + method);
            }
        }
        base.setProtocolVersion((ProtocolVersion)HttpVersion.HTTP_1_1);
        this.applyHeaders((HttpRequestBase)base, request);
        return base;
    }

    private void applyHeaders(HttpRequestBase httpRequest, Request request) {
        URI endpoint = request.getResourceUrl();
        String hostHeader = endpoint.getHost();
        if (!RequestUtils.isDefaultPort((URI)endpoint)) {
            hostHeader = hostHeader + ":" + endpoint.getPort();
        }
        httpRequest.addHeader("Host", hostHeader);
        httpRequest.addHeader("Accept-Encoding", "gzip");
        for (Map.Entry entry : request.getHeaders().entrySet()) {
            String key = (String)entry.getKey();
            List value = (List)entry.getValue();
            if ("Content-Length".equalsIgnoreCase(key) || "Host".equalsIgnoreCase(key)) continue;
            String delimited = Strings.collectionToCommaDelimitedString((Collection)value);
            httpRequest.addHeader(key, delimited);
        }
    }

    private URI getFullyQualifiedUri(Request request) {
        StringBuilder sb = new StringBuilder();
        sb.append(request.getResourceUrl().normalize());
        QueryString query = request.getQueryString();
        if (query != null && !query.isEmpty()) {
            sb.append("?").append(query.toString());
        }
        return URI.create(sb.toString());
    }

    private HttpEntity newBufferedHttpEntity(HttpEntity entity) {
        try {
            return new BufferedHttpEntity(entity);
        }
        catch (IOException e) {
            throw new HttpException("Unable to create HTTP entity: " + e.getMessage(), (Throwable)e);
        }
    }
}

