/*
 * Decompiled with CFR 0.152.
 */
package com.ogangi.messangi.android.sdk.push;

import android.content.Intent;
import android.os.Parcelable;
import com.google.firebase.messaging.RemoteMessage;
import com.ogangi.messangi.android.sdk.MessangiApp;
import com.ogangi.messangi.android.sdk.analytics.MessangiAnalytics;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;

public class MessangiPushManager {
    final List<PushArriveListener> listeners;
    private static MessangiPushManager instance;
    private final MessangiApp app;
    private final MessangiAnalytics analytics;

    private MessangiPushManager(MessangiApp app) {
        this.app = app;
        this.analytics = MessangiAnalytics.getInstances();
        this.listeners = new ArrayList<PushArriveListener>();
    }

    public static MessangiPushManager getInstance() {
        return MessangiPushManager.getInstance(MessangiApp.getInstance());
    }

    public static MessangiPushManager getInstance(MessangiApp app) {
        if (instance == null) {
            instance = new MessangiPushManager(app);
        }
        return instance;
    }

    void notifyExternalPushArrive(RemoteMessage remoteMessage) {
        JSONObject object = new JSONObject();
        try {
            object.putOpt("CollapseKey", (Object)remoteMessage.getCollapseKey());
            object.putOpt("From", (Object)remoteMessage.getFrom());
            object.putOpt("MessageId", (Object)remoteMessage.getMessageId());
            object.putOpt("MessageType", (Object)remoteMessage.getMessageType());
            object.putOpt("OriginalPriority", (Object)remoteMessage.getOriginalPriority());
            object.putOpt("Priority", (Object)remoteMessage.getPriority());
            object.putOpt("SentTime", (Object)remoteMessage.getSentTime());
            object.putOpt("To", (Object)remoteMessage.getTo());
            object.putOpt("Ttl", (Object)remoteMessage.getTtl());
            object.putOpt("Data", (Object)new JSONObject(remoteMessage.getData()));
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        this.analytics.logEvent("EXTERNAL_PUSH_RECEIVED", object.toString(), null);
        Intent intent = new Intent("com.ogangi.messangi.android.sdk.EXTERNAL_NOTIFICATION");
        intent.putExtra("message", (Parcelable)remoteMessage);
        MessangiApp.getInstance().getApplicationContext().sendBroadcast(intent, MessangiApp.getInstance().getApplicationContext().getPackageName() + ".permission.externalPush");
        for (PushArriveListener listener : this.listeners) {
            listener.onMessageReceived(remoteMessage);
        }
    }

    public void addExternalPushArriveListener(PushArriveListener listener) {
        this.listeners.add(listener);
    }

    public static interface PushArriveListener {
        public void onMessageReceived(RemoteMessage var1);
    }
}

