/*
 * Decompiled with CFR 0.152.
 */
package com.ogangi.messangi.android.sdk.push;

import android.content.Context;
import android.util.Log;
import com.google.firebase.messaging.FirebaseMessagingService;
import com.google.firebase.messaging.RemoteMessage;
import com.ogangi.messangi.android.sdk.MessangiEventManager;
import com.ogangi.messangi.android.sdk.entities.MessangiEvent;
import com.ogangi.messangi.android.sdk.push.FirebaseEvent;
import com.ogangi.messangi.android.sdk.push.MessangiPushManager;

public class FcmListenerService
extends FirebaseMessagingService {
    private static final String TAG = "FcmListenerService";

    public void onMessageReceived(RemoteMessage remoteMessage) {
        if (this.isMessangiEvent(remoteMessage)) {
            MessangiEventManager.onEventReceived((Context)this.getApplicationContext(), (MessangiEvent)new FirebaseEvent(remoteMessage));
        } else {
            MessangiPushManager.getInstance().notifyExternalPushArrive(remoteMessage);
        }
    }

    private boolean isMessangiEvent(RemoteMessage remoteMessage) {
        String message = (String)remoteMessage.getData().get("content");
        String msgType = (String)remoteMessage.getData().get("type");
        String clientId = (String)remoteMessage.getData().get("clientId");
        if (clientId == null || msgType == null || message == null) {
            return false;
        }
        switch (msgType) {
            case "GEOFENCE": 
            case "BEACON": 
            case "TXT_MSG": 
            case "CRT_REGION": 
            case "UPDT_REGION": 
            case "DLT_REGION": 
            case "CRT_BEACON": 
            case "UPDT_BEACON": 
            case "DLT_BEACON": 
            case "GET_LOC": 
            case "GEO_LOC": 
            case "GEO_PUSH": 
            case "GEOPUSH": 
            case "TRACK_USER": {
                return true;
            }
        }
        Log.w((String)TAG, (String)("You are getting a invalid MessageType (" + msgType + "), please check your Library version and contact with our Support Team"));
        return false;
    }
}

