/*
 * Decompiled with CFR 0.152.
 */
package com.octo.android.robospice.persistence.string;

import android.app.Application;
import com.octo.android.robospice.persistence.exception.CacheCreationException;
import com.octo.android.robospice.persistence.exception.CacheLoadingException;
import com.octo.android.robospice.persistence.exception.CacheSavingException;
import com.octo.android.robospice.persistence.file.InFileObjectPersister;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import roboguice.util.temp.Ln;

public class InFileStringObjectPersister
extends InFileObjectPersister<String> {
    public InFileStringObjectPersister(Application application) throws CacheCreationException {
        super(application, String.class);
    }

    @Override
    public boolean canHandleClass(Class<?> clazz) {
        return clazz.equals(String.class);
    }

    @Override
    protected String readCacheDataFromFile(File file) throws CacheLoadingException {
        try {
            return FileUtils.readFileToString((File)file, (String)"UTF-8");
        }
        catch (FileNotFoundException e) {
            Ln.w("file " + file.getAbsolutePath() + " does not exists", e);
            return null;
        }
        catch (Exception e) {
            throw new CacheLoadingException(e);
        }
    }

    @Override
    public String saveDataToCacheAndReturnData(final String data, final Object cacheKey) throws CacheSavingException {
        Ln.v("Saving String " + data + " into cacheKey = " + cacheKey, new Object[0]);
        try {
            if (this.isAsyncSaveEnabled()) {
                Thread t = new Thread(){

                    @Override
                    public void run() {
                        try {
                            FileUtils.writeStringToFile((File)InFileStringObjectPersister.this.getCacheFile(cacheKey), (String)data, (String)"UTF-8");
                        }
                        catch (IOException e) {
                            Ln.e(e, (Object)("An error occured on saving request " + cacheKey + " data asynchronously"), new Object[0]);
                        }
                    }
                };
                t.start();
            } else {
                FileUtils.writeStringToFile((File)this.getCacheFile(cacheKey), (String)data, (String)"UTF-8");
            }
        }
        catch (Exception e) {
            throw new CacheSavingException(e);
        }
        return data;
    }
}

