/*
 * Decompiled with CFR 0.152.
 */
package com.octo.android.robospice.persistence.file;

import android.app.Application;
import com.octo.android.robospice.persistence.ObjectPersister;
import com.octo.android.robospice.persistence.exception.CacheCreationException;
import com.octo.android.robospice.persistence.exception.CacheLoadingException;
import com.octo.android.robospice.persistence.exception.KeySanitationExcepion;
import com.octo.android.robospice.persistence.keysanitation.KeySanitizer;
import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import roboguice.util.temp.Ln;

public abstract class InFileObjectPersister<T>
extends ObjectPersister<T> {
    static final String CACHE_PREFIX_END = "_";
    static final String DEFAULT_ROOT_CACHE_DIR = "robospice-cache";
    private KeySanitizer keySanitizer;
    private File cacheFolder;
    private String factoryCachePrefix = "";

    public InFileObjectPersister(Application application, Class<T> clazz) throws CacheCreationException {
        super(application, clazz);
        this.setCacheFolder(null);
    }

    public InFileObjectPersister(Application application, Class<T> clazz, File cacheFolder) throws CacheCreationException {
        super(application, clazz);
        this.setCacheFolder(cacheFolder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCacheFolder(File cacheFolder) throws CacheCreationException {
        if (cacheFolder == null) {
            cacheFolder = new File(this.getApplication().getCacheDir(), DEFAULT_ROOT_CACHE_DIR);
        }
        String string = cacheFolder.getAbsolutePath().intern();
        synchronized (string) {
            if (!cacheFolder.exists() && !cacheFolder.mkdirs()) {
                throw new CacheCreationException("The cache folder " + cacheFolder.getAbsolutePath() + " could not be created.");
            }
        }
        this.cacheFolder = cacheFolder;
    }

    public final File getCacheFolder() {
        return this.cacheFolder;
    }

    @Override
    public long getCreationDateInCache(Object cacheKey) throws CacheLoadingException {
        File cacheFile = this.getCacheFile(cacheKey);
        if (cacheFile.exists()) {
            return cacheFile.lastModified();
        }
        throw new CacheLoadingException("Data could not be found in cache for cacheKey=" + cacheKey);
    }

    @Override
    public List<Object> getAllCacheKeys() {
        final String prefix = this.getCachePrefix();
        int prefixLength = prefix.length();
        String[] cacheFileNameList = this.getCacheFolder().list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String filename) {
                return filename.startsWith(prefix);
            }
        });
        if (cacheFileNameList == null) {
            return Collections.emptyList();
        }
        ArrayList<Object> result = new ArrayList<Object>(cacheFileNameList.length);
        for (String cacheFileName : cacheFileNameList) {
            String cacheKey = cacheFileName.substring(prefixLength);
            result.add(this.fromKey(cacheKey));
        }
        return result;
    }

    @Override
    public List<T> loadAllDataFromCache() throws CacheLoadingException {
        List<Object> allCacheKeys = this.getAllCacheKeys();
        ArrayList<T> result = new ArrayList<T>(allCacheKeys.size());
        for (Object key : allCacheKeys) {
            result.add(this.loadDataFromCache(key, 0L));
        }
        return result;
    }

    @Override
    public boolean removeDataFromCache(Object cacheKey) {
        return this.getCacheFile(cacheKey).delete();
    }

    @Override
    public void removeAllDataFromCache() {
        File cacheFolder = this.getCacheFolder();
        File[] cacheFileList = cacheFolder.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.getName().startsWith(InFileObjectPersister.this.getCachePrefix());
            }
        });
        boolean allDeleted = true;
        for (File cacheFile : cacheFileList) {
            allDeleted = cacheFile.delete() && allDeleted;
        }
        if (allDeleted || cacheFileList.length == 0) {
            Ln.d("Some file could not be deleted from cache.", new Object[0]);
        }
    }

    @Override
    public T loadDataFromCache(Object cacheKey, long maxTimeInCache) throws CacheLoadingException {
        File file = this.getCacheFile(cacheKey);
        if (this.isCachedAndNotExpired(file, maxTimeInCache)) {
            return this.readCacheDataFromFile(file);
        }
        return null;
    }

    @Override
    public boolean isDataInCache(Object cacheKey, long maxTimeInCacheBeforeExpiry) {
        File file = this.getCacheFile(cacheKey);
        return this.isCachedAndNotExpired(file, maxTimeInCacheBeforeExpiry);
    }

    public boolean isUsingKeySanitizer() {
        return this.keySanitizer != null;
    }

    public void setKeySanitizer(KeySanitizer keySanitizer) {
        this.keySanitizer = keySanitizer;
    }

    public KeySanitizer getKeySanitizer() {
        return this.keySanitizer;
    }

    public final File getCacheFile(Object cacheKey) {
        return new File(this.getCacheFolder(), this.getCachePrefix() + this.toKey(cacheKey.toString()));
    }

    void setFactoryCachePrefix(String factoryCachePrefix) {
        this.factoryCachePrefix = factoryCachePrefix;
    }

    protected final String toKey(String cacheKey) {
        if (this.isUsingKeySanitizer()) {
            try {
                return (String)this.keySanitizer.sanitizeKey(cacheKey);
            }
            catch (KeySanitationExcepion e) {
                Ln.e(e, (Object)"Key could not be sanitized, falling back on original key.", new Object[0]);
                return cacheKey;
            }
        }
        return cacheKey;
    }

    protected final String fromKey(String cacheKey) {
        if (this.isUsingKeySanitizer()) {
            try {
                return (String)this.keySanitizer.desanitizeKey(cacheKey);
            }
            catch (KeySanitationExcepion e) {
                Ln.e(e, (Object)"Key could not be desanitized, falling back on original key.", new Object[0]);
                return cacheKey;
            }
        }
        return cacheKey;
    }

    protected abstract T readCacheDataFromFile(File var1) throws CacheLoadingException;

    protected final String getCachePrefix() {
        return this.factoryCachePrefix + this.getClass().getSimpleName() + CACHE_PREFIX_END + this.getHandledClass().getSimpleName() + CACHE_PREFIX_END;
    }

    protected boolean isCachedAndNotExpired(Object cacheKey, long maxTimeInCacheBeforeExpiry) {
        File cacheFile = this.getCacheFile(cacheKey);
        return this.isCachedAndNotExpired(cacheFile, maxTimeInCacheBeforeExpiry);
    }

    protected boolean isCachedAndNotExpired(File cacheFile, long maxTimeInCacheBeforeExpiry) {
        if (cacheFile.exists()) {
            long timeInCache = System.currentTimeMillis() - cacheFile.lastModified();
            if (maxTimeInCacheBeforeExpiry == 0L || timeInCache <= maxTimeInCacheBeforeExpiry) {
                return true;
            }
        }
        return false;
    }
}

