/*
 * Decompiled with CFR 0.152.
 */
package com.octo.android.robospice.persistence.binary;

import android.app.Application;
import com.octo.android.robospice.persistence.binary.InFileInputStreamObjectPersister;
import com.octo.android.robospice.persistence.exception.CacheCreationException;
import com.octo.android.robospice.persistence.exception.CacheSavingException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;

public final class InFileBigInputStreamObjectPersister
extends InFileInputStreamObjectPersister {
    public InFileBigInputStreamObjectPersister(Application application) throws CacheCreationException {
        super(application);
    }

    public InFileBigInputStreamObjectPersister(Application application, File cacheFolder) throws CacheCreationException {
        super(application, cacheFolder);
    }

    @Override
    public InputStream saveDataToCacheAndReturnData(InputStream data, Object cacheKey) throws CacheSavingException {
        FileInputStream fileInputStream;
        FileOutputStream output = null;
        try {
            output = new FileOutputStream(this.getCacheFile(cacheKey));
            IOUtils.copy((InputStream)data, (OutputStream)output);
            fileInputStream = new FileInputStream(this.getCacheFile(cacheKey));
        }
        catch (IOException e) {
            try {
                throw new CacheSavingException(e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(output);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((OutputStream)output);
        return fileInputStream;
    }

    @Override
    public void setAsyncSaveEnabled(boolean isAsyncSaveEnabled) {
        if (isAsyncSaveEnabled) {
            throw new IllegalStateException("Asynchronous saving operation not supported.");
        }
    }
}

