/*
 * Decompiled with CFR 0.152.
 */
package com.octo.android.robospice.persistence;

import android.app.Application;
import com.octo.android.robospice.persistence.ObjectPersister;
import com.octo.android.robospice.persistence.Persister;
import com.octo.android.robospice.persistence.exception.CacheCreationException;
import java.util.List;

public abstract class ObjectPersisterFactory
implements Persister {
    private Application mApplication;
    private boolean isAsyncSaveEnabled;
    private List<Class<?>> listHandledClasses;

    public ObjectPersisterFactory(Application application) {
        this(application, null);
    }

    public ObjectPersisterFactory(Application application, List<Class<?>> listHandledClasses) {
        this.mApplication = application;
        this.listHandledClasses = listHandledClasses;
    }

    protected final Application getApplication() {
        return this.mApplication;
    }

    @Override
    public boolean canHandleClass(Class<?> clazz) {
        if (this.listHandledClasses == null) {
            return true;
        }
        return this.listHandledClasses.contains(clazz);
    }

    public abstract <DATA> ObjectPersister<DATA> createObjectPersister(Class<DATA> var1) throws CacheCreationException;

    public void setAsyncSaveEnabled(boolean isAsyncSaveEnabled) {
        this.isAsyncSaveEnabled = isAsyncSaveEnabled;
    }

    public boolean isAsyncSaveEnabled() {
        return this.isAsyncSaveEnabled;
    }

    protected List<Class<?>> getListHandledClasses() {
        return this.listHandledClasses;
    }
}

