/*
 * Decompiled with CFR 0.152.
 */
package com.ocpsoft.pretty.faces.el;

import com.ocpsoft.pretty.faces.el.LazyBeanNameFinder;
import com.ocpsoft.pretty.faces.el.PrettyExpression;
import com.ocpsoft.shade.org.apache.commons.logging.Log;
import com.ocpsoft.shade.org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LazyExpression
implements PrettyExpression {
    private static final Log log = LogFactory.getLog(LazyExpression.class);
    private final LazyBeanNameFinder finder;
    private final Class<?> beanClass;
    private final String component;
    private String expression;

    public LazyExpression(LazyBeanNameFinder finder, Class<?> beanClass, String component) {
        this.finder = finder;
        this.beanClass = beanClass;
        this.component = component;
    }

    @Override
    public String getELExpression() {
        if (this.expression == null) {
            this.expression = "#{" + this.finder.findBeanName(this.beanClass) + "." + this.component + "}";
            if (log.isTraceEnabled()) {
                log.trace("Lazy expression resolved to: " + this.expression);
            }
        }
        return this.expression;
    }

    public String toString() {
        return "#{[" + this.beanClass.getName() + "]." + this.component + "}";
    }

    public Class<?> getBeanClass() {
        return this.beanClass;
    }

    public String getComponent() {
        return this.component;
    }
}

