/*
 * Decompiled with CFR 0.152.
 */
package com.ocpsoft.pretty.faces.config.spi;

import com.ocpsoft.pretty.PrettyException;
import com.ocpsoft.pretty.faces.config.DigesterPrettyConfigParser;
import com.ocpsoft.pretty.faces.config.PrettyConfig;
import com.ocpsoft.pretty.faces.config.PrettyConfigBuilder;
import com.ocpsoft.pretty.faces.spi.ConfigurationProvider;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import javax.servlet.ServletContext;
import org.xml.sax.SAXException;

public class ClassLoaderConfigurationProvider
implements ConfigurationProvider {
    public static final String PRETTY_CONFIG_RESOURCE = "META-INF/pretty-config.xml";
    public static final String CLASSPATH_CONFIG_ENABLED = "com.ocpsoft.pretty.LOAD_CLASSPATH_CONFIG";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PrettyConfig loadConfiguration(ServletContext context) {
        PrettyConfigBuilder builder;
        block9: {
            String enabled = context.getInitParameter(CLASSPATH_CONFIG_ENABLED);
            if (enabled != null && "false".equalsIgnoreCase(enabled.trim())) {
                return null;
            }
            builder = new PrettyConfigBuilder();
            DigesterPrettyConfigParser configParser = new DigesterPrettyConfigParser();
            try {
                Enumeration<URL> urls = this.getClass().getClassLoader().getResources(PRETTY_CONFIG_RESOURCE);
                if (urls == null) break block9;
                while (urls.hasMoreElements()) {
                    URL url = urls.nextElement();
                    if (url == null) continue;
                    InputStream is = null;
                    try {
                        is = this.openStream(url);
                        try {
                            configParser.parse(builder, is);
                        }
                        catch (SAXException e) {
                            throw new PrettyException("Failed to parse PrettyFaces configuration from URL:" + url, e);
                        }
                    }
                    finally {
                        if (is == null) continue;
                        is.close();
                    }
                }
            }
            catch (Exception e) {
                throw new PrettyException("Could not get references to PrettyFaces ClassLoader-configuration elements.", e);
            }
        }
        return builder.build();
    }

    private InputStream openStream(URL url) throws IOException {
        URLConnection connection = url.openConnection();
        connection.setUseCaches(false);
        return connection.getInputStream();
    }
}

