/*
 * Decompiled with CFR 0.152.
 */
package com.ocnyang.contourview;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.LinearGradient;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Point;
import android.graphics.RadialGradient;
import android.graphics.Shader;
import android.graphics.SweepGradient;
import android.support.annotation.ColorInt;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.View;
import com.ocnyang.contourview.PointsFactory;
import com.ocnyang.contourview.R;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ContourView
extends View {
    public static final int SHADER_MODE_NULL = 0;
    public static final int SHADER_MODE_RADIAL = 1;
    public static final int SHADER_MODE_SWEEP = 2;
    public static final int SHADER_MODE_LINEAR = 3;
    public static final int SHADER_MODE_CUSTOM = 4;
    private int mW;
    private int mH;
    private int mShaderColor;
    public static final int SHADER_STYLE_LEFT_TO_BOTTOM = 0;
    public static final int SHADER_STYLE_RIGHT_TO_BOTTOM = 17;
    public static final int SHADER_STYLE_TOP_TO_BOTTOM = 18;
    public static final int SHADER_STYLE_CENTER = 19;
    public static final int STYLE_SAND = 0;
    public static final int STYLE_CLOUDS = 33;
    public static final int STYLE_RIPPLES = 34;
    public static final int STYLE_BEACH = 35;
    public static final int STYLE_SHELL = 37;
    private static final int STYLE_NULL = 36;
    public static final float SMOOTHNESS_DEF = 0.25f;
    private float mSmoothness = 0.25f;
    private int mShaderMode;
    private int mShaderStartColor;
    private int mShaderEndColor;
    private int mShaderStyle;
    private int mStyle;
    private Shader[] mShader;
    private List<Point[]> mPointsList;
    private Paint mPaint = new Paint();

    public ContourView(Context context) {
        this(context, null);
    }

    public ContourView(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public ContourView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        int shaderMode;
        this.mPaint.setStyle(Paint.Style.FILL);
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.ContourView);
        this.mStyle = typedArray.getInt(R.styleable.ContourView_contour_style, 0);
        float smn = typedArray.getFloat(R.styleable.ContourView_smoothness, 0.25f);
        this.mSmoothness = smn <= 0.0f ? 0.1f : (smn >= 1.0f ? 0.99f : smn);
        this.mShaderMode = shaderMode = typedArray.getInt(R.styleable.ContourView_shader_mode, 0);
        if (0 != shaderMode) {
            this.mShaderStartColor = typedArray.getColor(R.styleable.ContourView_shader_startcolor, Color.argb((int)90, (int)255, (int)255, (int)255));
            this.mShaderEndColor = typedArray.getColor(R.styleable.ContourView_shader_endcolor, Color.argb((int)90, (int)255, (int)255, (int)255));
            this.mShaderStyle = typedArray.getInt(R.styleable.ContourView_shader_style, 0);
        } else {
            this.mShaderColor = typedArray.getColor(R.styleable.ContourView_shader_color, Color.argb((int)90, (int)255, (int)255, (int)255));
        }
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.mW = w;
        this.mH = h;
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        boolean haveShader = false;
        if (this.mShaderMode == 0) {
            this.mPaint.setColor(this.mShaderColor);
        } else {
            haveShader = true;
        }
        if (this.mStyle != 36) {
            this.mPointsList = PointsFactory.getPoints(this.mStyle, this.mW, this.mH);
        }
        int flag = 0;
        block16: for (Point[] pts : this.mPointsList) {
            ++flag;
            int length = pts.length;
            if (length < 3) continue;
            Path path = new Path();
            int x_min = 0;
            int y_min = 0;
            int x_max = 0;
            int y_max = 0;
            for (int i = 0; i < length; ++i) {
                Point pI$1 = null;
                Point pI_1 = null;
                Point pI_2 = null;
                Point pI = pts[i];
                if (length == 3) {
                    switch (i) {
                        case 0: {
                            path.moveTo((float)pts[0].x, (float)pts[0].y);
                            x_max = x_min = pts[0].x;
                            y_min = y_max = pts[0].y;
                            pI$1 = pts[2];
                            pI_1 = pts[1];
                            pI_2 = pts[2];
                            break;
                        }
                        case 1: {
                            pI$1 = pts[0];
                            pI_1 = pts[2];
                            pI_2 = pts[0];
                            break;
                        }
                        case 2: {
                            pI$1 = pts[1];
                            pI_1 = pts[0];
                            pI_2 = pts[1];
                            break;
                        }
                    }
                } else if (i == 0) {
                    path.moveTo((float)pts[0].x, (float)pts[0].y);
                    x_max = x_min = pts[0].x;
                    y_min = y_max = pts[0].y;
                    pI$1 = pts[length - 1];
                    pI_1 = pts[i + 1];
                    pI_2 = pts[i + 2];
                } else if (i == length - 1) {
                    pI$1 = pts[i - 1];
                    pI_1 = pts[0];
                    pI_2 = pts[1];
                } else if (i == length - 2) {
                    pI$1 = pts[i - 1];
                    pI_1 = pts[i + 1];
                    pI_2 = pts[0];
                } else {
                    pI$1 = pts[i - 1];
                    pI_1 = pts[i + 1];
                    pI_2 = pts[i + 2];
                }
                if (pI$1 == null || pI == null || pI_1 == null || pI_2 == null) continue block16;
                float iControl1_X = (float)pI.x + (float)(pI_1.x - pI$1.x) * this.mSmoothness;
                float iControl1_Y = (float)pI.y + (float)(pI_1.y - pI$1.y) * this.mSmoothness;
                float iControl2_X = (float)pI_1.x - (float)(pI_2.x - pI.x) * this.mSmoothness;
                float iControl2_Y = (float)pI_1.y - (float)(pI_2.y - pI.y) * this.mSmoothness;
                path.cubicTo(iControl1_X, iControl1_Y, iControl2_X, iControl2_Y, (float)pI_1.x, (float)pI_1.y);
                if (pts[i].x < x_min) {
                    x_min = pts[i].x;
                }
                if (pts[i].x > x_max) {
                    x_max = pts[i].x;
                }
                if (pts[i].y < y_min) {
                    y_min = pts[i].y;
                }
                if (pts[i].y <= y_max) continue;
                y_max = pts[i].y;
            }
            if (haveShader) {
                if (this.mShaderMode == 4 && this.mShader != null) {
                    this.mPaint.setShader(this.mShader[(flag - 1) % this.mShader.length]);
                } else {
                    Point endPoint;
                    Point startPoint;
                    switch (this.mShaderStyle) {
                        case 0: {
                            startPoint = new Point(x_min, y_min);
                            endPoint = new Point(x_max, y_max);
                            break;
                        }
                        case 17: {
                            startPoint = new Point(x_max, y_min);
                            endPoint = new Point(x_min, y_max);
                            break;
                        }
                        case 18: {
                            startPoint = new Point((x_max - x_min) / 2 + x_min, y_min);
                            endPoint = new Point(x_min, (y_max - y_min) / 2 + y_min);
                            break;
                        }
                        case 19: {
                            startPoint = new Point((x_max - x_min) / 2 + x_min, (y_max - y_min) / 2 + y_min);
                            endPoint = new Point(x_max, (y_max - y_min) / 2 + y_min);
                            break;
                        }
                        default: {
                            startPoint = new Point(0, 0);
                            endPoint = new Point(this.mW, this.mH);
                        }
                    }
                    switch (this.mShaderMode) {
                        case 1: {
                            RadialGradient radialGradient = new RadialGradient((float)startPoint.x, (float)endPoint.y, (float)((int)Math.sqrt(Math.pow(Math.abs(x_max - x_min), 2.0) + Math.pow(Math.abs(y_max - y_min), 2.0))), this.mShaderStartColor, this.mShaderEndColor, Shader.TileMode.CLAMP);
                            this.mPaint.setShader((Shader)radialGradient);
                            break;
                        }
                        case 2: {
                            SweepGradient sweepGradient = new SweepGradient((float)startPoint.x, (float)startPoint.y, this.mShaderStartColor, this.mShaderEndColor);
                            this.mPaint.setShader((Shader)sweepGradient);
                            break;
                        }
                        case 3: {
                            LinearGradient linearGradient = new LinearGradient((float)startPoint.x, (float)startPoint.y, (float)endPoint.x, (float)endPoint.y, this.mShaderStartColor, this.mShaderEndColor, Shader.TileMode.REPEAT);
                            this.mPaint.setShader((Shader)linearGradient);
                            break;
                        }
                    }
                }
            }
            canvas.drawPath(path, this.mPaint);
        }
        flag = 0;
    }

    public void setPoints(Point ... points) {
        this.mPointsList = new ArrayList<Point[]>(1);
        this.mPointsList.add(points);
        this.mStyle = 36;
    }

    public void setPoints(int ... pts) {
        this.setPoints(this.ptsArrTopoints(pts));
    }

    public void setPoints(Point[] ... pointsArr) {
        this.mPointsList = Arrays.asList(pointsArr);
        this.mStyle = 36;
    }

    public void setPoints(int[] ... ptsArr) {
        this.mPointsList = new ArrayList<Point[]>();
        for (int[] pts : ptsArr) {
            this.mPointsList.add(this.ptsArrTopoints(pts));
        }
        this.mStyle = 36;
    }

    public Point[] ptsArrTopoints(int ... pts) {
        Point[] points = new Point[pts.length / 2];
        int i = 0;
        for (int j = 0; i < pts.length && j < points.length; i += 2, ++j) {
            points[j] = new Point(pts[i], pts[i + 1]);
        }
        return points;
    }

    public int getShaderMode() {
        return this.mShaderMode;
    }

    public void setShaderMode(int shaderMode) {
        this.mShaderMode = shaderMode;
    }

    public int getShaderStartColor() {
        return this.mShaderStartColor;
    }

    public void setShaderStartColor(@ColorInt int shaderStartColor) {
        this.mShaderStartColor = shaderStartColor;
    }

    public int getShaderEndColor() {
        return this.mShaderEndColor;
    }

    public void setShaderEndColor(@ColorInt int shaderEndColor) {
        this.mShaderEndColor = shaderEndColor;
    }

    public int getShaderStyle() {
        return this.mShaderStyle;
    }

    public void setShaderStyle(int shaderStyle) {
        this.mShaderStyle = shaderStyle;
    }

    public int getStyle() {
        return this.mStyle;
    }

    public void setStyle(int style) {
        this.mStyle = style;
    }

    public Shader[] getShader() {
        return this.mShader;
    }

    public void setShader(Shader ... shader) {
        this.mShader = shader;
        this.mShaderMode = 4;
    }

    public float getSmoothness() {
        return this.mSmoothness;
    }

    public void setSmoothness(float smoothness) {
        this.mSmoothness = smoothness;
    }

    public int getShaderColor() {
        return this.mShaderColor;
    }

    public void setShaderColor(int shaderColor) {
        this.mShaderColor = shaderColor;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Style {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ShaderStyle {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ShaderMode {
    }
}

