/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.clogproxy.client.util;

import com.oceanbase.clogproxy.common.util.NetworkUtil;
import java.lang.management.ManagementFactory;

public class ClientIdGenerator {
    public static String generate() {
        return NetworkUtil.getLocalIp() + "_" + ClientIdGenerator.getProcessId() + "_" + System.currentTimeMillis() / 1000L;
    }

    private static String getProcessId() {
        String jvmName = ManagementFactory.getRuntimeMXBean().getName();
        int index = jvmName.indexOf(64);
        if (index < 1) {
            return "NOPID";
        }
        try {
            return Long.toString(Long.parseLong(jvmName.substring(0, index)));
        }
        catch (NumberFormatException e) {
            return "NOPID";
        }
    }
}

