/*
 * Decompiled with CFR 0.152.
 */
package com.orsoncharts.graphics3d;

import com.orsoncharts.graphics3d.Dimension3D;
import com.orsoncharts.graphics3d.Object3D;
import com.orsoncharts.graphics3d.Point3D;
import com.orsoncharts.graphics3d.Rotate3D;
import com.orsoncharts.graphics3d.Utils2D;
import com.orsoncharts.graphics3d.Utils3D;
import com.orsoncharts.graphics3d.World;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.io.Serializable;

public class ViewPoint3D
implements Serializable {
    private double theta;
    private double phi;
    private double rho;
    private double v11;
    private double v12;
    private double v13;
    private double v21;
    private double v22;
    private double v23;
    private double v32;
    private double v33;
    private double v43;
    private Point3D up;
    private Rotate3D rotation;
    private double[] workspace;

    public static ViewPoint3D createAboveViewPoint(double rho) {
        return new ViewPoint3D(-1.5707963267948966, 3.5342917352885173, rho, 0.0);
    }

    public static ViewPoint3D createAboveLeftViewPoint(double rho) {
        ViewPoint3D vp = ViewPoint3D.createAboveViewPoint(rho);
        vp.panLeftRight(-0.5235987755982988);
        return vp;
    }

    public static ViewPoint3D createAboveRightViewPoint(double rho) {
        ViewPoint3D vp = ViewPoint3D.createAboveViewPoint(rho);
        vp.panLeftRight(0.5235987755982988);
        return vp;
    }

    public ViewPoint3D(double theta, double phi, double rho, double orientation) {
        this.theta = theta;
        this.phi = phi;
        this.rho = rho;
        this.updateMatrixElements();
        this.rotation = new Rotate3D(Point3D.ORIGIN, Point3D.UNIT_Z, orientation);
        this.up = this.rotation.applyRotation(Point3D.createPoint3D(this.theta, this.phi - 1.5707963267948966, this.rho));
        this.workspace = new double[3];
    }

    public ViewPoint3D(Point3D p, double orientation) {
        this.rho = (float)Math.sqrt(p.x * p.x + p.y * p.y + p.z * p.z);
        if (Math.sqrt(p.x * p.x + p.y * p.y) > 1.0E-6) {
            this.theta = (float)Math.atan2(p.y, p.x);
        }
        this.phi = (float)Math.acos(p.z / this.rho);
        this.updateMatrixElements();
        this.rotation = new Rotate3D(Point3D.ORIGIN, Point3D.UNIT_Z, orientation);
        this.up = this.rotation.applyRotation(Point3D.createPoint3D(this.theta, this.phi - 1.5707963267948966, this.rho));
        this.workspace = new double[3];
    }

    public ViewPoint3D(ViewPoint3D vp) {
        this.theta = vp.theta;
        this.phi = vp.phi;
        this.rho = vp.rho;
        this.updateMatrixElements();
        this.rotation = new Rotate3D(Point3D.ORIGIN, Point3D.UNIT_Z, vp.rotation.angle);
        this.up = vp.up;
        this.workspace = new double[3];
    }

    public final double getTheta() {
        return this.theta;
    }

    public final double getPhi() {
        return this.phi;
    }

    public final double getRho() {
        return this.rho;
    }

    public void setRho(double rho) {
        this.rho = rho;
        this.up = Point3D.createPoint3D(this.up.getTheta(), this.up.getPhi(), rho);
        this.updateMatrixElements();
    }

    public final double getX() {
        return this.rho * Math.sin(this.phi) * Math.cos(this.theta);
    }

    public final double getY() {
        return this.rho * Math.sin(this.phi) * Math.sin(this.theta);
    }

    public final double getZ() {
        return this.rho * Math.cos(this.phi);
    }

    public final Point3D getPoint() {
        return new Point3D(this.getX(), this.getY(), this.getZ());
    }

    public double calcRollAngle() {
        Point3D vp = this.getPoint();
        Point3D n1 = Utils3D.normal(vp, this.up, Point3D.ORIGIN);
        Point3D screenup = Point3D.createPoint3D(this.theta, this.phi - 1.5707963267948966, this.rho);
        Point3D n2 = Utils3D.normal(vp, screenup, Point3D.ORIGIN);
        double angle = Utils3D.angle(n1, n2);
        if (Utils3D.scalarprod(n1, screenup) >= 0.0) {
            return angle;
        }
        return -angle;
    }

    public void panLeftRight(double delta) {
        Point3D v = this.getVerticalRotationAxis();
        Rotate3D r = new Rotate3D(Point3D.ORIGIN, v, delta);
        Point3D p = r.applyRotation(this.getX(), this.getY(), this.getZ());
        this.theta = p.getTheta();
        this.phi = p.getPhi();
        this.updateMatrixElements();
        this.rotation.setAngle(this.calcRollAngle());
    }

    public void moveUpDown(double delta) {
        Point3D v = this.getHorizontalRotationAxis();
        Rotate3D r = new Rotate3D(Point3D.ORIGIN, v, delta);
        Point3D p = r.applyRotation(this.getX(), this.getY(), this.getZ());
        this.up = r.applyRotation(this.up);
        this.theta = p.getTheta();
        this.phi = p.getPhi();
        this.updateMatrixElements();
        this.rotation.setAngle(this.calcRollAngle());
    }

    public void roll(double delta) {
        Rotate3D r = new Rotate3D(this.getPoint(), Point3D.ORIGIN, delta);
        this.up = r.applyRotation(this.up);
        this.rotation.setAngle(this.calcRollAngle());
    }

    public Point3D worldToEye(Point3D p) {
        double x = this.v11 * p.x + this.v21 * p.y;
        double y = this.v12 * p.x + this.v22 * p.y + this.v32 * p.z;
        double z = this.v13 * p.x + this.v23 * p.y + this.v33 * p.z + this.v43;
        double[] rotated = this.rotation.applyRotation(x, y, z, this.workspace);
        return new Point3D(rotated[0], rotated[1], rotated[2]);
    }

    public Point2D worldToScreen(Point3D p, double d) {
        double x = this.v11 * p.x + this.v21 * p.y;
        double y = this.v12 * p.x + this.v22 * p.y + this.v32 * p.z;
        double z = this.v13 * p.x + this.v23 * p.y + this.v33 * p.z + this.v43;
        double[] rotated = this.rotation.applyRotation(x, y, z, this.workspace);
        return new Point2D.Double(-d * rotated[0] / rotated[2], -d * rotated[1] / rotated[2]);
    }

    public float optimalDistance(Dimension2D target, Dimension3D dim3D, double projDist) {
        ViewPoint3D vp = new ViewPoint3D(this.theta, this.phi, this.rho, this.calcRollAngle());
        float near = (float)dim3D.getDiagonalLength();
        float far = near * 40.0f;
        World w = new World();
        double ww = dim3D.getWidth();
        double hh = dim3D.getHeight();
        double dd = dim3D.getDepth();
        w.add(Object3D.createBox(0.0, ww, 0.0, hh, 0.0, dd, Color.RED));
        while (true) {
            vp.setRho(near);
            Point2D[] nearpts = w.calculateProjectedPoints(vp, projDist);
            Dimension neardim = Utils2D.findDimension(nearpts);
            double nearcover = this.coverage(neardim, target);
            vp.setRho(far);
            Point2D[] farpts = w.calculateProjectedPoints(vp, projDist);
            Dimension fardim = Utils2D.findDimension(farpts);
            double farcover = this.coverage(fardim, target);
            if (nearcover <= 1.0) {
                return near;
            }
            if (farcover >= 1.0) {
                return far;
            }
            float mid = (near + far) / 2.0f;
            vp.setRho(mid);
            Point2D[] midpts = w.calculateProjectedPoints(vp, projDist);
            Dimension middim = Utils2D.findDimension(midpts);
            double midcover = this.coverage(middim, target);
            if (midcover >= 1.0) {
                near = mid;
                continue;
            }
            far = mid;
        }
    }

    private double coverage(Dimension2D d, Dimension2D target) {
        double wpercent = d.getWidth() / target.getWidth();
        double hpercent = d.getHeight() / target.getHeight();
        if (wpercent <= 1.0 && hpercent <= 1.0) {
            return Math.max(wpercent, hpercent);
        }
        if (wpercent >= 1.0) {
            if (hpercent >= 1.0) {
                return Math.max(wpercent, hpercent);
            }
            return wpercent;
        }
        return hpercent;
    }

    private void updateMatrixElements() {
        float cosTheta = (float)Math.cos(this.theta);
        float sinTheta = (float)Math.sin(this.theta);
        float cosPhi = (float)Math.cos(this.phi);
        float sinPhi = (float)Math.sin(this.phi);
        this.v11 = -sinTheta;
        this.v12 = -cosPhi * cosTheta;
        this.v13 = sinPhi * cosTheta;
        this.v21 = cosTheta;
        this.v22 = -cosPhi * sinTheta;
        this.v23 = sinPhi * sinTheta;
        this.v32 = sinPhi;
        this.v33 = cosPhi;
        this.v43 = -this.rho;
    }

    public Point3D getVerticalRotationAxis() {
        return this.up;
    }

    public Point3D getHorizontalRotationAxis() {
        return Utils3D.normal(this.getPoint(), this.up, Point3D.ORIGIN);
    }

    public String toString() {
        return "[theta=" + this.theta + ", phi=" + this.phi + ", rho=" + this.rho + "]";
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ViewPoint3D)) {
            return false;
        }
        ViewPoint3D that = (ViewPoint3D)obj;
        if (this.theta != that.theta) {
            return false;
        }
        if (this.phi != that.phi) {
            return false;
        }
        if (this.rho != that.rho) {
            return false;
        }
        return this.up.equals(that.up);
    }
}

