/*
 * Decompiled with CFR 0.152.
 */
package com.orsoncharts.axis;

import com.orsoncharts.Chart3DHints;
import com.orsoncharts.Range;
import com.orsoncharts.axis.AbstractValueAxis3D;
import com.orsoncharts.axis.LabelOrientation;
import com.orsoncharts.axis.NumberTickSelector;
import com.orsoncharts.axis.TickData;
import com.orsoncharts.axis.TickSelector;
import com.orsoncharts.axis.ValueAxis3D;
import com.orsoncharts.graphics3d.RenderingInfo;
import com.orsoncharts.graphics3d.Utils2D;
import com.orsoncharts.util.ArgChecks;
import com.orsoncharts.util.ObjectUtils;
import com.orsoncharts.util.TextAnchor;
import com.orsoncharts.util.TextUtils;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.text.AttributedString;
import java.text.DecimalFormat;
import java.text.Format;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class LogAxis3D
extends AbstractValueAxis3D
implements ValueAxis3D {
    public static final double DEFAULT_SMALLEST_VALUE = 1.0E-100;
    private double base = 10.0;
    private double baseLog;
    private Range logRange;
    private double smallestValue = 1.0E-100;
    private String baseSymbol;
    private NumberFormat baseFormatter = new DecimalFormat("0");
    private TickSelector tickSelector = new NumberTickSelector();
    private double tickSize = 1.0;
    private Format tickLabelFormatter = new DecimalFormat("0.0");

    public LogAxis3D(String label) {
        super(label, new Range(1.0E-100, 1.0));
        this.baseLog = Math.log(this.base);
        this.logRange = new Range(this.calculateLog(1.0E-100), this.calculateLog(1.0));
    }

    public double getBase() {
        return this.base;
    }

    public void setBase(double base) {
        this.base = base;
        this.baseLog = Math.log(base);
        this.fireChangeEvent(true);
    }

    public String getBaseSymbol() {
        return this.baseSymbol;
    }

    public void setBaseSymbol(String symbol) {
        this.baseSymbol = symbol;
        this.fireChangeEvent(false);
    }

    public NumberFormat getBaseFormatter() {
        return this.baseFormatter;
    }

    public void setBaseFormatter(NumberFormat formatter) {
        ArgChecks.nullNotPermitted(formatter, "formatter");
        this.baseFormatter = formatter;
        this.fireChangeEvent(false);
    }

    public double getSmallestValue() {
        return this.smallestValue;
    }

    public void setSmallestValue(double smallestValue) {
        ArgChecks.positiveRequired(smallestValue, "smallestValue");
        this.smallestValue = smallestValue;
        this.fireChangeEvent(true);
    }

    public TickSelector getTickSelector() {
        return this.tickSelector;
    }

    public void setTickSelector(TickSelector selector) {
        this.tickSelector = selector;
        this.fireChangeEvent(false);
    }

    public double getTickSize() {
        return this.tickSize;
    }

    public void setTickSize(double tickSize) {
        this.tickSize = tickSize;
        this.fireChangeEvent(false);
    }

    public Format getTickLabelFormatter() {
        return this.tickLabelFormatter;
    }

    public void setTickLabelFormatter(Format formatter) {
        ArgChecks.nullNotPermitted(formatter, "formatter");
        this.tickLabelFormatter = formatter;
        this.fireChangeEvent(false);
    }

    @Override
    public void setRange(Range range) {
        ArgChecks.nullNotPermitted(range, "range");
        this.range = new Range(Math.max(range.getMin(), this.smallestValue), range.getMax());
        this.logRange = new Range(this.calculateLog(this.range.getMin()), this.calculateLog(this.range.getMax()));
        this.fireChangeEvent(true);
    }

    @Override
    public void setRange(double min, double max) {
        ArgChecks.negativeNotPermitted(min, "min");
        this.range = new Range(Math.max(min, this.smallestValue), max);
        this.logRange = new Range(this.calculateLog(this.range.getMin()), this.calculateLog(this.range.getMax()));
        this.fireChangeEvent(true);
    }

    @Override
    protected void updateRange(Range range) {
        this.range = range;
        this.logRange = new Range(this.calculateLog(this.range.getMin()), this.calculateLog(this.range.getMax()));
    }

    public final double calculateLog(double value) {
        return Math.log(value) / this.baseLog;
    }

    public final double calculateValue(double log) {
        return Math.pow(this.base, log);
    }

    @Override
    public double translateToWorld(double value, double length) {
        double logv = this.calculateLog(value);
        double percent = this.logRange.percent(logv);
        if (this.isInverted()) {
            percent = 1.0 - percent;
        }
        return percent * length;
    }

    @Override
    public void draw(Graphics2D g2, Point2D startPt, Point2D endPt, Point2D opposingPt, List<TickData> tickData, RenderingInfo info, boolean hinting) {
        if (!this.isVisible()) {
            return;
        }
        g2.setStroke(this.getLineStroke());
        g2.setPaint(this.getLineColor());
        Line2D.Float axisLine = new Line2D.Float(startPt, endPt);
        g2.draw(axisLine);
        double tickMarkLength = this.getTickMarkLength();
        double tickLabelOffset = this.getTickLabelOffset();
        g2.setPaint(this.getTickMarkPaint());
        g2.setStroke(this.getTickMarkStroke());
        for (TickData t : tickData) {
            if (!(tickMarkLength > 0.0)) continue;
            Line2D tickLine = Utils2D.createPerpendicularLine((Line2D)axisLine, t.getAnchorPt(), tickMarkLength, opposingPt);
            g2.draw(tickLine);
        }
        double maxTickLabelDim = 0.0;
        if (this.getTickLabelsVisible()) {
            g2.setFont(this.getTickLabelFont());
            g2.setPaint(this.getTickLabelColor());
            LabelOrientation orientation = this.getTickLabelOrientation();
            if (orientation.equals((Object)LabelOrientation.PERPENDICULAR)) {
                maxTickLabelDim = this.drawPerpendicularTickLabels(g2, axisLine, opposingPt, tickData, hinting);
            } else if (orientation.equals((Object)LabelOrientation.PARALLEL)) {
                maxTickLabelDim = g2.getFontMetrics().getHeight();
                double adj = g2.getFontMetrics().getAscent() / 2;
                this.drawParallelTickLabels(g2, axisLine, opposingPt, tickData, adj, hinting);
            }
        }
        if (this.getLabel() != null) {
            this.drawAxisLabel(this.getLabel(), g2, axisLine, opposingPt, maxTickLabelDim + tickMarkLength + tickLabelOffset + this.getLabelOffset(), info, hinting);
        }
    }

    private double drawPerpendicularTickLabels(Graphics2D g2, Line2D axisLine, Point2D opposingPt, List<TickData> tickData, boolean hinting) {
        double result = 0.0;
        for (TickData t : tickData) {
            double theta = Utils2D.calculateTheta(axisLine);
            double thetaAdj = theta + 1.5707963267948966;
            if (thetaAdj < -1.5707963267948966) {
                thetaAdj += Math.PI;
            }
            if (thetaAdj > 1.5707963267948966) {
                thetaAdj -= Math.PI;
            }
            Line2D perpLine = Utils2D.createPerpendicularLine(axisLine, t.getAnchorPt(), this.getTickMarkLength() + this.getTickLabelOffset(), opposingPt);
            double perpTheta = Utils2D.calculateTheta(perpLine);
            TextAnchor textAnchor = TextAnchor.CENTER_LEFT;
            if (Math.abs(perpTheta) > 1.5707963267948966) {
                textAnchor = TextAnchor.CENTER_RIGHT;
            }
            double logy = this.calculateLog(t.getDataValue());
            AttributedString as = this.createTickLabelAttributedString(logy, this.tickLabelFormatter);
            Rectangle2D.Double nonRotatedBounds = new Rectangle2D.Double();
            if (hinting) {
                HashMap<String, String> m = new HashMap<String, String>();
                m.put("ref", "{\"type\": \"valueTickLabel\", \"axis\": " + this.axisStr() + ", \"value\": \"" + t.getDataValue() + "\"}");
                g2.setRenderingHint(Chart3DHints.KEY_BEGIN_ELEMENT, m);
            }
            TextUtils.drawRotatedString(as, g2, (float)perpLine.getX2(), (float)perpLine.getY2(), textAnchor, thetaAdj, textAnchor, nonRotatedBounds);
            if (hinting) {
                g2.setRenderingHint(Chart3DHints.KEY_END_ELEMENT, true);
            }
            result = Math.max(result, ((RectangularShape)nonRotatedBounds).getWidth());
        }
        return result;
    }

    private void drawParallelTickLabels(Graphics2D g2, Line2D axisLine, Point2D opposingPt, List<TickData> tickData, double adj, boolean hinting) {
        for (TickData t : tickData) {
            double theta = Utils2D.calculateTheta(axisLine);
            TextAnchor anchor = TextAnchor.CENTER;
            if (theta < -1.5707963267948966) {
                theta += Math.PI;
                anchor = TextAnchor.CENTER;
            }
            if (theta > 1.5707963267948966) {
                theta -= Math.PI;
                anchor = TextAnchor.CENTER;
            }
            Line2D perpLine = Utils2D.createPerpendicularLine(axisLine, t.getAnchorPt(), this.getTickMarkLength() + this.getTickLabelOffset() + adj, opposingPt);
            double logy = this.calculateLog(t.getDataValue());
            AttributedString as = this.createTickLabelAttributedString(logy, this.tickSelector.getCurrentTickLabelFormat());
            if (hinting) {
                HashMap<String, String> m = new HashMap<String, String>();
                m.put("ref", "{\"type\": \"valueTickLabel\", \"axis\": " + this.axisStr() + ", \"value\": \"" + t.getDataValue() + "\"}");
                g2.setRenderingHint(Chart3DHints.KEY_BEGIN_ELEMENT, m);
            }
            TextUtils.drawRotatedString(as, g2, (float)perpLine.getX2(), (float)perpLine.getY2(), anchor, theta, anchor, null);
            if (!hinting) continue;
            g2.setRenderingHint(Chart3DHints.KEY_END_ELEMENT, true);
        }
    }

    private AttributedString createTickLabelAttributedString(double logy, Format exponentFormatter) {
        String baseStr = this.baseSymbol;
        if (baseStr == null) {
            baseStr = this.baseFormatter.format(this.base);
        }
        String exponentStr = exponentFormatter.format(logy);
        AttributedString as = new AttributedString(baseStr + exponentStr);
        as.addAttributes(this.getTickLabelFont().getAttributes(), 0, (baseStr + exponentStr).length());
        as.addAttribute(TextAttribute.SUPERSCRIPT, TextAttribute.SUPERSCRIPT_SUPER, baseStr.length(), baseStr.length() + exponentStr.length());
        return as;
    }

    @Override
    protected Range adjustedDataRange(Range range) {
        ArgChecks.nullNotPermitted(range, "range");
        double logmin = this.calculateLog(Math.max(range.getMin(), this.smallestValue));
        double logmax = this.calculateLog(range.getMax());
        double length = logmax - logmin;
        double lm = length * this.getLowerMargin();
        double um = length * this.getUpperMargin();
        double lowerBound = this.calculateValue(logmin - lm);
        double upperBound = this.calculateValue(logmax + um);
        return new Range(lowerBound, upperBound);
    }

    @Override
    public double selectTick(Graphics2D g2, Point2D pt0, Point2D pt1, Point2D opposingPt) {
        if (this.tickSelector == null) {
            return this.tickSize;
        }
        g2.setFont(this.getTickLabelFont());
        FontMetrics fm = g2.getFontMetrics();
        double length = pt0.distance(pt1);
        double rangeLength = this.logRange.getLength();
        LabelOrientation orientation = this.getTickLabelOrientation();
        if (orientation.equals((Object)LabelOrientation.PERPENDICULAR)) {
            int height = fm.getHeight();
            int maxTicks = (int)(length / ((double)height * this.getTickLabelFactor()));
            if (maxTicks > 2 && this.tickSelector != null) {
                this.tickSelector.select(rangeLength / 2.0);
                int tickCount = (int)(rangeLength / this.tickSelector.getCurrentTickSize());
                while (tickCount < maxTicks) {
                    this.tickSelector.previous();
                    tickCount = (int)(rangeLength / this.tickSelector.getCurrentTickSize());
                }
                this.tickSelector.next();
                this.tickSize = this.tickSelector.getCurrentTickSize();
                this.tickLabelFormatter = this.tickSelector.getCurrentTickLabelFormat();
            } else {
                this.tickSize = Double.NaN;
            }
        } else if (orientation.equals((Object)LabelOrientation.PARALLEL)) {
            this.tickSelector.select(rangeLength);
            boolean done = false;
            while (!done) {
                if (this.tickSelector.previous()) {
                    AttributedString s1;
                    TextLayout layout1;
                    double w1;
                    AttributedString s0 = this.createTickLabelAttributedString(this.logRange.getMax() + this.logRange.getMin(), this.tickSelector.getCurrentTickLabelFormat());
                    TextLayout layout0 = new TextLayout(s0.getIterator(), g2.getFontRenderContext());
                    double w0 = layout0.getAdvance();
                    double w = Math.max(w0, w1 = (double)(layout1 = new TextLayout((s1 = this.createTickLabelAttributedString(this.logRange.getMax() + this.logRange.getMin(), this.tickSelector.getCurrentTickLabelFormat())).getIterator(), g2.getFontRenderContext())).getAdvance());
                    int n = (int)(length / (w * this.getTickLabelFactor()));
                    if (!((double)n < rangeLength / this.tickSelector.getCurrentTickSize())) continue;
                    this.tickSelector.next();
                    done = true;
                    continue;
                }
                done = true;
            }
            this.tickSize = this.tickSelector.getCurrentTickSize();
            this.tickLabelFormatter = this.tickSelector.getCurrentTickLabelFormat();
        }
        return this.tickSize;
    }

    @Override
    public List<TickData> generateTickData(double tickUnit) {
        ArrayList<TickData> result = new ArrayList<TickData>();
        if (Double.isNaN(tickUnit)) {
            result.add(new TickData(0.0, this.getRange().getMin()));
            result.add(new TickData(1.0, this.getRange().getMax()));
        } else {
            for (double logx = tickUnit * Math.ceil(this.logRange.getMin() / tickUnit); logx <= this.logRange.getMax(); logx += tickUnit) {
                result.add(new TickData(this.logRange.percent(logx), this.calculateValue(logx)));
            }
        }
        return result;
    }

    @Override
    public int hashCode() {
        int hash = 5;
        hash = 59 * hash + (int)(Double.doubleToLongBits(this.base) ^ Double.doubleToLongBits(this.base) >>> 32);
        hash = 59 * hash + (int)(Double.doubleToLongBits(this.smallestValue) ^ Double.doubleToLongBits(this.smallestValue) >>> 32);
        hash = 59 * hash + ObjectUtils.hashCode(this.baseSymbol);
        hash = 59 * hash + ObjectUtils.hashCode(this.baseFormatter);
        hash = 59 * hash + ObjectUtils.hashCode(this.tickSelector);
        hash = 59 * hash + (int)(Double.doubleToLongBits(this.tickSize) ^ Double.doubleToLongBits(this.tickSize) >>> 32);
        hash = 59 * hash + ObjectUtils.hashCode(this.tickLabelFormatter);
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LogAxis3D other = (LogAxis3D)obj;
        if (Double.doubleToLongBits(this.base) != Double.doubleToLongBits(other.base)) {
            return false;
        }
        if (Double.doubleToLongBits(this.smallestValue) != Double.doubleToLongBits(other.smallestValue)) {
            return false;
        }
        if (!ObjectUtils.equals(this.baseSymbol, other.baseSymbol)) {
            return false;
        }
        if (!ObjectUtils.equals(this.baseFormatter, other.baseFormatter)) {
            return false;
        }
        if (!ObjectUtils.equals(this.tickSelector, other.tickSelector)) {
            return false;
        }
        if (Double.doubleToLongBits(this.tickSize) != Double.doubleToLongBits(other.tickSize)) {
            return false;
        }
        if (!ObjectUtils.equals(this.tickLabelFormatter, other.tickLabelFormatter)) {
            return false;
        }
        return super.equals(obj);
    }
}

