/*
 * Decompiled with CFR 0.152.
 */
package org.droidplanner.services.android.impl.utils.video;

import android.content.Context;
import android.media.MediaScannerConnection;
import android.net.Uri;
import android.os.Environment;
import android.text.TextUtils;
import com.coremedia.iso.boxes.Container;
import com.googlecode.mp4parser.DataSource;
import com.googlecode.mp4parser.FileDataSourceImpl;
import com.googlecode.mp4parser.authoring.Movie;
import com.googlecode.mp4parser.authoring.Track;
import com.googlecode.mp4parser.authoring.builder.DefaultMp4Builder;
import com.googlecode.mp4parser.authoring.tracks.h264.H264TrackImpl;
import com.o3dr.android.client.utils.video.MediaCodecManager;
import com.o3dr.android.client.utils.video.NaluChunk;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import timber.log.Timber;

class StreamRecorder
implements MediaCodecManager.NaluChunkListener {
    private final AtomicReference<String> recordingFilename = new AtomicReference();
    private final AtomicBoolean areParametersSet = new AtomicBoolean(false);
    private final File mediaRootDir;
    private final Context context;
    private final MediaScannerConnection.OnScanCompletedListener scanCompletedListener = new MediaScannerConnection.OnScanCompletedListener(){

        public void onScanCompleted(String path, Uri uri) {
            Timber.i((String)"Media file %s was scanned successfully: %s", (Object[])new Object[]{path, uri});
        }
    };
    private ExecutorService asyncExecutor;
    private BufferedOutputStream h264Writer;

    StreamRecorder(Context context) {
        this.context = context;
        this.mediaRootDir = new File(context.getExternalFilesDir(Environment.DIRECTORY_MOVIES), "stream");
        if (!this.mediaRootDir.exists()) {
            this.mediaRootDir.mkdirs();
        }
    }

    String getRecordingFilename() {
        return this.recordingFilename.get();
    }

    void startConverterThread() {
        if (this.asyncExecutor == null || this.asyncExecutor.isShutdown()) {
            this.asyncExecutor = Executors.newSingleThreadExecutor();
        }
    }

    void stopConverterThread() {
        if (this.asyncExecutor != null) {
            this.asyncExecutor.shutdown();
        }
    }

    boolean isRecordingEnabled() {
        return !TextUtils.isEmpty((CharSequence)this.recordingFilename.get());
    }

    boolean enableRecording(String mediaFilename) {
        if (!this.isRecordingEnabled()) {
            this.areParametersSet.set(false);
            this.recordingFilename.set(mediaFilename);
            Timber.i((String)"Enabling local recording to %s", (Object[])new Object[]{mediaFilename});
            File h264File = new File(this.mediaRootDir, mediaFilename);
            if (h264File.exists()) {
                h264File.delete();
            }
            try {
                this.h264Writer = new BufferedOutputStream(new FileOutputStream(h264File));
                return true;
            }
            catch (FileNotFoundException e) {
                Timber.e((Throwable)e, (String)e.getMessage(), (Object[])new Object[0]);
                this.recordingFilename.set(null);
                return false;
            }
        }
        Timber.w((String)"Video stream recording is already enabled", (Object[])new Object[0]);
        return false;
    }

    boolean disableRecording() {
        if (this.isRecordingEnabled()) {
            Timber.i((String)"Disabling local recording", (Object[])new Object[0]);
            if (this.h264Writer != null) {
                try {
                    this.h264Writer.close();
                }
                catch (IOException e) {
                    Timber.e((Throwable)e, (String)e.getMessage(), (Object[])new Object[0]);
                }
                finally {
                    this.h264Writer = null;
                    this.convertToMp4(this.recordingFilename.get());
                    this.recordingFilename.set(null);
                }
            }
        }
        this.areParametersSet.set(false);
        return true;
    }

    @Override
    public void onNaluChunkUpdated(NaluChunk parametersSet, NaluChunk dataChunk) {
        if (this.isRecordingEnabled() && this.h264Writer != null) {
            if (this.areParametersSet.get()) {
                try {
                    this.writeNaluChunk(this.h264Writer, dataChunk);
                }
                catch (IOException e) {
                    Timber.e((Throwable)e, (String)e.getMessage(), (Object[])new Object[0]);
                }
            } else {
                try {
                    this.areParametersSet.set(this.writeNaluChunk(this.h264Writer, parametersSet));
                }
                catch (IOException e) {
                    Timber.e((Throwable)e, (String)e.getMessage(), (Object[])new Object[0]);
                }
            }
        }
    }

    private boolean writeNaluChunk(BufferedOutputStream bos, NaluChunk naluChunk) throws IOException {
        if (naluChunk == null) {
            return false;
        }
        for (ByteBuffer payload : naluChunk.payloads) {
            if (payload.capacity() == 0) continue;
            int dataLength = payload.position();
            byte[] payloadData = payload.array();
            bos.write(payloadData, 0, dataLength);
        }
        return true;
    }

    void convertToMp4(final String filename) {
        if (TextUtils.isEmpty((CharSequence)filename)) {
            Timber.w((String)"Invalid media filename.", (Object[])new Object[0]);
            return;
        }
        final File rawMedia = new File(this.mediaRootDir, filename);
        if (!rawMedia.exists()) {
            Timber.w((String)"Media file doesn't exists.", (Object[])new Object[0]);
            return;
        }
        if (rawMedia.length() == 0L) {
            Timber.w((String)"Media file is empty.", (Object[])new Object[0]);
            return;
        }
        this.asyncExecutor.execute(new Runnable(){

            @Override
            public void run() {
                Timber.i((String)"Starting h264 conversion process for media file %s.", (Object[])new Object[]{filename});
                try {
                    H264TrackImpl h264Track = new H264TrackImpl((DataSource)new FileDataSourceImpl(rawMedia));
                    Movie movie = new Movie();
                    movie.addTrack((Track)h264Track);
                    Container mp4File = new DefaultMp4Builder().build(movie);
                    File dstDir = Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_MOVIES);
                    File mp4Media = new File(dstDir, filename + ".mp4");
                    Timber.i((String)"Generating the mp4 file @ %s", (Object[])new Object[]{mp4Media.getAbsolutePath()});
                    FileChannel fc = new FileOutputStream(mp4Media).getChannel();
                    mp4File.writeContainer((WritableByteChannel)fc);
                    fc.close();
                    Timber.i((String)"Deleting raw h264 media file.", (Object[])new Object[0]);
                    rawMedia.delete();
                    Timber.i((String)"Adding the generated mp4 file to the media store.", (Object[])new Object[0]);
                    MediaScannerConnection.scanFile((Context)StreamRecorder.this.context, (String[])new String[]{mp4Media.getAbsolutePath()}, null, (MediaScannerConnection.OnScanCompletedListener)StreamRecorder.this.scanCompletedListener);
                }
                catch (IOException | NullPointerException e) {
                    Timber.e((Throwable)e, (String)e.getMessage(), (Object[])new Object[0]);
                }
            }
        });
    }
}

