/*
 * Decompiled with CFR 0.152.
 */
package org.droidplanner.services.android.impl.core.survey.grid;

import com.o3dr.services.android.lib.coordinate.LatLong;
import java.util.ArrayList;
import java.util.List;
import org.droidplanner.services.android.impl.core.helpers.coordinates.CoordBounds;
import org.droidplanner.services.android.impl.core.helpers.geoTools.GeoTools;
import org.droidplanner.services.android.impl.core.helpers.geoTools.LineLatLong;

public class CircumscribedGrid {
    private static final int MAX_NUMBER_OF_LINES = 300;
    List<LineLatLong> grid = new ArrayList<LineLatLong>();
    private LatLong gridLowerLeft;
    private double extrapolatedDiag;
    private Double angle;

    public CircumscribedGrid(List<LatLong> polygonPoints, Double angle, Double lineDist) throws Exception {
        this.angle = angle;
        this.findPolygonBounds(polygonPoints);
        this.drawGrid(lineDist);
    }

    private void drawGrid(Double lineDist) throws GridWithTooManyLines {
        int lines = 0;
        LatLong startPoint = this.gridLowerLeft;
        while ((double)lines * lineDist < this.extrapolatedDiag) {
            LatLong endPoint = GeoTools.newCoordFromBearingAndDistance(startPoint, this.angle, this.extrapolatedDiag);
            LineLatLong line = new LineLatLong(startPoint, endPoint);
            this.grid.add(line);
            startPoint = GeoTools.newCoordFromBearingAndDistance(startPoint, this.angle + 90.0, lineDist);
            if (++lines <= 300) continue;
            throw new GridWithTooManyLines();
        }
    }

    private void findPolygonBounds(List<LatLong> polygonPoints) {
        CoordBounds bounds = new CoordBounds(polygonPoints);
        LatLong middlePoint = bounds.getMiddle();
        this.gridLowerLeft = GeoTools.newCoordFromBearingAndDistance(middlePoint, this.angle - 135.0, bounds.getDiag());
        this.extrapolatedDiag = bounds.getDiag() * 1.5;
    }

    public List<LineLatLong> getGrid() {
        return this.grid;
    }

    public class GridWithTooManyLines
    extends Exception {
        private static final long serialVersionUID = 1L;
    }
}

