/*
 * Decompiled with CFR 0.152.
 */
package org.droidplanner.services.android.impl.core.mission.waypoints;

import com.MAVLink.common.msg_mission_item;
import com.o3dr.services.android.lib.coordinate.LatLong;
import com.o3dr.services.android.lib.coordinate.LatLongAlt;
import java.util.ArrayList;
import java.util.List;
import org.droidplanner.services.android.impl.core.helpers.geoTools.GeoTools;
import org.droidplanner.services.android.impl.core.mission.MissionImpl;
import org.droidplanner.services.android.impl.core.mission.MissionItemImpl;
import org.droidplanner.services.android.impl.core.mission.MissionItemType;
import org.droidplanner.services.android.impl.core.mission.survey.SurveyImpl;
import org.droidplanner.services.android.impl.core.mission.waypoints.CircleImpl;
import org.droidplanner.services.android.impl.core.mission.waypoints.RegionOfInterestImpl;
import org.droidplanner.services.android.impl.core.mission.waypoints.SpatialCoordItem;
import org.droidplanner.services.android.impl.core.polygon.Polygon;
import org.droidplanner.services.android.impl.core.survey.CameraInfo;
import org.droidplanner.services.android.impl.core.survey.SurveyData;
import org.droidplanner.services.android.impl.core.survey.grid.GridBuilder;

public class StructureScannerImpl
extends SpatialCoordItem {
    private double radius = 10.0;
    private double heightStep = 5.0;
    private int numberOfSteps = 2;
    private boolean crossHatch = false;
    SurveyData survey = new SurveyData();

    public StructureScannerImpl(MissionImpl missionImpl, LatLongAlt coord) {
        super(missionImpl, coord);
    }

    public StructureScannerImpl(MissionItemImpl item) {
        super(item);
    }

    @Override
    public List<msg_mission_item> packMissionItem() {
        ArrayList<msg_mission_item> list = new ArrayList<msg_mission_item>();
        this.packROI(list);
        this.packCircles(list);
        if (this.crossHatch) {
            this.packHatch(list);
        }
        return list;
    }

    private void packROI(List<msg_mission_item> list) {
        RegionOfInterestImpl roi = new RegionOfInterestImpl(this.missionImpl, new LatLongAlt(this.coordinate, 0.0));
        list.addAll(roi.packMissionItem());
    }

    private void packCircles(List<msg_mission_item> list) {
        double altitude = this.coordinate.getAltitude();
        for (int iSteps = 0; iSteps < this.numberOfSteps; ++iSteps) {
            CircleImpl circleImpl = new CircleImpl(this.missionImpl, new LatLongAlt(this.coordinate, altitude));
            circleImpl.setRadius(this.radius);
            list.addAll(circleImpl.packMissionItem());
            altitude += this.heightStep;
        }
    }

    private void packHatch(List<msg_mission_item> list) {
        Polygon polygon = new Polygon();
        for (double angle = 0.0; angle <= 360.0; angle += 10.0) {
            polygon.addPoint(GeoTools.newCoordFromBearingAndDistance(this.coordinate, angle, this.radius));
        }
        LatLong corner = GeoTools.newCoordFromBearingAndDistance(this.coordinate, -45.0, this.radius * 2.0);
        this.survey.setAltitude(this.getTopHeight());
        try {
            this.survey.update(0.0, this.survey.getAltitude(), this.survey.getOverlap(), this.survey.getSidelap(), this.survey.getLockOrientation());
            GridBuilder grid = new GridBuilder(polygon, this.survey, corner);
            for (LatLong point : grid.generate((boolean)false).gridPoints) {
                list.add(SurveyImpl.packSurveyPoint(point, this.getTopHeight()));
            }
            this.survey.update(90.0, this.survey.getAltitude(), this.survey.getOverlap(), this.survey.getSidelap(), this.survey.getLockOrientation());
            GridBuilder grid2 = new GridBuilder(polygon, this.survey, corner);
            for (LatLong point : grid2.generate((boolean)false).gridPoints) {
                list.add(SurveyImpl.packSurveyPoint(point, this.getTopHeight()));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public List<LatLong> getPath() {
        ArrayList<LatLong> path = new ArrayList<LatLong>();
        for (msg_mission_item msg_mission_item2 : this.packMissionItem()) {
            if (msg_mission_item2.command == 16) {
                path.add(new LatLong(msg_mission_item2.x, msg_mission_item2.y));
            }
            if (msg_mission_item2.command != 18) continue;
            for (double angle = 0.0; angle <= 360.0; angle += 12.0) {
                path.add(GeoTools.newCoordFromBearingAndDistance(this.coordinate, angle, this.radius));
            }
        }
        return path;
    }

    @Override
    public void unpackMAVMessage(msg_mission_item mavMsg) {
    }

    @Override
    public MissionItemType getType() {
        return MissionItemType.CYLINDRICAL_SURVEY;
    }

    private double getTopHeight() {
        return this.coordinate.getAltitude() + (double)(this.numberOfSteps - 1) * this.heightStep;
    }

    public double getEndAltitude() {
        return this.heightStep;
    }

    public int getNumberOfSteps() {
        return this.numberOfSteps;
    }

    public double getRadius() {
        return this.radius;
    }

    public LatLong getCenter() {
        return this.coordinate;
    }

    public void setRadius(int newValue) {
        this.radius = newValue;
    }

    public void enableCrossHatch(boolean isEnabled) {
        this.crossHatch = isEnabled;
    }

    public boolean isCrossHatchEnabled() {
        return this.crossHatch;
    }

    public void setAltitudeStep(int newValue) {
        this.heightStep = newValue;
    }

    public void setNumberOfSteps(int newValue) {
        this.numberOfSteps = newValue;
    }

    public void setCamera(CameraInfo cameraInfo) {
        this.survey.setCameraInfo(cameraInfo);
    }

    public String getCamera() {
        return this.survey.getCameraName();
    }

    public SurveyData getSurveyData() {
        return this.survey;
    }
}

