/*
 * Decompiled with CFR 0.152.
 */
package org.droidplanner.services.android.impl.core.helpers.geoTools;

import com.o3dr.services.android.lib.coordinate.LatLong;
import org.droidplanner.services.android.impl.core.helpers.geoTools.GeoTools;

public class LineLatLong {
    private final LatLong start;
    private final LatLong end;

    public LineLatLong(LatLong start, LatLong end) {
        this.start = start;
        this.end = end;
    }

    public LineLatLong(LineLatLong line) {
        this(line.start, line.end);
    }

    public LatLong getStart() {
        return this.start;
    }

    public LatLong getEnd() {
        return this.end;
    }

    public double getHeading() {
        return GeoTools.getHeadingFromCoordinates(this.start, this.end);
    }

    public LatLong getFarthestEndpointTo(LatLong point) {
        if (this.getClosestEndpointTo(point).equals(this.start)) {
            return this.end;
        }
        return this.start;
    }

    public LatLong getClosestEndpointTo(LatLong point) {
        if (this.getDistanceToStart(point) < this.getDistanceToEnd(point)) {
            return this.start;
        }
        return this.end;
    }

    private Double getDistanceToEnd(LatLong point) {
        return GeoTools.getAproximatedDistance(this.end, point);
    }

    private Double getDistanceToStart(LatLong point) {
        return GeoTools.getAproximatedDistance(this.start, point);
    }

    public String toString() {
        return "from:" + this.start.toString() + "to:" + this.end.toString();
    }
}

